<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2018 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DPCalendar\HTML\Block;

defined('_JEXEC') or die();

/**
 * Icon constants
 */
class Icon
{
	/**
	 * The back icon.
	 *
	 * @var string
	 */
	public const BACK = 'angle-left';

	/**
	 * The bullseye icon.
	 *
	 * @var string
	 */
	public const BULLSEYE = 'bullseye';

	/**
	 * The calendar icon.
	 *
	 * @var string
	 */
	public const CALENDAR = 'calendar-alt';

	/**
	 * The cancel icon.
	 *
	 * @var string
	 */
	public const CANCEL = 'ban';

	/**
	 * The clock icon.
	 *
	 * @var string
	 */
	public const CLOCK = 'clock';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const COG = 'cog';

	/**
	 * The compress icon.
	 *
	 * @var string
	 */
	public const COMPRESS = 'compress-alt';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	public const DATABASE = 'database';

	/**
	 * The delete icon.
	 *
	 * @var string
	 */
	public const DELETE = 'trash';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	public const DIRECTIONS = 'directions';

	/**
	 * The down icon.
	 *
	 * @var string
	 */
	public const DOWN = 'caret-down';

	/**
	 * The download icon.
	 *
	 * @var string
	 */
	public const DOWNLOAD = 'download';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	public const EDIT = 'pencil-alt';

	/**
	 * The exclamation icon.
	 *
	 * @var string
	 */
	public const EXCLAMATION = 'exclamation';

	/**
	 * The external link icon.
	 *
	 * @var string
	 */
	public const EXTERNAL = 'external-link-square-alt';

	/**
	 * The expand icon.
	 *
	 * @var string
	 */
	public const EXPAND = 'expand-alt';

	/**
	 * The file icon.
	 *
	 * @var string
	 */
	public const FILE = 'file';

	/**
	 * The info icon.
	 *
	 * @var string
	 */
	public const INFO = 'info-circle';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const LANGUAGE = 'globe';

	/**
	 * The list icon.
	 *
	 * @var string
	 */
	public const LISTING = 'list';

	/**
	 * The location icon.
	 *
	 * @var string
	 */
	public const LOCATION = 'map-marker-alt';

	/**
	 * The lock icon.
	 *
	 * @var string
	 */
	public const LOCK = 'lock';

	/**
	 * The mail icon.
	 *
	 * @var string
	 */
	public const MAIL = 'envelope';

	/**
	 * The map icon.
	 *
	 * @var string
	 */
	public const MAP = 'map-marked-alt';

	/**
	 * The money icon.
	 *
	 * @var string
	 */
	public const MONEY = 'money-bill-alt';

	/**
	 * The multiple item icon.
	 *
	 * @var string
	 */
	public const MULTIPLE = 'clone';

	/**
	 * The next icon.
	 *
	 * @var string
	 */
	public const NEXT = 'angle-right';

	/**
	 * The ok icon.
	 *
	 * @var string
	 */
	public const OK = 'check';

	/**
	 * The plus icon.
	 *
	 * @var string
	 */
	public const PLUS = 'plus';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	public const PRINTING = 'print';

	/**
	 * The recurring icon.
	 *
	 * @var string
	 */
	public const RECURRING = 'redo';

	/**
	 * The search icon.
	 *
	 * @var string
	 */
	public const SEARCH = 'search';

	/**
	 * The signup icon.
	 *
	 * @var string
	 */
	public const SIGNUP = 'sign-in-alt';

	/**
	 * The single item icon.
	 *
	 * @var string
	 */
	public const SINGLE = 'square';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const SYNC = 'sync';

	/**
	 * The up icon.
	 *
	 * @var string
	 */
	public const UP = 'caret-up';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const USERS = 'users';

	/**
	 * The icon cache, used by the layout.
	 *
	 * @var array
	 */
	public static $pathCache = [];
}
