!function(t,i){"function"==typeof define&&define.amd?
// AMD
define(["leaflet","mapbox-gl"],i):"object"==typeof exports?
// Node, CommonJS-like
module.exports=i(require("leaflet"),require("mapbox-gl")):
// Browser globals (root is window)
t.returnExports=i(window.L,window.mapboxgl)}(this,(function(t,i){t.MapboxGL=t.Layer.extend({options:{updateInterval:32,
// How much to extend the overlay view (relative to map size)
// e.g. 0.1 would be 10% of map view in each direction
padding:.1,
// whether or not to register the mouse and keyboard
// events on the mapbox overlay
interactive:!1,
// set the tilepane as the default pane to draw gl tiles
pane:"tilePane"},initialize:function(n){t.setOptions(this,n),n.accessToken&&(i.accessToken=n.accessToken),// setup throttling the update event when panning
this._throttledUpdate=t.Util.throttle(this._update,this.options.updateInterval,this)},onAdd:function(i){this._container||this._initContainer();var n=this.getPaneName();i.getPane(n).appendChild(this._container),this._initGL(),this._offset=this._map.containerPointToLayerPoint([0,0]),// work around https://github.com/mapbox/mapbox-gl-leaflet/issues/47
i.options.zoomAnimation&&t.DomEvent.on(i._proxy,t.DomUtil.TRANSITION_END,this._transitionEnd,this)},onRemove:function(i){this._map._proxy&&this._map.options.zoomAnimation&&t.DomEvent.off(this._map._proxy,t.DomUtil.TRANSITION_END,this._transitionEnd,this);var n=this.getPaneName();i.getPane(n).removeChild(this._container),this._glMap.remove(),this._glMap=null},getEvents:function(){return{move:this._throttledUpdate,
// sensibly throttle updating while panning
zoomanim:this._animateZoom,
// applys the zoom animation to the <canvas>
zoom:this._pinchZoom,
// animate every zoom event for smoother pinch-zooming
zoomstart:this._zoomStart,
// flag starting a zoom to disable panning
zoomend:this._zoomEnd,resize:this._resize}},getMapboxMap:function(){return this._glMap},getCanvas:function(){return this._glMap.getCanvas()},getSize:function(){return this._map.getSize().multiplyBy(1+2*this.options.padding)},getBounds:function(){var i=this.getSize().multiplyBy(.5),n=this._map.latLngToContainerPoint(this._map.getCenter());return t.latLngBounds(this._map.containerPointToLatLng(n.subtract(i)),this._map.containerPointToLatLng(n.add(i)))},getContainer:function(){return this._container},
// returns the pane name set in options if it is a valid pane, defaults to tilePane
getPaneName:function(){return this._map.getPane(this.options.pane)?this.options.pane:"tilePane"},_initContainer:function(){var i=this._container=t.DomUtil.create("div","leaflet-gl-layer"),n=this.getSize(),a=this._map.getSize().multiplyBy(this.options.padding);i.style.width=n.x+"px",i.style.height=n.y+"px";var o=this._map.containerPointToLayerPoint([0,0]).subtract(a);t.DomUtil.setPosition(i,o)},_initGL:function(){var n=this._map.getCenter(),a=t.extend({},this.options,{container:this._container,center:[n.lng,n.lat],zoom:this._map.getZoom()-1,attributionControl:!1});this._glMap=new i.Map(a),// allow GL base map to pan beyond min/max latitudes
this._glMap.transform.latRange=null,this._transformGL(this._glMap),this._glMap._canvas.canvas?
// older versions of mapbox-gl surfaced the canvas differently
this._glMap._actualCanvas=this._glMap._canvas.canvas:this._glMap._actualCanvas=this._glMap._canvas;// treat child <canvas> element like L.ImageOverlay
var o=this._glMap._actualCanvas;t.DomUtil.addClass(o,"leaflet-image-layer"),t.DomUtil.addClass(o,"leaflet-zoom-animated"),this.options.interactive&&t.DomUtil.addClass(o,"leaflet-interactive"),this.options.className&&t.DomUtil.addClass(o,this.options.className)},_update:function(i){if(
// update the offset so we can correct for it later when we zoom
this._offset=this._map.containerPointToLayerPoint([0,0]),!this._zooming){var n=this.getSize(),a=this._container,o=this._glMap,e=this._map.getSize().multiplyBy(this.options.padding),s=this._map.containerPointToLayerPoint([0,0]).subtract(e);t.DomUtil.setPosition(a,s),this._transformGL(o),o.transform.width!==n.x||o.transform.height!==n.y?(a.style.width=n.x+"px",a.style.height=n.y+"px",null!==o._resize&&void 0!==o._resize?o._resize():o.resize()):
// older versions of mapbox-gl surfaced update publicly
null!==o._update&&void 0!==o._update?o._update():o.update()}},_transformGL:function(t){var n=this._map.getCenter(),a=t.transform;// gl.setView([center.lat, center.lng], this._map.getZoom() - 1, 0);
// calling setView directly causes sync issues because it uses requestAnimFrame
a.center=i.LngLat.convert([n.lng,n.lat]),a.zoom=this._map.getZoom()-1},
// update the map constantly during a pinch zoom
_pinchZoom:function(t){this._glMap.jumpTo({zoom:this._map.getZoom()-1,center:this._map.getCenter()})},
// borrowed from L.ImageOverlay
// https://github.com/Leaflet/Leaflet/blob/master/src/layer/ImageOverlay.js#L139-L144
_animateZoom:function(i){var n=this._map.getZoomScale(i.zoom),a=this._map.getSize().multiplyBy(this.options.padding*n),o=this.getSize()._divideBy(2),e=this._map.project(i.center,i.zoom)._subtract(o)._add(this._map._getMapPanePos().add(a))._round(),s=this._map.project(this._map.getBounds().getNorthWest(),i.zoom)._subtract(e);t.DomUtil.setTransform(this._glMap._actualCanvas,s.subtract(this._offset),n)},_zoomStart:function(t){this._zooming=!0},_zoomEnd:function(){var i=this._map.getZoomScale(this._map.getZoom());t.DomUtil.setTransform(this._glMap._actualCanvas,// https://github.com/mapbox/mapbox-gl-leaflet/pull/130
null,i),this._zooming=!1,this._update()},_transitionEnd:function(i){t.Util.requestAnimFrame((function(){var i=this._map.getZoom(),n=this._map.getCenter(),a=this._map.latLngToContainerPoint(this._map.getBounds().getNorthWest());// reset the scale and offset
t.DomUtil.setTransform(this._glMap._actualCanvas,a,1),// enable panning once the gl map is ready again
this._glMap.once("moveend",t.Util.bind((function(){this._zoomEnd()}),this)),// update the map position
this._glMap.jumpTo({center:n,zoom:i-1})}),this)},_resize:function(t){this._transitionEnd(t)}}),t.mapboxGL=function(i){return new t.MapboxGL(i)}}));