// Based on https://github.com/shramov/leaflet-plugins
// GridLayer like https://avinmathew.com/leaflet-and-google-maps/ , but using MutationObserver instead of jQuery
// 🍂class GridLayer.GoogleMutant
// 🍂extends GridLayer
L.GridLayer.GoogleMutant=L.GridLayer.extend({options:{minZoom:0,maxZoom:21,
// can be 23, but ugly if more than maxNativeZoom
tileSize:256,subdomains:"abc",errorTileUrl:"",attribution:"",
// The mutant container will add its own attribution anyways.
opacity:1,continuousWorld:!1,noWrap:!1,
// 🍂option type: String = 'roadmap'
// Google's map type. Valid values are 'roadmap', 'satellite' or 'terrain'. 'hybrid' is not really supported.
type:"roadmap",maxNativeZoom:21},initialize:function(t){L.GridLayer.prototype.initialize.call(this,t),this._ready=!!window.google&&!!window.google.maps&&!!window.google.maps.Map,this._isMounted=!0,this._GAPIPromise=this._ready?Promise.resolve(window.google):new Promise((function(t,e){var i=0,n=null;n=setInterval((function(){return i>=10?(clearInterval(n),e(new Error("window.google not found after 10 attempts"))):window.google&&window.google.maps&&window.google.maps.Map?(clearInterval(n),t(window.google)):void++i}),500)})),this.once("spawned",(function(){if(this._subLayers)
//restore previously added google layers
for(var t in this._subLayers)this._subLayers[t].setMap(this._mutant)})),// Couple data structures indexed by tile key
this._tileCallbacks={},// Callbacks for promises for tiles that are expected
this._freshTiles={},// Tiles from the mutant which haven't been requested yet
this._imagesPerTile="hybrid"===this.options.type?2:1,this._boundOnMutatedImage=this._onMutatedImage.bind(this)},onAdd:function(t){L.GridLayer.prototype.onAdd.call(this,t),this._initMutantContainer(),this._GAPIPromise.then(function(){if(this._isMounted&&(this._ready=!0,this._initMutant(),t=this._map)){var e=this.options.updateWhenIdle?"moveend":"move";t.on(e,this._update,this),this.once("remove",(function(){this._map.off(e,this._update,this)})),//handle layer being added to a map for which there are no Google tiles at the given zoom
google.maps.event.addListenerOnce(this._mutant,"idle",function(){this._map&&(this._checkZoomLevels(),this._mutantIsReady=!0)}.bind(this)),//20px instead of 1em to avoid a slight overlap with google's attribution
t._controlCorners.bottomright.style.marginBottom="20px",t._controlCorners.bottomleft.style.marginBottom="20px",this._update()}}.bind(this))},onRemove:function(t){L.GridLayer.prototype.onRemove.call(this,t),this._observer.disconnect(),t._container.removeChild(this._mutantContainer),google.maps.event.clearListeners(t,"idle"),this._mutant&&google.maps.event.clearListeners(this._mutant,"idle"),t.off("viewreset",this._reset,this),t.off("move",this._update,this),t.off("moveend",this._update,this),t.off("zoomend",this._handleZoomAnim,this),t.off("resize",this._resize,this),t._controlCorners&&(t._controlCorners.bottomright.style.marginBottom=0,t._controlCorners.bottomleft.style.marginBottom=0),this._isMounted=!1},
// @method addGoogleLayer(name: String, options?: Object): this
// Adds layer with the given name and options to the google Map instance.
// `name`: one of the google maps API layers, with it's constructor available in `google.maps` object.
// currently following values supported: 'TrafficLayer', 'TransitLayer', 'BicyclingLayer'.
// `options`: see https://developers.google.com/maps/documentation/javascript/reference/map
addGoogleLayer:function(t,e){return this._subLayers||(this._subLayers={}),this._GAPIPromise.then(function(){var i=new(0,google.maps[t])(e);this._mutant&&i.setMap(this._mutant),// otherwise it will be added on 'spawned'
this._subLayers[t]=i}.bind(this)),this},
// @method removeGoogleLayer(name: String): this
// Removes layer with the given name from the google Map instance.
removeGoogleLayer:function(t){return this._GAPIPromise.then(function(){var e=this._subLayers&&this._subLayers[t];e&&(e.setMap(null),delete this._subLayers[t])}.bind(this)),this},_initMutantContainer:function(){this._mutantContainer||(this._mutantContainer=L.DomUtil.create("div","leaflet-google-mutant leaflet-top leaflet-left"),this._mutantContainer.id="_MutantContainer_"+L.Util.stamp(this._mutantContainer),this._mutantContainer.style.zIndex=800,//leaflet map pane at 400, controls at 1000
this._mutantContainer.style.pointerEvents="none",L.DomEvent.off(this._mutantContainer)),this._map.getContainer().appendChild(this._mutantContainer),this.setOpacity(this.options.opacity);var t=this._mutantContainer.style;t.width="100%",t.height="100%",this._attachObserver(this._mutantContainer)},_initMutant:function(){if(!this._mutant){var t=new google.maps.Map(this._mutantContainer,{center:{lat:0,lng:0},zoom:0,tilt:0,mapTypeId:this.options.type,disableDefaultUI:!0,keyboardShortcuts:!1,draggable:!1,disableDoubleClickZoom:!0,scrollwheel:!1,streetViewControl:!1,styles:this.options.styles||{},backgroundColor:"transparent"});this._mutant=t,google.maps.event.addListenerOnce(t,"idle",function(){for(var t=this._mutantContainer.querySelectorAll("a"),e=0;e<t.length;++e)t[e].style.pointerEvents="auto"}.bind(this)),// 🍂event spawned
// Fired when the mutant has been created.
this.fire("spawned",{mapObject:t})}},_attachObserver:function(t){
// 		console.log('Gonna observe', node);
this._observer||(this._observer=new MutationObserver(this._onMutations.bind(this))),// pass in the target node, as well as the observer options
this._observer.observe(t,{childList:!0,subtree:!0}),// if we are reusing an old _mutantContainer, we must manually detect
// all existing tiles in it
Array.prototype.forEach.call(t.querySelectorAll("img"),this._boundOnMutatedImage)},_onMutations:function(t){for(var e=0;e<t.length;++e)for(var i=t[e],n=0;n<i.addedNodes.length;++n){var a=i.addedNodes[n];a instanceof HTMLImageElement?this._onMutatedImage(a):a instanceof HTMLElement&&(Array.prototype.forEach.call(a.querySelectorAll("img"),this._boundOnMutatedImage),// Check for, and remove, the "Google Maps can't load correctly" div.
// You *are* loading correctly, you dumbwit.
"white"===a.style.backgroundColor&&L.DomUtil.remove(a),// Check for, and remove, the "For development purposes only" divs on the aerial/hybrid tiles.
0===a.textContent.indexOf("For development purposes only")&&L.DomUtil.remove(a),// Check for, and remove, the "Sorry, we have no imagery here"
// empty <div>s. The [style*="text-align: center"] selector
// avoids matching the attribution notice.
// This empty div doesn't have a reference to the tile
// coordinates, so it's not possible to mark the tile as
// failed.
Array.prototype.forEach.call(a.querySelectorAll('div[draggable=false][style*="text-align: center"]'),L.DomUtil.remove))}},
// Only images which 'src' attrib match this will be considered for moving around.
// Looks like some kind of string-based protobuf, maybe??
// Only the roads (and terrain, and vector-based stuff) match this pattern
_roadRegexp:/!1i(\d+)!2i(\d+)!3i(\d+)!/,
// On the other hand, raster imagery matches this other pattern
_satRegexp:/x=(\d+)&y=(\d+)&z=(\d+)/,
// On small viewports, when zooming in/out, a static image is requested
// This will not be moved around, just removed from the DOM.
_staticRegExp:/StaticMapService\.GetMapImage/,_onMutatedImage:function(t){
// 		if (imgNode.src) {
// 			console.log('caught mutated image: ', imgNode.src);
// 		}
var e,i=t.src.match(this._roadRegexp),n=0;if(i?(e={z:i[1],x:i[2],y:i[3]},this._imagesPerTile>1&&(t.style.zIndex=1,n=1)):((i=t.src.match(this._satRegexp))&&(e={x:i[1],y:i[2],z:i[3]}),// 			imgNode.style.zIndex = 0;
n=0),e){var a=this._tileCoordsToKey(e);t.style.position="absolute",t.style.visibility="hidden";var s=a+"/"+n;// console.log('mutation for tile', key)
//store img so it can also be used in subsequent tile requests
if(this._freshTiles[s]=t,s in this._tileCallbacks&&this._tileCallbacks[s])
// console.log('Fullfilling callback ', key);
//fullfill most recent tileCallback because there maybe callbacks that will never get a
//corresponding mutation (because map moved to quickly...)
this._tileCallbacks[s].pop()(t),this._tileCallbacks[s].length||delete this._tileCallbacks[s];else if(this._tiles[a]){
//we already have a tile in this position (mutation is probably a google layer being added)
//replace it
var o=this._tiles[a].el,r=0===n?o.firstChild:o.firstChild.nextSibling,l=this._clone(t);o.replaceChild(l,r)}}else t.src.match(this._staticRegExp)&&(t.style.visibility="hidden")},createTile:function(t,e){var i=this._tileCoordsToKey(t),n=L.DomUtil.create("div");n.dataset.pending=this._imagesPerTile,e=e.bind(this,null,n);for(var a=0;a<this._imagesPerTile;++a){var s=i+"/"+a;if(s in this._freshTiles){var o=this._freshTiles[s];n.appendChild(this._clone(o)),--n.dataset.pending}else this._tileCallbacks[s]=this._tileCallbacks[s]||[],this._tileCallbacks[s].push(function(t
/*, k2*/){return function(i){t.appendChild(this._clone(i)),--t.dataset.pending,parseInt(t.dataset.pending)||e()}.bind(this)}.bind(this)(n
/*, key2*/))}return parseInt(n.dataset.pending)||L.Util.requestAnimFrame(e),n},_clone:function(t){var e=t.cloneNode(!0);return e.style.visibility="visible",e},_checkZoomLevels:function(){
//setting the zoom level on the Google map may result in a different zoom level than the one requested
//(it won't go beyond the level for which they have data).
var t=this._map.getZoom(),e=this._mutant.getZoom();t&&e&&(e!==t||//zoom levels are out of sync, Google doesn't have data
e>this.options.maxNativeZoom)&&
//at current location, Google does have data (contrary to maxNativeZoom)
//Update maxNativeZoom
this._setMaxNativeZoom(e)},_setMaxNativeZoom:function(t){t!==this.options.maxNativeZoom&&(this.options.maxNativeZoom=t,this._resetView())},_update:function(){
// zoom level check needs to happen before super's implementation (tile addition/creation)
// otherwise tiles may be missed if maxNativeZoom is not yet correctly determined
if(this._mutant){var t=this._map.getCenter(),e=new google.maps.LatLng(t.lat,t.lng);this._mutant.setCenter(e);var i=this._map.getZoom(),n=i!==Math.round(i),a=this._mutant.getZoom();//ignore fractional zoom levels
n||i===a||(this._mutant.setZoom(i),this._mutantIsReady&&this._checkZoomLevels())}L.GridLayer.prototype._update.call(this)},_resize:function(){var t=this._map.getSize();this._mutantContainer.style.width===t.x&&this._mutantContainer.style.height===t.y||(this.setElementSize(this._mutantContainer,t),this._mutant&&google.maps.event.trigger(this._mutant,"resize"))},_handleZoomAnim:function(){if(this._mutant){var t=this._map.getCenter(),e=new google.maps.LatLng(t.lat,t.lng);this._mutant.setCenter(e),this._mutant.setZoom(Math.round(this._map.getZoom()));var i=this._mutant.getZoom();// for (let key of Object.keys(this._freshTiles)) {
// IE-compatible code, in ecmascript5:
for(var n in Object.keys(this._freshTiles))i!==n.split(":")[2]
/* tileZoom */&&delete this._freshTiles[n]}},
// Agressively prune _freshtiles when a tile with the same key is removed,
// this prevents a problem where Leaflet keeps a loaded tile longer than
// GMaps, so that GMaps makes two requests but Leaflet only consumes one,
// polluting _freshTiles with stale data.
_removeTile:function(t){if(this._mutant)//give time for animations to finish before checking it tile should be pruned
return setTimeout(this._pruneTile.bind(this,t),1e3),L.GridLayer.prototype._removeTile.call(this,t)},_getLargeGMapBound:function(t){var e=t.getSouthWest(),i=t.getNorthEast(),n=e.lat(),a=e.lng(),s=i.lat(),o=i.lng(),r=Math.abs(s-n),l=Math.abs(o-a);return L.latLngBounds([[n-r,a-l],[s+r,o+l]])},_pruneTile:function(t){var e=this._mutant.getZoom(),i=t.split(":")[2],n=this._mutant.getBounds(),a=this._getLargeGMapBound(n);if(n)for(var s=0;s<this._imagesPerTile;++s){var o=t+"/"+s;if(o in this._freshTiles){var r=this._map&&this._keyToBounds(t);this._map&&r.overlaps(a)&&i===e||delete this._freshTiles[o];//                              console.log('Prunning of ', key, (!stillVisible))
}}}}),// 🍂factory gridLayer.googleMutant(options)
// Returns a new `GridLayer.GoogleMutant` given its options
L.gridLayer.googleMutant=function(t){return new L.GridLayer.GoogleMutant(t)},
/*!
 * Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 * License: WTFPL V2, 2004 (wtfpl.net).
 * Though credit and staring the repo will make me feel pretty, you can modify and redistribute as you please.
 * Attempts to follow spec (https://www.w3.org/TR/dom/#mutation-observers) as closely as possible for native javascript
 * See https://github.com/WebKit/webkit/blob/master/Source/WebCore/dom/MutationObserver.cpp for current webkit source c++ implementation
 */
/**
 * prefix bugs:
    - https://bugs.webkit.org/show_bug.cgi?id=85161
    - https://bugzilla.mozilla.org/show_bug.cgi?id=749920
 * Don't use WebKitMutationObserver as Safari (6.0.5-6.1) use a buggy implementation
*/
window.MutationObserver||(window.MutationObserver=function(t){"use strict";
/**
     * @param {function(Array.<MutationRecord>, MutationObserver)} listener
     * @constructor
     */function e(t){
/**
       * @type {Array.<Object>}
       * @private
       */
this._watched=[],
/** @private */
this._listener=t}
/**
     * Start a recursive timeout function to check all items being observed for mutations
     * @type {MutationObserver} observer
     * @private
     */
/**
     * Simple MutationRecord pseudoclass. No longer exposing as its not fully compliant
     * @param {Object} data
     * @return {Object} a MutationRecord
     */
function i(e){var i={
// technically these should be on proto so hasOwnProperty will return false for non explicitly props
type:null,target:null,addedNodes:[],removedNodes:[],previousSibling:null,nextSibling:null,attributeName:null,attributeNamespace:null,oldValue:null};for(var n in e)m(i,n)&&e[n]!==t&&(i[n]=e[n]);return i}
/**
     * Creates a func to find all the mutations
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     */function n(e,n){
/** type {Elestuct} */
var a=r(e,n);// create the cloned datastructure
/**
       * consumes array of mutations we can push to
       *
       * @param {Array.<MutationRecord>} mutations
       */return function(s){var h,d=s.length;n.charData&&3===e.nodeType&&e.nodeValue!==a.charData&&s.push(new i({type:"characterData",target:e,oldValue:a.charData})),// Alright we check base level changes in attributes... easy
n.attr&&a.attr&&o(s,e,a.attr,n.afilter),// check childlist or subtree for mutations
(n.kids||n.descendents)&&(h=
/**
     * searchSubtree: array of mutations so far, element, element clone, bool
     * synchronous dfs comparision of two nodes
     * This function is applied to any observed element with childList or subtree specified
     * Sorry this is kind of confusing as shit, tried to comment it a bit...
     * codereview.stackexchange.com/questions/38351 discussion of an earlier version of this func
     *
     * @param {Array} mutations
     * @param {Node} $target
     * @param {!Object} $oldstate : A custom cloned node from clone()
     * @param {!Object} config : A custom mutation config
     */
function(e,n,a,s){
// Track if the tree is dirty and has to be recomputed (#14).
var r;
/*
       * Helper to identify node rearrangment and stuff...
       * There is no gaurentee that the same node will be identified for both added and removed nodes
       * if the positions have been shuffled.
       * conflicts array will be emptied by end of operation
       */function h(t,n,a,r,l){for(
// the distance between the first conflicting node and the last
var h,u,c,m=t.length-1,_=-~((m-l)/2)// prevents same conflict being resolved twice consider when two nodes switch places.
// only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
;c=t.pop();)h=a[c.i],u=r[c.j],// attempt to determine if there was node rearrangement... won't gaurentee all matches
// also handles case where added/removed nodes cause nodes to be identified as conflicts
s.kids&&_&&Math.abs(c.i-c.j)>=m&&(e.push(i({type:"childList",target:n,addedNodes:[h],removedNodes:[h],
// haha don't rely on this please
nextSibling:h.nextSibling,previousSibling:h.previousSibling})),_--),// Alright we found the resorted nodes now check for other types of mutations
s.attr&&u.attr&&o(e,h,u.attr,s.afilter),s.charData&&3===h.nodeType&&h.nodeValue!==u.charData&&e.push(i({type:"characterData",target:h,oldValue:u.charData})),// now look @ subtree
s.descendents&&d(h,u)}
/**
       * Main worker. Finds and adds mutations if there are any
       * @param {Node} node
       * @param {!Object} old : A cloned data structure using internal clone
       */function d(n,a){// while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
for(var m,_,p,g,f,v,y,b=n.childNodes,L=a.kids,C=b.length,w=L?L.length:0,M=0,T=0,x=0;T<C||x<w;)
// current and old nodes at the indexs
(v=b[T])===(y=(f=L[x])&&f.node)?(
// expected case - optimized for this case
// check attributes as specified by config
s.attr&&f.attr&&
/* oldstruct.attr instead of textnode check */
o(e,v,f.attr,s.afilter),// check character data if node is a comment or textNode and it's being observed
s.charData&&f.charData!==t&&v.nodeValue!==f.charData&&e.push(i({type:"characterData",target:v,oldValue:f.charData})),// resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
_&&h(_,n,b,L,M),// recurse on next level of children. Avoids the recursive call when there are no children left to iterate
s.descendents&&(v.childNodes.length||f.kids&&f.kids.length)&&d(v,f),T++,x++):(
// (uncommon case) lookahead until they are the same again or the end of children
r=!0,m||(
// delayed initalization (big perf benefit)
m={},_=[]),v&&(
// check id is in the location map otherwise do a indexOf search
m[p=u(v)]||(
// to prevent double checking
// mark id as found
m[p]=!0,// custom indexOf using comparitor checking oldkids[i].node === $cur
-1===(g=l(L,v,x))?s.kids&&(e.push(i({type:"childList",target:n,addedNodes:[v],
// $cur is a new node
nextSibling:v.nextSibling,previousSibling:v.previousSibling})),M++):_.push({
// add conflict
i:T,j:g})),T++),y&&// special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
y!==b[T]&&(m[p=u(y)]||(m[p]=!0,-1===(g=c(b,y,T))?s.kids&&(e.push(i({type:"childList",target:a.node,removedNodes:[y],nextSibling:L[x+1],
// praise no indexoutofbounds exception
previousSibling:L[x-1]})),M--):_.push({i:g,j:x})),x++));// end loop
// resolve any remaining conflicts
_&&h(_,n,b,L,M)}return d(n,a),r}
/**
     * Utility
     * Cones a element into a custom data structure designed for comparision. https://gist.github.com/megawac/8201012
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     * @return {!Object} : Cloned data structure
     */(s,e,a,n)),// reclone data structure if theres changes
(h||s.length!==d)&&(
/** type {Elestuct} */
a=r(e,n))}}
/* attributes + attributeFilter helpers */
// Check if the environment has the attribute bug (#4) which cause
// element.attributes.style to always be null.
/**
     * Period to check for mutations (~32 times/sec)
     * @type {number}
     * @expose
     */
e._period=30
/*ms+runtime*/,
/**
     * Exposed API
     * @expose
     * @final
     */
e.prototype={
/**
       * see https://dom.spec.whatwg.org/#dom-mutationobserver-observe
       * not going to throw here but going to follow the current spec config sets
       * @param {Node|null} $target
       * @param {Object|null} config : MutationObserverInit configuration dictionary
       * @expose
       * @return undefined
       */
observe:function(t,i){// remove already observed target element from pool
for(
/**
         * Using slightly different names so closure can go ham
         * @type {!Object} : A custom mutation config
         */
var a,s={attr:!!(i.attributes||i.attributeFilter||i.attributeOldValue),
// some browsers enforce that subtree must be set with childList, attributes or characterData.
// We don't care as spec doesn't specify this rule.
kids:!!i.childList,descendents:!!i.subtree,charData:!(!i.characterData&&!i.characterDataOldValue)},o=this._watched,r=0;r<o.length;r++)o[r].tar===t&&o.splice(r,1);i.attributeFilter&&(
/**
           * converts to a {key: true} dict for faster lookup
           * @type {Object.<String,Boolean>}
           */
s.afilter=d(i.attributeFilter,(function(t,e){return t[e]=!0,t}),{})),o.push({tar:t,fn:n(t,s)}),// reconnect if not connected
this._timeout||(a=this,function t(){var i=a.takeRecords();i.length&&
// fire away
// calling the listener with context is not spec but currently consistent with FF and WebKit
a._listener(i,a)
/** @private */,a._timeout=setTimeout(t,e._period)}())},
/**
       * Finds mutations since last check and empties the "record queue" i.e. mutations will only be found once
       * @expose
       * @return {Array.<MutationRecord>}
       */
takeRecords:function(){for(var t=[],e=this._watched,i=0;i<e.length;i++)e[i].fn(t);return t},
/**
       * @expose
       * @return undefined
       */
disconnect:function(){this._watched=[],// clear the stuff being observed
clearTimeout(this._timeout),// ready for garbage collection
/** @private */
this._timeout=null}};var a=document.createElement("i");a.style.top=0;var s=(a="null"!=a.attributes.style.value)?
/**
     * Gets an attribute value in an environment without attribute bug
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */
function(t,e){
// There is a potential for a warning to occur here if the attribute is a
// custom attribute in IE<9 with a custom .toString() method. This is
// just a warning and doesn't affect execution (see #21)
return e.value}
/**
     * Gets an attribute value with special hack for style attribute (see #4)
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */:function(t,e){
// As with getAttributeSimple there is a potential warning for custom attribtues in IE7.
return"style"!==e.name?e.value:t.style.cssText};
/**
     * fast helper to check to see if attributes object of an element has changed
     * doesnt handle the textnode case
     *
     * @param {Array.<MutationRecord>} mutations
     * @param {Node} $target
     * @param {Object.<string, string>} $oldstate : Custom attribute clone data structure from clone
     * @param {Object} filter
     */function o(t,e,n,a){for(var o,r,l={},h=e.attributes,u=h.length;u--;)r=(o=h[u]).name,a&&!m(a,r)||(s(e,o)!==n[r]&&
// The pushing is redundant but gzips very nicely
t.push(i({type:"attributes",target:e,attributeName:r,oldValue:n[r],attributeNamespace:o.namespaceURI})),l[r]=!0);for(r in n)l[r]||t.push(i({target:e,type:"attributes",attributeName:r,oldValue:n[r]}))}function r(t,e){var i=!0;// set true so childList we'll always check the first level
return function t(n){var a={
/** @type {Node} */
node:n};// Store current character data of target text or comment node if the config requests
// those properties to be observed.
return!e.charData||3!==n.nodeType&&8!==n.nodeType?(
// Add attr only if subtree is specified or top level and avoid if
// attributes is a document object (#13).
e.attr&&i&&1===n.nodeType&&(
/**
               * clone live attribute list to an object structure {name: val}
               * @type {Object.<string, string>}
               */
a.attr=d(n.attributes,(function(t,i){return e.afilter&&!e.afilter[i.name]||(t[i.name]=s(n,i)),t}),{})),// whether we should iterate the children of $target node
i&&(e.kids||e.charData||e.attr&&e.descendents)&&(
/** @type {Array.<!Object>} : Array of custom clone */
a.kids=
/**
     * **map** Apply a mapping function to each item of a set
     * @param {Array|NodeList} set
     * @param {Function} iterator
     */
function(t,e){for(var i=[],n=0;n<t.length;n++)i[n]=e(t[n],n,t);return i}
/**
     * **Reduce** builds up a single result from a list of values
     * @param {Array|NodeList|NamedNodeMap} set
     * @param {Function} iterator
     * @param {*} [memo] Initial value of the memo.
     */(n.childNodes,t)),i=e.descendents):a.charData=n.nodeValue,a}(t)}
/**
     * indexOf an element in a collection of custom nodes
     *
     * @param {NodeList} set
     * @param {!Object} $node : A custom cloned node
     * @param {number} idx : index to start the loop
     * @return {number}
     */function l(t,e,i){return c(t,e,i,"node")}// using a non id (eg outerHTML or nodeValue) is extremely naive and will run into issues with nodes that may appear the same like <li></li>
var h=1;// don't use 0 as id (falsy)
/** @const */
/**
     * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
     *
     * @param {Node} $ele
     * @return {(string|number)}
     */
function u(t){try{return t.id||(t.mo_id=t.mo_id||h++)}catch(e){
// ie <8 will throw if you set an unknown property on a text node
try{return t.nodeValue;// naive
}catch(t){
// when text node is removed: https://gist.github.com/megawac/8355978 :(
return h++}}}function d(t,e,i){for(var n=0;n<t.length;n++)i=e(i,t[n],n,t);return i}
/**
     * **indexOf** find index of item in collection.
     * @param {Array|NodeList} set
     * @param {Object} item
     * @param {number} idx
     * @param {string} [prop] Property on set item to compare to item
     */function c(t,e,i,n){for(;
/*idx = ~~idx*/
i<t.length;i++)
// start idx is always given as this is internal
if((n?t[i][n]:t[i])===e)return i;return-1}
/**
     * @param {Object} obj
     * @param {(string|number)} prop
     * @return {boolean}
     */function m(e,i){return e[i]!==t;// will be nicely inlined by gcc
}// GCC hack see https://stackoverflow.com/a/23202438/1517919
return e}(void 0));