<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2018 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */
namespace DPCalendar\HTML\Block;

defined('_JEXEC') or die();

/**
 * Icon constants
 */
class Icon
{
	/**
	 * The back icon.
	 *
	 * @var string
	 */
	const BACK = 'angle-left';

	/**
	 * The bullseye icon.
	 *
	 * @var string
	 */
	const BULLSEYE = 'bullseye';

	/**
	 * The calendar icon.
	 *
	 * @var string
	 */
	const CALENDAR = 'calendar';

	/**
	 * The cancel icon.
	 *
	 * @var string
	 */
	const CANCEL = 'ban';

	/**
	 * The clock icon.
	 *
	 * @var string
	 */
	const CLOCK = 'clock';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	const COG = 'cog';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	const DATABASE = 'database';

	/**
	 * The delete icon.
	 *
	 * @var string
	 */
	const DELETE = 'trash';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	const DIRECTIONS = 'directions';

	/**
	 * The down icon.
	 *
	 * @var string
	 */
	const DOWN = 'caret-down';

	/**
	 * The download icon.
	 *
	 * @var string
	 */
	const DOWNLOAD = 'download';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	const EDIT = 'pencil';

	/**
	 * The exclamation icon.
	 *
	 * @var string
	 */
	const EXCLAMATION = 'exclamation';

	/**
	 * The external link icon.
	 *
	 * @var string
	 */
	const EXTERNAL = 'external-link-square';

	/**
	 * The file icon.
	 *
	 * @var string
	 */
	const FILE = 'file';

	/**
	 * The info icon.
	 *
	 * @var string
	 */
	const INFO = 'info-circle';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	const LANGUAGE = 'globe';

	/**
	 * The list icon.
	 *
	 * @var string
	 */
	const LISTING = 'list';

	/**
	 * The location icon.
	 *
	 * @var string
	 */
	const LOCATION = 'map-marker';

	/**
	 * The lock icon.
	 *
	 * @var string
	 */
	const LOCK = 'lock';

	/**
	 * The mail icon.
	 *
	 * @var string
	 */
	const MAIL = 'envelope';

	/**
	 * The map icon.
	 *
	 * @var string
	 */
	const MAP = 'map-marked';

	/**
	 * The money icon.
	 *
	 * @var string
	 */
	const MONEY = 'money-bill';

	/**
	 * The multiple item icon.
	 *
	 * @var string
	 */
	const MULTIPLE = 'clone';

	/**
	 * The next icon.
	 *
	 * @var string
	 */
	const NEXT = 'angle-right';

	/**
	 * The ok icon.
	 *
	 * @var string
	 */
	const OK = 'check';

	/**
	 * The plus icon.
	 *
	 * @var string
	 */
	const PLUS = 'plus';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	const PRINTING = 'print';

	/**
	 * The recurring icon.
	 *
	 * @var string
	 */
	const RECURRING = 'redo';

	/**
	 * The search icon.
	 *
	 * @var string
	 */
	const SEARCH = 'search';

	/**
	 * The signup icon.
	 *
	 * @var string
	 */
	const SIGNUP = 'sign-in';

	/**
	 * The single item icon.
	 *
	 * @var string
	 */
	const SINGLE = 'square';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	const SYNC = 'sync';

	/**
	 * The up icon.
	 *
	 * @var string
	 */
	const UP = 'caret-up';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	const USERS = 'users';

	/**
	 * The icon cache, used by the layout.
	 *
	 * @var array
	 */
	public static $pathCache = [];
}
