function _typeof(t){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}!function(t,i){"function"==typeof define&&define.amd?
// AMD
define(["leaflet","mapbox-gl"],i):"object"===("undefined"==typeof exports?"undefined":_typeof(exports))?
// Node, CommonJS-like
module.exports=i(require("leaflet"),require("mapbox-gl")):
// Browser globals (root is window)
t.returnExports=i(window.L,window.mapboxgl)}(this,(function(t,i){t.MapboxGL=t.Layer.extend({options:{updateInterval:32,
// How much to extend the overlay view (relative to map size)
// e.g. 0.1 would be 10% of map view in each direction
padding:.1,
// whether or not to register the mouse and keyboard
// events on the mapbox overlay
interactive:!1,
// set the tilepane as the default pane to draw gl tiles
pane:"tilePane"},initialize:function(o){t.setOptions(this,o),o.accessToken&&(i.accessToken=o.accessToken),// setup throttling the update event when panning
this._throttledUpdate=t.Util.throttle(this._update,this.options.updateInterval,this)},onAdd:function(i){this._container||this._initContainer();var o=this.getPaneName();i.getPane(o).appendChild(this._container),this._initGL(),this._offset=this._map.containerPointToLayerPoint([0,0]),// work around https://github.com/mapbox/mapbox-gl-leaflet/issues/47
i.options.zoomAnimation&&t.DomEvent.on(i._proxy,t.DomUtil.TRANSITION_END,this._transitionEnd,this)},onRemove:function(i){this._map._proxy&&this._map.options.zoomAnimation&&t.DomEvent.off(this._map._proxy,t.DomUtil.TRANSITION_END,this._transitionEnd,this);var o=this.getPaneName();i.getPane(o).removeChild(this._container),this._glMap.remove(),this._glMap=null},getEvents:function(){return{move:this._throttledUpdate,
// sensibly throttle updating while panning
zoomanim:this._animateZoom,
// applys the zoom animation to the <canvas>
zoom:this._pinchZoom,
// animate every zoom event for smoother pinch-zooming
zoomstart:this._zoomStart,
// flag starting a zoom to disable panning
zoomend:this._zoomEnd,resize:this._resize}},getMapboxMap:function(){return this._glMap},getCanvas:function(){return this._glMap.getCanvas()},getSize:function(){return this._map.getSize().multiplyBy(1+2*this.options.padding)},getBounds:function(){var i=this.getSize().multiplyBy(.5),o=this._map.latLngToContainerPoint(this._map.getCenter());return t.latLngBounds(this._map.containerPointToLatLng(o.subtract(i)),this._map.containerPointToLatLng(o.add(i)))},getContainer:function(){return this._container},
// returns the pane name set in options if it is a valid pane, defaults to tilePane
getPaneName:function(){return this._map.getPane(this.options.pane)?this.options.pane:"tilePane"},_initContainer:function(){var i=this._container=t.DomUtil.create("div","leaflet-gl-layer"),o=this.getSize(),n=this._map.getSize().multiplyBy(this.options.padding);i.style.width=o.x+"px",i.style.height=o.y+"px";var e=this._map.containerPointToLayerPoint([0,0]).subtract(n);t.DomUtil.setPosition(i,e)},_initGL:function(){var o=this._map.getCenter(),n=t.extend({},this.options,{container:this._container,center:[o.lng,o.lat],zoom:this._map.getZoom()-1,attributionControl:!1});this._glMap=new i.Map(n),// allow GL base map to pan beyond min/max latitudes
this._glMap.transform.latRange=null,this._glMap._canvas.canvas?
// older versions of mapbox-gl surfaced the canvas differently
this._glMap._actualCanvas=this._glMap._canvas.canvas:this._glMap._actualCanvas=this._glMap._canvas;// treat child <canvas> element like L.ImageOverlay
var e=this._glMap._actualCanvas;t.DomUtil.addClass(e,"leaflet-image-layer"),t.DomUtil.addClass(e,"leaflet-zoom-animated"),this.options.interactive&&t.DomUtil.addClass(e,"leaflet-interactive"),this.options.className&&t.DomUtil.addClass(e,this.options.className)},_update:function(o){if(
// update the offset so we can correct for it later when we zoom
this._offset=this._map.containerPointToLayerPoint([0,0]),!this._zooming){var n=this.getSize(),e=this._container,a=this._glMap,s=this._map.getSize().multiplyBy(this.options.padding),r=this._map.containerPointToLayerPoint([0,0]).subtract(s);t.DomUtil.setPosition(e,r);var p=this._map.getCenter(),m=a.transform;// gl.setView([center.lat, center.lng], this._map.getZoom() - 1, 0);
// calling setView directly causes sync issues because it uses requestAnimFrame
m.center=i.LngLat.convert([p.lng,p.lat]),m.zoom=this._map.getZoom()-1,a.transform.width!==n.x||a.transform.height!==n.y?(e.style.width=n.x+"px",e.style.height=n.y+"px",null!==a._resize&&void 0!==a._resize?a._resize():a.resize()):
// older versions of mapbox-gl surfaced update publicly
null!==a._update&&void 0!==a._update?a._update():a.update()}},
// update the map constantly during a pinch zoom
_pinchZoom:function(t){this._glMap.jumpTo({zoom:this._map.getZoom()-1,center:this._map.getCenter()})},
// borrowed from L.ImageOverlay
// https://github.com/Leaflet/Leaflet/blob/master/src/layer/ImageOverlay.js#L139-L144
_animateZoom:function(i){var o=this._map.getZoomScale(i.zoom),n=this._map.getSize().multiplyBy(this.options.padding*o),e=this.getSize()._divideBy(2),a=this._map.project(i.center,i.zoom)._subtract(e)._add(this._map._getMapPanePos().add(n))._round(),s=this._map.project(this._map.getBounds().getNorthWest(),i.zoom)._subtract(a);t.DomUtil.setTransform(this._glMap._actualCanvas,s.subtract(this._offset),o)},_zoomStart:function(t){this._zooming=!0},_zoomEnd:function(){var i=this._map.getZoomScale(this._map.getZoom()),o=this._map._latLngToNewLayerPoint(this._map.getBounds().getNorthWest(),this._map.getZoom(),this._map.getCenter());t.DomUtil.setTransform(this._glMap._actualCanvas,o.subtract(this._offset),i),this._zooming=!1,this._update()},_transitionEnd:function(i){t.Util.requestAnimFrame((function(){var i=this._map.getZoom(),o=this._map.getCenter(),n=this._map.latLngToContainerPoint(this._map.getBounds().getNorthWest());// reset the scale and offset
t.DomUtil.setTransform(this._glMap._actualCanvas,n,1),// enable panning once the gl map is ready again
this._glMap.once("moveend",t.Util.bind((function(){this._zoomEnd()}),this)),// update the map position
this._glMap.jumpTo({center:o,zoom:i-1})}),this)},_resize:function(t){this._transitionEnd(t)}}),t.mapboxGL=function(i){return new t.MapboxGL(i)}}));