function _typeof(t){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}
/* @preserve
 * Leaflet 1.7.1, a JS library for interactive maps. http://leafletjs.com
 * (c) 2010-2019 Vladimir Agafonkin, (c) 2010-2011 CloudMade
 */
!function(t,e){"object"===("undefined"==typeof exports?"undefined":_typeof(exports))&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.L={})}(this,function(t){"use strict";
/*
   * @namespace Util
   *
   * Various utility functions, used by Leaflet internally.
   */
// @function extend(dest: Object, src?: Object): Object
// Merges the properties of the `src` object (or multiple objects) into `dest` object and returns the latter. Has an `L.extend` shortcut.
function h(t){for(var e,i,n=1,o=arguments.length;n<o;n++)for(e in i=arguments[n])t[e]=i[e];return t}// @function create(proto: Object, properties?: Object): Object
// Compatibility polyfill for [Object.create](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/create)
var s=Object.create||function(t){return e.prototype=t,new e};// @function bind(fn: Function, …): Function
// Returns a new function bound to the arguments passed, like [Function.prototype.bind](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
// Has a `L.bind()` shortcut.
function e(){}function _(t,e){var i=Array.prototype.slice;if(t.bind)return t.bind.apply(t,i.call(arguments,1));var n=i.call(arguments,2);return function(){return t.apply(e,n.length?n.concat(i.call(arguments)):arguments)}}// @property lastId: Number
// Last unique ID used by [`stamp()`](#util-stamp)
var i=0;// @function stamp(obj: Object): Number
// Returns the unique ID of an object, assigning it one if it doesn't have it.
function m(t){
/*eslint-disable */
return t._leaflet_id=t._leaflet_id||++i,t._leaflet_id;
/* eslint-enable */}// @function throttle(fn: Function, time: Number, context: Object): Function
// Returns a function which executes function `fn` with the given scope `context`
// (so that the `this` keyword refers to `context` inside `fn`'s code). The function
// `fn` will be called no more than one time per given amount of `time`. The arguments
// received by the bound function will be any arguments passed when binding the
// function, followed by any arguments passed when invoking the bound function.
// Has an `L.throttle` shortcut.
function n(t,e,i){var n,o,s=function(){
// reset lock and call if queued
n=!1,o&&(r.apply(i,o),o=!1)},r=function(){n?
// called too soon, queue to call later
o=arguments:(
// call and lock until later
t.apply(i,arguments),setTimeout(s,e),n=!0)};return r}// @function wrapNum(num: Number, range: Number[], includeMax?: Boolean): Number
// Returns the number `num` modulo `range` in such a way so it lies within
// `range[0]` and `range[1]`. The returned value will be always smaller than
// `range[1]` unless `includeMax` is set to `true`.
function o(t,e,i){var n=e[1],o=e[0],e=n-o;return t===n&&i?t:((t-o)%e+e)%e+o}// @function falseFn(): Function
// Returns a function which always returns `false`.
function a(){return!1}// @function formatNum(num: Number, digits?: Number): Number
// Returns the number `num` rounded to `digits` decimals, or to 6 decimals by default.
function r(t,e){e=Math.pow(10,void 0===e?6:e);return Math.round(t*e)/e}// @function trim(str: String): String
// Compatibility polyfill for [String.prototype.trim](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String/Trim)
function l(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")}// @function splitWords(str: String): String[]
// Trims and splits the string on whitespace and returns the array of parts.
function u(t){return l(t).split(/\s+/)}// @function setOptions(obj: Object, options: Object): Object
// Merges the given properties to the `options` of the `obj` object, returning the resulting options. See `Class options`. Has an `L.setOptions` shortcut.
function c(t,e){for(var i in Object.prototype.hasOwnProperty.call(t,"options")||(t.options=t.options?s(t.options):{}),e)t.options[i]=e[i];return t.options}// @function getParamString(obj: Object, existingUrl?: String, uppercase?: Boolean): String
// Converts an object into a parameter URL string, e.g. `{a: "foo", b: "bar"}`
// translates to `'?a=foo&b=bar'`. If `existingUrl` is set, the parameters will
// be appended at the end. If `uppercase` is `true`, the parameter names will
// be uppercased (e.g. `'?A=foo&B=bar'`)
function d(t,e,i){var n,o=[];for(n in t)o.push(encodeURIComponent(i?n.toUpperCase():n)+"="+encodeURIComponent(t[n]));return(e&&-1!==e.indexOf("?")?"&":"?")+o.join("&")}var p=/\{ *([\w_-]+) *\}/g;// @function template(str: String, data: Object): String
// Simple templating facility, accepts a template string of the form `'Hello {a}, {b}'`
// and a data object like `{a: 'foo', b: 'bar'}`, returns evaluated string
// `('Hello foo, bar')`. You can also specify functions instead of strings for
// data values — they will be evaluated passing `data` as an argument.
function f(t,i){return t.replace(p,function(t,e){e=i[e];if(void 0===e)throw new Error("No value provided for variable "+t);return"function"==typeof e&&(e=e(i)),e})}// @function isArray(obj): Boolean
// Compatibility polyfill for [Array.isArray](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray)
var g=Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)};// @function indexOf(array: Array, el: Object): Number
// Compatibility polyfill for [Array.prototype.indexOf](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf)
function v(t,e){for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1}// @property emptyImageUrl: String
// Data URI string containing a base64-encoded empty GIF image.
// Used as a hack to free memory from unused images on WebKit-powered
// mobile devices (by setting image `src` to this string).
var y="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=";// inspired by http://paulirish.com/2011/requestanimationframe-for-smart-animating/
function x(t){return window["webkit"+t]||window["moz"+t]||window["ms"+t]}var w=0;// fallback for IE 7-8
function b(t){var e=+new Date,i=Math.max(0,16-(e-w));return w=e+i,window.setTimeout(t,i)}var P=window.requestAnimationFrame||x("RequestAnimationFrame")||b,C=window.cancelAnimationFrame||x("CancelAnimationFrame")||x("CancelRequestAnimationFrame")||function(t){window.clearTimeout(t)};// @function requestAnimFrame(fn: Function, context?: Object, immediate?: Boolean): Number
// Schedules `fn` to be executed when the browser repaints. `fn` is bound to
// `context` if given. When `immediate` is set, `fn` is called immediately if
// the browser doesn't have native support for
// [`window.requestAnimationFrame`](https://developer.mozilla.org/docs/Web/API/window/requestAnimationFrame),
// otherwise it's delayed. Returns a request ID that can be used to cancel the request.
function M(t,e,i){if(!i||P!==b)return P.call(window,_(t,e));t.call(e)}// @function cancelAnimFrame(id: Number): undefined
// Cancels a previous `requestAnimFrame`. See also [window.cancelAnimationFrame](https://developer.mozilla.org/docs/Web/API/window/cancelAnimationFrame).
function T(t){t&&C.call(window,t)}var k={extend:h,create:s,bind:_,lastId:i,stamp:m,throttle:n,wrapNum:o,falseFn:a,formatNum:r,trim:l,splitWords:u,setOptions:c,getParamString:d,template:f,isArray:g,indexOf:v,emptyImageUrl:y,requestFn:P,cancelFn:C,requestAnimFrame:M,cancelAnimFrame:T};// @class Class
// @aka L.Class
// @section
// @uninheritable
// Thanks to John Resig and Dean Edwards for inspiration!
function z(){}z.extend=function(t){function e(){
// call the constructor
this.initialize&&this.initialize.apply(this,arguments),// call all constructor hooks
this.callInitHooks()}
// @function extend(props: Object): Function
// [Extends the current class](#class-inheritance) given the properties to be included.
// Returns a Javascript function that is a class constructor (to be called with `new`).
var i,n=e.__super__=this.prototype,o=s(n);// inherit parent's statics
for(i in(o.constructor=e).prototype=o,this)Object.prototype.hasOwnProperty.call(this,i)&&"prototype"!==i&&"__super__"!==i&&(e[i]=this[i]);// mix static properties into the class
return t.statics&&(h(e,t.statics),delete t.statics),// mix includes into the prototype
t.includes&&(function(t){if("undefined"==typeof L||!L||!L.Mixin)return;t=g(t)?t:[t];for(var e=0;e<t.length;e++)t[e]===L.Mixin.Events&&console.warn("Deprecated include of L.Mixin.Events: this property will be removed in future releases, please inherit from L.Evented instead.",(new Error).stack)}
/*
   * @class Evented
   * @aka L.Evented
   * @inherits Class
   *
   * A set of methods shared between event-powered classes (like `Map` and `Marker`). Generally, events allow you to execute some function when something happens with an object (e.g. the user clicks on the map, causing the map to fire `'click'` event).
   *
   * @example
   *
   * ```js
   * map.on('click', function(e) {
   * 	alert(e.latlng);
   * } );
   * ```
   *
   * Leaflet deals with event listeners by reference, so if you want to add a listener and then remove it, define it as a function:
   *
   * ```js
   * function onClick(e) { ... }
   *
   * map.on('click', onClick);
   * map.off('click', onClick);
   * ```
   */(t.includes),h.apply(null,[o].concat(t.includes)),delete t.includes),// merge options
o.options&&(t.options=h(s(o.options),t.options)),// mix given properties into the prototype
h(o,t),o._initHooks=[],// add method for calling all hooks
o.callInitHooks=function(){if(!this._initHooksCalled){n.callInitHooks&&n.callInitHooks.call(this),this._initHooksCalled=!0;for(var t=0,e=o._initHooks.length;t<e;t++)o._initHooks[t].call(this)}},e},// @function include(properties: Object): this
// [Includes a mixin](#class-includes) into the current class.
z.include=function(t){return h(this.prototype,t),this},// @function mergeOptions(options: Object): this
// [Merges `options`](#class-options) into the defaults of the class.
z.mergeOptions=function(t){return h(this.prototype.options,t),this},// @function addInitHook(fn: Function): this
// Adds a [constructor hook](#class-constructor-hooks) to the class.
z.addInitHook=function(t){
// (Function) || (String, args...)
var e=Array.prototype.slice.call(arguments,1),i="function"==typeof t?t:function(){this[t].apply(this,e)};return this.prototype._initHooks=this.prototype._initHooks||[],this.prototype._initHooks.push(i),this};var S={
/* @method on(type: String, fn: Function, context?: Object): this
     * Adds a listener function (`fn`) to a particular event type of the object. You can optionally specify the context of the listener (object the this keyword will point to). You can also pass several space-separated types (e.g. `'click dblclick'`).
     *
     * @alternative
     * @method on(eventMap: Object): this
     * Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`
     */
on:function(t,e,i){
// types can be a map of types/handlers
if("object"===_typeof(t))for(var n in t)
// we don't process space-separated events here for performance;
// it's a hot path since Layer uses the on(obj) syntax
this._on(n,t[n],e);else for(var o=0,s=(
// types can be a string of space-separated words
t=u(t)).length;o<s;o++)this._on(t[o],e,i);return this},
/* @method off(type: String, fn?: Function, context?: Object): this
     * Removes a previously added listener function. If no function is specified, it will remove all the listeners of that particular event from the object. Note that if you passed a custom context to `on`, you must pass the same context to `off` in order to remove the listener.
     *
     * @alternative
     * @method off(eventMap: Object): this
     * Removes a set of type/listener pairs.
     *
     * @alternative
     * @method off: this
     * Removes all listeners to all events on the object. This includes implicitly attached events.
     */
off:function(t,e,i){if(t)if("object"===_typeof(t))for(var n in t)this._off(n,t[n],e);else for(var o=0,s=(t=u(t)).length;o<s;o++)this._off(t[o],e,i);else
// clear all listeners if called without arguments
delete this._events;return this},
// attach listener (without syntactic sugar now)
_on:function(t,e,i){this._events=this._events||{};
/* get/init listeners for type */
var n=this._events[t];n||(n=[],this._events[t]=n),i===this&&(
// Less memory footprint.
i=void 0);// check if fn already there
for(var t={fn:e,ctx:i},o=n,s=0,r=o.length;s<r;s++)if(o[s].fn===e&&o[s].ctx===i)return;o.push(t)},_off:function(t,e,i){var n,o,s;if(this._events&&(n=this._events[t]))if(e){if(i===this&&(i=void 0),n)
// find fn and remove it
for(o=0,s=n.length;o<s;o++){var r=n[o];if(r.ctx===i&&r.fn===e)
// set the removed listener to noop so that's not called if remove happens in fire
return r.fn=a,this._firingCount&&(
/* copy array in case events are being fired */
this._events[t]=n=n.slice()),void n.splice(o,1)}}else{
// Set all removed listeners to noop so they are not called if remove happens in fire
for(o=0,s=n.length;o<s;o++)n[o].fn=a;// clear all listeners for a type if function isn't specified
delete this._events[t]}},
// @method fire(type: String, data?: Object, propagate?: Boolean): this
// Fires an event of the specified type. You can optionally provide an data
// object — the first argument of the listener function will contain its
// properties. The event can optionally be propagated to event parents.
fire:function(t,e,i){if(!this.listens(t,i))return this;var n=h({},e,{type:t,target:this,sourceTarget:e&&e.sourceTarget||this});if(this._events){var o=this._events[t];if(o){this._firingCount=this._firingCount+1||1;for(var s=0,r=o.length;s<r;s++){var a=o[s];a.fn.call(a.ctx||this,n)}this._firingCount--}}return i&&
// propagate the event to parents (set with addEventParent)
this._propagateEvent(n),this},
// @method listens(type: String): Boolean
// Returns `true` if a particular event type has any listeners attached to it.
listens:function(t,e){var i=this._events&&this._events[t];if(i&&i.length)return!0;if(e)
// also check parents for listeners if event propagates
for(var n in this._eventParents)if(this._eventParents[n].listens(t,e))return!0;return!1},
// @method once(…): this
// Behaves as [`on(…)`](#evented-on), except the listener will only get fired once and then removed.
once:function(t,e,i){if("object"===_typeof(t)){for(var n in t)this.once(n,t[n],e);return this}var o=_(function(){this.off(t,e,i).off(t,o,i)},this);// add a listener that's executed once and removed after that
return this.on(t,e,i).on(t,o,i)},
// @method addEventParent(obj: Evented): this
// Adds an event parent - an `Evented` that will receive propagated events
addEventParent:function(t){return this._eventParents=this._eventParents||{},this._eventParents[m(t)]=t,this},
// @method removeEventParent(obj: Evented): this
// Removes an event parent, so it will stop receiving propagated events
removeEventParent:function(t){return this._eventParents&&delete this._eventParents[m(t)],this},_propagateEvent:function(t){for(var e in this._eventParents)this._eventParents[e].fire(t.type,h({layer:t.target,propagatedFrom:t.target},t),!0)}};// aliases; we should ditch those eventually
// @method addEventListener(…): this
// Alias to [`on(…)`](#evented-on)
S.addEventListener=S.on,// @method removeEventListener(…): this
// Alias to [`off(…)`](#evented-off)
// @method clearAllEventListeners(…): this
// Alias to [`off()`](#evented-off)
S.removeEventListener=S.clearAllEventListeners=S.off,// @method addOneTimeEventListener(…): this
// Alias to [`once(…)`](#evented-once)
S.addOneTimeEventListener=S.once,// @method fireEvent(…): this
// Alias to [`fire(…)`](#evented-fire)
S.fireEvent=S.fire,// @method hasEventListeners(…): Boolean
// Alias to [`listens(…)`](#evented-listens)
S.hasEventListeners=S.listens;var E=z.extend(S);
/*
   * @class Point
   * @aka L.Point
   *
   * Represents a point with `x` and `y` coordinates in pixels.
   *
   * @example
   *
   * ```js
   * var point = L.point(200, 300);
   * ```
   *
   * All Leaflet methods and options that accept `Point` objects also accept them in a simple Array form (unless noted otherwise), so these lines are equivalent:
   *
   * ```js
   * map.panBy([200, 300]);
   * map.panBy(L.point(200, 300));
   * ```
   *
   * Note that `Point` does not inherit from Leaflet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */function Z(t,e,i){
// @property x: Number; The `x` coordinate of the point
this.x=i?Math.round(t):t,// @property y: Number; The `y` coordinate of the point
this.y=i?Math.round(e):e}var A=Math.trunc||function(t){return 0<t?Math.floor(t):Math.ceil(t)};// @factory L.point(x: Number, y: Number, round?: Boolean)
// Creates a Point object with the given `x` and `y` coordinates. If optional `round` is set to true, rounds the `x` and `y` values.
// @alternative
// @factory L.point(coords: Number[])
// Expects an array of the form `[x, y]` instead.
// @alternative
// @factory L.point(coords: Object)
// Expects a plain object of the form `{x: Number, y: Number}` instead.
function B(t,e,i){return t instanceof Z?t:g(t)?new Z(t[0],t[1]):null==t?t:"object"===_typeof(t)&&"x"in t&&"y"in t?new Z(t.x,t.y):new Z(t,e,i)}
/*
   * @class Bounds
   * @aka L.Bounds
   *
   * Represents a rectangular area in pixel coordinates.
   *
   * @example
   *
   * ```js
   * var p1 = L.point(10, 10),
   * p2 = L.point(40, 60),
   * bounds = L.bounds(p1, p2);
   * ```
   *
   * All Leaflet methods that accept `Bounds` objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:
   *
   * ```js
   * otherBounds.intersects([[10, 10], [40, 60]]);
   * ```
   *
   * Note that `Bounds` does not inherit from Leaflet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */function O(t,e){if(t)for(var i=e?[t,e]:t,n=0,o=i.length;n<o;n++)this.extend(i[n])}// @factory L.bounds(corner1: Point, corner2: Point)
// Creates a Bounds object from two corners coordinate pairs.
// @alternative
// @factory L.bounds(points: Point[])
// Creates a Bounds object from the given array of points.
function I(t,e){return!t||t instanceof O?t:new O(t,e)}
/*
   * @class LatLngBounds
   * @aka L.LatLngBounds
   *
   * Represents a rectangular geographical area on a map.
   *
   * @example
   *
   * ```js
   * var corner1 = L.latLng(40.712, -74.227),
   * corner2 = L.latLng(40.774, -74.125),
   * bounds = L.latLngBounds(corner1, corner2);
   * ```
   *
   * All Leaflet methods that accept LatLngBounds objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:
   *
   * ```js
   * map.fitBounds([
   * 	[40.712, -74.227],
   * 	[40.774, -74.125]
   * ]);
   * ```
   *
   * Caution: if the area crosses the antimeridian (often confused with the International Date Line), you must specify corners _outside_ the [-180, 180] degrees longitude range.
   *
   * Note that `LatLngBounds` does not inherit from Leaflet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */function D(t,e){
// (LatLng, LatLng) or (LatLng[])
if(t)for(var i=e?[t,e]:t,n=0,o=i.length;n<o;n++)this.extend(i[n])}// TODO International date line?
// @factory L.latLngBounds(corner1: LatLng, corner2: LatLng)
// Creates a `LatLngBounds` object by defining two diagonally opposite corners of the rectangle.
// @alternative
// @factory L.latLngBounds(latlngs: LatLng[])
// Creates a `LatLngBounds` object defined by the geographical points it contains. Very useful for zooming the map to fit a particular set of locations with [`fitBounds`](#map-fitbounds).
function R(t,e){return t instanceof D?t:new D(t,e)}
/* @class LatLng
   * @aka L.LatLng
   *
   * Represents a geographical point with a certain latitude and longitude.
   *
   * @example
   *
   * ```
   * var latlng = L.latLng(50.5, 30.5);
   * ```
   *
   * All Leaflet methods that accept LatLng objects also accept them in a simple Array form and simple object form (unless noted otherwise), so these lines are equivalent:
   *
   * ```
   * map.panTo([50, 30]);
   * map.panTo({lon: 30, lat: 50});
   * map.panTo({lat: 50, lng: 30});
   * map.panTo(L.latLng(50, 30));
   * ```
   *
   * Note that `LatLng` does not inherit from Leaflet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */function N(t,e,i){if(isNaN(t)||isNaN(e))throw new Error("Invalid LatLng object: ("+t+", "+e+")");// @property lat: Number
// Latitude in degrees
this.lat=+t,// @property lng: Number
// Longitude in degrees
this.lng=+e,// @property alt: Number
// Altitude in meters (optional)
void 0!==i&&(this.alt=+i)}// @factory L.latLng(latitude: Number, longitude: Number, altitude?: Number): LatLng
// Creates an object representing a geographical point with the given latitude and longitude (and optionally altitude).
// @alternative
// @factory L.latLng(coords: Array): LatLng
// Expects an array of the form `[Number, Number]` or `[Number, Number, Number]` instead.
// @alternative
// @factory L.latLng(coords: Object): LatLng
// Expects an plain object of the form `{lat: Number, lng: Number}` or `{lat: Number, lng: Number, alt: Number}` instead.
function j(t,e,i){return t instanceof N?t:g(t)&&"object"!==_typeof(t[0])?3===t.length?new N(t[0],t[1],t[2]):2===t.length?new N(t[0],t[1]):null:null==t?t:"object"===_typeof(t)&&"lat"in t?new N(t.lat,"lng"in t?t.lng:t.lon,t.alt):void 0===e?null:new N(t,e,i)}
/*
   * @namespace CRS
   * @crs L.CRS.Base
   * Object that defines coordinate reference systems for projecting
   * geographical points into pixel (screen) coordinates and back (and to
   * coordinates in other units for [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services). See
   * [spatial reference system](http://en.wikipedia.org/wiki/Coordinate_reference_system).
   *
   * Leaflet defines the most usual CRSs by default. If you want to use a
   * CRS not defined by default, take a look at the
   * [Proj4Leaflet](https://github.com/kartena/Proj4Leaflet) plugin.
   *
   * Note that the CRS instances do not inherit from Leaflet's `Class` object,
   * and can't be instantiated. Also, new classes can't inherit from them,
   * and methods can't be added to them with the `include` function.
   */Z.prototype={
// @method clone(): Point
// Returns a copy of the current point.
clone:function(){return new Z(this.x,this.y)},
// @method add(otherPoint: Point): Point
// Returns the result of addition of the current and the given points.
add:function(t){
// non-destructive, returns a new point
return this.clone()._add(B(t))},_add:function(t){
// destructive, used directly for performance in situations where it's safe to modify existing point
return this.x+=t.x,this.y+=t.y,this},
// @method subtract(otherPoint: Point): Point
// Returns the result of subtraction of the given point from the current.
subtract:function(t){return this.clone()._subtract(B(t))},_subtract:function(t){return this.x-=t.x,this.y-=t.y,this},
// @method divideBy(num: Number): Point
// Returns the result of division of the current point by the given number.
divideBy:function(t){return this.clone()._divideBy(t)},_divideBy:function(t){return this.x/=t,this.y/=t,this},
// @method multiplyBy(num: Number): Point
// Returns the result of multiplication of the current point by the given number.
multiplyBy:function(t){return this.clone()._multiplyBy(t)},_multiplyBy:function(t){return this.x*=t,this.y*=t,this},
// @method scaleBy(scale: Point): Point
// Multiply each coordinate of the current point by each coordinate of
// `scale`. In linear algebra terms, multiply the point by the
// [scaling matrix](https://en.wikipedia.org/wiki/Scaling_%28geometry%29#Matrix_representation)
// defined by `scale`.
scaleBy:function(t){return new Z(this.x*t.x,this.y*t.y)},
// @method unscaleBy(scale: Point): Point
// Inverse of `scaleBy`. Divide each coordinate of the current point by
// each coordinate of `scale`.
unscaleBy:function(t){return new Z(this.x/t.x,this.y/t.y)},
// @method round(): Point
// Returns a copy of the current point with rounded coordinates.
round:function(){return this.clone()._round()},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},
// @method floor(): Point
// Returns a copy of the current point with floored coordinates (rounded down).
floor:function(){return this.clone()._floor()},_floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},
// @method ceil(): Point
// Returns a copy of the current point with ceiled coordinates (rounded up).
ceil:function(){return this.clone()._ceil()},_ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},
// @method trunc(): Point
// Returns a copy of the current point with truncated coordinates (rounded towards zero).
trunc:function(){return this.clone()._trunc()},_trunc:function(){return this.x=A(this.x),this.y=A(this.y),this},
// @method distanceTo(otherPoint: Point): Number
// Returns the cartesian distance between the current and the given points.
distanceTo:function(t){var e=(t=B(t)).x-this.x,t=t.y-this.y;return Math.sqrt(e*e+t*t)},
// @method equals(otherPoint: Point): Boolean
// Returns `true` if the given point has the same coordinates.
equals:function(t){return(t=B(t)).x===this.x&&t.y===this.y},
// @method contains(otherPoint: Point): Boolean
// Returns `true` if both coordinates of the given point are less than the corresponding current point coordinates (in absolute values).
contains:function(t){return t=B(t),Math.abs(t.x)<=Math.abs(this.x)&&Math.abs(t.y)<=Math.abs(this.y)},
// @method toString(): String
// Returns a string representation of the point for debugging purposes.
toString:function(){return"Point("+r(this.x)+", "+r(this.y)+")"}},O.prototype={
// @method extend(point: Point): this
// Extends the bounds to contain the given point.
extend:function(t){
// (Point)
return t=B(t),// @property min: Point
// The top left corner of the rectangle.
// @property max: Point
// The bottom right corner of the rectangle.
this.min||this.max?(this.min.x=Math.min(t.x,this.min.x),this.max.x=Math.max(t.x,this.max.x),this.min.y=Math.min(t.y,this.min.y),this.max.y=Math.max(t.y,this.max.y)):(this.min=t.clone(),this.max=t.clone()),this},
// @method getCenter(round?: Boolean): Point
// Returns the center point of the bounds.
getCenter:function(t){return new Z((this.min.x+this.max.x)/2,(this.min.y+this.max.y)/2,t)},
// @method getBottomLeft(): Point
// Returns the bottom-left point of the bounds.
getBottomLeft:function(){return new Z(this.min.x,this.max.y)},
// @method getTopRight(): Point
// Returns the top-right point of the bounds.
getTopRight:function(){
// -> Point
return new Z(this.max.x,this.min.y)},
// @method getTopLeft(): Point
// Returns the top-left point of the bounds (i.e. [`this.min`](#bounds-min)).
getTopLeft:function(){return this.min;// left, top
},
// @method getBottomRight(): Point
// Returns the bottom-right point of the bounds (i.e. [`this.max`](#bounds-max)).
getBottomRight:function(){return this.max;// right, bottom
},
// @method getSize(): Point
// Returns the size of the given bounds
getSize:function(){return this.max.subtract(this.min)},
// @method contains(otherBounds: Bounds): Boolean
// Returns `true` if the rectangle contains the given one.
// @alternative
// @method contains(point: Point): Boolean
// Returns `true` if the rectangle contains the given point.
contains:function(t){var e,i;return(t=("number"==typeof t[0]||t instanceof Z?B:I)(t))instanceof O?(e=t.min,i=t.max):e=i=t,e.x>=this.min.x&&i.x<=this.max.x&&e.y>=this.min.y&&i.y<=this.max.y},
// @method intersects(otherBounds: Bounds): Boolean
// Returns `true` if the rectangle intersects the given bounds. Two bounds
// intersect if they have at least one point in common.
intersects:function(t){
// (Bounds) -> Boolean
t=I(t);var e=this.min,i=this.max,n=t.min,o=t.max,t=o.x>=e.x&&n.x<=i.x,i=o.y>=e.y&&n.y<=i.y;return t&&i},
// @method overlaps(otherBounds: Bounds): Boolean
// Returns `true` if the rectangle overlaps the given bounds. Two bounds
// overlap if their intersection is an area.
overlaps:function(t){
// (Bounds) -> Boolean
t=I(t);var e=this.min,i=this.max,n=t.min,o=t.max,t=o.x>e.x&&n.x<i.x,i=o.y>e.y&&n.y<i.y;return t&&i},isValid:function(){return!(!this.min||!this.max)}},D.prototype={
// @method extend(latlng: LatLng): this
// Extend the bounds to contain the given point
// @alternative
// @method extend(otherBounds: LatLngBounds): this
// Extend the bounds to contain the given bounds
extend:function(t){var e,i,n=this._southWest,o=this._northEast;if(t instanceof N)i=e=t;else{if(!(t instanceof D))return t?this.extend(j(t)||R(t)):this;if(e=t._southWest,i=t._northEast,!e||!i)return this}return n||o?(n.lat=Math.min(e.lat,n.lat),n.lng=Math.min(e.lng,n.lng),o.lat=Math.max(i.lat,o.lat),o.lng=Math.max(i.lng,o.lng)):(this._southWest=new N(e.lat,e.lng),this._northEast=new N(i.lat,i.lng)),this},
// @method pad(bufferRatio: Number): LatLngBounds
// Returns bounds created by extending or retracting the current bounds by a given ratio in each direction.
// For example, a ratio of 0.5 extends the bounds by 50% in each direction.
// Negative values will retract the bounds.
pad:function(t){var e=this._southWest,i=this._northEast,n=Math.abs(e.lat-i.lat)*t,t=Math.abs(e.lng-i.lng)*t;return new D(new N(e.lat-n,e.lng-t),new N(i.lat+n,i.lng+t))},
// @method getCenter(): LatLng
// Returns the center point of the bounds.
getCenter:function(){return new N((this._southWest.lat+this._northEast.lat)/2,(this._southWest.lng+this._northEast.lng)/2)},
// @method getSouthWest(): LatLng
// Returns the south-west point of the bounds.
getSouthWest:function(){return this._southWest},
// @method getNorthEast(): LatLng
// Returns the north-east point of the bounds.
getNorthEast:function(){return this._northEast},
// @method getNorthWest(): LatLng
// Returns the north-west point of the bounds.
getNorthWest:function(){return new N(this.getNorth(),this.getWest())},
// @method getSouthEast(): LatLng
// Returns the south-east point of the bounds.
getSouthEast:function(){return new N(this.getSouth(),this.getEast())},
// @method getWest(): Number
// Returns the west longitude of the bounds
getWest:function(){return this._southWest.lng},
// @method getSouth(): Number
// Returns the south latitude of the bounds
getSouth:function(){return this._southWest.lat},
// @method getEast(): Number
// Returns the east longitude of the bounds
getEast:function(){return this._northEast.lng},
// @method getNorth(): Number
// Returns the north latitude of the bounds
getNorth:function(){return this._northEast.lat},
// @method contains(otherBounds: LatLngBounds): Boolean
// Returns `true` if the rectangle contains the given one.
// @alternative
// @method contains (latlng: LatLng): Boolean
// Returns `true` if the rectangle contains the given point.
contains:function(t){
// (LatLngBounds) or (LatLng) -> Boolean
t=("number"==typeof t[0]||t instanceof N||"lat"in t?j:R)(t);var e,i,n=this._southWest,o=this._northEast;return t instanceof D?(e=t.getSouthWest(),i=t.getNorthEast()):e=i=t,e.lat>=n.lat&&i.lat<=o.lat&&e.lng>=n.lng&&i.lng<=o.lng},
// @method intersects(otherBounds: LatLngBounds): Boolean
// Returns `true` if the rectangle intersects the given bounds. Two bounds intersect if they have at least one point in common.
intersects:function(t){t=R(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),o=t.getNorthEast(),t=o.lat>=e.lat&&n.lat<=i.lat,i=o.lng>=e.lng&&n.lng<=i.lng;return t&&i},
// @method overlaps(otherBounds: LatLngBounds): Boolean
// Returns `true` if the rectangle overlaps the given bounds. Two bounds overlap if their intersection is an area.
overlaps:function(t){t=R(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),o=t.getNorthEast(),t=o.lat>e.lat&&n.lat<i.lat,i=o.lng>e.lng&&n.lng<i.lng;return t&&i},
// @method toBBoxString(): String
// Returns a string with bounding box coordinates in a 'southwest_lng,southwest_lat,northeast_lng,northeast_lat' format. Useful for sending requests to web services that return geo data.
toBBoxString:function(){return[this.getWest(),this.getSouth(),this.getEast(),this.getNorth()].join(",")},
// @method equals(otherBounds: LatLngBounds, maxMargin?: Number): Boolean
// Returns `true` if the rectangle is equivalent (within a small margin of error) to the given bounds. The margin of error can be overridden by setting `maxMargin` to a small number.
equals:function(t,e){return!!t&&(t=R(t),this._southWest.equals(t.getSouthWest(),e)&&this._northEast.equals(t.getNorthEast(),e))},
// @method isValid(): Boolean
// Returns `true` if the bounds are properly initialized.
isValid:function(){return!(!this._southWest||!this._northEast)}};var F={
// @method latLngToPoint(latlng: LatLng, zoom: Number): Point
// Projects geographical coordinates into pixel coordinates for a given zoom.
latLngToPoint:function(t,e){t=this.projection.project(t),e=this.scale(e);return this.transformation._transform(t,e)},
// @method pointToLatLng(point: Point, zoom: Number): LatLng
// The inverse of `latLngToPoint`. Projects pixel coordinates on a given
// zoom into geographical coordinates.
pointToLatLng:function(t,e){e=this.scale(e),e=this.transformation.untransform(t,e);return this.projection.unproject(e)},
// @method project(latlng: LatLng): Point
// Projects geographical coordinates into coordinates in units accepted for
// this CRS (e.g. meters for EPSG:3857, for passing it to WMS services).
project:function(t){return this.projection.project(t)},
// @method unproject(point: Point): LatLng
// Given a projected coordinate returns the corresponding LatLng.
// The inverse of `project`.
unproject:function(t){return this.projection.unproject(t)},
// @method scale(zoom: Number): Number
// Returns the scale used when transforming projected coordinates into
// pixel coordinates for a particular zoom. For example, it returns
// `256 * 2^zoom` for Mercator-based CRS.
scale:function(t){return 256*Math.pow(2,t)},
// @method zoom(scale: Number): Number
// Inverse of `scale()`, returns the zoom level corresponding to a scale
// factor of `scale`.
zoom:function(t){return Math.log(t/256)/Math.LN2},
// @method getProjectedBounds(zoom: Number): Bounds
// Returns the projection's bounds scaled and transformed for the provided `zoom`.
getProjectedBounds:function(t){if(this.infinite)return null;var e=this.projection.bounds,t=this.scale(t);return new O(this.transformation.transform(e.min,t),this.transformation.transform(e.max,t))},
// @method distance(latlng1: LatLng, latlng2: LatLng): Number
// Returns the distance between two geographical coordinates.
// @property code: String
// Standard code name of the CRS passed into WMS services (e.g. `'EPSG:3857'`)
//
// @property wrapLng: Number[]
// An array of two numbers defining whether the longitude (horizontal) coordinate
// axis wraps around a given range and how. Defaults to `[-180, 180]` in most
// geographical CRSs. If `undefined`, the longitude axis does not wrap around.
//
// @property wrapLat: Number[]
// Like `wrapLng`, but for the latitude (vertical) axis.
// wrapLng: [min, max],
// wrapLat: [min, max],
// @property infinite: Boolean
// If true, the coordinate space will be unbounded (infinite in both axes)
infinite:!(N.prototype={
// @method equals(otherLatLng: LatLng, maxMargin?: Number): Boolean
// Returns `true` if the given `LatLng` point is at the same position (within a small margin of error). The margin of error can be overridden by setting `maxMargin` to a small number.
equals:function(t,e){return!!t&&(t=j(t),Math.max(Math.abs(this.lat-t.lat),Math.abs(this.lng-t.lng))<=(void 0===e?1e-9:e))},
// @method toString(): String
// Returns a string representation of the point (for debugging purposes).
toString:function(t){return"LatLng("+r(this.lat,t)+", "+r(this.lng,t)+")"},
// @method distanceTo(otherLatLng: LatLng): Number
// Returns the distance (in meters) to the given `LatLng` calculated using the [Spherical Law of Cosines](https://en.wikipedia.org/wiki/Spherical_law_of_cosines).
distanceTo:function(t){return U.distance(this,j(t))},
// @method wrap(): LatLng
// Returns a new `LatLng` object with the longitude wrapped so it's always between -180 and +180 degrees.
wrap:function(){return U.wrapLatLng(this)},
// @method toBounds(sizeInMeters: Number): LatLngBounds
// Returns a new `LatLngBounds` object in which each boundary is `sizeInMeters/2` meters apart from the `LatLng`.
toBounds:function(t){var e=180*t/40075017,t=e/Math.cos(Math.PI/180*this.lat);return R([this.lat-e,this.lng-t],[this.lat+e,this.lng+t])},clone:function(){return new N(this.lat,this.lng,this.alt)}}),
// @method wrapLatLng(latlng: LatLng): LatLng
// Returns a `LatLng` where lat and lng has been wrapped according to the
// CRS's `wrapLat` and `wrapLng` properties, if they are outside the CRS's bounds.
wrapLatLng:function(t){var e=this.wrapLng?o(t.lng,this.wrapLng,!0):t.lng;return new N(this.wrapLat?o(t.lat,this.wrapLat,!0):t.lat,e,t.alt)},
// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds
// Returns a `LatLngBounds` with the same size as the given one, ensuring
// that its center is within the CRS's bounds.
// Only accepts actual `L.LatLngBounds` instances, not arrays.
wrapLatLngBounds:function(t){var e=t.getCenter(),i=this.wrapLatLng(e),n=e.lat-i.lat,e=e.lng-i.lng;if(0==n&&0==e)return t;i=t.getSouthWest(),t=t.getNorthEast();return new D(new N(i.lat-n,i.lng-e),new N(t.lat-n,t.lng-e))}},U=h({},F,{wrapLng:[-180,180],
// Mean Earth Radius, as recommended for use by
// the International Union of Geodesy and Geophysics,
// see http://rosettacode.org/wiki/Haversine_formula
R:6371e3,
// distance between two geographical points using spherical law of cosines approximation
distance:function(t,e){var i=Math.PI/180,n=t.lat*i,o=e.lat*i,s=Math.sin((e.lat-t.lat)*i/2),i=Math.sin((e.lng-t.lng)*i/2),i=s*s+Math.cos(n)*Math.cos(o)*i*i,i=2*Math.atan2(Math.sqrt(i),Math.sqrt(1-i));return this.R*i}}),H=6378137,G={R:H,MAX_LATITUDE:85.0511287798,project:function(t){var e=Math.PI/180,i=this.MAX_LATITUDE,i=Math.max(Math.min(i,t.lat),-i),i=Math.sin(i*e);return new Z(this.R*t.lng*e,this.R*Math.log((1+i)/(1-i))/2)},unproject:function(t){var e=180/Math.PI;return new N((2*Math.atan(Math.exp(t.y/this.R))-Math.PI/2)*e,t.x*e/this.R)},bounds:new O([-(gt=H*Math.PI),-gt],[gt,gt])};
/*
   * @namespace CRS
   * @crs L.CRS.Earth
   *
   * Serves as the base for CRS that are global such that they cover the earth.
   * Can only be used as the base for other CRS and cannot be used directly,
   * since it does not have a `code`, `projection` or `transformation`. `distance()` returns
   * meters.
   */
/*
   * @class Transformation
   * @aka L.Transformation
   *
   * Represents an affine transformation: a set of coefficients `a`, `b`, `c`, `d`
   * for transforming a point of a form `(x, y)` into `(a*x + b, c*y + d)` and doing
   * the reverse. Used by Leaflet in its projections code.
   *
   * @example
   *
   * ```js
   * var transformation = L.transformation(2, 5, -1, 10),
   * 	p = L.point(1, 2),
   * 	p2 = transformation.transform(p), //  L.point(7, 8)
   * 	p3 = transformation.untransform(p2); //  L.point(1, 2)
   * ```
   */
// factory new L.Transformation(a: Number, b: Number, c: Number, d: Number)
// Creates a `Transformation` object with the given coefficients.
function W(t,e,i,n){if(g(t))
// use array properties
return this._a=t[0],this._b=t[1],this._c=t[2],void(this._d=t[3]);this._a=t,this._b=e,this._c=i,this._d=n}// factory L.transformation(a: Number, b: Number, c: Number, d: Number)
// @factory L.transformation(a: Number, b: Number, c: Number, d: Number)
// Instantiates a Transformation object with the given coefficients.
// @alternative
// @factory L.transformation(coefficients: Array): Transformation
// Expects an coefficients array of the form
// `[a: Number, b: Number, c: Number, d: Number]`.
function V(t,e,i,n){return new W(t,e,i,n)}
/*
   * @namespace CRS
   * @crs L.CRS.EPSG3857
   *
   * The most common CRS for online maps, used by almost all free and commercial
   * tile providers. Uses Spherical Mercator projection. Set in by default in
   * Map's `crs` option.
   */W.prototype={
// @method transform(point: Point, scale?: Number): Point
// Returns a transformed point, optionally multiplied by the given scale.
// Only accepts actual `L.Point` instances, not arrays.
transform:function(t,e){
// (Point, Number) -> Point
return this._transform(t.clone(),e)},
// destructive transform (faster)
_transform:function(t,e){return e=e||1,t.x=e*(this._a*t.x+this._b),t.y=e*(this._c*t.y+this._d),t},
// @method untransform(point: Point, scale?: Number): Point
// Returns the reverse transformation of the given point, optionally divided
// by the given scale. Only accepts actual `L.Point` instances, not arrays.
untransform:function(t,e){return e=e||1,new Z((t.x/e-this._b)/this._a,(t.y/e-this._d)/this._c)}};var q=h({},U,{code:"EPSG:3857",projection:G,transformation:V(vt=.5/(Math.PI*G.R),.5,-vt,.5)}),K=h({},q,{code:"EPSG:900913"});// @namespace SVG; @section
// There are several static functions which can be called without instantiating L.SVG:
// @function create(name: String): SVGElement
// Returns a instance of [SVGElement](https://developer.mozilla.org/docs/Web/API/SVGElement),
// corresponding to the class name passed. For example, using 'line' will return
// an instance of [SVGLineElement](https://developer.mozilla.org/docs/Web/API/SVGLineElement).
function Y(t){return document.createElementNS("http://www.w3.org/2000/svg",t)}// @function pointsToPath(rings: Point[], closed: Boolean): String
// Generates a SVG path string for multiple rings, with each ring turning
// into "M..L..L.." instructions
function X(t,e){for(var i,n,o,s,r="",a=0,h=t.length;a<h;a++){for(i=0,n=(o=t[a]).length;i<n;i++)r+=(i?"L":"M")+(s=o[i]).x+" "+s.y;// closes the ring for polygons; "x" is VML syntax
r+=e?Ct?"z":"x":""}// SVG complains about empty path strings
return r||"M0 0"}
/*
   * @namespace Browser
   * @aka L.Browser
   *
   * A namespace with static properties for browser/feature detection used by Leaflet internally.
   *
   * @example
   *
   * ```js
   * if (L.Browser.ielt9) {
   *   alert('Upgrade your browser, dude!');
   * }
   * ```
   */var J=document.documentElement.style,Q="ActiveXObject"in window,$=Q&&!document.addEventListener,tt="msLaunchUri"in navigator&&!("documentMode"in document),et=Tt("webkit"),it=Tt("android"),nt=Tt("android 2")||Tt("android 3"),ot=parseInt(/WebKit\/([0-9]+)|$/.exec(navigator.userAgent)[1],10),st=it&&Tt("Google")&&ot<537&&!("AudioNode"in window),rt=!!window.opera,at=!tt&&Tt("chrome"),ht=Tt("gecko")&&!et&&!rt&&!Q,lt=!at&&Tt("safari"),ut=Tt("phantom"),ct="OTransition"in J,_t=0===navigator.platform.indexOf("Win"),dt=Q&&"transition"in J,pt="WebKitCSSMatrix"in window&&"m11"in new window.WebKitCSSMatrix&&!nt,mt="MozPerspective"in J,ft=!window.L_DISABLE_3D&&(dt||pt||mt)&&!ct&&!ut,H="undefined"!=typeof orientation||Tt("mobile"),gt=H&&et,vt=H&&pt,ot=!window.PointerEvent&&window.MSPointerEvent,yt=!(!window.PointerEvent&&!ot),Lt=!window.L_NO_TOUCH&&(yt||"ontouchstart"in window||window.DocumentTouch&&document instanceof window.DocumentTouch),xt=H&&rt,J=H&&ht,wt=1<(window.devicePixelRatio||window.screen.deviceXDPI/window.screen.logicalXDPI),bt=function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){
// eslint-disable-line getter-return
t=!0}});window.addEventListener("testPassiveEventSupport",a,e),window.removeEventListener("testPassiveEventSupport",a,e)}catch(t){// Errors can safely be ignored since this is only a browser support test.
}return t}(),Pt=!!document.createElement("canvas").getContext,Ct=!(!document.createElementNS||!Y("svg").createSVGRect),Mt=!Ct&&function(){try{var t=document.createElement("div");t.innerHTML='<v:shape adj="1"/>';t=t.firstChild;return t.style.behavior="url(#default#VML)",t&&"object"===_typeof(t.adj)}catch(t){return!1}}();// @property ie: Boolean; `true` for all Internet Explorer versions (not Edge).
function Tt(t){return 0<=navigator.userAgent.toLowerCase().indexOf(t)}var rt={ie:Q,ielt9:$,edge:tt,webkit:et,android:it,android23:nt,androidStock:st,opera:rt,chrome:at,gecko:ht,safari:lt,phantom:ut,opera12:ct,win:_t,ie3d:dt,webkit3d:pt,gecko3d:mt,any3d:ft,mobile:H,mobileWebkit:gt,mobileWebkit3d:vt,msPointer:ot,pointer:yt,touch:Lt,mobileOpera:xt,mobileGecko:J,retina:wt,passiveEvents:bt,canvas:Pt,svg:Ct,vml:Mt},kt=ot?"MSPointerDown":"pointerdown",zt=ot?"MSPointerMove":"pointermove",St=ot?"MSPointerUp":"pointerup",Et=ot?"MSPointerCancel":"pointercancel",Zt={},At=!1;
/*
   * Extends L.DomEvent to provide touch support for Internet Explorer and Windows-based devices.
   */ // Provides a touch events wrapper for (ms)pointer events.
// ref http://www.w3.org/TR/pointerevents/ https://www.w3.org/Bugs/Public/show_bug.cgi?id=22890
function Bt(t,e,i,n){function o(t){Rt(t,s)}var s,r,a,h,l,u;
/*
   * Extends the event handling code with double tap support for mobile browsers.
   */function c(t){
// don't fire touch moves when mouse isn't down
t.pointerType===(t.MSPOINTER_TYPE_MOUSE||"mouse")&&0===t.buttons||Rt(t,r)}return"touchstart"===e?(a=t,h=i,l=n,u=_(function(t){
// IE10 specific: MsTouch needs preventDefault. See #2000
t.MSPOINTER_TYPE_TOUCH&&t.pointerType===t.MSPOINTER_TYPE_TOUCH&&Se(t),Rt(t,h)}),a["_leaflet_touchstart"+l]=u,a.addEventListener(kt,u,!1),// need to keep track of what pointers and how many are active to provide e.touches emulation
At||(
// we listen document as any drags that end by moving the touch off the screen get fired there
document.addEventListener(kt,Ot,!0),document.addEventListener(zt,It,!0),document.addEventListener(St,Dt,!0),document.addEventListener(Et,Dt,!0),At=!0)):"touchmove"===e?(r=i,(u=t)["_leaflet_touchmove"+n]=c,u.addEventListener(zt,c,!1)):"touchend"===e&&(s=i,(t=t)["_leaflet_touchend"+n]=o,t.addEventListener(St,o,!1),t.addEventListener(Et,o,!1)),this}function Ot(t){Zt[t.pointerId]=t}function It(t){Zt[t.pointerId]&&(Zt[t.pointerId]=t)}function Dt(t){delete Zt[t.pointerId]}function Rt(t,e){for(var i in t.touches=[],Zt)t.touches.push(Zt[i]);t.changedTouches=[t],e(t)}var Nt=ot?"MSPointerDown":yt?"pointerdown":"touchstart",jt=ot?"MSPointerUp":yt?"pointerup":"touchend",Ft="_leaflet_";
/*
   * @namespace DomUtil
   *
   * Utility functions to work with the [DOM](https://developer.mozilla.org/docs/Web/API/Document_Object_Model)
   * tree, used by Leaflet internally.
   *
   * Most functions expecting or returning a `HTMLElement` also work for
   * SVG elements. The only difference is that classes refer to CSS classes
   * in HTML and SVG classes in SVG.
   */
// @property TRANSFORM: String
// Vendor-prefixed transform style name (e.g. `'webkitTransform'` for WebKit).
var Ut,Ht,Gt,Wt,Vt,qt,Kt=ue(["transform","webkitTransform","OTransform","MozTransform","msTransform"]),Yt=ue(["webkitTransition","transition","OTransition","MozTransition","msTransition"]),Xt="webkitTransition"===Yt||"OTransition"===Yt?Yt+"End":"transitionend";// webkitTransition comes first because some browser versions that drop vendor prefix don't do
// the same for the transitionend event, in particular the Android 4.1 stock browser
// @property TRANSITION: String
// Vendor-prefixed transition style name.
// @function get(id: String|HTMLElement): HTMLElement
// Returns an element given its DOM id, or returns the element itself
// if it was passed directly.
function Jt(t){return"string"==typeof t?document.getElementById(t):t}// @function getStyle(el: HTMLElement, styleAttrib: String): String
// Returns the value for a certain style attribute on an element,
// including computed values or values set through CSS.
function Qt(t,e){var i=t.style[e]||t.currentStyle&&t.currentStyle[e];return i&&"auto"!==i||!document.defaultView||(i=(t=document.defaultView.getComputedStyle(t,null))?t[e]:null),"auto"===i?null:i}// @function create(tagName: String, className?: String, container?: HTMLElement): HTMLElement
// Creates an HTML element with `tagName`, sets its class to `className`, and optionally appends it to `container` element.
function $t(t,e,i){t=document.createElement(t);return t.className=e||"",i&&i.appendChild(t),t}// @function remove(el: HTMLElement)
// Removes `el` from its parent element
function te(t){var e=t.parentNode;e&&e.removeChild(t)}// @function empty(el: HTMLElement)
// Removes all of `el`'s children elements from `el`
function ee(t){for(;t.firstChild;)t.removeChild(t.firstChild)}// @function toFront(el: HTMLElement)
// Makes `el` the last child of its parent, so it renders in front of the other children.
function ie(t){var e=t.parentNode;e&&e.lastChild!==t&&e.appendChild(t)}// @function toBack(el: HTMLElement)
// Makes `el` the first child of its parent, so it renders behind the other children.
function ne(t){var e=t.parentNode;e&&e.firstChild!==t&&e.insertBefore(t,e.firstChild)}// @function hasClass(el: HTMLElement, name: String): Boolean
// Returns `true` if the element's class attribute contains `name`.
function oe(t,e){if(void 0!==t.classList)return t.classList.contains(e);t=he(t);return 0<t.length&&new RegExp("(^|\\s)"+e+"(\\s|$)").test(t)}// @function addClass(el: HTMLElement, name: String)
// Adds `name` to the element's class attribute.
function se(t,e){var i;if(void 0!==t.classList)for(var n=u(e),o=0,s=n.length;o<s;o++)t.classList.add(n[o]);else oe(t,e)||ae(t,((i=he(t))?i+" ":"")+e)}// @function removeClass(el: HTMLElement, name: String)
// Removes `name` from the element's class attribute.
function re(t,e){void 0!==t.classList?t.classList.remove(e):ae(t,l((" "+he(t)+" ").replace(" "+e+" "," ")))}// @function setClass(el: HTMLElement, name: String)
// Sets the element's class.
function ae(t,e){void 0===t.className.baseVal?t.className=e:
// in case of SVG element
t.className.baseVal=e}// @function getClass(el: HTMLElement): String
// Returns the element's class.
function he(t){
// Check if the element is an SVGElementInstance and use the correspondingElement instead
// (Required for linked SVG elements in IE11.)
return t.correspondingElement&&(t=t.correspondingElement),void 0===t.className.baseVal?t.className:t.className.baseVal}// @function setOpacity(el: HTMLElement, opacity: Number)
// Set the opacity of an element (including old IE support).
// `opacity` must be a number from `0` to `1`.
function le(t,e){"opacity"in t.style?t.style.opacity=e:"filter"in t.style&&function(t,e){var i=!1,n="DXImageTransform.Microsoft.Alpha";// filters collection throws an error if we try to retrieve a filter that doesn't exist
try{i=t.filters.item(n)}catch(t){
// don't set opacity to 1 if we haven't already set an opacity,
// it isn't needed and breaks transparent pngs.
if(1===e)return}e=Math.round(100*e),i?(i.Enabled=100!==e,i.Opacity=e):t.style.filter+=" progid:"+n+"(opacity="+e+")"}// @function testProp(props: String[]): String|false
// Goes through the array of style names and returns the first name
// that is a valid style name for an element. If no such name is found,
// it returns false. Useful for vendor-prefixed styles like `transform`.
(t,e)}function ue(t){for(var e=document.documentElement.style,i=0;i<t.length;i++)if(t[i]in e)return t[i];return!1}// @function setTransform(el: HTMLElement, offset: Point, scale?: Number)
// Resets the 3D CSS transform of `el` so it is translated by `offset` pixels
// and optionally scaled by `scale`. Does not have an effect if the
// browser doesn't support 3D CSS transforms.
function ce(t,e,i){e=e||new Z(0,0);t.style[Kt]=(dt?"translate("+e.x+"px,"+e.y+"px)":"translate3d("+e.x+"px,"+e.y+"px,0)")+(i?" scale("+i+")":"")}// @function setPosition(el: HTMLElement, position: Point)
// Sets the position of `el` to coordinates specified by `position`,
// using CSS translate or top/left positioning depending on the browser
// (used by Leaflet internally to position its layers).
function _e(t,e){
/*eslint-disable */
t._leaflet_pos=e,
/* eslint-enable */
ft?ce(t,e):(t.style.left=e.x+"px",t.style.top=e.y+"px")}// @function getPosition(el: HTMLElement): Point
// Returns the coordinates of an element previously positioned with setPosition.
function de(t){
// this method is only used for elements previously positioned using setPosition,
// so it's safe to cache the position for performance
return t._leaflet_pos||new Z(0,0)}// @function disableTextSelection()
// Prevents the user from generating `selectstart` DOM events, usually generated
// when the user drags the mouse through a page with text. Used internally
// by Leaflet to override the behaviour of any click-and-drag interaction on
// the map. Affects drag interactions on the whole document.
// @function enableTextSelection()
// Cancels the effects of a previous [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection).
// @function disableImageDrag()
// As [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection), but
// for `dragstart` DOM events, usually generated when the user drags an image.
function pe(){Le(window,"dragstart",Se)}// @function enableImageDrag()
// Cancels the effects of a previous [`L.DomUtil.disableImageDrag`](#domutil-disabletextselection).
function me(){we(window,"dragstart",Se)}// @function preventOutline(el: HTMLElement)
// Makes the [outline](https://developer.mozilla.org/docs/Web/CSS/outline)
// of the element `el` invisible. Used internally by Leaflet to prevent
// focusable elements from displaying an outline when the user performs a
// drag interaction on them.
function fe(t){for(;-1===t.tabIndex;)t=t.parentNode;t.style&&(ge(),qt=(Vt=t).style.outline,t.style.outline="none",Le(window,"keydown",ge))}// @function restoreOutline()
// Cancels the effects of a previous [`L.DomUtil.preventOutline`]().
function ge(){Vt&&(Vt.style.outline=qt,qt=Vt=void 0,we(window,"keydown",ge))}// @function getSizedParentNode(el: HTMLElement): HTMLElement
// Finds the closest parent node which size (width and height) is not null.
function ve(t){for(;!((t=t.parentNode).offsetWidth&&t.offsetHeight||t===document.body););return t}// @function getScale(el: HTMLElement): Object
// Computes the CSS scale currently applied on the element.
// Returns an object with `x` and `y` members as horizontal and vertical scales respectively,
// and `boundingClientRect` as the result of [`getBoundingClientRect()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).
function ye(t){var e=t.getBoundingClientRect();// Read-only in old browsers.
return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}Wt="onselectstart"in document?(Gt=function(){Le(window,"selectstart",Se)},function(){we(window,"selectstart",Se)}):(Ht=ue(["userSelect","WebkitUserSelect","OUserSelect","MozUserSelect","msUserSelect"]),Gt=function(){var t;Ht&&(t=document.documentElement.style,Ut=t[Ht],t[Ht]="none")},function(){Ht&&(document.documentElement.style[Ht]=Ut,Ut=void 0)});ut={TRANSFORM:Kt,TRANSITION:Yt,TRANSITION_END:Xt,get:Jt,getStyle:Qt,create:$t,remove:te,empty:ee,toFront:ie,toBack:ne,hasClass:oe,addClass:se,removeClass:re,setClass:ae,getClass:he,setOpacity:le,testProp:ue,setTransform:ce,setPosition:_e,getPosition:de,disableTextSelection:Gt,enableTextSelection:Wt,disableImageDrag:pe,enableImageDrag:me,preventOutline:fe,restoreOutline:ge,getSizedParentNode:ve,getScale:ye};
/*
   * @namespace DomEvent
   * Utility functions to work with the [DOM events](https://developer.mozilla.org/docs/Web/API/Event), used by Leaflet internally.
   */
// Inspired by John Resig, Dean Edwards and YUI addEvent implementations.
// @function on(el: HTMLElement, types: String, fn: Function, context?: Object): this
// Adds a listener function (`fn`) to a particular DOM event type of the
// element `el`. You can optionally specify the context of the listener
// (object the `this` keyword will point to). You can also pass several
// space-separated types (e.g. `'click dblclick'`).
// @alternative
// @function on(el: HTMLElement, eventMap: Object, context?: Object): this
// Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`
function Le(t,e,i,n){if("object"===_typeof(e))for(var o in e)Ce(t,o,e[o],i);else for(var s=0,r=(e=u(e)).length;s<r;s++)Ce(t,e[s],i,n);return this}var xe="_leaflet_events";// @function off(el: HTMLElement, types: String, fn: Function, context?: Object): this
// Removes a previously added listener function.
// Note that if you passed a custom context to on, you must pass the same
// context to `off` in order to remove the listener.
// @alternative
// @function off(el: HTMLElement, eventMap: Object, context?: Object): this
// Removes a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`
function we(t,e,i,n){if("object"===_typeof(e))for(var o in e)Me(t,o,e[o],i);else if(e)for(var s=0,r=(e=u(e)).length;s<r;s++)Me(t,e[s],i,n);else{for(var a in t[xe])Me(t,a,t[xe][a]);delete t[xe]}return this}function be(){
// See https://github.com/w3c/pointerevents/issues/171
return yt&&(!tt&&!lt)}var Pe={mouseenter:"mouseover",mouseleave:"mouseout",wheel:!("onwheel"in window)&&"mousewheel"};function Ce(e,t,i,n){var o=t+m(i)+(n?"_"+m(n):"");if(e[xe]&&e[xe][o])return this;var s,r,a,h,l,u,c=function(t){return i.call(n||e,t||window.event)},_=c;function d(t){if(yt){if(!t.isPrimary)return;if("mouse"===t.pointerType)return;// mouse fires native dblclick
}else if(1<t.touches.length)return;var e=Date.now(),i=e-(h||e);l=t.touches?t.touches[0]:t,u=0<i&&i<=250,h=e}function p(t){if(u&&!l.cancelBubble){if(yt){if("mouse"===t.pointerType)return;// work around .type being readonly with MSPointer* events
var e,i,n={};for(i in l)e=l[i],n[i]=e&&e.bind?e.bind(l):e;l=n}l.type="dblclick",l.button=0,r(l),h=null}}yt&&0===t.indexOf("touch")?
// Needs DomEvent.Pointer.js
Bt(e,t,c,o):Lt&&"dblclick"===t&&!be()?(r=c,u=!1,(s=e)[Ft+Nt+(a=o)]=d,s[Ft+jt+a]=p,s[Ft+"dblclick"+a]=r,s.addEventListener(Nt,d,!!bt&&{passive:!1}),s.addEventListener(jt,p,!!bt&&{passive:!1}),// On some platforms (notably, chrome<55 on win10 + touchscreen + mouse),
// the browser doesn't fire touchend/pointerup events but does fire
// native dblclicks. See #4127.
// Edge 14 also fires native dblclicks, but only for pointerType mouse, see #5180.
s.addEventListener("dblclick",r,!1)):"addEventListener"in e?"touchstart"===t||"touchmove"===t||"wheel"===t||"mousewheel"===t?e.addEventListener(Pe[t]||t,c,!!bt&&{passive:!1}):"mouseenter"===t||"mouseleave"===t?(c=function(t){t=t||window.event,Re(e,t)&&_(t)},e.addEventListener(Pe[t],c,!1)):e.addEventListener(t,_,!1):"attachEvent"in e&&e.attachEvent("on"+t,c),e[xe]=e[xe]||{},e[xe][o]=c}function Me(t,e,i,n){var o,s,r,a=e+m(i)+(n?"_"+m(n):""),i=t[xe]&&t[xe][a];if(!i)return this;yt&&0===e.indexOf("touch")?(r=(o=t)["_leaflet_"+(s=e)+(r=a)],"touchstart"===s?o.removeEventListener(kt,r,!1):"touchmove"===s?o.removeEventListener(zt,r,!1):"touchend"===s&&(o.removeEventListener(St,r,!1),o.removeEventListener(Et,r,!1))):Lt&&"dblclick"===e&&!be()?(o=(n=t)[Ft+Nt+(s=a)],r=n[Ft+jt+s],s=n[Ft+"dblclick"+s],n.removeEventListener(Nt,o,!!bt&&{passive:!1}),n.removeEventListener(jt,r,!!bt&&{passive:!1}),n.removeEventListener("dblclick",s,!1)):"removeEventListener"in t?t.removeEventListener(Pe[e]||e,i,!1):"detachEvent"in t&&t.detachEvent("on"+e,i),t[xe][a]=null}// @function stopPropagation(ev: DOMEvent): this
// Stop the given event from propagation to parent elements. Used inside the listener functions:
// ```js
// L.DomEvent.on(div, 'click', function (ev) {
// 	L.DomEvent.stopPropagation(ev);
// });
// ```
function Te(t){return t.stopPropagation?t.stopPropagation():t.originalEvent?
// In case of Leaflet event.
t.originalEvent._stopped=!0:t.cancelBubble=!0,De(t),this}// @function disableScrollPropagation(el: HTMLElement): this
// Adds `stopPropagation` to the element's `'wheel'` events (plus browser variants).
function ke(t){return Ce(t,"wheel",Te),this}// @function disableClickPropagation(el: HTMLElement): this
// Adds `stopPropagation` to the element's `'click'`, `'doubleclick'`,
// `'mousedown'` and `'touchstart'` events (plus browser variants).
function ze(t){return Le(t,"mousedown touchstart dblclick",Te),Ce(t,"click",Ie),this}// @function preventDefault(ev: DOMEvent): this
// Prevents the default action of the DOM Event `ev` from happening (such as
// following a link in the href of the a element, or doing a POST request
// with page reload when a `<form>` is submitted).
// Use it inside listener functions.
function Se(t){return t.preventDefault?t.preventDefault():t.returnValue=!1,this}// @function stop(ev: DOMEvent): this
// Does `stopPropagation` and `preventDefault` at the same time.
function Ee(t){return Se(t),Te(t),this}// @function getMousePosition(ev: DOMEvent, container?: HTMLElement): Point
// Gets normalized mouse position from a DOM event relative to the
// `container` (border excluded) or to the whole page if not specified.
function Ze(t,e){if(!e)return new Z(t.clientX,t.clientY);var i=ye(e),n=i.boundingClientRect;// left and top  values are in page scale (like the event clientX/Y)
return new Z(// offset.left/top values are in page scale (like clientX/Y),
// whereas clientLeft/Top (border width) values are the original values (before CSS scale applies).
(t.clientX-n.left)/i.x-e.clientLeft,(t.clientY-n.top)/i.y-e.clientTop)}// Chrome on Win scrolls double the pixels as in other platforms (see #4538),
// and Firefox scrolls device pixels, not CSS pixels
var Ae=_t&&at?2*window.devicePixelRatio:ht?window.devicePixelRatio:1;// @function getWheelDelta(ev: DOMEvent): Number
// Gets normalized wheel delta from a wheel DOM event, in vertical
// pixels scrolled (negative if scrolling down).
// Events from pointing devices without precise scrolling are mapped to
// a best guess of 60 pixels.
function Be(t){return tt?t.wheelDeltaY/2:// Don't trust window-geometry-based delta
t.deltaY&&0===t.deltaMode?-t.deltaY/Ae:// Pixels
t.deltaY&&1===t.deltaMode?20*-t.deltaY:// Lines
t.deltaY&&2===t.deltaMode?60*-t.deltaY:// Pages
t.deltaX||t.deltaZ?0:// Skip horizontal/depth wheel events
t.wheelDelta?(t.wheelDeltaY||t.wheelDelta)/2:// Legacy IE pixels
t.detail&&Math.abs(t.detail)<32765?20*-t.detail:// Legacy Moz lines
t.detail?t.detail/-32765*60:// Legacy Moz pages
0}var Oe={};function Ie(t){
// fakes stopPropagation by setting a special event flag, checked/reset with skipped(e)
Oe[t.type]=!0}function De(t){var e=Oe[t.type];// reset when checking, as it's only used in map container and propagates outside of the map
return Oe[t.type]=!1,e}// check if element really left/entered the event target (for mouseenter/mouseleave)
function Re(t,e){var i=e.relatedTarget;if(!i)return!0;try{for(;i&&i!==t;)i=i.parentNode}catch(t){return!1}return i!==t}var ct={on:Le,off:we,stopPropagation:Te,disableScrollPropagation:ke,disableClickPropagation:ze,preventDefault:Se,stop:Ee,getMousePosition:Ze,getWheelDelta:Be,fakeStop:Ie,skipped:De,isExternalTarget:Re,addListener:Le,removeListener:we},Ne=E.extend({
// @method run(el: HTMLElement, newPos: Point, duration?: Number, easeLinearity?: Number)
// Run an animation of a given element to a new position, optionally setting
// duration in seconds (`0.25` by default) and easing linearity factor (3rd
// argument of the [cubic bezier curve](http://cubic-bezier.com/#0,0,.5,1),
// `0.5` by default).
run:function(t,e,i,n){this.stop(),this._el=t,this._inProgress=!0,this._duration=i||.25,this._easeOutPower=1/Math.max(n||.5,.2),this._startPos=de(t),this._offset=e.subtract(this._startPos),this._startTime=+new Date,// @event start: Event
// Fired when the animation starts
this.fire("start"),this._animate()},
// @method stop()
// Stops the animation (if currently running).
stop:function(){this._inProgress&&(this._step(!0),this._complete())},_animate:function(){
// animation loop
this._animId=M(this._animate,this),this._step()},_step:function(t){var e=+new Date-this._startTime,i=1e3*this._duration;e<i?this._runFrame(this._easeOut(e/i),t):(this._runFrame(1),this._complete())},_runFrame:function(t,e){t=this._startPos.add(this._offset.multiplyBy(t));e&&t._round(),_e(this._el,t),// @event step: Event
// Fired continuously during the animation.
this.fire("step")},_complete:function(){T(this._animId),this._inProgress=!1,// @event end: Event
// Fired when the animation ends.
this.fire("end")},_easeOut:function(t){return 1-Math.pow(1-t,this._easeOutPower)}}),je=E.extend({options:{
// @section Map State Options
// @option crs: CRS = L.CRS.EPSG3857
// The [Coordinate Reference System](#crs) to use. Don't change this if you're not
// sure what it means.
crs:q,
// @option center: LatLng = undefined
// Initial geographic center of the map
center:void 0,
// @option zoom: Number = undefined
// Initial map zoom level
zoom:void 0,
// @option minZoom: Number = *
// Minimum zoom level of the map.
// If not specified and at least one `GridLayer` or `TileLayer` is in the map,
// the lowest of their `minZoom` options will be used instead.
minZoom:void 0,
// @option maxZoom: Number = *
// Maximum zoom level of the map.
// If not specified and at least one `GridLayer` or `TileLayer` is in the map,
// the highest of their `maxZoom` options will be used instead.
maxZoom:void 0,
// @option layers: Layer[] = []
// Array of layers that will be added to the map initially
layers:[],
// @option maxBounds: LatLngBounds = null
// When this option is set, the map restricts the view to the given
// geographical bounds, bouncing the user back if the user tries to pan
// outside the view. To set the restriction dynamically, use
// [`setMaxBounds`](#map-setmaxbounds) method.
maxBounds:void 0,
// @option renderer: Renderer = *
// The default method for drawing vector layers on the map. `L.SVG`
// or `L.Canvas` by default depending on browser support.
renderer:void 0,
// @section Animation Options
// @option zoomAnimation: Boolean = true
// Whether the map zoom animation is enabled. By default it's enabled
// in all browsers that support CSS3 Transitions except Android.
zoomAnimation:!0,
// @option zoomAnimationThreshold: Number = 4
// Won't animate zoom if the zoom difference exceeds this value.
zoomAnimationThreshold:4,
// @option fadeAnimation: Boolean = true
// Whether the tile fade animation is enabled. By default it's enabled
// in all browsers that support CSS3 Transitions except Android.
fadeAnimation:!0,
// @option markerZoomAnimation: Boolean = true
// Whether markers animate their zoom with the zoom animation, if disabled
// they will disappear for the length of the animation. By default it's
// enabled in all browsers that support CSS3 Transitions except Android.
markerZoomAnimation:!0,
// @option transform3DLimit: Number = 2^23
// Defines the maximum size of a CSS translation transform. The default
// value should not be changed unless a web browser positions layers in
// the wrong place after doing a large `panBy`.
transform3DLimit:8388608,
// Precision limit of a 32-bit float
// @section Interaction Options
// @option zoomSnap: Number = 1
// Forces the map's zoom level to always be a multiple of this, particularly
// right after a [`fitBounds()`](#map-fitbounds) or a pinch-zoom.
// By default, the zoom level snaps to the nearest integer; lower values
// (e.g. `0.5` or `0.1`) allow for greater granularity. A value of `0`
// means the zoom level will not be snapped after `fitBounds` or a pinch-zoom.
zoomSnap:1,
// @option zoomDelta: Number = 1
// Controls how much the map's zoom level will change after a
// [`zoomIn()`](#map-zoomin), [`zoomOut()`](#map-zoomout), pressing `+`
// or `-` on the keyboard, or using the [zoom controls](#control-zoom).
// Values smaller than `1` (e.g. `0.5`) allow for greater granularity.
zoomDelta:1,
// @option trackResize: Boolean = true
// Whether the map automatically handles browser window resize to update itself.
trackResize:!0},initialize:function(t,e){
// (HTMLElement or String, Object)
e=c(this,e),// Make sure to assign internal flags at the beginning,
// to avoid inconsistent state in some edge cases.
this._handlers=[],this._layers={},this._zoomBoundLayers={},this._sizeChanged=!0,this._initContainer(t),this._initLayout(),// hack for https://github.com/Leaflet/Leaflet/issues/1980
this._onResize=_(this._onResize,this),this._initEvents(),e.maxBounds&&this.setMaxBounds(e.maxBounds),void 0!==e.zoom&&(this._zoom=this._limitZoom(e.zoom)),e.center&&void 0!==e.zoom&&this.setView(j(e.center),e.zoom,{reset:!0}),this.callInitHooks(),// don't animate on browsers without hardware-accelerated transitions or old Android/Opera
this._zoomAnimated=Yt&&ft&&!xt&&this.options.zoomAnimation,// zoom transitions run with the same duration for all layers, so if one of transitionend events
// happens after starting zoom animation (propagating to the map pane), we know that it ended globally
this._zoomAnimated&&(this._createAnimProxy(),Le(this._proxy,Xt,this._catchTransitionEnd,this)),this._addLayers(this.options.layers)},
// @section Methods for modifying map state
// @method setView(center: LatLng, zoom: Number, options?: Zoom/pan options): this
// Sets the view of the map (geographical center and zoom) with the given
// animation options.
setView:function(t,e,i){if((e=void 0===e?this._zoom:this._limitZoom(e),t=this._limitCenter(j(t),e,this.options.maxBounds),i=i||{},this._stop(),this._loaded&&!i.reset&&!0!==i)&&(void 0!==i.animate&&(i.zoom=h({animate:i.animate},i.zoom),i.pan=h({animate:i.animate,duration:i.duration},i.pan)),this._zoom!==e?this._tryAnimatedZoom&&this._tryAnimatedZoom(t,e,i.zoom):this._tryAnimatedPan(t,i.pan)))
// prevent resize handler call, the view will refresh after animation anyway
return clearTimeout(this._sizeTimer),this;// animation didn't start, just reset the map view
return this._resetView(t,e),this},
// @method setZoom(zoom: Number, options?: Zoom/pan options): this
// Sets the zoom of the map.
setZoom:function(t,e){return this._loaded?this.setView(this.getCenter(),t,{zoom:e}):(this._zoom=t,this)},
// @method zoomIn(delta?: Number, options?: Zoom options): this
// Increases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).
zoomIn:function(t,e){return t=t||(ft?this.options.zoomDelta:1),this.setZoom(this._zoom+t,e)},
// @method zoomOut(delta?: Number, options?: Zoom options): this
// Decreases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).
zoomOut:function(t,e){return t=t||(ft?this.options.zoomDelta:1),this.setZoom(this._zoom-t,e)},
// @method setZoomAround(latlng: LatLng, zoom: Number, options: Zoom options): this
// Zooms the map while keeping a specified geographical point on the map
// stationary (e.g. used internally for scroll zoom and double-click zoom).
// @alternative
// @method setZoomAround(offset: Point, zoom: Number, options: Zoom options): this
// Zooms the map while keeping a specified pixel on the map (relative to the top-left corner) stationary.
setZoomAround:function(t,e,i){var n=this.getZoomScale(e),o=this.getSize().divideBy(2),n=(t instanceof Z?t:this.latLngToContainerPoint(t)).subtract(o).multiplyBy(1-1/n),n=this.containerPointToLatLng(o.add(n));return this.setView(n,e,{zoom:i})},_getBoundsCenterZoom:function(t,e){e=e||{},t=t.getBounds?t.getBounds():R(t);var i=B(e.paddingTopLeft||e.padding||[0,0]),n=B(e.paddingBottomRight||e.padding||[0,0]),o=this.getBoundsZoom(t,!1,i.add(n));if((o="number"==typeof e.maxZoom?Math.min(e.maxZoom,o):o)===1/0)return{center:t.getCenter(),zoom:o};n=n.subtract(i).divideBy(2),i=this.project(t.getSouthWest(),o),t=this.project(t.getNorthEast(),o);return{center:this.unproject(i.add(t).divideBy(2).add(n),o),zoom:o}},
// @method fitBounds(bounds: LatLngBounds, options?: fitBounds options): this
// Sets a map view that contains the given geographical bounds with the
// maximum zoom level possible.
fitBounds:function(t,e){if(!(t=R(t)).isValid())throw new Error("Bounds are not valid.");t=this._getBoundsCenterZoom(t,e);return this.setView(t.center,t.zoom,e)},
// @method fitWorld(options?: fitBounds options): this
// Sets a map view that mostly contains the whole world with the maximum
// zoom level possible.
fitWorld:function(t){return this.fitBounds([[-90,-180],[90,180]],t)},
// @method panTo(latlng: LatLng, options?: Pan options): this
// Pans the map to a given center.
panTo:function(t,e){
// (LatLng)
return this.setView(t,this._zoom,{pan:e})},
// @method panBy(offset: Point, options?: Pan options): this
// Pans the map by a given number of pixels (animated).
panBy:function(t,e){return e=e||{},(t=B(t).round()).x||t.y?(// If we pan too far, Chrome gets issues with tiles
// and makes them disappear or appear in the wrong place (slightly offset) #2602
!0===e.animate||this.getSize().contains(t)?(this._panAnim||(this._panAnim=new Ne,this._panAnim.on({step:this._onPanTransitionStep,end:this._onPanTransitionEnd},this)),// don't fire movestart if animating inertia
e.noMoveStart||this.fire("movestart"),// animate pan unless animate: false specified
!1!==e.animate?(se(this._mapPane,"leaflet-pan-anim"),i=this._getMapPanePos().subtract(t).round(),this._panAnim.run(this._mapPane,i,e.duration||.25,e.easeLinearity)):(this._rawPanBy(t),this.fire("move").fire("moveend"))):this._resetView(this.unproject(this.project(this.getCenter()).add(t)),this.getZoom()),this):this.fire("moveend");var i},
// @method flyTo(latlng: LatLng, zoom?: Number, options?: Zoom/pan options): this
// Sets the view of the map (geographical center and zoom) performing a smooth
// pan-zoom animation.
flyTo:function(n,o,t){if(!1===(t=t||{}).animate||!ft)return this.setView(n,o,t);this._stop();var s=this.project(this.getCenter()),r=this.project(n),e=this.getSize(),a=this._zoom;n=j(n),o=void 0===o?a:o;var h=Math.max(e.x,e.y),i=h*this.getZoomScale(a,o),l=r.distanceTo(s)||1,u=1.42,c=u*u;function _(t){t=(i*i-h*h+(t?-1:1)*c*c*l*l)/(2*(t?i:h)*c*l),t=Math.sqrt(t*t+1)-t;// workaround for floating point precision bug when sq = 0, log = -Infinite,
// thus triggering an infinite loop in flyTo
return t<1e-9?-18:Math.log(t)}function d(t){return(Math.exp(t)-Math.exp(-t))/2}function p(t){return(Math.exp(t)+Math.exp(-t))/2}var m=_(0);function f(t){return h*(p(m)*(d(t=m+u*t)/p(t))-d(m))/c}var g=Date.now(),v=(_(1)-m)/u,y=t.duration?1e3*t.duration:1e3*v*.8;return this._moveStart(!0,t.noMoveStart),function t(){var e=(Date.now()-g)/y,i=(i=e,(1-Math.pow(1-i,1.5))*v);e<=1?(this._flyToFrame=M(t,this),this._move(this.unproject(s.add(r.subtract(s).multiplyBy(f(i)/l)),a),this.getScaleZoom(h/(h*(p(m)/p(m+u*i))),a),{flyTo:!0})):this._move(n,o)._moveEnd(!0)}.call(this),this},
// @method flyToBounds(bounds: LatLngBounds, options?: fitBounds options): this
// Sets the view of the map with a smooth animation like [`flyTo`](#map-flyto),
// but takes a bounds parameter like [`fitBounds`](#map-fitbounds).
flyToBounds:function(t,e){t=this._getBoundsCenterZoom(t,e);return this.flyTo(t.center,t.zoom,e)},
// @method setMaxBounds(bounds: LatLngBounds): this
// Restricts the map view to the given bounds (see the [maxBounds](#map-maxbounds) option).
setMaxBounds:function(t){return(t=R(t)).isValid()?(this.options.maxBounds&&this.off("moveend",this._panInsideMaxBounds),this.options.maxBounds=t,this._loaded&&this._panInsideMaxBounds(),this.on("moveend",this._panInsideMaxBounds)):(this.options.maxBounds=null,this.off("moveend",this._panInsideMaxBounds))},
// @method setMinZoom(zoom: Number): this
// Sets the lower limit for the available zoom levels (see the [minZoom](#map-minzoom) option).
setMinZoom:function(t){var e=this.options.minZoom;return this.options.minZoom=t,this._loaded&&e!==t&&(this.fire("zoomlevelschange"),this.getZoom()<this.options.minZoom)?this.setZoom(t):this},
// @method setMaxZoom(zoom: Number): this
// Sets the upper limit for the available zoom levels (see the [maxZoom](#map-maxzoom) option).
setMaxZoom:function(t){var e=this.options.maxZoom;return this.options.maxZoom=t,this._loaded&&e!==t&&(this.fire("zoomlevelschange"),this.getZoom()>this.options.maxZoom)?this.setZoom(t):this},
// @method panInsideBounds(bounds: LatLngBounds, options?: Pan options): this
// Pans the map to the closest view that would lie inside the given bounds (if it's not already), controlling the animation using the options specific, if any.
panInsideBounds:function(t,e){this._enforcingBounds=!0;var i=this.getCenter(),t=this._limitCenter(i,this._zoom,R(t));return i.equals(t)||this.panTo(t,e),this._enforcingBounds=!1,this},
// @method panInside(latlng: LatLng, options?: options): this
// Pans the map the minimum amount to make the `latlng` visible. Use
// `padding`, `paddingTopLeft` and `paddingTopRight` options to fit
// the display to more restricted bounds, like [`fitBounds`](#map-fitbounds).
// If `latlng` is already within the (optionally padded) display bounds,
// the map will not be panned.
panInside:function(t,e){var i=B((e=e||{}).paddingTopLeft||e.padding||[0,0]),n=B(e.paddingBottomRight||e.padding||[0,0]),o=this.getCenter(),s=this.project(o),r=this.project(t),a=this.getPixelBounds(),h=a.getSize().divideBy(2),o=I([a.min.add(i),a.max.subtract(n)]);return o.contains(r)||(this._enforcingBounds=!0,t=s.subtract(r),a=B(r.x+t.x,r.y+t.y),(r.x<o.min.x||r.x>o.max.x)&&(a.x=s.x-t.x,0<t.x?a.x+=h.x-i.x:a.x-=h.x-n.x),(r.y<o.min.y||r.y>o.max.y)&&(a.y=s.y-t.y,0<t.y?a.y+=h.y-i.y:a.y-=h.y-n.y),this.panTo(this.unproject(a),e),this._enforcingBounds=!1),this},
// @method invalidateSize(options: Zoom/pan options): this
// Checks if the map container size changed and updates the map if so —
// call it after you've changed the map size dynamically, also animating
// pan by default. If `options.pan` is `false`, panning will not occur.
// If `options.debounceMoveend` is `true`, it will delay `moveend` event so
// that it doesn't happen often even if the method is called many
// times in a row.
// @alternative
// @method invalidateSize(animate: Boolean): this
// Checks if the map container size changed and updates the map if so —
// call it after you've changed the map size dynamically, also animating
// pan by default.
invalidateSize:function(t){if(!this._loaded)return this;t=h({animate:!1,pan:!0},!0===t?{animate:!0}:t);var e=this.getSize();this._sizeChanged=!0,this._lastCenter=null;var i=this.getSize(),n=e.divideBy(2).round(),o=i.divideBy(2).round(),o=n.subtract(o);return o.x||o.y?(t.animate&&t.pan?this.panBy(o):(t.pan&&this._rawPanBy(o),this.fire("move"),t.debounceMoveend?(clearTimeout(this._sizeTimer),this._sizeTimer=setTimeout(_(this.fire,this,"moveend"),200)):this.fire("moveend")),this.fire("resize",{oldSize:e,newSize:i})):this},
// @section Methods for modifying map state
// @method stop(): this
// Stops the currently running `panTo` or `flyTo` animation, if any.
stop:function(){return this.setZoom(this._limitZoom(this._zoom)),this.options.zoomSnap||this.fire("viewreset"),this._stop()},
// @section Geolocation methods
// @method locate(options?: Locate options): this
// Tries to locate the user using the Geolocation API, firing a [`locationfound`](#map-locationfound)
// event with location data on success or a [`locationerror`](#map-locationerror) event on failure,
// and optionally sets the map view to the user's location with respect to
// detection accuracy (or to the world view if geolocation failed).
// Note that, if your page doesn't use HTTPS, this method will fail in
// modern browsers ([Chrome 50 and newer](https://sites.google.com/a/chromium.org/dev/Home/chromium-security/deprecating-powerful-features-on-insecure-origins))
// See `Locate options` for more details.
locate:function(t){if(t=this._locateOptions=h({timeout:1e4,watch:!1},t),!("geolocation"in navigator))return this._handleGeolocationError({code:0,message:"Geolocation not supported."}),this;var e=_(this._handleGeolocationResponse,this),i=_(this._handleGeolocationError,this);return t.watch?this._locationWatchId=navigator.geolocation.watchPosition(e,i,t):navigator.geolocation.getCurrentPosition(e,i,t),this},
// @method stopLocate(): this
// Stops watching location previously initiated by `map.locate({watch: true})`
// and aborts resetting the map view if map.locate was called with
// `{setView: true}`.
stopLocate:function(){return navigator.geolocation&&navigator.geolocation.clearWatch&&navigator.geolocation.clearWatch(this._locationWatchId),this._locateOptions&&(this._locateOptions.setView=!1),this},_handleGeolocationError:function(t){var e=t.code,t=t.message||(1===e?"permission denied":2===e?"position unavailable":"timeout");this._locateOptions.setView&&!this._loaded&&this.fitWorld(),// @section Location events
// @event locationerror: ErrorEvent
// Fired when geolocation (using the [`locate`](#map-locate) method) failed.
this.fire("locationerror",{code:e,message:"Geolocation error: "+t+"."})},_handleGeolocationResponse:function(t){var e,i=new N(t.coords.latitude,t.coords.longitude),n=i.toBounds(2*t.coords.accuracy),o=this._locateOptions;o.setView&&(e=this.getBoundsZoom(n),this.setView(i,o.maxZoom?Math.min(e,o.maxZoom):e));var s,r={latlng:i,bounds:n,timestamp:t.timestamp};for(s in t.coords)"number"==typeof t.coords[s]&&(r[s]=t.coords[s]);// @event locationfound: LocationEvent
// Fired when geolocation (using the [`locate`](#map-locate) method)
// went successfully.
this.fire("locationfound",r)},
// TODO Appropriate docs section?
// @section Other Methods
// @method addHandler(name: String, HandlerClass: Function): this
// Adds a new `Handler` to the map, given its name and constructor function.
addHandler:function(t,e){if(!e)return this;e=this[t]=new e(this);return this._handlers.push(e),this.options[t]&&e.enable(),this},
// @method remove(): this
// Destroys the map and clears all related event listeners.
remove:function(){if(this._initEvents(!0),this.off("moveend",this._panInsideMaxBounds),this._containerId!==this._container._leaflet_id)throw new Error("Map container is being reused by another instance");try{
// throws error in IE6-8
delete this._container._leaflet_id,delete this._containerId}catch(t){
/*eslint-disable */
this._container._leaflet_id=void 0,
/* eslint-enable */
this._containerId=void 0}for(var t in void 0!==this._locationWatchId&&this.stopLocate(),this._stop(),te(this._mapPane),this._clearControlPos&&this._clearControlPos(),this._resizeRequest&&(T(this._resizeRequest),this._resizeRequest=null),this._clearHandlers(),this._loaded&&
// @section Map state change events
// @event unload: Event
// Fired when the map is destroyed with [remove](#map-remove) method.
this.fire("unload"),this._layers)this._layers[t].remove();for(t in this._panes)te(this._panes[t]);return this._layers=[],this._panes=[],delete this._mapPane,delete this._renderer,this},
// @section Other Methods
// @method createPane(name: String, container?: HTMLElement): HTMLElement
// Creates a new [map pane](#map-pane) with the given name if it doesn't exist already,
// then returns it. The pane is created as a child of `container`, or
// as a child of the main map pane if not set.
createPane:function(t,e){e=$t("div","leaflet-pane"+(t?" leaflet-"+t.replace("Pane","")+"-pane":""),e||this._mapPane);return t&&(this._panes[t]=e),e},
// @section Methods for Getting Map State
// @method getCenter(): LatLng
// Returns the geographical center of the map view
getCenter:function(){return this._checkIfLoaded(),this._lastCenter&&!this._moved()?this._lastCenter:this.layerPointToLatLng(this._getCenterLayerPoint())},
// @method getZoom(): Number
// Returns the current zoom level of the map view
getZoom:function(){return this._zoom},
// @method getBounds(): LatLngBounds
// Returns the geographical bounds visible in the current map view
getBounds:function(){var t=this.getPixelBounds();return new D(this.unproject(t.getBottomLeft()),this.unproject(t.getTopRight()))},
// @method getMinZoom(): Number
// Returns the minimum zoom level of the map (if set in the `minZoom` option of the map or of any layers), or `0` by default.
getMinZoom:function(){return void 0===this.options.minZoom?this._layersMinZoom||0:this.options.minZoom},
// @method getMaxZoom(): Number
// Returns the maximum zoom level of the map (if set in the `maxZoom` option of the map or of any layers).
getMaxZoom:function(){return void 0===this.options.maxZoom?void 0===this._layersMaxZoom?1/0:this._layersMaxZoom:this.options.maxZoom},
// @method getBoundsZoom(bounds: LatLngBounds, inside?: Boolean, padding?: Point): Number
// Returns the maximum zoom level on which the given bounds fit to the map
// view in its entirety. If `inside` (optional) is set to `true`, the method
// instead returns the minimum zoom level on which the map view fits into
// the given bounds in its entirety.
getBoundsZoom:function(t,e,i){
// (LatLngBounds[, Boolean, Point]) -> Number
t=R(t),i=B(i||[0,0]);var n=this.getZoom()||0,o=this.getMinZoom(),s=this.getMaxZoom(),r=t.getNorthWest(),a=t.getSouthEast(),t=this.getSize().subtract(i),i=I(this.project(a,n),this.project(r,n)).getSize(),a=ft?this.options.zoomSnap:1,r=t.x/i.x,i=t.y/i.y,i=e?Math.max(r,i):Math.min(r,i),n=this.getScaleZoom(i,n);return a&&(n=Math.round(n/(a/100))*(a/100),// don't jump if within 1% of a snap level
n=e?Math.ceil(n/a)*a:Math.floor(n/a)*a),Math.max(o,Math.min(s,n))},
// @method getSize(): Point
// Returns the current size of the map container (in pixels).
getSize:function(){return this._size&&!this._sizeChanged||(this._size=new Z(this._container.clientWidth||0,this._container.clientHeight||0),this._sizeChanged=!1),this._size.clone()},
// @method getPixelBounds(): Bounds
// Returns the bounds of the current map view in projected pixel
// coordinates (sometimes useful in layer and overlay implementations).
getPixelBounds:function(t,e){e=this._getTopLeftPoint(t,e);return new O(e,e.add(this.getSize()))},
// TODO: Check semantics - isn't the pixel origin the 0,0 coord relative to
// the map pane? "left point of the map layer" can be confusing, specially
// since there can be negative offsets.
// @method getPixelOrigin(): Point
// Returns the projected pixel coordinates of the top left point of
// the map layer (useful in custom layer and overlay implementations).
getPixelOrigin:function(){return this._checkIfLoaded(),this._pixelOrigin},
// @method getPixelWorldBounds(zoom?: Number): Bounds
// Returns the world's bounds in pixel coordinates for zoom level `zoom`.
// If `zoom` is omitted, the map's current zoom level is used.
getPixelWorldBounds:function(t){return this.options.crs.getProjectedBounds(void 0===t?this.getZoom():t)},
// @section Other Methods
// @method getPane(pane: String|HTMLElement): HTMLElement
// Returns a [map pane](#map-pane), given its name or its HTML element (its identity).
getPane:function(t){return"string"==typeof t?this._panes[t]:t},
// @method getPanes(): Object
// Returns a plain object containing the names of all [panes](#map-pane) as keys and
// the panes as values.
getPanes:function(){return this._panes},
// @method getContainer: HTMLElement
// Returns the HTML element that contains the map.
getContainer:function(){return this._container},
// @section Conversion Methods
// @method getZoomScale(toZoom: Number, fromZoom: Number): Number
// Returns the scale factor to be applied to a map transition from zoom level
// `fromZoom` to `toZoom`. Used internally to help with zoom animations.
getZoomScale:function(t,e){
// TODO replace with universal implementation after refactoring projections
var i=this.options.crs;return e=void 0===e?this._zoom:e,i.scale(t)/i.scale(e)},
// @method getScaleZoom(scale: Number, fromZoom: Number): Number
// Returns the zoom level that the map would end up at, if it is at `fromZoom`
// level and everything is scaled by a factor of `scale`. Inverse of
// [`getZoomScale`](#map-getZoomScale).
getScaleZoom:function(t,e){var i=this.options.crs;e=void 0===e?this._zoom:e;e=i.zoom(t*i.scale(e));return isNaN(e)?1/0:e},
// @method project(latlng: LatLng, zoom: Number): Point
// Projects a geographical coordinate `LatLng` according to the projection
// of the map's CRS, then scales it according to `zoom` and the CRS's
// `Transformation`. The result is pixel coordinate relative to
// the CRS origin.
project:function(t,e){return e=void 0===e?this._zoom:e,this.options.crs.latLngToPoint(j(t),e)},
// @method unproject(point: Point, zoom: Number): LatLng
// Inverse of [`project`](#map-project).
unproject:function(t,e){return e=void 0===e?this._zoom:e,this.options.crs.pointToLatLng(B(t),e)},
// @method layerPointToLatLng(point: Point): LatLng
// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),
// returns the corresponding geographical coordinate (for the current zoom level).
layerPointToLatLng:function(t){t=B(t).add(this.getPixelOrigin());return this.unproject(t)},
// @method latLngToLayerPoint(latlng: LatLng): Point
// Given a geographical coordinate, returns the corresponding pixel coordinate
// relative to the [origin pixel](#map-getpixelorigin).
latLngToLayerPoint:function(t){return this.project(j(t))._round()._subtract(this.getPixelOrigin())},
// @method wrapLatLng(latlng: LatLng): LatLng
// Returns a `LatLng` where `lat` and `lng` has been wrapped according to the
// map's CRS's `wrapLat` and `wrapLng` properties, if they are outside the
// CRS's bounds.
// By default this means longitude is wrapped around the dateline so its
// value is between -180 and +180 degrees.
wrapLatLng:function(t){return this.options.crs.wrapLatLng(j(t))},
// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds
// Returns a `LatLngBounds` with the same size as the given one, ensuring that
// its center is within the CRS's bounds.
// By default this means the center longitude is wrapped around the dateline so its
// value is between -180 and +180 degrees, and the majority of the bounds
// overlaps the CRS's bounds.
wrapLatLngBounds:function(t){return this.options.crs.wrapLatLngBounds(R(t))},
// @method distance(latlng1: LatLng, latlng2: LatLng): Number
// Returns the distance between two geographical coordinates according to
// the map's CRS. By default this measures distance in meters.
distance:function(t,e){return this.options.crs.distance(j(t),j(e))},
// @method containerPointToLayerPoint(point: Point): Point
// Given a pixel coordinate relative to the map container, returns the corresponding
// pixel coordinate relative to the [origin pixel](#map-getpixelorigin).
containerPointToLayerPoint:function(t){
// (Point)
return B(t).subtract(this._getMapPanePos())},
// @method layerPointToContainerPoint(point: Point): Point
// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),
// returns the corresponding pixel coordinate relative to the map container.
layerPointToContainerPoint:function(t){
// (Point)
return B(t).add(this._getMapPanePos())},
// @method containerPointToLatLng(point: Point): LatLng
// Given a pixel coordinate relative to the map container, returns
// the corresponding geographical coordinate (for the current zoom level).
containerPointToLatLng:function(t){t=this.containerPointToLayerPoint(B(t));return this.layerPointToLatLng(t)},
// @method latLngToContainerPoint(latlng: LatLng): Point
// Given a geographical coordinate, returns the corresponding pixel coordinate
// relative to the map container.
latLngToContainerPoint:function(t){return this.layerPointToContainerPoint(this.latLngToLayerPoint(j(t)))},
// @method mouseEventToContainerPoint(ev: MouseEvent): Point
// Given a MouseEvent object, returns the pixel coordinate relative to the
// map container where the event took place.
mouseEventToContainerPoint:function(t){return Ze(t,this._container)},
// @method mouseEventToLayerPoint(ev: MouseEvent): Point
// Given a MouseEvent object, returns the pixel coordinate relative to
// the [origin pixel](#map-getpixelorigin) where the event took place.
mouseEventToLayerPoint:function(t){return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(t))},
// @method mouseEventToLatLng(ev: MouseEvent): LatLng
// Given a MouseEvent object, returns geographical coordinate where the
// event took place.
mouseEventToLatLng:function(t){
// (MouseEvent)
return this.layerPointToLatLng(this.mouseEventToLayerPoint(t))},
// map initialization methods
_initContainer:function(t){t=this._container=Jt(t);if(!t)throw new Error("Map container not found.");if(t._leaflet_id)throw new Error("Map container is already initialized.");Le(t,"scroll",this._onScroll,this),this._containerId=m(t)},_initLayout:function(){var t=this._container;this._fadeAnimated=this.options.fadeAnimation&&ft,se(t,"leaflet-container"+(Lt?" leaflet-touch":"")+(wt?" leaflet-retina":"")+($?" leaflet-oldie":"")+(lt?" leaflet-safari":"")+(this._fadeAnimated?" leaflet-fade-anim":""));var e=Qt(t,"position");"absolute"!==e&&"relative"!==e&&"fixed"!==e&&(t.style.position="relative"),this._initPanes(),this._initControlPos&&this._initControlPos()},_initPanes:function(){var t=this._panes={};this._paneRenderers={},// @section
//
// Panes are DOM elements used to control the ordering of layers on the map. You
// can access panes with [`map.getPane`](#map-getpane) or
// [`map.getPanes`](#map-getpanes) methods. New panes can be created with the
// [`map.createPane`](#map-createpane) method.
//
// Every map has the following default panes that differ only in zIndex.
//
// @pane mapPane: HTMLElement = 'auto'
// Pane that contains all other map panes
this._mapPane=this.createPane("mapPane",this._container),_e(this._mapPane,new Z(0,0)),// @pane tilePane: HTMLElement = 200
// Pane for `GridLayer`s and `TileLayer`s
this.createPane("tilePane"),// @pane overlayPane: HTMLElement = 400
// Pane for overlay shadows (e.g. `Marker` shadows)
this.createPane("shadowPane"),// @pane shadowPane: HTMLElement = 500
// Pane for vectors (`Path`s, like `Polyline`s and `Polygon`s), `ImageOverlay`s and `VideoOverlay`s
this.createPane("overlayPane"),// @pane markerPane: HTMLElement = 600
// Pane for `Icon`s of `Marker`s
this.createPane("markerPane"),// @pane tooltipPane: HTMLElement = 650
// Pane for `Tooltip`s.
this.createPane("tooltipPane"),// @pane popupPane: HTMLElement = 700
// Pane for `Popup`s.
this.createPane("popupPane"),this.options.markerZoomAnimation||(se(t.markerPane,"leaflet-zoom-hide"),se(t.shadowPane,"leaflet-zoom-hide"))},
// private methods that modify map state
// @section Map state change events
_resetView:function(t,e){_e(this._mapPane,new Z(0,0));var i=!this._loaded;this._loaded=!0,e=this._limitZoom(e),this.fire("viewprereset");var n=this._zoom!==e;this._moveStart(n,!1)._move(t,e)._moveEnd(n),// @event viewreset: Event
// Fired when the map needs to redraw its content (this usually happens
// on map zoom or load). Very useful for creating custom overlays.
this.fire("viewreset"),// @event load: Event
// Fired when the map is initialized (when its center and zoom are set
// for the first time).
i&&this.fire("load")},_moveStart:function(t,e){
// @event zoomstart: Event
// Fired when the map zoom is about to change (e.g. before zoom animation).
// @event movestart: Event
// Fired when the view of the map starts changing (e.g. user starts dragging the map).
return t&&this.fire("zoomstart"),e||this.fire("movestart"),this},_move:function(t,e,i){void 0===e&&(e=this._zoom);var n=this._zoom!==e;// @event move: Event
// Fired repeatedly during any movement of the map, including pan and
// fly animations.
return this._zoom=e,this._lastCenter=t,this._pixelOrigin=this._getNewPixelOrigin(t),// @event zoom: Event
// Fired repeatedly during any change in zoom level, including zoom
// and fly animations.
(n||i&&i.pinch)&&
// Always fire 'zoom' if pinching because #3530
this.fire("zoom",i),this.fire("move",i)},_moveEnd:function(t){// @event moveend: Event
// Fired when the center of the map stops changing (e.g. user stopped
// dragging the map).
// @event zoomend: Event
// Fired when the map has changed, after any animations.
return t&&this.fire("zoomend"),this.fire("moveend")},_stop:function(){return T(this._flyToFrame),this._panAnim&&this._panAnim.stop(),this},_rawPanBy:function(t){_e(this._mapPane,this._getMapPanePos().subtract(t))},_getZoomSpan:function(){return this.getMaxZoom()-this.getMinZoom()},_panInsideMaxBounds:function(){this._enforcingBounds||this.panInsideBounds(this.options.maxBounds)},_checkIfLoaded:function(){if(!this._loaded)throw new Error("Set map center and zoom first.")},
// DOM event handling
// @section Interaction events
_initEvents:function(t){this._targets={};var e=t?we:Le;// @event click: MouseEvent
// Fired when the user clicks (or taps) the map.
// @event dblclick: MouseEvent
// Fired when the user double-clicks (or double-taps) the map.
// @event mousedown: MouseEvent
// Fired when the user pushes the mouse button on the map.
// @event mouseup: MouseEvent
// Fired when the user releases the mouse button on the map.
// @event mouseover: MouseEvent
// Fired when the mouse enters the map.
// @event mouseout: MouseEvent
// Fired when the mouse leaves the map.
// @event mousemove: MouseEvent
// Fired while the mouse moves over the map.
// @event contextmenu: MouseEvent
// Fired when the user pushes the right mouse button on the map, prevents
// default browser context menu from showing if there are listeners on
// this event. Also fired on mobile when the user holds a single touch
// for a second (also called long press).
// @event keypress: KeyboardEvent
// Fired when the user presses a key from the keyboard that produces a character value while the map is focused.
// @event keydown: KeyboardEvent
// Fired when the user presses a key from the keyboard while the map is focused. Unlike the `keypress` event,
// the `keydown` event is fired for keys that produce a character value and for keys
// that do not produce a character value.
// @event keyup: KeyboardEvent
// Fired when the user releases a key from the keyboard while the map is focused.
e((this._targets[m(this._container)]=this)._container,"click dblclick mousedown mouseup mouseover mouseout mousemove contextmenu keypress keydown keyup",this._handleDOMEvent,this),this.options.trackResize&&e(window,"resize",this._onResize,this),ft&&this.options.transform3DLimit&&(t?this.off:this.on).call(this,"moveend",this._onMoveEnd)},_onResize:function(){T(this._resizeRequest),this._resizeRequest=M(function(){this.invalidateSize({debounceMoveend:!0})},this)},_onScroll:function(){this._container.scrollTop=0,this._container.scrollLeft=0},_onMoveEnd:function(){var t=this._getMapPanePos();Math.max(Math.abs(t.x),Math.abs(t.y))>=this.options.transform3DLimit&&
// https://bugzilla.mozilla.org/show_bug.cgi?id=1203873 but Webkit also have
// a pixel offset on very high values, see: http://jsfiddle.net/dg6r5hhb/
this._resetView(this.getCenter(),this.getZoom())},_findEventTargets:function(t,e){for(var i,n=[],o="mouseout"===e||"mouseover"===e,s=t.target||t.srcElement,r=!1;s;){if((i=this._targets[m(s)])&&("click"===e||"preclick"===e)&&!t._simulated&&this._draggableMoved(i)){
// Prevent firing click after you just dragged an object.
r=!0;break}if(i&&i.listens(e,!0)){if(o&&!Re(s,t))break;if(n.push(i),o)break}if(s===this._container)break;s=s.parentNode}return n.length||r||o||!Re(s,t)||(n=[this]),n},_handleDOMEvent:function(t){var e;this._loaded&&!De(t)&&("mousedown"!==(e=t.type)&&"keypress"!==e&&"keyup"!==e&&"keydown"!==e||
// prevents outline when clicking on keyboard-focusable element
fe(t.target||t.srcElement),this._fireDOMEvent(t,e))},_mouseEvents:["click","dblclick","mouseover","mouseout","contextmenu"],_fireDOMEvent:function(t,e,i){if("click"===t.type&&((o=h({},t)).type="preclick",this._fireDOMEvent(o,o.type,i)),!t._stopped&&(// Find the layer the event is propagating from and its parents.
i=(i||[]).concat(this._findEventTargets(t,e))).length){var n=i[0];"contextmenu"===e&&n.listens(e,!0)&&Se(t);var o,s={originalEvent:t};"keypress"!==t.type&&"keydown"!==t.type&&"keyup"!==t.type&&(o=n.getLatLng&&(!n._radius||n._radius<=10),s.containerPoint=o?this.latLngToContainerPoint(n.getLatLng()):this.mouseEventToContainerPoint(t),s.layerPoint=this.containerPointToLayerPoint(s.containerPoint),s.latlng=o?n.getLatLng():this.layerPointToLatLng(s.layerPoint));for(var r=0;r<i.length;r++)if(i[r].fire(e,s,!0),s.originalEvent._stopped||!1===i[r].options.bubblingMouseEvents&&-1!==v(this._mouseEvents,e))return}},_draggableMoved:function(t){return(t=t.dragging&&t.dragging.enabled()?t:this).dragging&&t.dragging.moved()||this.boxZoom&&this.boxZoom.moved()},_clearHandlers:function(){for(var t=0,e=this._handlers.length;t<e;t++)this._handlers[t].disable()},
// @section Other Methods
// @method whenReady(fn: Function, context?: Object): this
// Runs the given function `fn` when the map gets initialized with
// a view (center and zoom) and at least one layer, or immediately
// if it's already initialized, optionally passing a function context.
whenReady:function(t,e){return this._loaded?t.call(e||this,{target:this}):this.on("load",t,e),this},
// private methods for getting map state
_getMapPanePos:function(){return de(this._mapPane)||new Z(0,0)},_moved:function(){var t=this._getMapPanePos();return t&&!t.equals([0,0])},_getTopLeftPoint:function(t,e){return(t&&void 0!==e?this._getNewPixelOrigin(t,e):this.getPixelOrigin()).subtract(this._getMapPanePos())},_getNewPixelOrigin:function(t,e){var i=this.getSize()._divideBy(2);return this.project(t,e)._subtract(i)._add(this._getMapPanePos())._round()},_latLngToNewLayerPoint:function(t,e,i){i=this._getNewPixelOrigin(i,e);return this.project(t,e)._subtract(i)},_latLngBoundsToNewLayerBounds:function(t,e,i){i=this._getNewPixelOrigin(i,e);return I([this.project(t.getSouthWest(),e)._subtract(i),this.project(t.getNorthWest(),e)._subtract(i),this.project(t.getSouthEast(),e)._subtract(i),this.project(t.getNorthEast(),e)._subtract(i)])},
// layer point of the current center
_getCenterLayerPoint:function(){return this.containerPointToLayerPoint(this.getSize()._divideBy(2))},
// offset of the specified place to the current center in pixels
_getCenterOffset:function(t){return this.latLngToLayerPoint(t).subtract(this._getCenterLayerPoint())},
// adjust center for view to get inside bounds
_limitCenter:function(t,e,i){if(!i)return t;var n=this.project(t,e),o=this.getSize().divideBy(2),o=new O(n.subtract(o),n.add(o)),i=this._getBoundsOffset(o,i,e);// If offset is less than a pixel, ignore.
// This prevents unstable projections from getting into
// an infinite loop of tiny offsets.
return i.round().equals([0,0])?t:this.unproject(n.add(i),e)},
// adjust offset for view to get inside bounds
_limitOffset:function(t,e){if(!e)return t;var i=this.getPixelBounds(),i=new O(i.min.add(t),i.max.add(t));return t.add(this._getBoundsOffset(i,e))},
// returns offset needed for pxBounds to get inside maxBounds at a specified zoom
_getBoundsOffset:function(t,e,i){e=I(this.project(e.getNorthEast(),i),this.project(e.getSouthWest(),i)),i=e.min.subtract(t.min),t=e.max.subtract(t.max);return new Z(this._rebound(i.x,-t.x),this._rebound(i.y,-t.y))},_rebound:function(t,e){return 0<t+e?Math.round(t-e)/2:Math.max(0,Math.ceil(t))-Math.max(0,Math.floor(e))},_limitZoom:function(t){var e=this.getMinZoom(),i=this.getMaxZoom(),n=ft?this.options.zoomSnap:1;return n&&(t=Math.round(t/n)*n),Math.max(e,Math.min(i,t))},_onPanTransitionStep:function(){this.fire("move")},_onPanTransitionEnd:function(){re(this._mapPane,"leaflet-pan-anim"),this.fire("moveend")},_tryAnimatedPan:function(t,e){
// difference between the new and current centers in pixels
t=this._getCenterOffset(t)._trunc();// don't animate too far unless animate: true specified in options
return!(!0!==(e&&e.animate)&&!this.getSize().contains(t))&&(this.panBy(t,e),!0)},_createAnimProxy:function(){var t=this._proxy=$t("div","leaflet-proxy leaflet-zoom-animated");this._panes.mapPane.appendChild(t),this.on("zoomanim",function(t){var e=Kt,i=this._proxy.style[e];ce(this._proxy,this.project(t.center,t.zoom),this.getZoomScale(t.zoom,1)),// workaround for case when transform is the same and so transitionend event is not fired
i===this._proxy.style[e]&&this._animatingZoom&&this._onZoomTransitionEnd()},this),this.on("load moveend",this._animMoveEnd,this),this._on("unload",this._destroyAnimProxy,this)},_destroyAnimProxy:function(){te(this._proxy),this.off("load moveend",this._animMoveEnd,this),delete this._proxy},_animMoveEnd:function(){var t=this.getCenter(),e=this.getZoom();ce(this._proxy,this.project(t,e),this.getZoomScale(e,1))},_catchTransitionEnd:function(t){this._animatingZoom&&0<=t.propertyName.indexOf("transform")&&this._onZoomTransitionEnd()},_nothingToAnimate:function(){return!this._container.getElementsByClassName("leaflet-zoom-animated").length},_tryAnimatedZoom:function(t,e,i){if(this._animatingZoom)return!0;// don't animate if disabled, not supported or zoom difference is too large
if(i=i||{},!this._zoomAnimated||!1===i.animate||this._nothingToAnimate()||Math.abs(e-this._zoom)>this.options.zoomAnimationThreshold)return!1;// offset is the pixel coords of the zoom origin relative to the current center
var n=this.getZoomScale(e),n=this._getCenterOffset(t)._divideBy(1-1/n);// don't animate if the zoom origin isn't within one screen from the current center, unless forced
return!(!0!==i.animate&&!this.getSize().contains(n))&&(M(function(){this._moveStart(!0,!1)._animateZoom(t,e,!0)},this),!0)},_animateZoom:function(t,e,i,n){this._mapPane&&(i&&(this._animatingZoom=!0,// remember what center/zoom to set after animation
this._animateToCenter=t,this._animateToZoom=e,se(this._mapPane,"leaflet-zoom-anim")),// @section Other Events
// @event zoomanim: ZoomAnimEvent
// Fired at least once per zoom animation. For continuous zoom, like pinch zooming, fired once per frame during zoom.
this.fire("zoomanim",{center:t,zoom:e,noUpdate:n}),// Work around webkit not firing 'transitionend', see https://github.com/Leaflet/Leaflet/issues/3689, 2693
setTimeout(_(this._onZoomTransitionEnd,this),250))},_onZoomTransitionEnd:function(){this._animatingZoom&&(this._mapPane&&re(this._mapPane,"leaflet-zoom-anim"),this._animatingZoom=!1,this._move(this._animateToCenter,this._animateToZoom),// This anim frame should prevent an obscure iOS webkit tile loading race condition.
M(function(){this._moveEnd(!0)},this))}});
/*
   * @class PosAnimation
   * @aka L.PosAnimation
   * @inherits Evented
   * Used internally for panning animations, utilizing CSS3 Transitions for modern browsers and a timer fallback for IE6-9.
   *
   * @example
   * ```js
   * var fx = new L.PosAnimation();
   * fx.run(el, [300, 500], 0.5);
   * ```
   *
   * @constructor L.PosAnimation()
   * Creates a `PosAnimation` object.
   *
   */
/*
   * @class Control
   * @aka L.Control
   * @inherits Class
   *
   * L.Control is a base class for implementing map controls. Handles positioning.
   * All other controls extend from this class.
   */
var Fe=z.extend({
// @section
// @aka Control options
options:{
// @option position: String = 'topright'
// The position of the control (one of the map corners). Possible values are `'topleft'`,
// `'topright'`, `'bottomleft'` or `'bottomright'`
position:"topright"},initialize:function(t){c(this,t)},
/* @section
     * Classes extending L.Control will inherit the following methods:
     *
     * @method getPosition: string
     * Returns the position of the control.
     */
getPosition:function(){return this.options.position},
// @method setPosition(position: string): this
// Sets the position of the control.
setPosition:function(t){var e=this._map;return e&&e.removeControl(this),this.options.position=t,e&&e.addControl(this),this},
// @method getContainer: HTMLElement
// Returns the HTMLElement that contains the control.
getContainer:function(){return this._container},
// @method addTo(map: Map): this
// Adds the control to the given map.
addTo:function(t){this.remove(),this._map=t;var e=this._container=this.onAdd(t),i=this.getPosition(),t=t._controlCorners[i];return se(e,"leaflet-control"),-1!==i.indexOf("bottom")?t.insertBefore(e,t.firstChild):t.appendChild(e),this._map.on("unload",this.remove,this),this},
// @method remove: this
// Removes the control from the map it is currently active on.
remove:function(){return this._map&&(te(this._container),this.onRemove&&this.onRemove(this._map),this._map.off("unload",this.remove,this),this._map=null),this},_refocusOnMap:function(t){
// if map exists and event is not a keyboard event
this._map&&t&&0<t.screenX&&0<t.screenY&&this._map.getContainer().focus()}}),pt=function(t){return new Fe(t)};
/* @section Extension methods
   * @uninheritable
   *
   * Every control should extend from `L.Control` and (re-)implement the following methods.
   *
   * @method onAdd(map: Map): HTMLElement
   * Should return the container DOM element for the control and add listeners on relevant map events. Called on [`control.addTo(map)`](#control-addTo).
   *
   * @method onRemove(map: Map)
   * Optional method. Should contain all clean up code that removes the listeners previously added in [`onAdd`](#control-onadd). Called on [`control.remove()`](#control-remove).
   */
/* @namespace Map
   * @section Methods for Layers and Controls
   */
je.include({
// @method addControl(control: Control): this
// Adds the given control to the map
addControl:function(t){return t.addTo(this),this},
// @method removeControl(control: Control): this
// Removes the given control from the map
removeControl:function(t){return t.remove(),this},_initControlPos:function(){var n=this._controlCorners={},o="leaflet-",s=this._controlContainer=$t("div",o+"control-container",this._container);function t(t,e){var i=o+t+" "+o+e;n[t+e]=$t("div",i,s)}t("top","left"),t("top","right"),t("bottom","left"),t("bottom","right")},_clearControlPos:function(){for(var t in this._controlCorners)te(this._controlCorners[t]);te(this._controlContainer),delete this._controlCorners,delete this._controlContainer}});
/*
   * @class Control.Layers
   * @aka L.Control.Layers
   * @inherits Control
   *
   * The layers control gives users the ability to switch between different base layers and switch overlays on/off (check out the [detailed example](http://leafletjs.com/examples/layers-control/)). Extends `Control`.
   *
   * @example
   *
   * ```js
   * var baseLayers = {
   * 	"Mapbox": mapbox,
   * 	"OpenStreetMap": osm
   * };
   *
   * var overlays = {
   * 	"Marker": marker,
   * 	"Roads": roadsLayer
   * };
   *
   * L.control.layers(baseLayers, overlays).addTo(map);
   * ```
   *
   * The `baseLayers` and `overlays` parameters are object literals with layer names as keys and `Layer` objects as values:
   *
   * ```js
   * {
   *     "<someName1>": layer1,
   *     "<someName2>": layer2
   * }
   * ```
   *
   * The layer names can contain HTML, which allows you to add additional styling to the items:
   *
   * ```js
   * {"<img src='my-layer-icon' /> <span class='my-layer-item'>My Layer</span>": myLayer}
   * ```
   */
var Ue=Fe.extend({
// @section
// @aka Control.Layers options
options:{
// @option collapsed: Boolean = true
// If `true`, the control will be collapsed into an icon and expanded on mouse hover or touch.
collapsed:!0,position:"topright",
// @option autoZIndex: Boolean = true
// If `true`, the control will assign zIndexes in increasing order to all of its layers so that the order is preserved when switching them on/off.
autoZIndex:!0,
// @option hideSingleBase: Boolean = false
// If `true`, the base layers in the control will be hidden when there is only one.
hideSingleBase:!1,
// @option sortLayers: Boolean = false
// Whether to sort the layers. When `false`, layers will keep the order
// in which they were added to the control.
sortLayers:!1,
// @option sortFunction: Function = *
// A [compare function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/sort)
// that will be used for sorting the layers, when `sortLayers` is `true`.
// The function receives both the `L.Layer` instances and their names, as in
// `sortFunction(layerA, layerB, nameA, nameB)`.
// By default, it sorts layers alphabetically by their name.
sortFunction:function(t,e,i,n){return i<n?-1:n<i?1:0}},initialize:function(t,e,i){for(var n in c(this,i),this._layerControlInputs=[],this._layers=[],this._lastZIndex=0,this._handlingClick=!1,t)this._addLayer(t[n],n);for(n in e)this._addLayer(e[n],n,!0)},onAdd:function(t){this._initLayout(),this._update(),(this._map=t).on("zoomend",this._checkDisabledLayers,this);for(var e=0;e<this._layers.length;e++)this._layers[e].layer.on("add remove",this._onLayerChange,this);return this._container},addTo:function(t){// Trigger expand after Layers Control has been inserted into DOM so that is now has an actual height.
return Fe.prototype.addTo.call(this,t),this._expandIfNotCollapsed()},onRemove:function(){this._map.off("zoomend",this._checkDisabledLayers,this);for(var t=0;t<this._layers.length;t++)this._layers[t].layer.off("add remove",this._onLayerChange,this)},
// @method addBaseLayer(layer: Layer, name: String): this
// Adds a base layer (radio button entry) with the given name to the control.
addBaseLayer:function(t,e){return this._addLayer(t,e),this._map?this._update():this},
// @method addOverlay(layer: Layer, name: String): this
// Adds an overlay (checkbox entry) with the given name to the control.
addOverlay:function(t,e){return this._addLayer(t,e,!0),this._map?this._update():this},
// @method removeLayer(layer: Layer): this
// Remove the given layer from the control.
removeLayer:function(t){t.off("add remove",this._onLayerChange,this);t=this._getLayer(m(t));return t&&this._layers.splice(this._layers.indexOf(t),1),this._map?this._update():this},
// @method expand(): this
// Expand the control container if collapsed.
expand:function(){se(this._container,"leaflet-control-layers-expanded"),this._section.style.height=null;var t=this._map.getSize().y-(this._container.offsetTop+50);return t<this._section.clientHeight?(se(this._section,"leaflet-control-layers-scrollbar"),this._section.style.height=t+"px"):re(this._section,"leaflet-control-layers-scrollbar"),this._checkDisabledLayers(),this},
// @method collapse(): this
// Collapse the control container if expanded.
collapse:function(){return re(this._container,"leaflet-control-layers-expanded"),this},_initLayout:function(){var t="leaflet-control-layers",e=this._container=$t("div",t),i=this.options.collapsed;// makes this work on IE touch devices by stopping it from firing a mouseout event when the touch is released
e.setAttribute("aria-haspopup",!0),ze(e),ke(e);var n=this._section=$t("section",t+"-list");i&&(this._map.on("click",this.collapse,this),it||Le(e,{mouseenter:this.expand,mouseleave:this.collapse},this));var o=this._layersLink=$t("a",t+"-toggle",e);o.href="#",o.title="Layers",Lt?(Le(o,"click",Ee),Le(o,"click",this.expand,this)):Le(o,"focus",this.expand,this),i||this.expand(),this._baseLayersList=$t("div",t+"-base",n),this._separator=$t("div",t+"-separator",n),this._overlaysList=$t("div",t+"-overlays",n),e.appendChild(n)},_getLayer:function(t){for(var e=0;e<this._layers.length;e++)if(this._layers[e]&&m(this._layers[e].layer)===t)return this._layers[e]},_addLayer:function(t,e,i){this._map&&t.on("add remove",this._onLayerChange,this),this._layers.push({layer:t,name:e,overlay:i}),this.options.sortLayers&&this._layers.sort(_(function(t,e){return this.options.sortFunction(t.layer,e.layer,t.name,e.name)},this)),this.options.autoZIndex&&t.setZIndex&&(this._lastZIndex++,t.setZIndex(this._lastZIndex)),this._expandIfNotCollapsed()},_update:function(){if(!this._container)return this;ee(this._baseLayersList),ee(this._overlaysList),this._layerControlInputs=[];for(var t,e,i,n=0,o=0;o<this._layers.length;o++)i=this._layers[o],this._addItem(i),e=e||i.overlay,t=t||!i.overlay,n+=i.overlay?0:1;// Hide base layers section if there's only one layer.
return this.options.hideSingleBase&&(t=t&&1<n,this._baseLayersList.style.display=t?"":"none"),this._separator.style.display=e&&t?"":"none",this},_onLayerChange:function(t){this._handlingClick||this._update();var e=this._getLayer(m(t.target)),t=e.overlay?"add"===t.type?"overlayadd":"overlayremove":"add"===t.type?"baselayerchange":null;// @namespace Map
// @section Layer events
// @event baselayerchange: LayersControlEvent
// Fired when the base layer is changed through the [layers control](#control-layers).
// @event overlayadd: LayersControlEvent
// Fired when an overlay is selected through the [layers control](#control-layers).
// @event overlayremove: LayersControlEvent
// Fired when an overlay is deselected through the [layers control](#control-layers).
// @namespace Control.Layers
t&&this._map.fire(t,e)},
// IE7 bugs out if you create a radio dynamically, so you have to do it this hacky way (see http://bit.ly/PqYLBe)
_createRadioElement:function(t,e){t='<input type="radio" class="leaflet-control-layers-selector" name="'+t+'"'+(e?' checked="checked"':"")+"/>",e=document.createElement("div");return e.innerHTML=t,e.firstChild},_addItem:function(t){var e,i=document.createElement("label"),n=this._map.hasLayer(t.layer);t.overlay?((e=document.createElement("input")).type="checkbox",e.className="leaflet-control-layers-selector",e.defaultChecked=n):e=this._createRadioElement("leaflet-base-layers_"+m(this),n),this._layerControlInputs.push(e),e.layerId=m(t.layer),Le(e,"click",this._onInputClick,this);var o=document.createElement("span");o.innerHTML=" "+t.name;// Helps from preventing layer control flicker when checkboxes are disabled
// https://github.com/Leaflet/Leaflet/issues/2771
n=document.createElement("div");return i.appendChild(n),n.appendChild(e),n.appendChild(o),(t.overlay?this._overlaysList:this._baseLayersList).appendChild(i),this._checkDisabledLayers(),i},_onInputClick:function(){var t,e,i=this._layerControlInputs,n=[],o=[];this._handlingClick=!0;for(var s=i.length-1;0<=s;s--)t=i[s],e=this._getLayer(t.layerId).layer,t.checked?n.push(e):t.checked||o.push(e);// Bugfix issue 2318: Should remove all old layers before readding new ones
for(s=0;s<o.length;s++)this._map.hasLayer(o[s])&&this._map.removeLayer(o[s]);for(s=0;s<n.length;s++)this._map.hasLayer(n[s])||this._map.addLayer(n[s]);this._handlingClick=!1,this._refocusOnMap()},_checkDisabledLayers:function(){for(var t,e,i=this._layerControlInputs,n=this._map.getZoom(),o=i.length-1;0<=o;o--)t=i[o],e=this._getLayer(t.layerId).layer,t.disabled=void 0!==e.options.minZoom&&n<e.options.minZoom||void 0!==e.options.maxZoom&&n>e.options.maxZoom},_expandIfNotCollapsed:function(){return this._map&&!this.options.collapsed&&this.expand(),this},_expand:function(){
// Backward compatibility, remove me in 1.1.
return this.expand()},_collapse:function(){
// Backward compatibility, remove me in 1.1.
return this.collapse()}}),He=Fe.extend({
// @section
// @aka Control.Zoom options
options:{position:"topleft",
// @option zoomInText: String = '+'
// The text set on the 'zoom in' button.
zoomInText:"+",
// @option zoomInTitle: String = 'Zoom in'
// The title set on the 'zoom in' button.
zoomInTitle:"Zoom in",
// @option zoomOutText: String = '&#x2212;'
// The text set on the 'zoom out' button.
zoomOutText:"&#x2212;",
// @option zoomOutTitle: String = 'Zoom out'
// The title set on the 'zoom out' button.
zoomOutTitle:"Zoom out"},onAdd:function(t){var e="leaflet-control-zoom",i=$t("div",e+" leaflet-bar"),n=this.options;return this._zoomInButton=this._createButton(n.zoomInText,n.zoomInTitle,e+"-in",i,this._zoomIn),this._zoomOutButton=this._createButton(n.zoomOutText,n.zoomOutTitle,e+"-out",i,this._zoomOut),this._updateDisabled(),t.on("zoomend zoomlevelschange",this._updateDisabled,this),i},onRemove:function(t){t.off("zoomend zoomlevelschange",this._updateDisabled,this)},disable:function(){return this._disabled=!0,this._updateDisabled(),this},enable:function(){return this._disabled=!1,this._updateDisabled(),this},_zoomIn:function(t){!this._disabled&&this._map._zoom<this._map.getMaxZoom()&&this._map.zoomIn(this._map.options.zoomDelta*(t.shiftKey?3:1))},_zoomOut:function(t){!this._disabled&&this._map._zoom>this._map.getMinZoom()&&this._map.zoomOut(this._map.options.zoomDelta*(t.shiftKey?3:1))},_createButton:function(t,e,i,n,o){n=$t("a",i,n);return n.innerHTML=t,n.href="#",n.title=e,
/*
       * Will force screen readers like VoiceOver to read this as "Zoom in - button"
       */
n.setAttribute("role","button"),n.setAttribute("aria-label",e),ze(n),Le(n,"click",Ee),Le(n,"click",o,this),Le(n,"click",this._refocusOnMap,this),n},_updateDisabled:function(){var t=this._map,e="leaflet-disabled";re(this._zoomInButton,e),re(this._zoomOutButton,e),!this._disabled&&t._zoom!==t.getMinZoom()||se(this._zoomOutButton,e),!this._disabled&&t._zoom!==t.getMaxZoom()||se(this._zoomInButton,e)}});// @factory L.control.layers(baselayers?: Object, overlays?: Object, options?: Control.Layers options)
// Creates a layers control with the given layers. Base layers will be switched with radio buttons, while overlays will be switched with checkboxes. Note that all base layers should be passed in the base layers object, but only one should be added to the map during map instantiation.
// @namespace Map
// @section Control options
// @option zoomControl: Boolean = true
// Whether a [zoom control](#control-zoom) is added to the map by default.
je.mergeOptions({zoomControl:!0}),je.addInitHook(function(){this.options.zoomControl&&(
// @section Controls
// @property zoomControl: Control.Zoom
// The default zoom control (only available if the
// [`zoomControl` option](#map-zoomcontrol) was `true` when creating the map).
this.zoomControl=new He,this.addControl(this.zoomControl))});// @namespace Control.Zoom
// @factory L.control.zoom(options: Control.Zoom options)
// Creates a zoom control
var Ge=Fe.extend({
// @section
// @aka Control.Scale options
options:{position:"bottomleft",
// @option maxWidth: Number = 100
// Maximum width of the control in pixels. The width is set dynamically to show round values (e.g. 100, 200, 500).
maxWidth:100,
// @option metric: Boolean = True
// Whether to show the metric scale line (m/km).
metric:!0,
// @option imperial: Boolean = True
// Whether to show the imperial scale line (mi/ft).
imperial:!0},onAdd:function(t){var e="leaflet-control-scale",i=$t("div",e),n=this.options;return this._addScales(n,e+"-line",i),t.on(n.updateWhenIdle?"moveend":"move",this._update,this),t.whenReady(this._update,this),i},onRemove:function(t){t.off(this.options.updateWhenIdle?"moveend":"move",this._update,this)},_addScales:function(t,e,i){t.metric&&(this._mScale=$t("div",e,i)),t.imperial&&(this._iScale=$t("div",e,i))},_update:function(){var t=this._map,e=t.getSize().y/2,e=t.distance(t.containerPointToLatLng([0,e]),t.containerPointToLatLng([this.options.maxWidth,e]));this._updateScales(e)},_updateScales:function(t){this.options.metric&&t&&this._updateMetric(t),this.options.imperial&&t&&this._updateImperial(t)},_updateMetric:function(t){var e=this._getRoundNum(t),i=e<1e3?e+" m":e/1e3+" km";this._updateScale(this._mScale,i,e/t)},_updateImperial:function(t){var e,i=3.2808399*t;5280<i?(e=i/5280,t=this._getRoundNum(e),this._updateScale(this._iScale,t+" mi",t/e)):(e=this._getRoundNum(i),this._updateScale(this._iScale,e+" ft",e/i))},_updateScale:function(t,e,i){t.style.width=Math.round(this.options.maxWidth*i)+"px",t.innerHTML=e},_getRoundNum:function(t){var e=Math.pow(10,(Math.floor(t)+"").length-1),t=t/e;return e*(t=10<=t?10:5<=t?5:3<=t?3:2<=t?2:1)}}),We=Fe.extend({
// @section
// @aka Control.Attribution options
options:{position:"bottomright",
// @option prefix: String = 'Leaflet'
// The HTML text shown before the attributions. Pass `false` to disable.
prefix:'<a href="https://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>'},initialize:function(t){c(this,t),this._attributions={}},onAdd:function(t){// TODO ugly, refactor
for(var e in(t.attributionControl=this)._container=$t("div","leaflet-control-attribution"),ze(this._container),t._layers)t._layers[e].getAttribution&&this.addAttribution(t._layers[e].getAttribution());return this._update(),this._container},
// @method setPrefix(prefix: String): this
// Sets the text before the attributions.
setPrefix:function(t){return this.options.prefix=t,this._update(),this},
// @method addAttribution(text: String): this
// Adds an attribution text (e.g. `'Vector data &copy; Mapbox'`).
addAttribution:function(t){return t&&(this._attributions[t]||(this._attributions[t]=0),this._attributions[t]++,this._update()),this},
// @method removeAttribution(text: String): this
// Removes an attribution text.
removeAttribution:function(t){return t&&this._attributions[t]&&(this._attributions[t]--,this._update()),this},_update:function(){if(this._map){var t,e=[];for(t in this._attributions)this._attributions[t]&&e.push(t);var i=[];this.options.prefix&&i.push(this.options.prefix),e.length&&i.push(e.join(", ")),this._container.innerHTML=i.join(" | ")}}});
/*
   * @class Control.Scale
   * @aka L.Control.Scale
   * @inherits Control
   *
   * A simple scale control that shows the scale of the current center of screen in metric (m/km) and imperial (mi/ft) systems. Extends `Control`.
   *
   * @example
   *
   * ```js
   * L.control.scale().addTo(map);
   * ```
   */ // @namespace Map
// @section Control options
// @option attributionControl: Boolean = true
// Whether a [attribution control](#control-attribution) is added to the map by default.
je.mergeOptions({attributionControl:!0}),je.addInitHook(function(){this.options.attributionControl&&(new We).addTo(this)});Fe.Layers=Ue,Fe.Zoom=He,Fe.Scale=Ge,Fe.Attribution=We,pt.layers=function(t,e,i){return new Ue(t,e,i)},pt.zoom=function(t){return new He(t)},pt.scale=function(t){return new Ge(t)},pt.attribution=function(t){return new We(t)};
/*
  	L.Handler is a base class for handler classes that are used internally to inject
  	interaction features like dragging to classes like Map and Marker.
  */
// @class Handler
// @aka L.Handler
// Abstract class for map interaction handlers
mt=z.extend({initialize:function(t){this._map=t},
// @method enable(): this
// Enables the handler
enable:function(){return this._enabled||(this._enabled=!0,this.addHooks()),this},
// @method disable(): this
// Disables the handler
disable:function(){return this._enabled&&(this._enabled=!1,this.removeHooks()),this},
// @method enabled(): Boolean
// Returns `true` if the handler is enabled
enabled:function(){return!!this._enabled}// @section Extension methods
// Classes inheriting from `Handler` must implement the two following methods:
// @method addHooks()
// Called when the handler is enabled, should add event hooks.
// @method removeHooks()
// Called when the handler is disabled, should remove the event hooks added previously.
});// @section There is static function which can be called without instantiating L.Handler:
// @function addTo(map: Map, name: String): this
// Adds a new Handler to the given map with the given name.
mt.addTo=function(t,e){return t.addHandler(e,this),this};var Ve,gt={Events:S},qe=Lt?"touchstart mousedown":"mousedown",Ke={mousedown:"mouseup",touchstart:"touchend",pointerdown:"touchend",MSPointerDown:"touchend"},Ye={mousedown:"mousemove",touchstart:"touchmove",pointerdown:"touchmove",MSPointerDown:"touchmove"},Xe=E.extend({options:{
// @section
// @aka Draggable options
// @option clickTolerance: Number = 3
// The max number of pixels a user can shift the mouse pointer during a click
// for it to be considered a valid click (as opposed to a mouse drag).
clickTolerance:3},
// @constructor L.Draggable(el: HTMLElement, dragHandle?: HTMLElement, preventOutline?: Boolean, options?: Draggable options)
// Creates a `Draggable` object for moving `el` when you start dragging the `dragHandle` element (equals `el` itself by default).
initialize:function(t,e,i,n){c(this,n),this._element=t,this._dragStartTarget=e||t,this._preventOutline=i},
// @method enable()
// Enables the dragging ability
enable:function(){this._enabled||(Le(this._dragStartTarget,qe,this._onDown,this),this._enabled=!0)},
// @method disable()
// Disables the dragging ability
disable:function(){this._enabled&&(// If we're currently dragging this draggable,
// disabling it counts as first ending the drag.
Xe._dragging===this&&this.finishDrag(),we(this._dragStartTarget,qe,this._onDown,this),this._enabled=!1,this._moved=!1)},_onDown:function(t){
// Ignore simulated events, since we handle both touch and
// mouse explicitly; otherwise we risk getting duplicates of
// touch events, see #4315.
// Also ignore the event if disabled; this happens in IE11
// under some circumstances, see #3666.
var e,i;!t._simulated&&this._enabled&&(this._moved=!1,oe(this._element,"leaflet-zoom-anim")||Xe._dragging||t.shiftKey||1!==t.which&&1!==t.button&&!t.touches||(// Prevent dragging multiple objects at once.
(Xe._dragging=this)._preventOutline&&fe(this._element),pe(),Gt(),this._moving||(// @event down: Event
// Fired when a drag is about to start.
this.fire("down"),e=t.touches?t.touches[0]:t,i=ve(this._element),this._startPoint=new Z(e.clientX,e.clientY),// Cache the scale, so that we can continuously compensate for it during drag (_onMove).
this._parentScale=ye(i),Le(document,Ye[t.type],this._onMove,this),Le(document,Ke[t.type],this._onUp,this))))},_onMove:function(t){
// Ignore simulated events, since we handle both touch and
// mouse explicitly; otherwise we risk getting duplicates of
// touch events, see #4315.
// Also ignore the event if disabled; this happens in IE11
// under some circumstances, see #3666.
var e;!t._simulated&&this._enabled&&(t.touches&&1<t.touches.length?this._moved=!0:((e=new Z((e=t.touches&&1===t.touches.length?t.touches[0]:t).clientX,e.clientY)._subtract(this._startPoint)).x||e.y)&&(Math.abs(e.x)+Math.abs(e.y)<this.options.clickTolerance||(// We assume that the parent container's position, border and scale do not change for the duration of the drag.
// Therefore there is no need to account for the position and border (they are eliminated by the subtraction)
// and we can use the cached value for the scale.
e.x/=this._parentScale.x,e.y/=this._parentScale.y,Se(t),this._moved||(
// @event dragstart: Event
// Fired when a drag starts
this.fire("dragstart"),this._moved=!0,this._startPos=de(this._element).subtract(e),se(document.body,"leaflet-dragging"),this._lastTarget=t.target||t.srcElement,// IE and Edge do not give the <use> element, so fetch it
// if necessary
window.SVGElementInstance&&this._lastTarget instanceof window.SVGElementInstance&&(this._lastTarget=this._lastTarget.correspondingUseElement),se(this._lastTarget,"leaflet-drag-target")),this._newPos=this._startPos.add(e),this._moving=!0,T(this._animRequest),this._lastEvent=t,this._animRequest=M(this._updatePosition,this,!0))))},_updatePosition:function(){var t={originalEvent:this._lastEvent};// @event predrag: Event
// Fired continuously during dragging *before* each corresponding
// update of the element's position.
this.fire("predrag",t),_e(this._element,this._newPos),// @event drag: Event
// Fired continuously during dragging.
this.fire("drag",t)},_onUp:function(t){
// Ignore simulated events, since we handle both touch and
// mouse explicitly; otherwise we risk getting duplicates of
// touch events, see #4315.
// Also ignore the event if disabled; this happens in IE11
// under some circumstances, see #3666.
!t._simulated&&this._enabled&&this.finishDrag()},finishDrag:function(){for(var t in re(document.body,"leaflet-dragging"),this._lastTarget&&(re(this._lastTarget,"leaflet-drag-target"),this._lastTarget=null),Ye)we(document,Ye[t],this._onMove,this),we(document,Ke[t],this._onUp,this);me(),Wt(),this._moved&&this._moving&&(
// ensure drag is not fired after dragend
T(this._animRequest),// @event dragend: DragEndEvent
// Fired when the drag ends.
this.fire("dragend",{distance:this._newPos.distanceTo(this._startPos)})),this._moving=!1,Xe._dragging=!1}});
/*
   * @class Draggable
   * @aka L.Draggable
   * @inherits Evented
   *
   * A class for making DOM elements draggable (including touch support).
   * Used internally for map and marker dragging. Only works for elements
   * that were positioned with [`L.DomUtil.setPosition`](#domutil-setposition).
   *
   * @example
   * ```js
   * var draggable = new L.Draggable(elementToDrag);
   * draggable.enable();
   * ```
   */
/*
   * @namespace LineUtil
   *
   * Various utility functions for polyline points processing, used by Leaflet internally to make polylines lightning-fast.
   */
// Simplify polyline with vertex reduction and Douglas-Peucker simplification.
// Improves rendering performance dramatically by lessening the number of points to draw.
// @function simplify(points: Point[], tolerance: Number): Point[]
// Dramatically reduces the number of points in a polyline while retaining
// its shape and returns a new array of simplified points, using the
// [Douglas-Peucker algorithm](http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm).
// Used for a huge performance boost when processing/displaying Leaflet polylines for
// each zoom level and also reducing visual noise. tolerance affects the amount of
// simplification (lesser value means higher quality but slower and with more points).
// Also released as a separated micro-library [Simplify.js](http://mourner.github.com/simplify-js/).
function Je(t,e){if(!e||!t.length)return t.slice();e*=e;// stage 1: vertex reduction
// stage 2: Douglas-Peucker simplification
return t=// Douglas-Peucker simplification, see http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm
function(t,e){var i=t.length,n=new(("undefined"==typeof Uint8Array?"undefined":_typeof(Uint8Array))!==void 0+""?Uint8Array:Array)(i);n[0]=n[i-1]=1,function t(e,i,n,o,s){var r,a,h,l=0;for(a=o+1;a<=s-1;a++)h=ii(e[a],e[o],e[s],!0),l<h&&(r=a,l=h);n<l&&(i[r]=1,t(e,i,n,o,r),t(e,i,n,r,s))}// reduce points that are too close to each other to a single point
(t,n,e,0,i-1);var o,s=[];for(o=0;o<i;o++)n[o]&&s.push(t[o]);return s}(t=function(t,e){for(var i=[t[0]],n=1,o=0,s=t.length;n<s;n++)(// square distance (to avoid unnecessary Math.sqrt calls)
function(t,e){var i=e.x-t.x,t=e.y-t.y;return i*i+t*t}// return closest point on segment or distance to that point
)(t[n],t[o])>e&&(i.push(t[n]),o=n);o<s-1&&i.push(t[s-1]);return i}(t,e),e)}// @function pointToSegmentDistance(p: Point, p1: Point, p2: Point): Number
// Returns the distance between point `p` and segment `p1` to `p2`.
function Qe(t,e,i){return Math.sqrt(ii(t,e,i,!0))}// @function closestPointOnSegment(p: Point, p1: Point, p2: Point): Number
// Returns the closest point from a point `p` on a segment `p1` to `p2`.
// @function clipSegment(a: Point, b: Point, bounds: Bounds, useLastCode?: Boolean, round?: Boolean): Point[]|Boolean
// Clips the segment a to b by rectangular bounds with the
// [Cohen-Sutherland algorithm](https://en.wikipedia.org/wiki/Cohen%E2%80%93Sutherland_algorithm)
// (modifying the segment points directly!). Used by Leaflet to only show polyline
// points that are on the screen or near, increasing performance.
function $e(t,e,i,n,o){var s,r,a,h=n?Ve:ei(t,i),l=ei(e,i);// save 2nd code to avoid calculating it on the next segment
for(Ve=l;;){
// if a,b is inside the clip window (trivial accept)
if(!(h|l))return[t,e];// if a,b is outside the clip window (trivial reject)
if(h&l)return!1;// other cases
a=ei(r=ti(t,e,s=h||l,i,o),i),s===h?(t=r,h=a):(e=r,l=a)}}function ti(t,e,i,n,o){var s,r,a=e.x-t.x,h=e.y-t.y,e=n.min,n=n.max;return 8&i?(
// top
s=t.x+a*(n.y-t.y)/h,r=n.y):4&i?(
// bottom
s=t.x+a*(e.y-t.y)/h,r=e.y):2&i?(
// right
s=n.x,r=t.y+h*(n.x-t.x)/a):1&i&&(
// left
s=e.x,r=t.y+h*(e.x-t.x)/a),new Z(s,r,o)}function ei(t,e){var i=0;return t.x<e.min.x?
// left
i|=1:t.x>e.max.x&&(
// right
i|=2),t.y<e.min.y?
// bottom
i|=4:t.y>e.max.y&&(
// top
i|=8),i}function ii(t,e,i,n){var o=e.x,s=e.y,r=i.x-o,a=i.y-s,e=r*r+a*a;return 0<e&&(1<(e=((t.x-o)*r+(t.y-s)*a)/e)?(o=i.x,s=i.y):0<e&&(o+=r*e,s+=a*e)),r=t.x-o,a=t.y-s,n?r*r+a*a:new Z(o,s)}// @function isFlat(latlngs: LatLng[]): Boolean
// Returns true if `latlngs` is a flat array, false is nested.
function ni(t){return!g(t[0])||"object"!==_typeof(t[0][0])&&void 0!==t[0][0]}function oi(t){return console.warn("Deprecated use of _flat, please use L.LineUtil.isFlat instead."),ni(t)}vt={simplify:Je,pointToSegmentDistance:Qe,closestPointOnSegment:function(t,e,i){return ii(t,e,i)},clipSegment:$e,_getEdgeIntersection:ti,_getBitCode:ei,_sqClosestPointOnSegment:ii,isFlat:ni,_flat:oi};
/*
   * @namespace PolyUtil
   * Various utility functions for polygon geometries.
   */
/* @function clipPolygon(points: Point[], bounds: Bounds, round?: Boolean): Point[]
   * Clips the polygon geometry defined by the given `points` by the given bounds (using the [Sutherland-Hodgman algorithm](https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm)).
   * Used by Leaflet to only show polygon points that are on the screen or near, increasing
   * performance. Note that polygon points needs different algorithm for clipping
   * than polyline, so there's a separate method for it.
   */function si(t,e,i){for(var n,o,s,r,a,h,l,u=[1,4,2,8],c=0,_=t.length;c<_;c++)t[c]._code=ei(t[c],e);// for each edge (left, bottom, right, top)
for(s=0;s<4;s++){for(h=u[s],n=[],c=0,o=(_=t.length)-1;c<_;o=c++)r=t[c],a=t[o],// if a is inside the clip window
r._code&h?a._code&h||((l=ti(a,r,h,e,i))._code=ei(l,e),n.push(l)):(
// if b is outside the clip window (a->b goes out of screen)
a._code&h&&((l=ti(a,r,h,e,i))._code=ei(l,e),n.push(l)),n.push(r));t=n}return t}var J={clipPolygon:si},ot={project:function(t){return new Z(t.lng,t.lat)},unproject:function(t){return new N(t.y,t.x)},bounds:new O([-180,-90],[180,90])},_t={R:6378137,R_MINOR:6356752.314245179,bounds:new O([-20037508.34279,-15496570.73972],[20037508.34279,18764656.23138]),project:function(t){var e=Math.PI/180,i=this.R,n=t.lat*e,o=this.R_MINOR/i,s=Math.sqrt(1-o*o),o=s*Math.sin(n),s=Math.tan(Math.PI/4-n/2)/Math.pow((1-o)/(1+o),s/2),n=-i*Math.log(Math.max(s,1e-10));return new Z(t.lng*e*i,n)},unproject:function(t){for(var e,i=180/Math.PI,n=this.R,o=this.R_MINOR/n,s=Math.sqrt(1-o*o),r=Math.exp(-t.y/n),a=Math.PI/2-2*Math.atan(r),h=0,l=.1;h<15&&1e-7<Math.abs(l);h++)e=s*Math.sin(a),e=Math.pow((1-e)/(1+e),s/2),a+=l=Math.PI/2-2*Math.atan(r*e)-a;return new N(a*i,t.x*i/n)}},at={LonLat:ot,Mercator:_t,SphericalMercator:G},S=h({},U,{code:"EPSG:3395",projection:_t,transformation:V(ht=.5/(Math.PI*_t.R),.5,-ht,.5)}),ri=h({},U,{code:"EPSG:4326",projection:ot,transformation:V(1/180,1,-1/180,.5)}),G=h({},F,{projection:ot,transformation:V(1,0,-1,0),scale:function(t){return Math.pow(2,t)},zoom:function(t){return Math.log(t)/Math.LN2},distance:function(t,e){var i=e.lng-t.lng,t=e.lat-t.lat;return Math.sqrt(i*i+t*t)},infinite:!0});
/*
   * @namespace Projection
   * @section
   * Leaflet comes with a set of already defined Projections out of the box:
   *
   * @projection L.Projection.LonLat
   *
   * Equirectangular, or Plate Carree projection — the most simple projection,
   * mostly used by GIS enthusiasts. Directly maps `x` as longitude, and `y` as
   * latitude. Also suitable for flat worlds, e.g. game maps. Used by the
   * `EPSG:4326` and `Simple` CRS.
   */F.Earth=U,F.EPSG3395=S,F.EPSG3857=q,F.EPSG900913=K,F.EPSG4326=ri,F.Simple=G;
/*
   * @class Layer
   * @inherits Evented
   * @aka L.Layer
   * @aka ILayer
   *
   * A set of methods from the Layer base class that all Leaflet layers use.
   * Inherits all methods, options and events from `L.Evented`.
   *
   * @example
   *
   * ```js
   * var layer = L.marker(latlng).addTo(map);
   * layer.addTo(map);
   * layer.remove();
   * ```
   *
   * @event add: Event
   * Fired after the layer is added to a map
   *
   * @event remove: Event
   * Fired after the layer is removed from a map
   */
var ai=E.extend({
// Classes extending `L.Layer` will inherit the following options:
options:{
// @option pane: String = 'overlayPane'
// By default the layer will be added to the map's [overlay pane](#map-overlaypane). Overriding this option will cause the layer to be placed on another pane by default.
pane:"overlayPane",
// @option attribution: String = null
// String to be shown in the attribution control, e.g. "© OpenStreetMap contributors". It describes the layer data and is often a legal obligation towards copyright holders and tile providers.
attribution:null,bubblingMouseEvents:!0},
/* @section
     * Classes extending `L.Layer` will inherit the following methods:
     *
     * @method addTo(map: Map|LayerGroup): this
     * Adds the layer to the given map or layer group.
     */
addTo:function(t){return t.addLayer(this),this},
// @method remove: this
// Removes the layer from the map it is currently active on.
remove:function(){return this.removeFrom(this._map||this._mapToAdd)},
// @method removeFrom(map: Map): this
// Removes the layer from the given map
//
// @alternative
// @method removeFrom(group: LayerGroup): this
// Removes the layer from the given `LayerGroup`
removeFrom:function(t){return t&&t.removeLayer(this),this},
// @method getPane(name? : String): HTMLElement
// Returns the `HTMLElement` representing the named pane on the map. If `name` is omitted, returns the pane for this layer.
getPane:function(t){return this._map.getPane(t?this.options[t]||t:this.options.pane)},addInteractiveTarget:function(t){return this._map._targets[m(t)]=this},removeInteractiveTarget:function(t){return delete this._map._targets[m(t)],this},
// @method getAttribution: String
// Used by the `attribution control`, returns the [attribution option](#gridlayer-attribution).
getAttribution:function(){return this.options.attribution},_layerAdd:function(t){var e,i=t.target;// check in case layer gets added and then removed before the map is ready
i.hasLayer(this)&&(this._map=i,this._zoomAnimated=i._zoomAnimated,this.getEvents&&(e=this.getEvents(),i.on(e,this),this.once("remove",function(){i.off(e,this)},this)),this.onAdd(i),this.getAttribution&&i.attributionControl&&i.attributionControl.addAttribution(this.getAttribution()),this.fire("add"),i.fire("layeradd",{layer:this}))}});
/* @section Extension methods
   * @uninheritable
   *
   * Every layer should extend from `L.Layer` and (re-)implement the following methods.
   *
   * @method onAdd(map: Map): this
   * Should contain code that creates DOM elements for the layer, adds them to `map panes` where they should belong and puts listeners on relevant map events. Called on [`map.addLayer(layer)`](#map-addlayer).
   *
   * @method onRemove(map: Map): this
   * Should contain all clean up code that removes the layer's elements from the DOM and removes listeners previously added in [`onAdd`](#layer-onadd). Called on [`map.removeLayer(layer)`](#map-removelayer).
   *
   * @method getEvents(): Object
   * This optional method should return an object like `{ viewreset: this._reset }` for [`addEventListener`](#evented-addeventlistener). The event handlers in this object will be automatically added and removed from the map with your layer.
   *
   * @method getAttribution(): String
   * This optional method should return a string containing HTML to be shown on the `Attribution control` whenever the layer is visible.
   *
   * @method beforeAdd(map: Map): this
   * Optional method. Called on [`map.addLayer(layer)`](#map-addlayer), before the layer is added to the map, before events are initialized, without waiting until the map is in a usable state. Use for early initialization only.
   */
/* @namespace Map
   * @section Layer events
   *
   * @event layeradd: LayerEvent
   * Fired when a new layer is added to the map.
   *
   * @event layerremove: LayerEvent
   * Fired when some layer is removed from the map
   *
   * @section Methods for Layers and Controls
   */je.include({
// @method addLayer(layer: Layer): this
// Adds the given layer to the map
addLayer:function(t){if(!t._layerAdd)throw new Error("The provided object is not a Layer.");var e=m(t);return this._layers[e]||((this._layers[e]=t)._mapToAdd=this,t.beforeAdd&&t.beforeAdd(this),this.whenReady(t._layerAdd,t)),this},
// @method removeLayer(layer: Layer): this
// Removes the given layer from the map.
removeLayer:function(t){var e=m(t);return this._layers[e]&&(this._loaded&&t.onRemove(this),t.getAttribution&&this.attributionControl&&this.attributionControl.removeAttribution(t.getAttribution()),delete this._layers[e],this._loaded&&(this.fire("layerremove",{layer:t}),t.fire("remove")),t._map=t._mapToAdd=null),this},
// @method hasLayer(layer: Layer): Boolean
// Returns `true` if the given layer is currently added to the map
hasLayer:function(t){return!!t&&m(t)in this._layers},
/* @method eachLayer(fn: Function, context?: Object): this
     * Iterates over the layers of the map, optionally specifying context of the iterator function.
     * ```
     * map.eachLayer(function(layer){
     *     layer.bindPopup('Hello');
     * });
     * ```
     */
eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},_addLayers:function(t){for(var e=0,i=(t=t?g(t)?t:[t]:[]).length;e<i;e++)this.addLayer(t[e])},_addZoomLimit:function(t){!isNaN(t.options.maxZoom)&&isNaN(t.options.minZoom)||(this._zoomBoundLayers[m(t)]=t,this._updateZoomLevels())},_removeZoomLimit:function(t){t=m(t);this._zoomBoundLayers[t]&&(delete this._zoomBoundLayers[t],this._updateZoomLevels())},_updateZoomLevels:function(){var t,e=1/0,i=-1/0,n=this._getZoomSpan();for(t in this._zoomBoundLayers)var o=this._zoomBoundLayers[t].options,e=void 0===o.minZoom?e:Math.min(e,o.minZoom),i=void 0===o.maxZoom?i:Math.max(i,o.maxZoom);this._layersMaxZoom=i===-1/0?void 0:i,this._layersMinZoom=e===1/0?void 0:e,// @section Map state change events
// @event zoomlevelschange: Event
// Fired when the number of zoomlevels on the map is changed due
// to adding or removing a layer.
n!==this._getZoomSpan()&&this.fire("zoomlevelschange"),void 0===this.options.maxZoom&&this._layersMaxZoom&&this.getZoom()>this._layersMaxZoom&&this.setZoom(this._layersMaxZoom),void 0===this.options.minZoom&&this._layersMinZoom&&this.getZoom()<this._layersMinZoom&&this.setZoom(this._layersMinZoom)}});
/*
   * @class LayerGroup
   * @aka L.LayerGroup
   * @inherits Layer
   *
   * Used to group several layers and handle them as one. If you add it to the map,
   * any layers added or removed from the group will be added/removed on the map as
   * well. Extends `Layer`.
   *
   * @example
   *
   * ```js
   * L.layerGroup([marker1, marker2])
   * 	.addLayer(polyline)
   * 	.addTo(map);
   * ```
   */
var hi=ai.extend({initialize:function(t,e){var i,n;if(c(this,e),this._layers={},t)for(i=0,n=t.length;i<n;i++)this.addLayer(t[i])},
// @method addLayer(layer: Layer): this
// Adds the given layer to the group.
addLayer:function(t){var e=this.getLayerId(t);return this._layers[e]=t,this._map&&this._map.addLayer(t),this},
// @method removeLayer(layer: Layer): this
// Removes the given layer from the group.
// @alternative
// @method removeLayer(id: Number): this
// Removes the layer with the given internal ID from the group.
removeLayer:function(t){t=t in this._layers?t:this.getLayerId(t);return this._map&&this._layers[t]&&this._map.removeLayer(this._layers[t]),delete this._layers[t],this},
// @method hasLayer(layer: Layer): Boolean
// Returns `true` if the given layer is currently added to the group.
// @alternative
// @method hasLayer(id: Number): Boolean
// Returns `true` if the given internal ID is currently added to the group.
hasLayer:function(t){return!!t&&("number"==typeof t?t:this.getLayerId(t))in this._layers},
// @method clearLayers(): this
// Removes all the layers from the group.
clearLayers:function(){return this.eachLayer(this.removeLayer,this)},
// @method invoke(methodName: String, …): this
// Calls `methodName` on every layer contained in this group, passing any
// additional parameters. Has no effect if the layers contained do not
// implement `methodName`.
invoke:function(t){var e,i,n=Array.prototype.slice.call(arguments,1);for(e in this._layers)(i=this._layers[e])[t]&&i[t].apply(i,n);return this},onAdd:function(t){this.eachLayer(t.addLayer,t)},onRemove:function(t){this.eachLayer(t.removeLayer,t)},
// @method eachLayer(fn: Function, context?: Object): this
// Iterates over the layers of the group, optionally specifying context of the iterator function.
// ```js
// group.eachLayer(function (layer) {
// 	layer.bindPopup('Hello');
// });
// ```
eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},
// @method getLayer(id: Number): Layer
// Returns the layer with the given internal ID.
getLayer:function(t){return this._layers[t]},
// @method getLayers(): Layer[]
// Returns an array of all the layers added to the group.
getLayers:function(){var t=[];return this.eachLayer(t.push,t),t},
// @method setZIndex(zIndex: Number): this
// Calls `setZIndex` on every layer contained in this group, passing the z-index.
setZIndex:function(t){return this.invoke("setZIndex",t)},
// @method getLayerId(layer: Layer): Number
// Returns the internal ID for a layer
getLayerId:m}),li=hi.extend({addLayer:function(t){return this.hasLayer(t)?this:(t.addEventParent(this),hi.prototype.addLayer.call(this,t),this.fire("layeradd",{layer:t}))},removeLayer:function(t){return this.hasLayer(t)?(t in this._layers&&(t=this._layers[t]),t.removeEventParent(this),hi.prototype.removeLayer.call(this,t),this.fire("layerremove",{layer:t})):this},
// @method setStyle(style: Path options): this
// Sets the given path options to each layer of the group that has a `setStyle` method.
setStyle:function(t){return this.invoke("setStyle",t)},
// @method bringToFront(): this
// Brings the layer group to the top of all other layers
bringToFront:function(){return this.invoke("bringToFront")},
// @method bringToBack(): this
// Brings the layer group to the back of all other layers
bringToBack:function(){return this.invoke("bringToBack")},
// @method getBounds(): LatLngBounds
// Returns the LatLngBounds of the Feature Group (created from bounds and coordinates of its children).
getBounds:function(){var t,e=new D;for(t in this._layers){var i=this._layers[t];e.extend(i.getBounds?i.getBounds():i.getLatLng())}return e}}),ui=z.extend({
/* @section
     * @aka Icon options
     *
     * @option iconUrl: String = null
     * **(required)** The URL to the icon image (absolute or relative to your script path).
     *
     * @option iconRetinaUrl: String = null
     * The URL to a retina sized version of the icon image (absolute or relative to your
     * script path). Used for Retina screen devices.
     *
     * @option iconSize: Point = null
     * Size of the icon image in pixels.
     *
     * @option iconAnchor: Point = null
     * The coordinates of the "tip" of the icon (relative to its top left corner). The icon
     * will be aligned so that this point is at the marker's geographical location. Centered
     * by default if size is specified, also can be set in CSS with negative margins.
     *
     * @option popupAnchor: Point = [0, 0]
     * The coordinates of the point from which popups will "open", relative to the icon anchor.
     *
     * @option tooltipAnchor: Point = [0, 0]
     * The coordinates of the point from which tooltips will "open", relative to the icon anchor.
     *
     * @option shadowUrl: String = null
     * The URL to the icon shadow image. If not specified, no shadow image will be created.
     *
     * @option shadowRetinaUrl: String = null
     *
     * @option shadowSize: Point = null
     * Size of the shadow image in pixels.
     *
     * @option shadowAnchor: Point = null
     * The coordinates of the "tip" of the shadow (relative to its top left corner) (the same
     * as iconAnchor if not specified).
     *
     * @option className: String = ''
     * A custom class name to assign to both icon and shadow images. Empty by default.
     */
options:{popupAnchor:[0,0],tooltipAnchor:[0,0]},initialize:function(t){c(this,t)},
// @method createIcon(oldIcon?: HTMLElement): HTMLElement
// Called internally when the icon has to be shown, returns a `<img>` HTML element
// styled according to the options.
createIcon:function(t){return this._createIcon("icon",t)},
// @method createShadow(oldIcon?: HTMLElement): HTMLElement
// As `createIcon`, but for the shadow beneath it.
createShadow:function(t){return this._createIcon("shadow",t)},_createIcon:function(t,e){var i=this._getIconUrl(t);if(!i){if("icon"===t)throw new Error("iconUrl not set in Icon options (see the docs).");return null}e=this._createImg(i,e&&"IMG"===e.tagName?e:null);return this._setIconStyles(e,t),e},_setIconStyles:function(t,e){var i=this.options,n=i[e+"Size"];"number"==typeof n&&(n=[n,n]);var o=B(n),n=B("shadow"===e&&i.shadowAnchor||i.iconAnchor||o&&o.divideBy(2,!0));t.className="leaflet-marker-"+e+" "+(i.className||""),n&&(t.style.marginLeft=-n.x+"px",t.style.marginTop=-n.y+"px"),o&&(t.style.width=o.x+"px",t.style.height=o.y+"px")},_createImg:function(t,e){return(e=e||document.createElement("img")).src=t,e},_getIconUrl:function(t){return wt&&this.options[t+"RetinaUrl"]||this.options[t+"Url"]}});// @factory L.layerGroup(layers?: Layer[], options?: Object)
// Create a layer group, optionally given an initial set of layers and an `options` object.
/*
   * @miniclass Icon.Default (Icon)
   * @aka L.Icon.Default
   * @section
   *
   * A trivial subclass of `Icon`, represents the icon to use in `Marker`s when
   * no icon is specified. Points to the blue marker image distributed with Leaflet
   * releases.
   *
   * In order to customize the default icon, just change the properties of `L.Icon.Default.prototype.options`
   * (which is a set of `Icon options`).
   *
   * If you want to _completely_ replace the default icon, override the
   * `L.Marker.prototype.options.icon` with your own icon instead.
   */
var ci=ui.extend({options:{iconUrl:"marker-icon.png",iconRetinaUrl:"marker-icon-2x.png",shadowUrl:"marker-shadow.png",iconSize:[25,41],iconAnchor:[12,41],popupAnchor:[1,-34],tooltipAnchor:[16,-28],shadowSize:[41,41]},_getIconUrl:function(t){// @option imagePath: String
// `Icon.Default` will try to auto-detect the location of the
// blue icon images. If you are placing these images in a non-standard
// way, set this option to point to the right path.
return ci.imagePath||(
// Deprecated, backwards-compatibility only
ci.imagePath=this._detectIconPath()),(this.options.imagePath||ci.imagePath)+ui.prototype._getIconUrl.call(this,t)},_detectIconPath:function(){var t=$t("div","leaflet-default-icon-path",document.body),e=Qt(t,"background-image")||Qt(t,"backgroundImage");// IE8
return document.body.removeChild(t),e=null===e||0!==e.indexOf("url")?"":e.replace(/^url\(["']?/,"").replace(/marker-icon\.png["']?\)$/,"")}}),_i=mt.extend({initialize:function(t){this._marker=t},addHooks:function(){var t=this._marker._icon;this._draggable||(this._draggable=new Xe(t,t,!0)),this._draggable.on({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).enable(),se(t,"leaflet-marker-draggable")},removeHooks:function(){this._draggable.off({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).disable(),this._marker._icon&&re(this._marker._icon,"leaflet-marker-draggable")},moved:function(){return this._draggable&&this._draggable._moved},_adjustPan:function(t){var e=this._marker,i=e._map,n=this._marker.options.autoPanSpeed,o=this._marker.options.autoPanPadding,s=de(e._icon),r=i.getPixelBounds(),a=i.getPixelOrigin(),o=I(r.min._subtract(a).add(o),r.max._subtract(a).subtract(o));o.contains(s)||(n=B((Math.max(o.max.x,s.x)-o.max.x)/(r.max.x-o.max.x)-(Math.min(o.min.x,s.x)-o.min.x)/(r.min.x-o.min.x),(Math.max(o.max.y,s.y)-o.max.y)/(r.max.y-o.max.y)-(Math.min(o.min.y,s.y)-o.min.y)/(r.min.y-o.min.y)).multiplyBy(n),i.panBy(n,{animate:!1}),this._draggable._newPos._add(n),this._draggable._startPos._add(n),_e(e._icon,this._draggable._newPos),this._onDrag(t),this._panRequest=M(this._adjustPan.bind(this,t)))},_onDragStart:function(){
// @section Dragging events
// @event dragstart: Event
// Fired when the user starts dragging the marker.
// @event movestart: Event
// Fired when the marker starts moving (because of dragging).
this._oldLatLng=this._marker.getLatLng(),// When using ES6 imports it could not be set when `Popup` was not imported as well
this._marker.closePopup&&this._marker.closePopup(),this._marker.fire("movestart").fire("dragstart")},_onPreDrag:function(t){this._marker.options.autoPan&&(T(this._panRequest),this._panRequest=M(this._adjustPan.bind(this,t)))},_onDrag:function(t){var e=this._marker,i=e._shadow,n=de(e._icon),o=e._map.layerPointToLatLng(n);// update shadow position
i&&_e(i,n),e._latlng=o,t.latlng=o,t.oldLatLng=this._oldLatLng,// @event drag: Event
// Fired repeatedly while the user drags the marker.
e.fire("move",t).fire("drag",t)},_onDragEnd:function(t){
// @event dragend: DragEndEvent
// Fired when the user stops dragging the marker.
T(this._panRequest),// @event moveend: Event
// Fired when the marker stops moving (because of dragging).
delete this._oldLatLng,this._marker.fire("moveend").fire("dragend",t)}}),di=ai.extend({
// @section
// @aka Marker options
options:{
// @option icon: Icon = *
// Icon instance to use for rendering the marker.
// See [Icon documentation](#L.Icon) for details on how to customize the marker icon.
// If not specified, a common instance of `L.Icon.Default` is used.
icon:new ci,
// Option inherited from "Interactive layer" abstract class
interactive:!0,
// @option keyboard: Boolean = true
// Whether the marker can be tabbed to with a keyboard and clicked by pressing enter.
keyboard:!0,
// @option title: String = ''
// Text for the browser tooltip that appear on marker hover (no tooltip by default).
title:"",
// @option alt: String = ''
// Text for the `alt` attribute of the icon image (useful for accessibility).
alt:"",
// @option zIndexOffset: Number = 0
// By default, marker images zIndex is set automatically based on its latitude. Use this option if you want to put the marker on top of all others (or below), specifying a high value like `1000` (or high negative value, respectively).
zIndexOffset:0,
// @option opacity: Number = 1.0
// The opacity of the marker.
opacity:1,
// @option riseOnHover: Boolean = false
// If `true`, the marker will get on top of others when you hover the mouse over it.
riseOnHover:!1,
// @option riseOffset: Number = 250
// The z-index offset used for the `riseOnHover` feature.
riseOffset:250,
// @option pane: String = 'markerPane'
// `Map pane` where the markers icon will be added.
pane:"markerPane",
// @option shadowPane: String = 'shadowPane'
// `Map pane` where the markers shadow will be added.
shadowPane:"shadowPane",
// @option bubblingMouseEvents: Boolean = false
// When `true`, a mouse event on this marker will trigger the same event on the map
// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).
bubblingMouseEvents:!1,
// @section Draggable marker options
// @option draggable: Boolean = false
// Whether the marker is draggable with mouse/touch or not.
draggable:!1,
// @option autoPan: Boolean = false
// Whether to pan the map when dragging this marker near its edge or not.
autoPan:!1,
// @option autoPanPadding: Point = Point(50, 50)
// Distance (in pixels to the left/right and to the top/bottom) of the
// map edge to start panning the map.
autoPanPadding:[50,50],
// @option autoPanSpeed: Number = 10
// Number of pixels the map should pan by.
autoPanSpeed:10},
/* @section
     *
     * In addition to [shared layer methods](#Layer) like `addTo()` and `remove()` and [popup methods](#Popup) like bindPopup() you can also use the following methods:
     */
initialize:function(t,e){c(this,e),this._latlng=j(t)},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&t.options.markerZoomAnimation,this._zoomAnimated&&t.on("zoomanim",this._animateZoom,this),this._initIcon(),this.update()},onRemove:function(t){this.dragging&&this.dragging.enabled()&&(this.options.draggable=!0,this.dragging.removeHooks()),delete this.dragging,this._zoomAnimated&&t.off("zoomanim",this._animateZoom,this),this._removeIcon(),this._removeShadow()},getEvents:function(){return{zoom:this.update,viewreset:this.update}},
// @method getLatLng: LatLng
// Returns the current geographical position of the marker.
getLatLng:function(){return this._latlng},
// @method setLatLng(latlng: LatLng): this
// Changes the marker position to the given point.
setLatLng:function(t){var e=this._latlng;// @event move: Event
// Fired when the marker is moved via [`setLatLng`](#marker-setlatlng) or by [dragging](#marker-dragging). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.
return this._latlng=j(t),this.update(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},
// @method setZIndexOffset(offset: Number): this
// Changes the [zIndex offset](#marker-zindexoffset) of the marker.
setZIndexOffset:function(t){return this.options.zIndexOffset=t,this.update()},
// @method getIcon: Icon
// Returns the current icon used by the marker
getIcon:function(){return this.options.icon},
// @method setIcon(icon: Icon): this
// Changes the marker icon.
setIcon:function(t){return this.options.icon=t,this._map&&(this._initIcon(),this.update()),this._popup&&this.bindPopup(this._popup,this._popup.options),this},getElement:function(){return this._icon},update:function(){var t;return this._icon&&this._map&&(t=this._map.latLngToLayerPoint(this._latlng).round(),this._setPos(t)),this},_initIcon:function(){var t=this.options,e="leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"),i=t.icon.createIcon(this._icon),n=!1;// if we're not reusing the icon, remove the old one and init new one
i!==this._icon&&(this._icon&&this._removeIcon(),n=!0,t.title&&(i.title=t.title),"IMG"===i.tagName&&(i.alt=t.alt||"")),se(i,e),t.keyboard&&(i.tabIndex="0"),this._icon=i,t.riseOnHover&&this.on({mouseover:this._bringToFront,mouseout:this._resetZIndex});var o=t.icon.createShadow(this._shadow),i=!1;o!==this._shadow&&(this._removeShadow(),i=!0),o&&(se(o,e),o.alt=""),this._shadow=o,t.opacity<1&&this._updateOpacity(),n&&this.getPane().appendChild(this._icon),this._initInteraction(),o&&i&&this.getPane(t.shadowPane).appendChild(this._shadow)},_removeIcon:function(){this.options.riseOnHover&&this.off({mouseover:this._bringToFront,mouseout:this._resetZIndex}),te(this._icon),this.removeInteractiveTarget(this._icon),this._icon=null},_removeShadow:function(){this._shadow&&te(this._shadow),this._shadow=null},_setPos:function(t){this._icon&&_e(this._icon,t),this._shadow&&_e(this._shadow,t),this._zIndex=t.y+this.options.zIndexOffset,this._resetZIndex()},_updateZIndex:function(t){this._icon&&(this._icon.style.zIndex=this._zIndex+t)},_animateZoom:function(t){t=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center).round();this._setPos(t)},_initInteraction:function(){var t;this.options.interactive&&(se(this._icon,"leaflet-interactive"),this.addInteractiveTarget(this._icon),_i&&(t=this.options.draggable,this.dragging&&(t=this.dragging.enabled(),this.dragging.disable()),this.dragging=new _i(this),t&&this.dragging.enable()))},
// @method setOpacity(opacity: Number): this
// Changes the opacity of the marker.
setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},_updateOpacity:function(){var t=this.options.opacity;this._icon&&le(this._icon,t),this._shadow&&le(this._shadow,t)},_bringToFront:function(){this._updateZIndex(this.options.riseOffset)},_resetZIndex:function(){this._updateZIndex(0)},_getPopupAnchor:function(){return this.options.icon.options.popupAnchor},_getTooltipAnchor:function(){return this.options.icon.options.tooltipAnchor}});
/*
   * L.Handler.MarkerDrag is used internally by L.Marker to make the markers draggable.
   */
/* @namespace Marker
   * @section Interaction handlers
   *
   * Interaction handlers are properties of a marker instance that allow you to control interaction behavior in runtime, enabling or disabling certain features such as dragging (see `Handler` methods). Example:
   *
   * ```js
   * marker.dragging.disable();
   * ```
   *
   * @property dragging: Handler
   * Marker dragging handler (by both mouse and touch). Only valid when the marker is on the map (Otherwise set [`marker.options.draggable`](#marker-draggable)).
   */
/*
   * @class Path
   * @aka L.Path
   * @inherits Interactive layer
   *
   * An abstract class that contains options and constants shared between vector
   * overlays (Polygon, Polyline, Circle). Do not use it directly. Extends `Layer`.
   */
var pi=ai.extend({
// @section
// @aka Path options
options:{
// @option stroke: Boolean = true
// Whether to draw stroke along the path. Set it to `false` to disable borders on polygons or circles.
stroke:!0,
// @option color: String = '#3388ff'
// Stroke color
color:"#3388ff",
// @option weight: Number = 3
// Stroke width in pixels
weight:3,
// @option opacity: Number = 1.0
// Stroke opacity
opacity:1,
// @option lineCap: String= 'round'
// A string that defines [shape to be used at the end](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linecap) of the stroke.
lineCap:"round",
// @option lineJoin: String = 'round'
// A string that defines [shape to be used at the corners](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linejoin) of the stroke.
lineJoin:"round",
// @option dashArray: String = null
// A string that defines the stroke [dash pattern](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dasharray). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).
dashArray:null,
// @option dashOffset: String = null
// A string that defines the [distance into the dash pattern to start the dash](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dashoffset). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).
dashOffset:null,
// @option fill: Boolean = depends
// Whether to fill the path with color. Set it to `false` to disable filling on polygons or circles.
fill:!1,
// @option fillColor: String = *
// Fill color. Defaults to the value of the [`color`](#path-color) option
fillColor:null,
// @option fillOpacity: Number = 0.2
// Fill opacity.
fillOpacity:.2,
// @option fillRule: String = 'evenodd'
// A string that defines [how the inside of a shape](https://developer.mozilla.org/docs/Web/SVG/Attribute/fill-rule) is determined.
fillRule:"evenodd",
// className: '',
// Option inherited from "Interactive layer" abstract class
interactive:!0,
// @option bubblingMouseEvents: Boolean = true
// When `true`, a mouse event on this path will trigger the same event on the map
// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).
bubblingMouseEvents:!0},beforeAdd:function(t){
// Renderer is set here because we need to call renderer.getEvents
// before this.getEvents.
this._renderer=t.getRenderer(this)},onAdd:function(){this._renderer._initPath(this),this._reset(),this._renderer._addPath(this)},onRemove:function(){this._renderer._removePath(this)},
// @method redraw(): this
// Redraws the layer. Sometimes useful after you changed the coordinates that the path uses.
redraw:function(){return this._map&&this._renderer._updatePath(this),this},
// @method setStyle(style: Path options): this
// Changes the appearance of a Path based on the options in the `Path options` object.
setStyle:function(t){return c(this,t),this._renderer&&(this._renderer._updateStyle(this),this.options.stroke&&t&&Object.prototype.hasOwnProperty.call(t,"weight")&&this._updateBounds()),this},
// @method bringToFront(): this
// Brings the layer to the top of all path layers.
bringToFront:function(){return this._renderer&&this._renderer._bringToFront(this),this},
// @method bringToBack(): this
// Brings the layer to the bottom of all path layers.
bringToBack:function(){return this._renderer&&this._renderer._bringToBack(this),this},getElement:function(){return this._path},_reset:function(){
// defined in child classes
this._project(),this._update()},_clickTolerance:function(){
// used when doing hit detection for Canvas layers
return(this.options.stroke?this.options.weight/2:0)+this._renderer.options.tolerance}}),mi=pi.extend({
// @section
// @aka CircleMarker options
options:{fill:!0,
// @option radius: Number = 10
// Radius of the circle marker, in pixels
radius:10},initialize:function(t,e){c(this,e),this._latlng=j(t),this._radius=this.options.radius},
// @method setLatLng(latLng: LatLng): this
// Sets the position of a circle marker to a new location.
setLatLng:function(t){var e=this._latlng;// @event move: Event
// Fired when the marker is moved via [`setLatLng`](#circlemarker-setlatlng). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.
return this._latlng=j(t),this.redraw(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},
// @method getLatLng(): LatLng
// Returns the current geographical position of the circle marker
getLatLng:function(){return this._latlng},
// @method setRadius(radius: Number): this
// Sets the radius of a circle marker. Units are in pixels.
setRadius:function(t){return this.options.radius=this._radius=t,this.redraw()},
// @method getRadius(): Number
// Returns the current radius of the circle
getRadius:function(){return this._radius},setStyle:function(t){var e=t&&t.radius||this._radius;return pi.prototype.setStyle.call(this,t),this.setRadius(e),this},_project:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._updateBounds()},_updateBounds:function(){var t=this._radius,e=this._radiusY||t,i=this._clickTolerance(),i=[t+i,e+i];this._pxBounds=new O(this._point.subtract(i),this._point.add(i))},_update:function(){this._map&&this._updatePath()},_updatePath:function(){this._renderer._updateCircle(this)},_empty:function(){return this._radius&&!this._renderer._bounds.intersects(this._pxBounds)},
// Needed by the `Canvas` renderer for interactivity
_containsPoint:function(t){return t.distanceTo(this._point)<=this._radius+this._clickTolerance()}});
/*
   * @class CircleMarker
   * @aka L.CircleMarker
   * @inherits Path
   *
   * A circle of a fixed size with radius specified in pixels. Extends `Path`.
   */
/*
   * @class Circle
   * @aka L.Circle
   * @inherits CircleMarker
   *
   * A class for drawing circle overlays on a map. Extends `CircleMarker`.
   *
   * It's an approximation and starts to diverge from a real circle closer to poles (due to projection distortion).
   *
   * @example
   *
   * ```js
   * L.circle([50.5, 30.5], {radius: 200}).addTo(map);
   * ```
   */
var fi=mi.extend({initialize:function(t,e,i){if("number"==typeof e&&(
// Backwards compatibility with 0.7.x factory (latlng, radius, options?)
e=h({},i,{radius:e})),c(this,e),this._latlng=j(t),isNaN(this.options.radius))throw new Error("Circle radius cannot be NaN");// @section
// @aka Circle options
// @option radius: Number; Radius of the circle, in meters.
this._mRadius=this.options.radius},
// @method setRadius(radius: Number): this
// Sets the radius of a circle. Units are in meters.
setRadius:function(t){return this._mRadius=t,this.redraw()},
// @method getRadius(): Number
// Returns the current radius of a circle. Units are in meters.
getRadius:function(){return this._mRadius},
// @method getBounds(): LatLngBounds
// Returns the `LatLngBounds` of the path.
getBounds:function(){var t=[this._radius,this._radiusY||this._radius];return new D(this._map.layerPointToLatLng(this._point.subtract(t)),this._map.layerPointToLatLng(this._point.add(t)))},setStyle:pi.prototype.setStyle,_project:function(){var t,e,i,n,o,s=this._latlng.lng,r=this._latlng.lat,a=this._map,h=a.options.crs;h.distance===U.distance?(o=Math.PI/180,t=this._mRadius/U.R/o,e=a.project([r+t,s]),n=a.project([r-t,s]),i=e.add(n).divideBy(2),n=a.unproject(i).lat,o=Math.acos((Math.cos(t*o)-Math.sin(r*o)*Math.sin(n*o))/(Math.cos(r*o)*Math.cos(n*o)))/o,!isNaN(o)&&0!==o||(o=t/Math.cos(Math.PI/180*r)),this._point=i.subtract(a.getPixelOrigin()),this._radius=isNaN(o)?0:i.x-a.project([n,s-o]).x,this._radiusY=i.y-e.y):(h=h.unproject(h.project(this._latlng).subtract([this._mRadius,0])),this._point=a.latLngToLayerPoint(this._latlng),this._radius=this._point.x-a.latLngToLayerPoint(h).x),this._updateBounds()}});// @factory L.circle(latlng: LatLng, options?: Circle options)
// Instantiates a circle object given a geographical point, and an options object
// which contains the circle radius.
// @alternative
// @factory L.circle(latlng: LatLng, radius: Number, options?: Circle options)
// Obsolete way of instantiating a circle, for compatibility with 0.7.x code.
// Do not use in new applications or plugins.
/*
   * @class Polyline
   * @aka L.Polyline
   * @inherits Path
   *
   * A class for drawing polyline overlays on a map. Extends `Path`.
   *
   * @example
   *
   * ```js
   * // create a red polyline from an array of LatLng points
   * var latlngs = [
   * 	[45.51, -122.68],
   * 	[37.77, -122.43],
   * 	[34.04, -118.2]
   * ];
   *
   * var polyline = L.polyline(latlngs, {color: 'red'}).addTo(map);
   *
   * // zoom the map to the polyline
   * map.fitBounds(polyline.getBounds());
   * ```
   *
   * You can also pass a multi-dimensional array to represent a `MultiPolyline` shape:
   *
   * ```js
   * // create a red polyline from an array of arrays of LatLng points
   * var latlngs = [
   * 	[[45.51, -122.68],
   * 	 [37.77, -122.43],
   * 	 [34.04, -118.2]],
   * 	[[40.78, -73.91],
   * 	 [41.83, -87.62],
   * 	 [32.76, -96.72]]
   * ];
   * ```
   */
var gi=pi.extend({
// @section
// @aka Polyline options
options:{
// @option smoothFactor: Number = 1.0
// How much to simplify the polyline on each zoom level. More means
// better performance and smoother look, and less means more accurate representation.
smoothFactor:1,
// @option noClip: Boolean = false
// Disable polyline clipping.
noClip:!1},initialize:function(t,e){c(this,e),this._setLatLngs(t)},
// @method getLatLngs(): LatLng[]
// Returns an array of the points in the path, or nested arrays of points in case of multi-polyline.
getLatLngs:function(){return this._latlngs},
// @method setLatLngs(latlngs: LatLng[]): this
// Replaces all the points in the polyline with the given array of geographical points.
setLatLngs:function(t){return this._setLatLngs(t),this.redraw()},
// @method isEmpty(): Boolean
// Returns `true` if the Polyline has no LatLngs.
isEmpty:function(){return!this._latlngs.length},
// @method closestLayerPoint(p: Point): Point
// Returns the point closest to `p` on the Polyline.
closestLayerPoint:function(t){for(var e,i,n=1/0,o=null,s=ii,r=0,a=this._parts.length;r<a;r++)for(var h=this._parts[r],l=1,u=h.length;l<u;l++){var c=s(t,e=h[l-1],i=h[l],!0);c<n&&(n=c,o=s(t,e,i))}return o&&(o.distance=Math.sqrt(n)),o},
// @method getCenter(): LatLng
// Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the polyline.
getCenter:function(){
// throws error when not yet added to map as this center calculation requires projected coordinates
if(!this._map)throw new Error("Must add layer to map before using getCenter()");var t,e,i,n,o,s,r=this._rings[0],a=r.length;if(!a)return null;// polyline centroid algorithm; only uses the first ring if there are multiple
for(e=t=0;t<a-1;t++)e+=r[t].distanceTo(r[t+1])/2;// The line is so small in the current view that all points are on the same pixel.
if(0===e)return this._map.layerPointToLatLng(r[0]);for(i=t=0;t<a-1;t++)if(n=r[t],o=r[t+1],e<(i+=s=n.distanceTo(o)))return s=(i-e)/s,this._map.layerPointToLatLng([o.x-s*(o.x-n.x),o.y-s*(o.y-n.y)])},
// @method getBounds(): LatLngBounds
// Returns the `LatLngBounds` of the path.
getBounds:function(){return this._bounds},
// @method addLatLng(latlng: LatLng, latlngs?: LatLng[]): this
// Adds a given point to the polyline. By default, adds to the first ring of
// the polyline in case of a multi-polyline, but can be overridden by passing
// a specific ring as a LatLng array (that you can earlier access with [`getLatLngs`](#polyline-getlatlngs)).
addLatLng:function(t,e){return e=e||this._defaultShape(),t=j(t),e.push(t),this._bounds.extend(t),this.redraw()},_setLatLngs:function(t){this._bounds=new D,this._latlngs=this._convertLatLngs(t)},_defaultShape:function(){return ni(this._latlngs)?this._latlngs:this._latlngs[0]},
// recursively convert latlngs input into actual LatLng instances; calculate bounds along the way
_convertLatLngs:function(t){for(var e=[],i=ni(t),n=0,o=t.length;n<o;n++)i?(e[n]=j(t[n]),this._bounds.extend(e[n])):e[n]=this._convertLatLngs(t[n]);return e},_project:function(){var t=new O;this._rings=[],this._projectLatlngs(this._latlngs,this._rings,t),this._bounds.isValid()&&t.isValid()&&(this._rawPxBounds=t,this._updateBounds())},_updateBounds:function(){var t=this._clickTolerance(),t=new Z(t,t);this._pxBounds=new O([this._rawPxBounds.min.subtract(t),this._rawPxBounds.max.add(t)])},
// recursively turns latlngs into a set of rings with projected coordinates
_projectLatlngs:function(t,e,i){var n,o,s=t[0]instanceof N,r=t.length;if(s){for(o=[],n=0;n<r;n++)o[n]=this._map.latLngToLayerPoint(t[n]),i.extend(o[n]);e.push(o)}else for(n=0;n<r;n++)this._projectLatlngs(t[n],e,i)},
// clip polyline by renderer bounds so that we have less to render for performance
_clipPoints:function(){var t=this._renderer._bounds;if(this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else for(var e,i,n,o,s=this._parts,r=0,a=0,h=this._rings.length;r<h;r++)for(e=0,i=(o=this._rings[r]).length;e<i-1;e++)(n=$e(o[e],o[e+1],t,e,!0))&&(s[a]=s[a]||[],s[a].push(n[0]),// if segment goes out of screen, or it's the last one, it's the end of the line part
n[1]===o[e+1]&&e!==i-2||(s[a].push(n[1]),a++))},
// simplify each clipped part of the polyline for performance
_simplifyPoints:function(){for(var t=this._parts,e=this.options.smoothFactor,i=0,n=t.length;i<n;i++)t[i]=Je(t[i],e)},_update:function(){this._map&&(this._clipPoints(),this._simplifyPoints(),this._updatePath())},_updatePath:function(){this._renderer._updatePoly(this)},
// Needed by the `Canvas` renderer for interactivity
_containsPoint:function(t,e){var i,n,o,s,r,a,h=this._clickTolerance();if(!this._pxBounds||!this._pxBounds.contains(t))return!1;// hit detection for polylines
for(i=0,s=this._parts.length;i<s;i++)for(n=0,o=(r=(a=this._parts[i]).length)-1;n<r;o=n++)if((e||0!==n)&&Qe(t,a[o],a[n])<=h)return!0;return!1}});// @factory L.polyline(latlngs: LatLng[], options?: Polyline options)
// Instantiates a polyline object given an array of geographical points and
// optionally an options object. You can create a `Polyline` object with
// multiple separate lines (`MultiPolyline`) by passing an array of arrays
// of geographic points.
// Retrocompat. Allow plugins to support Leaflet versions before and after 1.1.
gi._flat=oi;
/*
   * @class Polygon
   * @aka L.Polygon
   * @inherits Polyline
   *
   * A class for drawing polygon overlays on a map. Extends `Polyline`.
   *
   * Note that points you pass when creating a polygon shouldn't have an additional last point equal to the first one — it's better to filter out such points.
   *
   *
   * @example
   *
   * ```js
   * // create a red polygon from an array of LatLng points
   * var latlngs = [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]];
   *
   * var polygon = L.polygon(latlngs, {color: 'red'}).addTo(map);
   *
   * // zoom the map to the polygon
   * map.fitBounds(polygon.getBounds());
   * ```
   *
   * You can also pass an array of arrays of latlngs, with the first array representing the outer shape and the other arrays representing holes in the outer shape:
   *
   * ```js
   * var latlngs = [
   *   [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring
   *   [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole
   * ];
   * ```
   *
   * Additionally, you can pass a multi-dimensional array to represent a MultiPolygon shape.
   *
   * ```js
   * var latlngs = [
   *   [ // first polygon
   *     [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring
   *     [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole
   *   ],
   *   [ // second polygon
   *     [[41, -111.03],[45, -111.04],[45, -104.05],[41, -104.05]]
   *   ]
   * ];
   * ```
   */
var vi=gi.extend({options:{fill:!0},isEmpty:function(){return!this._latlngs.length||!this._latlngs[0].length},getCenter:function(){
// throws error when not yet added to map as this center calculation requires projected coordinates
if(!this._map)throw new Error("Must add layer to map before using getCenter()");var t,e,i,n,o,s,r,a,h,l=this._rings[0],u=l.length;if(!u)return null;// polygon centroid algorithm; only uses the first ring if there are multiple
for(t=s=r=a=0,e=u-1;t<u;e=t++)i=l[t],n=l[e],o=i.y*n.x-n.y*i.x,r+=(i.x+n.x)*o,a+=(i.y+n.y)*o,s+=3*o;
// Polygon is so small that all points are on same pixel.
return h=0===s?l[0]:[r/s,a/s],this._map.layerPointToLatLng(h)},_convertLatLngs:function(t){var e=gi.prototype._convertLatLngs.call(this,t),t=e.length;// remove last point if it equals first one
return 2<=t&&e[0]instanceof N&&e[0].equals(e[t-1])&&e.pop(),e},_setLatLngs:function(t){gi.prototype._setLatLngs.call(this,t),ni(this._latlngs)&&(this._latlngs=[this._latlngs])},_defaultShape:function(){return(ni(this._latlngs[0])?this._latlngs:this._latlngs[0])[0]},_clipPoints:function(){
// polygons need a different clipping algorithm so we redefine that
var t=this._renderer._bounds,e=this.options.weight,e=new Z(e,e),// increase clip padding by stroke width to avoid stroke on clip edges
t=new O(t.min.subtract(e),t.max.add(e));if(this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else for(var i,n=0,o=this._rings.length;n<o;n++)(i=si(this._rings[n],t,!0)).length&&this._parts.push(i)},_updatePath:function(){this._renderer._updatePoly(this,!0)},
// Needed by the `Canvas` renderer for interactivity
_containsPoint:function(t){var e,i,n,o,s,r,a,h,l=!1;if(!this._pxBounds||!this._pxBounds.contains(t))return!1;// ray casting algorithm for detecting if point is in polygon
for(o=0,a=this._parts.length;o<a;o++)for(s=0,r=(h=(e=this._parts[o]).length)-1;s<h;r=s++)i=e[s],n=e[r],i.y>t.y!=n.y>t.y&&t.x<(n.x-i.x)*(t.y-i.y)/(n.y-i.y)+i.x&&(l=!l);// also check if it's on polygon stroke
return l||gi.prototype._containsPoint.call(this,t,!0)}});// @factory L.polygon(latlngs: LatLng[], options?: Polyline options)
/*
   * @class GeoJSON
   * @aka L.GeoJSON
   * @inherits FeatureGroup
   *
   * Represents a GeoJSON object or an array of GeoJSON objects. Allows you to parse
   * GeoJSON data and display it on the map. Extends `FeatureGroup`.
   *
   * @example
   *
   * ```js
   * L.geoJSON(data, {
   * 	style: function (feature) {
   * 		return {color: feature.properties.color};
   * 	}
   * }).bindPopup(function (layer) {
   * 	return layer.feature.properties.description;
   * }).addTo(map);
   * ```
   */
var yi=li.extend({
/* @section
     * @aka GeoJSON options
     *
     * @option pointToLayer: Function = *
     * A `Function` defining how GeoJSON points spawn Leaflet layers. It is internally
     * called when data is added, passing the GeoJSON point feature and its `LatLng`.
     * The default is to spawn a default `Marker`:
     * ```js
     * function(geoJsonPoint, latlng) {
     * 	return L.marker(latlng);
     * }
     * ```
     *
     * @option style: Function = *
     * A `Function` defining the `Path options` for styling GeoJSON lines and polygons,
     * called internally when data is added.
     * The default value is to not override any defaults:
     * ```js
     * function (geoJsonFeature) {
     * 	return {}
     * }
     * ```
     *
     * @option onEachFeature: Function = *
     * A `Function` that will be called once for each created `Feature`, after it has
     * been created and styled. Useful for attaching events and popups to features.
     * The default is to do nothing with the newly created layers:
     * ```js
     * function (feature, layer) {}
     * ```
     *
     * @option filter: Function = *
     * A `Function` that will be used to decide whether to include a feature or not.
     * The default is to include all features:
     * ```js
     * function (geoJsonFeature) {
     * 	return true;
     * }
     * ```
     * Note: dynamically changing the `filter` option will have effect only on newly
     * added data. It will _not_ re-evaluate already included features.
     *
     * @option coordsToLatLng: Function = *
     * A `Function` that will be used for converting GeoJSON coordinates to `LatLng`s.
     * The default is the `coordsToLatLng` static method.
     *
     * @option markersInheritOptions: Boolean = false
     * Whether default Markers for "Point" type Features inherit from group options.
     */
initialize:function(t,e){c(this,e),this._layers={},t&&this.addData(t)},
// @method addData( <GeoJSON> data ): this
// Adds a GeoJSON object to the layer.
addData:function(t){var e,i,n,o=g(t)?t:t.features;if(o){for(e=0,i=o.length;e<i;e++)
// only add this if geometry or geometries are set and not null
((n=o[e]).geometries||n.geometry||n.features||n.coordinates)&&this.addData(n);return this}var s=this.options;if(s.filter&&!s.filter(t))return this;var r=Li(t,s);return r?(r.feature=Ti(t),r.defaultOptions=r.options,this.resetStyle(r),s.onEachFeature&&s.onEachFeature(t,r),this.addLayer(r)):this},
// @method resetStyle( <Path> layer? ): this
// Resets the given vector layer's style to the original GeoJSON style, useful for resetting style after hover events.
// If `layer` is omitted, the style of all features in the current layer is reset.
resetStyle:function(t){return void 0===t?this.eachLayer(this.resetStyle,this):(// reset any custom styles
t.options=h({},t.defaultOptions),this._setLayerStyle(t,this.options.style),this)},
// @method setStyle( <Function> style ): this
// Changes styles of GeoJSON vector layers with the given style function.
setStyle:function(e){return this.eachLayer(function(t){this._setLayerStyle(t,e)},this)},_setLayerStyle:function(t,e){t.setStyle&&("function"==typeof e&&(e=e(t.feature)),t.setStyle(e))}});// @section
// There are several static functions which can be called without instantiating L.GeoJSON:
// @function geometryToLayer(featureData: Object, options?: GeoJSON options): Layer
// Creates a `Layer` from a given GeoJSON feature. Can use a custom
// [`pointToLayer`](#geojson-pointtolayer) and/or [`coordsToLatLng`](#geojson-coordstolatlng)
// functions if provided as options.
function Li(t,e){var i,n,o,s,r="Feature"===t.type?t.geometry:t,a=r?r.coordinates:null,h=[],l=e&&e.pointToLayer,u=e&&e.coordsToLatLng||wi;if(!a&&!r)return null;switch(r.type){case"Point":return xi(l,t,i=u(a),e);case"MultiPoint":for(o=0,s=a.length;o<s;o++)i=u(a[o]),h.push(xi(l,t,i,e));return new li(h);case"LineString":case"MultiLineString":return n=bi(a,"LineString"===r.type?0:1,u),new gi(n,e);case"Polygon":case"MultiPolygon":return n=bi(a,"Polygon"===r.type?1:2,u),new vi(n,e);case"GeometryCollection":for(o=0,s=r.geometries.length;o<s;o++){var c=Li({geometry:r.geometries[o],type:"Feature",properties:t.properties},e);c&&h.push(c)}return new li(h);default:throw new Error("Invalid GeoJSON object.")}}function xi(t,e,i,n){return t?t(e,i):new di(i,n&&n.markersInheritOptions&&n)}// @function coordsToLatLng(coords: Array): LatLng
// Creates a `LatLng` object from an array of 2 numbers (longitude, latitude)
// or 3 numbers (longitude, latitude, altitude) used in GeoJSON for points.
function wi(t){return new N(t[1],t[0],t[2])}// @function coordsToLatLngs(coords: Array, levelsDeep?: Number, coordsToLatLng?: Function): Array
// Creates a multidimensional array of `LatLng`s from a GeoJSON coordinates array.
// `levelsDeep` specifies the nesting level (0 is for an array of points, 1 for an array of arrays of points, etc., 0 by default).
// Can use a custom [`coordsToLatLng`](#geojson-coordstolatlng) function.
function bi(t,e,i){for(var n,o=[],s=0,r=t.length;s<r;s++)n=e?bi(t[s],e-1,i):(i||wi)(t[s]),o.push(n);return o}// @function latLngToCoords(latlng: LatLng, precision?: Number): Array
// Reverse of [`coordsToLatLng`](#geojson-coordstolatlng)
function Pi(t,e){return e="number"==typeof e?e:6,void 0!==t.alt?[r(t.lng,e),r(t.lat,e),r(t.alt,e)]:[r(t.lng,e),r(t.lat,e)]}// @function latLngsToCoords(latlngs: Array, levelsDeep?: Number, closed?: Boolean): Array
// Reverse of [`coordsToLatLngs`](#geojson-coordstolatlngs)
// `closed` determines whether the first point should be appended to the end of the array to close the feature, only used when `levelsDeep` is 0. False by default.
function Ci(t,e,i,n){for(var o=[],s=0,r=t.length;s<r;s++)o.push(e?Ci(t[s],e-1,i,n):Pi(t[s],n));return!e&&i&&o.push(o[0]),o}function Mi(t,e){return t.feature?h({},t.feature,{geometry:e}):Ti(e)}// @function asFeature(geojson: Object): Object
// Normalize GeoJSON geometries/features into GeoJSON features.
function Ti(t){return"Feature"===t.type||"FeatureCollection"===t.type?t:{type:"Feature",properties:{},geometry:t}}_t={toGeoJSON:function(t){return Mi(this,{type:"Point",coordinates:Pi(this.getLatLng(),t)})}};// @namespace Marker
// @section Other methods
// @method toGeoJSON(precision?: Number): Object
// `precision` is the number of decimal places for coordinates.
// The default value is 6 places.
// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the marker (as a GeoJSON `Point` Feature).
// @namespace GeoJSON
// @factory L.geoJSON(geojson?: Object, options?: GeoJSON options)
// Creates a GeoJSON layer. Optionally accepts an object in
// [GeoJSON format](https://tools.ietf.org/html/rfc7946) to display on the map
// (you can alternatively add it later with `addData` method) and an `options` object.
function ki(t,e){return new yi(t,e)}// Backward compatibility.
di.include(_t),// @namespace CircleMarker
// @method toGeoJSON(precision?: Number): Object
// `precision` is the number of decimal places for coordinates.
// The default value is 6 places.
// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the circle marker (as a GeoJSON `Point` Feature).
fi.include(_t),mi.include(_t),// @namespace Polyline
// @method toGeoJSON(precision?: Number): Object
// `precision` is the number of decimal places for coordinates.
// The default value is 6 places.
// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polyline (as a GeoJSON `LineString` or `MultiLineString` Feature).
gi.include({toGeoJSON:function(t){var e=!ni(this._latlngs);return Mi(this,{type:(e?"Multi":"")+"LineString",coordinates:Ci(this._latlngs,e?1:0,!1,t)})}}),// @namespace Polygon
// @method toGeoJSON(precision?: Number): Object
// `precision` is the number of decimal places for coordinates.
// The default value is 6 places.
// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polygon (as a GeoJSON `Polygon` or `MultiPolygon` Feature).
vi.include({toGeoJSON:function(t){var e=!ni(this._latlngs),i=e&&!ni(this._latlngs[0]),t=Ci(this._latlngs,i?2:e?1:0,!0,t);return e||(t=[t]),Mi(this,{type:(i?"Multi":"")+"Polygon",coordinates:t})}}),// @namespace LayerGroup
hi.include({toMultiPoint:function(e){var i=[];return this.eachLayer(function(t){i.push(t.toGeoJSON(e).geometry.coordinates)}),Mi(this,{type:"MultiPoint",coordinates:i})},
// @method toGeoJSON(precision?: Number): Object
// `precision` is the number of decimal places for coordinates.
// The default value is 6 places.
// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the layer group (as a GeoJSON `FeatureCollection`, `GeometryCollection`, or `MultiPoint`).
toGeoJSON:function(e){var t=this.feature&&this.feature.geometry&&this.feature.geometry.type;if("MultiPoint"===t)return this.toMultiPoint(e);var i="GeometryCollection"===t,n=[];return this.eachLayer(function(t){t.toGeoJSON&&(t=t.toGeoJSON(e),i?n.push(t.geometry):// Squash nested feature collections
"FeatureCollection"===(t=Ti(t)).type?n.push.apply(n,t.features):n.push(t))}),i?Mi(this,{geometries:n,type:"GeometryCollection"}):{type:"FeatureCollection",features:n}}});var ht=ki,zi=ai.extend({
// @section
// @aka ImageOverlay options
options:{
// @option opacity: Number = 1.0
// The opacity of the image overlay.
opacity:1,
// @option alt: String = ''
// Text for the `alt` attribute of the image (useful for accessibility).
alt:"",
// @option interactive: Boolean = false
// If `true`, the image overlay will emit [mouse events](#interactive-layer) when clicked or hovered.
interactive:!1,
// @option crossOrigin: Boolean|String = false
// Whether the crossOrigin attribute will be added to the image.
// If a String is provided, the image will have its crossOrigin attribute set to the String provided. This is needed if you want to access image pixel data.
// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.
crossOrigin:!1,
// @option errorOverlayUrl: String = ''
// URL to the overlay image to show in place of the overlay that failed to load.
errorOverlayUrl:"",
// @option zIndex: Number = 1
// The explicit [zIndex](https://developer.mozilla.org/docs/Web/CSS/CSS_Positioning/Understanding_z_index) of the overlay layer.
zIndex:1,
// @option className: String = ''
// A custom class name to assign to the image. Empty by default.
className:""},initialize:function(t,e,i){
// (String, LatLngBounds, Object)
this._url=t,this._bounds=R(e),c(this,i)},onAdd:function(){this._image||(this._initImage(),this.options.opacity<1&&this._updateOpacity()),this.options.interactive&&(se(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){te(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},
// @method setOpacity(opacity: Number): this
// Sets the opacity of the overlay.
setOpacity:function(t){return this.options.opacity=t,this._image&&this._updateOpacity(),this},setStyle:function(t){return t.opacity&&this.setOpacity(t.opacity),this},
// @method bringToFront(): this
// Brings the layer to the top of all overlays.
bringToFront:function(){return this._map&&ie(this._image),this},
// @method bringToBack(): this
// Brings the layer to the bottom of all overlays.
bringToBack:function(){return this._map&&ne(this._image),this},
// @method setUrl(url: String): this
// Changes the URL of the image.
setUrl:function(t){return this._url=t,this._image&&(this._image.src=t),this},
// @method setBounds(bounds: LatLngBounds): this
// Update the bounds that this ImageOverlay covers
setBounds:function(t){return this._bounds=R(t),this._map&&this._reset(),this},getEvents:function(){var t={zoom:this._reset,viewreset:this._reset};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},
// @method setZIndex(value: Number): this
// Changes the [zIndex](#imageoverlay-zindex) of the image overlay.
setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},
// @method getBounds(): LatLngBounds
// Get the bounds that this ImageOverlay covers
getBounds:function(){return this._bounds},
// @method getElement(): HTMLElement
// Returns the instance of [`HTMLImageElement`](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)
// used by this overlay.
getElement:function(){return this._image},_initImage:function(){var t="IMG"===this._url.tagName,e=this._image=t?this._url:$t("img");se(e,"leaflet-image-layer"),this._zoomAnimated&&se(e,"leaflet-zoom-animated"),this.options.className&&se(e,this.options.className),e.onselectstart=a,e.onmousemove=a,// @event load: Event
// Fired when the ImageOverlay layer has loaded its image
e.onload=_(this.fire,this,"load"),e.onerror=_(this._overlayOnError,this,"error"),!this.options.crossOrigin&&""!==this.options.crossOrigin||(e.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),this.options.zIndex&&this._updateZIndex(),t?this._url=e.src:(e.src=this._url,e.alt=this.options.alt)},_animateZoom:function(t){var e=this._map.getZoomScale(t.zoom),t=this._map._latLngBoundsToNewLayerBounds(this._bounds,t.zoom,t.center).min;ce(this._image,t,e)},_reset:function(){var t=this._image,e=new O(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast())),i=e.getSize();_e(t,e.min),t.style.width=i.x+"px",t.style.height=i.y+"px"},_updateOpacity:function(){le(this._image,this.options.opacity)},_updateZIndex:function(){this._image&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._image.style.zIndex=this.options.zIndex)},_overlayOnError:function(){
// @event error: Event
// Fired when the ImageOverlay layer fails to load its image
this.fire("error");var t=this.options.errorOverlayUrl;t&&this._url!==t&&(this._url=t,this._image.src=t)}}),Si=zi.extend({
// @section
// @aka VideoOverlay options
options:{
// @option autoplay: Boolean = true
// Whether the video starts playing automatically when loaded.
autoplay:!0,
// @option loop: Boolean = true
// Whether the video will loop back to the beginning when played.
loop:!0,
// @option keepAspectRatio: Boolean = true
// Whether the video will save aspect ratio after the projection.
// Relevant for supported browsers. Browser compatibility- https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit
keepAspectRatio:!0,
// @option muted: Boolean = false
// Whether the video starts on mute when loaded.
muted:!1},_initImage:function(){var t="VIDEO"===this._url.tagName,e=this._image=t?this._url:$t("video");if(se(e,"leaflet-image-layer"),this._zoomAnimated&&se(e,"leaflet-zoom-animated"),this.options.className&&se(e,this.options.className),e.onselectstart=a,e.onmousemove=a,// @event load: Event
// Fired when the video has finished loading the first frame
e.onloadeddata=_(this.fire,this,"load"),t){for(var i=e.getElementsByTagName("source"),n=[],o=0;o<i.length;o++)n.push(i[o].src);this._url=0<i.length?n:[e.src]}else{g(this._url)||(this._url=[this._url]),!this.options.keepAspectRatio&&Object.prototype.hasOwnProperty.call(e.style,"objectFit")&&(e.style.objectFit="fill"),e.autoplay=!!this.options.autoplay,e.loop=!!this.options.loop,e.muted=!!this.options.muted;for(var s=0;s<this._url.length;s++){var r=$t("source");r.src=this._url[s],e.appendChild(r)}}}// @method getElement(): HTMLVideoElement
// Returns the instance of [`HTMLVideoElement`](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)
// used by this overlay.
});
/*
   * @class ImageOverlay
   * @aka L.ImageOverlay
   * @inherits Interactive layer
   *
   * Used to load and display a single image over specific bounds of the map. Extends `Layer`.
   *
   * @example
   *
   * ```js
   * var imageUrl = 'http://www.lib.utexas.edu/maps/historical/newark_nj_1922.jpg',
   * 	imageBounds = [[40.712216, -74.22655], [40.773941, -74.12544]];
   * L.imageOverlay(imageUrl, imageBounds).addTo(map);
   * ```
   */
/*
   * @class SVGOverlay
   * @aka L.SVGOverlay
   * @inherits ImageOverlay
   *
   * Used to load, display and provide DOM access to an SVG file over specific bounds of the map. Extends `ImageOverlay`.
   *
   * An SVG overlay uses the [`<svg>`](https://developer.mozilla.org/docs/Web/SVG/Element/svg) element.
   *
   * @example
   *
   * ```js
   * var svgElement = document.createElementNS("http://www.w3.org/2000/svg", "svg");
   * svgElement.setAttribute('xmlns', "http://www.w3.org/2000/svg");
   * svgElement.setAttribute('viewBox', "0 0 200 200");
   * svgElement.innerHTML = '<rect width="200" height="200"/><rect x="75" y="23" width="50" height="50" style="fill:red"/><rect x="75" y="123" width="50" height="50" style="fill:#0013ff"/>';
   * var svgElementBounds = [ [ 32, -130 ], [ 13, -100 ] ];
   * L.svgOverlay(svgElement, svgElementBounds).addTo(map);
   * ```
   */
var Ei=zi.extend({_initImage:function(){var t=this._image=this._url;se(t,"leaflet-image-layer"),this._zoomAnimated&&se(t,"leaflet-zoom-animated"),this.options.className&&se(t,this.options.className),t.onselectstart=a,t.onmousemove=a}// @method getElement(): SVGElement
// Returns the instance of [`SVGElement`](https://developer.mozilla.org/docs/Web/API/SVGElement)
// used by this overlay.
});// @factory L.svgOverlay(svg: String|SVGElement, bounds: LatLngBounds, options?: SVGOverlay options)
// Instantiates an image overlay object given an SVG element and the geographical bounds it is tied to.
// A viewBox attribute is required on the SVG element to zoom in and out properly.
/*
   * @class DivOverlay
   * @inherits Layer
   * @aka L.DivOverlay
   * Base model for L.Popup and L.Tooltip. Inherit from it for custom popup like plugins.
   */
// @namespace DivOverlay
var Zi=ai.extend({
// @section
// @aka DivOverlay options
options:{
// @option offset: Point = Point(0, 7)
// The offset of the popup position. Useful to control the anchor
// of the popup when opening it on some overlays.
offset:[0,7],
// @option className: String = ''
// A custom CSS class name to assign to the popup.
className:"",
// @option pane: String = 'popupPane'
// `Map pane` where the popup will be added.
pane:"popupPane"},initialize:function(t,e){c(this,t),this._source=e},onAdd:function(t){this._zoomAnimated=t._zoomAnimated,this._container||this._initLayout(),t._fadeAnimated&&le(this._container,0),clearTimeout(this._removeTimeout),this.getPane().appendChild(this._container),this.update(),t._fadeAnimated&&le(this._container,1),this.bringToFront()},onRemove:function(t){t._fadeAnimated?(le(this._container,0),this._removeTimeout=setTimeout(_(te,void 0,this._container),200)):te(this._container)},
// @namespace Popup
// @method getLatLng: LatLng
// Returns the geographical point of popup.
getLatLng:function(){return this._latlng},
// @method setLatLng(latlng: LatLng): this
// Sets the geographical point where the popup will open.
setLatLng:function(t){return this._latlng=j(t),this._map&&(this._updatePosition(),this._adjustPan()),this},
// @method getContent: String|HTMLElement
// Returns the content of the popup.
getContent:function(){return this._content},
// @method setContent(htmlContent: String|HTMLElement|Function): this
// Sets the HTML content of the popup. If a function is passed the source layer will be passed to the function. The function should return a `String` or `HTMLElement` to be used in the popup.
setContent:function(t){return this._content=t,this.update(),this},
// @method getElement: String|HTMLElement
// Returns the HTML container of the popup.
getElement:function(){return this._container},
// @method update: null
// Updates the popup content, layout and position. Useful for updating the popup after something inside changed, e.g. image loaded.
update:function(){this._map&&(this._container.style.visibility="hidden",this._updateContent(),this._updateLayout(),this._updatePosition(),this._container.style.visibility="",this._adjustPan())},getEvents:function(){var t={zoom:this._updatePosition,viewreset:this._updatePosition};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},
// @method isOpen: Boolean
// Returns `true` when the popup is visible on the map.
isOpen:function(){return!!this._map&&this._map.hasLayer(this)},
// @method bringToFront: this
// Brings this popup in front of other popups (in the same map pane).
bringToFront:function(){return this._map&&ie(this._container),this},
// @method bringToBack: this
// Brings this popup to the back of other popups (in the same map pane).
bringToBack:function(){return this._map&&ne(this._container),this},_prepareOpen:function(t,e,i){if(e instanceof ai||(i=e,e=t),e instanceof li)for(var n in t._layers){e=t._layers[n];break}if(!i)if(e.getCenter)i=e.getCenter();else{if(!e.getLatLng)throw new Error("Unable to get source layer LatLng.");i=e.getLatLng()}// set overlay source to this layer
return this._source=e,// update the overlay (content, layout, ect...)
this.update(),i},_updateContent:function(){if(this._content){var t=this._contentNode,e="function"==typeof this._content?this._content(this._source||this):this._content;if("string"==typeof e)t.innerHTML=e;else{for(;t.hasChildNodes();)t.removeChild(t.firstChild);t.appendChild(e)}this.fire("contentupdate")}},_updatePosition:function(){var t,e,i;this._map&&(t=this._map.latLngToLayerPoint(this._latlng),i=B(this.options.offset),e=this._getAnchor(),this._zoomAnimated?_e(this._container,t.add(e)):i=i.add(t).add(e),e=this._containerBottom=-i.y,i=this._containerLeft=-Math.round(this._containerWidth/2)+i.x,// bottom position the popup in case the height of the popup changes (images loading etc)
this._container.style.bottom=e+"px",this._container.style.left=i+"px")},_getAnchor:function(){return[0,0]}}),Ai=Zi.extend({
// @section
// @aka Popup options
options:{
// @option maxWidth: Number = 300
// Max width of the popup, in pixels.
maxWidth:300,
// @option minWidth: Number = 50
// Min width of the popup, in pixels.
minWidth:50,
// @option maxHeight: Number = null
// If set, creates a scrollable container of the given height
// inside a popup if its content exceeds it.
maxHeight:null,
// @option autoPan: Boolean = true
// Set it to `false` if you don't want the map to do panning animation
// to fit the opened popup.
autoPan:!0,
// @option autoPanPaddingTopLeft: Point = null
// The margin between the popup and the top left corner of the map
// view after autopanning was performed.
autoPanPaddingTopLeft:null,
// @option autoPanPaddingBottomRight: Point = null
// The margin between the popup and the bottom right corner of the map
// view after autopanning was performed.
autoPanPaddingBottomRight:null,
// @option autoPanPadding: Point = Point(5, 5)
// Equivalent of setting both top left and bottom right autopan padding to the same value.
autoPanPadding:[5,5],
// @option keepInView: Boolean = false
// Set it to `true` if you want to prevent users from panning the popup
// off of the screen while it is open.
keepInView:!1,
// @option closeButton: Boolean = true
// Controls the presence of a close button in the popup.
closeButton:!0,
// @option autoClose: Boolean = true
// Set it to `false` if you want to override the default behavior of
// the popup closing when another popup is opened.
autoClose:!0,
// @option closeOnEscapeKey: Boolean = true
// Set it to `false` if you want to override the default behavior of
// the ESC key for closing of the popup.
closeOnEscapeKey:!0,
// @option closeOnClick: Boolean = *
// Set it if you want to override the default behavior of the popup closing when user clicks
// on the map. Defaults to the map's [`closePopupOnClick`](#map-closepopuponclick) option.
// @option className: String = ''
// A custom CSS class name to assign to the popup.
className:""},
// @namespace Popup
// @method openOn(map: Map): this
// Adds the popup to the map and closes the previous one. The same as `map.openPopup(popup)`.
openOn:function(t){return t.openPopup(this),this},onAdd:function(t){Zi.prototype.onAdd.call(this,t),// @namespace Map
// @section Popup events
// @event popupopen: PopupEvent
// Fired when a popup is opened in the map
t.fire("popupopen",{popup:this}),this._source&&(
// @namespace Layer
// @section Popup events
// @event popupopen: PopupEvent
// Fired when a popup bound to this layer is opened
this._source.fire("popupopen",{popup:this},!0),// For non-path layers, we toggle the popup when clicking
// again the layer, so prevent the map to reopen it.
this._source instanceof pi||this._source.on("preclick",Te))},onRemove:function(t){Zi.prototype.onRemove.call(this,t),// @namespace Map
// @section Popup events
// @event popupclose: PopupEvent
// Fired when a popup in the map is closed
t.fire("popupclose",{popup:this}),this._source&&(
// @namespace Layer
// @section Popup events
// @event popupclose: PopupEvent
// Fired when a popup bound to this layer is closed
this._source.fire("popupclose",{popup:this},!0),this._source instanceof pi||this._source.off("preclick",Te))},getEvents:function(){var t=Zi.prototype.getEvents.call(this);return(void 0!==this.options.closeOnClick?this.options.closeOnClick:this._map.options.closePopupOnClick)&&(t.preclick=this._close),this.options.keepInView&&(t.moveend=this._adjustPan),t},_close:function(){this._map&&this._map.closePopup(this)},_initLayout:function(){var t="leaflet-popup",e=this._container=$t("div",t+" "+(this.options.className||"")+" leaflet-zoom-animated"),i=this._wrapper=$t("div",t+"-content-wrapper",e);this._contentNode=$t("div",t+"-content",i),ze(e),ke(this._contentNode),Le(e,"contextmenu",Te),this._tipContainer=$t("div",t+"-tip-container",e),this._tip=$t("div",t+"-tip",this._tipContainer),this.options.closeButton&&((e=this._closeButton=$t("a",t+"-close-button",e)).href="#close",e.innerHTML="&#215;",Le(e,"click",this._onCloseButtonClick,this))},_updateLayout:function(){var t=this._contentNode,e=t.style;e.width="",e.whiteSpace="nowrap";var i=t.offsetWidth,i=Math.min(i,this.options.maxWidth);i=Math.max(i,this.options.minWidth),e.width=i+1+"px",e.whiteSpace="",e.height="";var n=t.offsetHeight,o=this.options.maxHeight,i="leaflet-popup-scrolled";o&&o<n?(e.height=o+"px",se(t,i)):re(t,i),this._containerWidth=this._container.offsetWidth},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center),t=this._getAnchor();_e(this._container,e.add(t))},_adjustPan:function(){var t,e,i,n,o,s,r,a,h;this.options.autoPan&&(this._map._panAnim&&this._map._panAnim.stop(),t=this._map,r=parseInt(Qt(this._container,"marginBottom"),10)||0,e=this._container.offsetHeight+r,i=this._containerWidth,(a=new Z(this._containerLeft,-e-this._containerBottom))._add(de(this._container)),n=t.layerPointToContainerPoint(a),h=B(this.options.autoPanPadding),o=B(this.options.autoPanPaddingTopLeft||h),s=B(this.options.autoPanPaddingBottomRight||h),r=t.getSize(),h=a=0,n.x+i+s.x>r.x&&(
// right
a=n.x+i-r.x+s.x),n.x-a-o.x<0&&(
// left
a=n.x-o.x),n.y+e+s.y>r.y&&(
// bottom
h=n.y+e-r.y+s.y),n.y-h-o.y<0&&(
// top
h=n.y-o.y),// @namespace Map
// @section Popup events
// @event autopanstart: Event
// Fired when the map starts autopanning when opening a popup.
(a||h)&&t.fire("autopanstart").panBy([a,h]))},_onCloseButtonClick:function(t){this._close(),Ee(t)},_getAnchor:function(){
// Where should we anchor the popup on the source layer?
return B(this._source&&this._source._getPopupAnchor?this._source._getPopupAnchor():[0,0])}});
/*
   * @class Popup
   * @inherits DivOverlay
   * @aka L.Popup
   * Used to open popups in certain places of the map. Use [Map.openPopup](#map-openpopup) to
   * open popups while making sure that only one popup is open at one time
   * (recommended for usability), or use [Map.addLayer](#map-addlayer) to open as many as you want.
   *
   * @example
   *
   * If you want to just bind a popup to marker click and then open it, it's really easy:
   *
   * ```js
   * marker.bindPopup(popupContent).openPopup();
   * ```
   * Path overlays like polylines also have a `bindPopup` method.
   * Here's a more complicated way to open a popup on a map:
   *
   * ```js
   * var popup = L.popup()
   * 	.setLatLng(latlng)
   * 	.setContent('<p>Hello world!<br />This is a nice popup.</p>')
   * 	.openOn(map);
   * ```
   */
// @namespace Popup
/* @namespace Map
   * @section Interaction Options
   * @option closePopupOnClick: Boolean = true
   * Set it to `false` if you don't want popups to close when user clicks the map.
   */
je.mergeOptions({closePopupOnClick:!0}),// @namespace Map
// @section Methods for Layers and Controls
je.include({
// @method openPopup(popup: Popup): this
// Opens the specified popup while closing the previously opened (to make sure only one is opened at one time for usability).
// @alternative
// @method openPopup(content: String|HTMLElement, latlng: LatLng, options?: Popup options): this
// Creates a popup with the specified content and options and opens it in the given point on a map.
openPopup:function(t,e,i){return t instanceof Ai||(t=new Ai(i).setContent(t)),e&&t.setLatLng(e),this.hasLayer(t)?this:(this._popup&&this._popup.options.autoClose&&this.closePopup(),this._popup=t,this.addLayer(t))},
// @method closePopup(popup?: Popup): this
// Closes the popup previously opened with [openPopup](#map-openpopup) (or the given one).
closePopup:function(t){return t&&t!==this._popup||(t=this._popup,this._popup=null),t&&this.removeLayer(t),this}}),
/*
   * @namespace Layer
   * @section Popup methods example
   *
   * All layers share a set of methods convenient for binding popups to it.
   *
   * ```js
   * var layer = L.Polygon(latlngs).bindPopup('Hi There!').addTo(map);
   * layer.openPopup();
   * layer.closePopup();
   * ```
   *
   * Popups will also be automatically opened when the layer is clicked on and closed when the layer is removed from the map or another popup is opened.
   */
// @section Popup methods
ai.include({
// @method bindPopup(content: String|HTMLElement|Function|Popup, options?: Popup options): this
// Binds a popup to the layer with the passed `content` and sets up the
// necessary event listeners. If a `Function` is passed it will receive
// the layer as the first argument and should return a `String` or `HTMLElement`.
bindPopup:function(t,e){return t instanceof Ai?(c(t,e),(this._popup=t)._source=this):(this._popup&&!e||(this._popup=new Ai(e,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!0),this},
// @method unbindPopup(): this
// Removes the popup previously bound with `bindPopup`.
unbindPopup:function(){return this._popup&&(this.off({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!1,this._popup=null),this},
// @method openPopup(latlng?: LatLng): this
// Opens the bound popup at the specified `latlng` or at the default popup anchor if no `latlng` is passed.
openPopup:function(t,e){return this._popup&&this._map&&(e=this._popup._prepareOpen(this,t,e),// open the popup on the map
this._map.openPopup(this._popup,e)),this},
// @method closePopup(): this
// Closes the popup bound to this layer if it is open.
closePopup:function(){return this._popup&&this._popup._close(),this},
// @method togglePopup(): this
// Opens or closes the popup bound to this layer depending on its current state.
togglePopup:function(t){return this._popup&&(this._popup._map?this.closePopup():this.openPopup(t)),this},
// @method isPopupOpen(): boolean
// Returns `true` if the popup bound to this layer is currently open.
isPopupOpen:function(){return!!this._popup&&this._popup.isOpen()},
// @method setPopupContent(content: String|HTMLElement|Popup): this
// Sets the content of the popup bound to this layer.
setPopupContent:function(t){return this._popup&&this._popup.setContent(t),this},
// @method getPopup(): Popup
// Returns the popup bound to this layer.
getPopup:function(){return this._popup},_openPopup:function(t){var e=t.layer||t.target;this._popup&&this._map&&(// prevent map click
Ee(t),// if this inherits from Path its a vector and we can just
// open the popup at the new location
e instanceof pi?this.openPopup(t.layer||t.target,t.latlng):// otherwise treat it like a marker and figure out
// if we should toggle it open/closed
this._map.hasLayer(this._popup)&&this._popup._source===e?this.closePopup():this.openPopup(e,t.latlng))},_movePopup:function(t){this._popup.setLatLng(t.latlng)},_onKeyPress:function(t){13===t.originalEvent.keyCode&&this._openPopup(t)}});
/*
   * @class Tooltip
   * @inherits DivOverlay
   * @aka L.Tooltip
   * Used to display small texts on top of map layers.
   *
   * @example
   *
   * ```js
   * marker.bindTooltip("my tooltip text").openTooltip();
   * ```
   * Note about tooltip offset. Leaflet takes two options in consideration
   * for computing tooltip offsetting:
   * - the `offset` Tooltip option: it defaults to [0, 0], and it's specific to one tooltip.
   *   Add a positive x offset to move the tooltip to the right, and a positive y offset to
   *   move it to the bottom. Negatives will move to the left and top.
   * - the `tooltipAnchor` Icon option: this will only be considered for Marker. You
   *   should adapt this value if you use a custom icon.
   */
// @namespace Tooltip
var Bi=Zi.extend({
// @section
// @aka Tooltip options
options:{
// @option pane: String = 'tooltipPane'
// `Map pane` where the tooltip will be added.
pane:"tooltipPane",
// @option offset: Point = Point(0, 0)
// Optional offset of the tooltip position.
offset:[0,0],
// @option direction: String = 'auto'
// Direction where to open the tooltip. Possible values are: `right`, `left`,
// `top`, `bottom`, `center`, `auto`.
// `auto` will dynamically switch between `right` and `left` according to the tooltip
// position on the map.
direction:"auto",
// @option permanent: Boolean = false
// Whether to open the tooltip permanently or only on mouseover.
permanent:!1,
// @option sticky: Boolean = false
// If true, the tooltip will follow the mouse instead of being fixed at the feature center.
sticky:!1,
// @option interactive: Boolean = false
// If true, the tooltip will listen to the feature events.
interactive:!1,
// @option opacity: Number = 0.9
// Tooltip container opacity.
opacity:.9},onAdd:function(t){Zi.prototype.onAdd.call(this,t),this.setOpacity(this.options.opacity),// @namespace Map
// @section Tooltip events
// @event tooltipopen: TooltipEvent
// Fired when a tooltip is opened in the map.
t.fire("tooltipopen",{tooltip:this}),this._source&&
// @namespace Layer
// @section Tooltip events
// @event tooltipopen: TooltipEvent
// Fired when a tooltip bound to this layer is opened.
this._source.fire("tooltipopen",{tooltip:this},!0)},onRemove:function(t){Zi.prototype.onRemove.call(this,t),// @namespace Map
// @section Tooltip events
// @event tooltipclose: TooltipEvent
// Fired when a tooltip in the map is closed.
t.fire("tooltipclose",{tooltip:this}),this._source&&
// @namespace Layer
// @section Tooltip events
// @event tooltipclose: TooltipEvent
// Fired when a tooltip bound to this layer is closed.
this._source.fire("tooltipclose",{tooltip:this},!0)},getEvents:function(){var t=Zi.prototype.getEvents.call(this);return Lt&&!this.options.permanent&&(t.preclick=this._close),t},_close:function(){this._map&&this._map.closeTooltip(this)},_initLayout:function(){var t="leaflet-tooltip "+(this.options.className||"")+" leaflet-zoom-"+(this._zoomAnimated?"animated":"hide");this._contentNode=this._container=$t("div",t)},_updateLayout:function(){},_adjustPan:function(){},_setPosition:function(t){var e,i=this._map,n=this._container,o=i.latLngToContainerPoint(i.getCenter()),s=i.layerPointToContainerPoint(t),r=this.options.direction,a=n.offsetWidth,h=n.offsetHeight,l=B(this.options.offset),i=this._getAnchor(),h="top"===r?(e=a/2,h):"bottom"===r?(e=a/2,0):(e="center"===r?a/2:"right"===r?0:"left"===r?a:s.x<o.x?(r="right",0):(r="left",a+2*(l.x+i.x)),h/2);t=t.subtract(B(e,h,!0)).add(l).add(i),re(n,"leaflet-tooltip-right"),re(n,"leaflet-tooltip-left"),re(n,"leaflet-tooltip-top"),re(n,"leaflet-tooltip-bottom"),se(n,"leaflet-tooltip-"+r),_e(n,t)},_updatePosition:function(){var t=this._map.latLngToLayerPoint(this._latlng);this._setPosition(t)},setOpacity:function(t){this.options.opacity=t,this._container&&le(this._container,t)},_animateZoom:function(t){t=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center);this._setPosition(t)},_getAnchor:function(){
// Where should we anchor the tooltip on the source layer?
return B(this._source&&this._source._getTooltipAnchor&&!this.options.sticky?this._source._getTooltipAnchor():[0,0])}});// @namespace Tooltip
// @factory L.tooltip(options?: Tooltip options, source?: Layer)
// Instantiates a Tooltip object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the tooltip with a reference to the Layer to which it refers.
// @namespace Map
// @section Methods for Layers and Controls
je.include({
// @method openTooltip(tooltip: Tooltip): this
// Opens the specified tooltip.
// @alternative
// @method openTooltip(content: String|HTMLElement, latlng: LatLng, options?: Tooltip options): this
// Creates a tooltip with the specified content and options and open it.
openTooltip:function(t,e,i){return t instanceof Bi||(t=new Bi(i).setContent(t)),e&&t.setLatLng(e),this.hasLayer(t)?this:this.addLayer(t)},
// @method closeTooltip(tooltip?: Tooltip): this
// Closes the tooltip given as parameter.
closeTooltip:function(t){return t&&this.removeLayer(t),this}}),
/*
   * @namespace Layer
   * @section Tooltip methods example
   *
   * All layers share a set of methods convenient for binding tooltips to it.
   *
   * ```js
   * var layer = L.Polygon(latlngs).bindTooltip('Hi There!').addTo(map);
   * layer.openTooltip();
   * layer.closeTooltip();
   * ```
   */
// @section Tooltip methods
ai.include({
// @method bindTooltip(content: String|HTMLElement|Function|Tooltip, options?: Tooltip options): this
// Binds a tooltip to the layer with the passed `content` and sets up the
// necessary event listeners. If a `Function` is passed it will receive
// the layer as the first argument and should return a `String` or `HTMLElement`.
bindTooltip:function(t,e){return t instanceof Bi?(c(t,e),(this._tooltip=t)._source=this):(this._tooltip&&!e||(this._tooltip=new Bi(e,this)),this._tooltip.setContent(t)),this._initTooltipInteractions(),this._tooltip.options.permanent&&this._map&&this._map.hasLayer(this)&&this.openTooltip(),this},
// @method unbindTooltip(): this
// Removes the tooltip previously bound with `bindTooltip`.
unbindTooltip:function(){return this._tooltip&&(this._initTooltipInteractions(!0),this.closeTooltip(),this._tooltip=null),this},_initTooltipInteractions:function(t){var e,i;!t&&this._tooltipHandlersAdded||(e=t?"off":"on",i={remove:this.closeTooltip,move:this._moveTooltip},this._tooltip.options.permanent?i.add=this._openTooltip:(i.mouseover=this._openTooltip,i.mouseout=this.closeTooltip,this._tooltip.options.sticky&&(i.mousemove=this._moveTooltip),Lt&&(i.click=this._openTooltip)),this[e](i),this._tooltipHandlersAdded=!t)},
// @method openTooltip(latlng?: LatLng): this
// Opens the bound tooltip at the specified `latlng` or at the default tooltip anchor if no `latlng` is passed.
openTooltip:function(t,e){return this._tooltip&&this._map&&(e=this._tooltip._prepareOpen(this,t,e),// open the tooltip on the map
this._map.openTooltip(this._tooltip,e),// Tooltip container may not be defined if not permanent and never
// opened.
this._tooltip.options.interactive&&this._tooltip._container&&(se(this._tooltip._container,"leaflet-clickable"),this.addInteractiveTarget(this._tooltip._container))),this},
// @method closeTooltip(): this
// Closes the tooltip bound to this layer if it is open.
closeTooltip:function(){return this._tooltip&&(this._tooltip._close(),this._tooltip.options.interactive&&this._tooltip._container&&(re(this._tooltip._container,"leaflet-clickable"),this.removeInteractiveTarget(this._tooltip._container))),this},
// @method toggleTooltip(): this
// Opens or closes the tooltip bound to this layer depending on its current state.
toggleTooltip:function(t){return this._tooltip&&(this._tooltip._map?this.closeTooltip():this.openTooltip(t)),this},
// @method isTooltipOpen(): boolean
// Returns `true` if the tooltip bound to this layer is currently open.
isTooltipOpen:function(){return this._tooltip.isOpen()},
// @method setTooltipContent(content: String|HTMLElement|Tooltip): this
// Sets the content of the tooltip bound to this layer.
setTooltipContent:function(t){return this._tooltip&&this._tooltip.setContent(t),this},
// @method getTooltip(): Tooltip
// Returns the tooltip bound to this layer.
getTooltip:function(){return this._tooltip},_openTooltip:function(t){var e=t.layer||t.target;this._tooltip&&this._map&&this.openTooltip(e,this._tooltip.options.sticky?t.latlng:void 0)},_moveTooltip:function(t){var e=t.latlng;this._tooltip.options.sticky&&t.originalEvent&&(t=this._map.mouseEventToContainerPoint(t.originalEvent),t=this._map.containerPointToLayerPoint(t),e=this._map.layerPointToLatLng(t)),this._tooltip.setLatLng(e)}});
/*
   * @class DivIcon
   * @aka L.DivIcon
   * @inherits Icon
   *
   * Represents a lightweight icon for markers that uses a simple `<div>`
   * element instead of an image. Inherits from `Icon` but ignores the `iconUrl` and shadow options.
   *
   * @example
   * ```js
   * var myIcon = L.divIcon({className: 'my-div-icon'});
   * // you can set .my-div-icon styles in CSS
   *
   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);
   * ```
   *
   * By default, it has a 'leaflet-div-icon' CSS class and is styled as a little white square with a shadow.
   */
var Oi=ui.extend({options:{
// @section
// @aka DivIcon options
iconSize:[12,12],
// also can be set through CSS
// iconAnchor: (Point),
// popupAnchor: (Point),
// @option html: String|HTMLElement = ''
// Custom HTML code to put inside the div element, empty by default. Alternatively,
// an instance of `HTMLElement`.
html:!1,
// @option bgPos: Point = [0, 0]
// Optional relative position of the background, in pixels
bgPos:null,className:"leaflet-div-icon"},createIcon:function(t){var e=t&&"DIV"===t.tagName?t:document.createElement("div"),t=this.options;return t.html instanceof Element?(ee(e),e.appendChild(t.html)):e.innerHTML=!1!==t.html?t.html:"",t.bgPos&&(t=B(t.bgPos),e.style.backgroundPosition=-t.x+"px "+-t.y+"px"),this._setIconStyles(e,"icon"),e},createShadow:function(){return null}});// @factory L.divIcon(options: DivIcon options)
// Creates a `DivIcon` instance with the given options.
ui.Default=ci;
/*
   * @class GridLayer
   * @inherits Layer
   * @aka L.GridLayer
   *
   * Generic class for handling a tiled grid of HTML elements. This is the base class for all tile layers and replaces `TileLayer.Canvas`.
   * GridLayer can be extended to create a tiled grid of HTML elements like `<canvas>`, `<img>` or `<div>`. GridLayer will handle creating and animating these DOM elements for you.
   *
   *
   * @section Synchronous usage
   * @example
   *
   * To create a custom layer, extend GridLayer and implement the `createTile()` method, which will be passed a `Point` object with the `x`, `y`, and `z` (zoom level) coordinates to draw your tile.
   *
   * ```js
   * var CanvasLayer = L.GridLayer.extend({
   *     createTile: function(coords){
   *         // create a <canvas> element for drawing
   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');
   *
   *         // setup tile width and height according to the options
   *         var size = this.getTileSize();
   *         tile.width = size.x;
   *         tile.height = size.y;
   *
   *         // get a canvas context and draw something on it using coords.x, coords.y and coords.z
   *         var ctx = tile.getContext('2d');
   *
   *         // return the tile so it can be rendered on screen
   *         return tile;
   *     }
   * });
   * ```
   *
   * @section Asynchronous usage
   * @example
   *
   * Tile creation can also be asynchronous, this is useful when using a third-party drawing library. Once the tile is finished drawing it can be passed to the `done()` callback.
   *
   * ```js
   * var CanvasLayer = L.GridLayer.extend({
   *     createTile: function(coords, done){
   *         var error;
   *
   *         // create a <canvas> element for drawing
   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');
   *
   *         // setup tile width and height according to the options
   *         var size = this.getTileSize();
   *         tile.width = size.x;
   *         tile.height = size.y;
   *
   *         // draw something asynchronously and pass the tile to the done() callback
   *         setTimeout(function() {
   *             done(error, tile);
   *         }, 1000);
   *
   *         return tile;
   *     }
   * });
   * ```
   *
   * @section
   */
var Ii=ai.extend({
// @section
// @aka GridLayer options
options:{
// @option tileSize: Number|Point = 256
// Width and height of tiles in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.
tileSize:256,
// @option opacity: Number = 1.0
// Opacity of the tiles. Can be used in the `createTile()` function.
opacity:1,
// @option updateWhenIdle: Boolean = (depends)
// Load new tiles only when panning ends.
// `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.
// `false` otherwise in order to display new tiles _during_ panning, since it is easy to pan outside the
// [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.
updateWhenIdle:H,
// @option updateWhenZooming: Boolean = true
// By default, a smooth zoom animation (during a [touch zoom](#map-touchzoom) or a [`flyTo()`](#map-flyto)) will update grid layers every integer zoom level. Setting this option to `false` will update the grid layer only when the smooth animation ends.
updateWhenZooming:!0,
// @option updateInterval: Number = 200
// Tiles will not update more than once every `updateInterval` milliseconds when panning.
updateInterval:200,
// @option zIndex: Number = 1
// The explicit zIndex of the tile layer.
zIndex:1,
// @option bounds: LatLngBounds = undefined
// If set, tiles will only be loaded inside the set `LatLngBounds`.
bounds:null,
// @option minZoom: Number = 0
// The minimum zoom level down to which this layer will be displayed (inclusive).
minZoom:0,
// @option maxZoom: Number = undefined
// The maximum zoom level up to which this layer will be displayed (inclusive).
maxZoom:void 0,
// @option maxNativeZoom: Number = undefined
// Maximum zoom number the tile source has available. If it is specified,
// the tiles on all zoom levels higher than `maxNativeZoom` will be loaded
// from `maxNativeZoom` level and auto-scaled.
maxNativeZoom:void 0,
// @option minNativeZoom: Number = undefined
// Minimum zoom number the tile source has available. If it is specified,
// the tiles on all zoom levels lower than `minNativeZoom` will be loaded
// from `minNativeZoom` level and auto-scaled.
minNativeZoom:void 0,
// @option noWrap: Boolean = false
// Whether the layer is wrapped around the antimeridian. If `true`, the
// GridLayer will only be displayed once at low zoom levels. Has no
// effect when the [map CRS](#map-crs) doesn't wrap around. Can be used
// in combination with [`bounds`](#gridlayer-bounds) to prevent requesting
// tiles outside the CRS limits.
noWrap:!1,
// @option pane: String = 'tilePane'
// `Map pane` where the grid layer will be added.
pane:"tilePane",
// @option className: String = ''
// A custom class name to assign to the tile layer. Empty by default.
className:"",
// @option keepBuffer: Number = 2
// When panning the map, keep this many rows and columns of tiles before unloading them.
keepBuffer:2},initialize:function(t){c(this,t)},onAdd:function(){this._initContainer(),this._levels={},this._tiles={},this._resetView(),this._update()},beforeAdd:function(t){t._addZoomLimit(this)},onRemove:function(t){this._removeAllTiles(),te(this._container),t._removeZoomLimit(this),this._container=null,this._tileZoom=void 0},
// @method bringToFront: this
// Brings the tile layer to the top of all tile layers.
bringToFront:function(){return this._map&&(ie(this._container),this._setAutoZIndex(Math.max)),this},
// @method bringToBack: this
// Brings the tile layer to the bottom of all tile layers.
bringToBack:function(){return this._map&&(ne(this._container),this._setAutoZIndex(Math.min)),this},
// @method getContainer: HTMLElement
// Returns the HTML element that contains the tiles for this layer.
getContainer:function(){return this._container},
// @method setOpacity(opacity: Number): this
// Changes the [opacity](#gridlayer-opacity) of the grid layer.
setOpacity:function(t){return this.options.opacity=t,this._updateOpacity(),this},
// @method setZIndex(zIndex: Number): this
// Changes the [zIndex](#gridlayer-zindex) of the grid layer.
setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},
// @method isLoading: Boolean
// Returns `true` if any tile in the grid layer has not finished loading.
isLoading:function(){return this._loading},
// @method redraw: this
// Causes the layer to clear all the tiles and request them again.
redraw:function(){return this._map&&(this._removeAllTiles(),this._update()),this},getEvents:function(){var t={viewprereset:this._invalidateAll,viewreset:this._resetView,zoom:this._resetView,moveend:this._onMoveEnd};return this.options.updateWhenIdle||(
// update tiles on move, but not more often than once per given interval
this._onMove||(this._onMove=n(this._onMoveEnd,this.options.updateInterval,this)),t.move=this._onMove),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},
// @section Extension methods
// Layers extending `GridLayer` shall reimplement the following method.
// @method createTile(coords: Object, done?: Function): HTMLElement
// Called only internally, must be overridden by classes extending `GridLayer`.
// Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback
// is specified, it must be called when the tile has finished loading and drawing.
createTile:function(){return document.createElement("div")},
// @section
// @method getTileSize: Point
// Normalizes the [tileSize option](#gridlayer-tilesize) into a point. Used by the `createTile()` method.
getTileSize:function(){var t=this.options.tileSize;return t instanceof Z?t:new Z(t,t)},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_setAutoZIndex:function(t){// -Infinity for max, Infinity for min
for(
// go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)
var e,i=this.getPane().children,n=-t(-1/0,1/0),o=0,s=i.length;o<s;o++)e=i[o].style.zIndex,i[o]!==this._container&&e&&(n=t(n,+e));isFinite(n)&&(this.options.zIndex=n+t(-1,1),this._updateZIndex())},_updateOpacity:function(){if(this._map&&!$)// IE doesn't inherit filter opacity properly, so we're forced to set it on tiles
{le(this._container,this.options.opacity);var t,e=+new Date,i=!1,n=!1;for(t in this._tiles){var o,s=this._tiles[t];s.current&&s.loaded&&(o=Math.min(1,(e-s.loaded)/200),le(s.el,o),o<1?i=!0:(s.active?n=!0:this._onOpaqueTile(s),s.active=!0))}n&&!this._noPrune&&this._pruneTiles(),i&&(T(this._fadeFrame),this._fadeFrame=M(this._updateOpacity,this))}},_onOpaqueTile:a,_initContainer:function(){this._container||(this._container=$t("div","leaflet-layer "+(this.options.className||"")),this._updateZIndex(),this.options.opacity<1&&this._updateOpacity(),this.getPane().appendChild(this._container))},_updateLevels:function(){var t=this._tileZoom,e=this.options.maxZoom;if(void 0!==t){for(var i in this._levels)i=Number(i),this._levels[i].el.children.length||i===t?(this._levels[i].el.style.zIndex=e-Math.abs(t-i),this._onUpdateLevel(i)):(te(this._levels[i].el),this._removeTilesAtZoom(i),this._onRemoveLevel(i),delete this._levels[i]);var n=this._levels[t],o=this._map;return n||((n=this._levels[t]={}).el=$t("div","leaflet-tile-container leaflet-zoom-animated",this._container),n.el.style.zIndex=e,n.origin=o.project(o.unproject(o.getPixelOrigin()),t).round(),n.zoom=t,this._setZoomTransform(n,o.getCenter(),o.getZoom()),// force the browser to consider the newly added element for transition
a(n.el.offsetWidth),this._onCreateLevel(n)),this._level=n}},_onUpdateLevel:a,_onRemoveLevel:a,_onCreateLevel:a,_pruneTiles:function(){if(this._map){var t,e,i,n=this._map.getZoom();if(n>this.options.maxZoom||n<this.options.minZoom)this._removeAllTiles();else{for(t in this._tiles)(i=this._tiles[t]).retain=i.current;for(t in this._tiles){(i=this._tiles[t]).current&&!i.active&&(e=i.coords,this._retainParent(e.x,e.y,e.z,e.z-5)||this._retainChildren(e.x,e.y,e.z,e.z+2))}for(t in this._tiles)this._tiles[t].retain||this._removeTile(t)}}},_removeTilesAtZoom:function(t){for(var e in this._tiles)this._tiles[e].coords.z===t&&this._removeTile(e)},_removeAllTiles:function(){for(var t in this._tiles)this._removeTile(t)},_invalidateAll:function(){for(var t in this._levels)te(this._levels[t].el),this._onRemoveLevel(Number(t)),delete this._levels[t];this._removeAllTiles(),this._tileZoom=void 0},_retainParent:function(t,e,i,n){var o=Math.floor(t/2),t=Math.floor(e/2),e=i-1,i=new Z(+o,+t);i.z=+e;i=this._tileCoordsToKey(i),i=this._tiles[i];return i&&i.active?i.retain=!0:(i&&i.loaded&&(i.retain=!0),n<e&&this._retainParent(o,t,e,n))},_retainChildren:function(t,e,i,n){for(var o=2*t;o<2*t+2;o++)for(var s=2*e;s<2*e+2;s++){var r=new Z(o,s);r.z=i+1;r=this._tileCoordsToKey(r),r=this._tiles[r];r&&r.active?r.retain=!0:(r&&r.loaded&&(r.retain=!0),i+1<n&&this._retainChildren(o,s,i+1,n))}},_resetView:function(t){t=t&&(t.pinch||t.flyTo);this._setView(this._map.getCenter(),this._map.getZoom(),t,t)},_animateZoom:function(t){this._setView(t.center,t.zoom,!0,t.noUpdate)},_clampZoom:function(t){var e=this.options;return void 0!==e.minNativeZoom&&t<e.minNativeZoom?e.minNativeZoom:void 0!==e.maxNativeZoom&&e.maxNativeZoom<t?e.maxNativeZoom:t},_setView:function(t,e,i,n){var o=Math.round(e),o=void 0!==this.options.maxZoom&&o>this.options.maxZoom||void 0!==this.options.minZoom&&o<this.options.minZoom?void 0:this._clampZoom(o),s=this.options.updateWhenZooming&&o!==this._tileZoom;n&&!s||(this._tileZoom=o,this._abortLoading&&this._abortLoading(),this._updateLevels(),this._resetGrid(),void 0!==o&&this._update(t),i||this._pruneTiles(),// Flag to prevent _updateOpacity from pruning tiles during
// a zoom anim or a pinch gesture
this._noPrune=!!i),this._setZoomTransforms(t,e)},_setZoomTransforms:function(t,e){for(var i in this._levels)this._setZoomTransform(this._levels[i],t,e)},_setZoomTransform:function(t,e,i){var n=this._map.getZoomScale(i,t.zoom),i=t.origin.multiplyBy(n).subtract(this._map._getNewPixelOrigin(e,i)).round();ft?ce(t.el,i,n):_e(t.el,i)},_resetGrid:function(){var t=this._map,e=t.options.crs,i=this._tileSize=this.getTileSize(),n=this._tileZoom,o=this._map.getPixelWorldBounds(this._tileZoom);o&&(this._globalTileRange=this._pxBoundsToTileRange(o)),this._wrapX=e.wrapLng&&!this.options.noWrap&&[Math.floor(t.project([0,e.wrapLng[0]],n).x/i.x),Math.ceil(t.project([0,e.wrapLng[1]],n).x/i.y)],this._wrapY=e.wrapLat&&!this.options.noWrap&&[Math.floor(t.project([e.wrapLat[0],0],n).y/i.x),Math.ceil(t.project([e.wrapLat[1],0],n).y/i.y)]},_onMoveEnd:function(){this._map&&!this._map._animatingZoom&&this._update()},_getTiledPixelBounds:function(t){var e=this._map,i=e._animatingZoom?Math.max(e._animateToZoom,e.getZoom()):e.getZoom(),i=e.getZoomScale(i,this._tileZoom),t=e.project(t,this._tileZoom).floor(),i=e.getSize().divideBy(2*i);return new O(t.subtract(i),t.add(i))},
// Private method to load tiles in the grid's active zoom level according to map bounds
_update:function(t){var e=this._map;if(e){var i=this._clampZoom(e.getZoom());if(void 0===t&&(t=e.getCenter()),void 0!==this._tileZoom){// if out of minzoom/maxzoom
var n,e=this._getTiledPixelBounds(t),o=this._pxBoundsToTileRange(e),s=o.getCenter(),r=[],e=this.options.keepBuffer,a=new O(o.getBottomLeft().subtract([e,-e]),o.getTopRight().add([e,-e]));// Sanity check: panic if the tile range contains Infinity somewhere.
if(!(isFinite(o.min.x)&&isFinite(o.min.y)&&isFinite(o.max.x)&&isFinite(o.max.y)))throw new Error("Attempted to load an infinite number of tiles");for(n in this._tiles){var h=this._tiles[n].coords;h.z===this._tileZoom&&a.contains(new Z(h.x,h.y))||(this._tiles[n].current=!1)}// _update just loads more tiles. If the tile zoom level differs too much
// from the map's, let _setView reset levels and prune old tiles.
if(1<Math.abs(i-this._tileZoom))this._setView(t,i);else{// create a queue of coordinates to load tiles from
for(var l=o.min.y;l<=o.max.y;l++)for(var u=o.min.x;u<=o.max.x;u++){var c,_=new Z(u,l);_.z=this._tileZoom,this._isValidTile(_)&&((c=this._tiles[this._tileCoordsToKey(_)])?c.current=!0:r.push(_))}// sort tile queue to load tiles in order of their distance to center
if(r.sort(function(t,e){return t.distanceTo(s)-e.distanceTo(s)}),0!==r.length){
// if it's the first batch of tiles to load
this._loading||(this._loading=!0,// @event loading: Event
// Fired when the grid layer starts loading tiles.
this.fire("loading"));// create DOM fragment to append tiles in one batch
for(var d=document.createDocumentFragment(),u=0;u<r.length;u++)this._addTile(r[u],d);this._level.el.appendChild(d)}}}}},_isValidTile:function(t){var e=this._map.options.crs;if(!e.infinite){
// don't load tile if it's out of bounds and not wrapped
var i=this._globalTileRange;if(!e.wrapLng&&(t.x<i.min.x||t.x>i.max.x)||!e.wrapLat&&(t.y<i.min.y||t.y>i.max.y))return!1}if(!this.options.bounds)return!0;// don't load tile if it doesn't intersect the bounds in options
t=this._tileCoordsToBounds(t);return R(this.options.bounds).overlaps(t)},_keyToBounds:function(t){return this._tileCoordsToBounds(this._keyToTileCoords(t))},_tileCoordsToNwSe:function(t){var e=this._map,i=this.getTileSize(),n=t.scaleBy(i),i=n.add(i);return[e.unproject(n,t.z),e.unproject(i,t.z)]},
// converts tile coordinates to its geographical bounds
_tileCoordsToBounds:function(t){t=this._tileCoordsToNwSe(t),t=new D(t[0],t[1]);return this.options.noWrap||(t=this._map.wrapLatLngBounds(t)),t},
// converts tile coordinates to key for the tile cache
_tileCoordsToKey:function(t){return t.x+":"+t.y+":"+t.z},
// converts tile cache key to coordinates
_keyToTileCoords:function(t){var e=t.split(":"),t=new Z(+e[0],+e[1]);return t.z=+e[2],t},_removeTile:function(t){var e=this._tiles[t];e&&(te(e.el),delete this._tiles[t],// @event tileunload: TileEvent
// Fired when a tile is removed (e.g. when a tile goes off the screen).
this.fire("tileunload",{tile:e.el,coords:this._keyToTileCoords(t)}))},_initTile:function(t){se(t,"leaflet-tile");var e=this.getTileSize();t.style.width=e.x+"px",t.style.height=e.y+"px",t.onselectstart=a,t.onmousemove=a,// update opacity on tiles in IE7-8 because of filter inheritance problems
$&&this.options.opacity<1&&le(t,this.options.opacity),// without this hack, tiles disappear after zoom on Chrome for Android
// https://github.com/Leaflet/Leaflet/issues/2078
it&&!nt&&(t.style.WebkitBackfaceVisibility="hidden")},_addTile:function(t,e){var i=this._getTilePos(t),n=this._tileCoordsToKey(t),o=this.createTile(this._wrapCoords(t),_(this._tileReady,this,t));this._initTile(o),// if createTile is defined with a second argument ("done" callback),
// we know that tile is async and will be ready later; otherwise
this.createTile.length<2&&
// mark tile as ready, but delay one frame for opacity animation to happen
M(_(this._tileReady,this,t,null,o)),_e(o,i),// save tile in cache
this._tiles[n]={el:o,coords:t,current:!0},e.appendChild(o),// @event tileloadstart: TileEvent
// Fired when a tile is requested and starts loading.
this.fire("tileloadstart",{tile:o,coords:t})},_tileReady:function(t,e,i){e&&
// @event tileerror: TileErrorEvent
// Fired when there is an error loading a tile.
this.fire("tileerror",{error:e,tile:i,coords:t});var n=this._tileCoordsToKey(t);(i=this._tiles[n])&&(i.loaded=+new Date,this._map._fadeAnimated?(le(i.el,0),T(this._fadeFrame),this._fadeFrame=M(this._updateOpacity,this)):(i.active=!0,this._pruneTiles()),e||(se(i.el,"leaflet-tile-loaded"),// @event tileload: TileEvent
// Fired when a tile loads.
this.fire("tileload",{tile:i.el,coords:t})),this._noTilesToLoad()&&(this._loading=!1,// @event load: Event
// Fired when the grid layer loaded all visible tiles.
this.fire("load"),$||!this._map._fadeAnimated?M(this._pruneTiles,this):
// Wait a bit more than 0.2 secs (the duration of the tile fade-in)
// to trigger a pruning.
setTimeout(_(this._pruneTiles,this),250)))},_getTilePos:function(t){return t.scaleBy(this.getTileSize()).subtract(this._level.origin)},_wrapCoords:function(t){var e=new Z(this._wrapX?o(t.x,this._wrapX):t.x,this._wrapY?o(t.y,this._wrapY):t.y);return e.z=t.z,e},_pxBoundsToTileRange:function(t){var e=this.getTileSize();return new O(t.min.unscaleBy(e).floor(),t.max.unscaleBy(e).ceil().subtract([1,1]))},_noTilesToLoad:function(){for(var t in this._tiles)if(!this._tiles[t].loaded)return!1;return!0}});// @factory L.gridLayer(options?: GridLayer options)
// Creates a new instance of GridLayer with the supplied options.
/*
   * @class TileLayer
   * @inherits GridLayer
   * @aka L.TileLayer
   * Used to load and display tile layers on the map. Note that most tile servers require attribution, which you can set under `Layer`. Extends `GridLayer`.
   *
   * @example
   *
   * ```js
   * L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png?{foo}', {foo: 'bar', attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, <a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>'}).addTo(map);
   * ```
   *
   * @section URL template
   * @example
   *
   * A string of the following form:
   *
   * ```
   * 'http://{s}.somedomain.com/blabla/{z}/{x}/{y}{r}.png'
   * ```
   *
   * `{s}` means one of the available subdomains (used sequentially to help with browser parallel requests per domain limitation; subdomain values are specified in options; `a`, `b` or `c` by default, can be omitted), `{z}` — zoom level, `{x}` and `{y}` — tile coordinates. `{r}` can be used to add "&commat;2x" to the URL to load retina tiles.
   *
   * You can use custom keys in the template, which will be [evaluated](#util-template) from TileLayer options, like this:
   *
   * ```
   * L.tileLayer('http://{s}.somedomain.com/{foo}/{z}/{x}/{y}.png', {foo: 'bar'});
   * ```
   */
var Di=Ii.extend({
// @section
// @aka TileLayer options
options:{
// @option minZoom: Number = 0
// The minimum zoom level down to which this layer will be displayed (inclusive).
minZoom:0,
// @option maxZoom: Number = 18
// The maximum zoom level up to which this layer will be displayed (inclusive).
maxZoom:18,
// @option subdomains: String|String[] = 'abc'
// Subdomains of the tile service. Can be passed in the form of one string (where each letter is a subdomain name) or an array of strings.
subdomains:"abc",
// @option errorTileUrl: String = ''
// URL to the tile image to show in place of the tile that failed to load.
errorTileUrl:"",
// @option zoomOffset: Number = 0
// The zoom number used in tile URLs will be offset with this value.
zoomOffset:0,
// @option tms: Boolean = false
// If `true`, inverses Y axis numbering for tiles (turn this on for [TMS](https://en.wikipedia.org/wiki/Tile_Map_Service) services).
tms:!1,
// @option zoomReverse: Boolean = false
// If set to true, the zoom number used in tile URLs will be reversed (`maxZoom - zoom` instead of `zoom`)
zoomReverse:!1,
// @option detectRetina: Boolean = false
// If `true` and user is on a retina display, it will request four tiles of half the specified size and a bigger zoom level in place of one to utilize the high resolution.
detectRetina:!1,
// @option crossOrigin: Boolean|String = false
// Whether the crossOrigin attribute will be added to the tiles.
// If a String is provided, all tiles will have their crossOrigin attribute set to the String provided. This is needed if you want to access tile pixel data.
// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.
crossOrigin:!1},initialize:function(t,e){this._url=t,// detecting retina displays, adjusting tileSize and zoom levels
(e=c(this,e)).detectRetina&&wt&&0<e.maxZoom&&(e.tileSize=Math.floor(e.tileSize/2),e.zoomReverse?(e.zoomOffset--,e.minZoom++):(e.zoomOffset++,e.maxZoom--),e.minZoom=Math.max(0,e.minZoom)),"string"==typeof e.subdomains&&(e.subdomains=e.subdomains.split("")),// for https://github.com/Leaflet/Leaflet/issues/137
it||this.on("tileunload",this._onTileRemove)},
// @method setUrl(url: String, noRedraw?: Boolean): this
// Updates the layer's URL template and redraws it (unless `noRedraw` is set to `true`).
// If the URL does not change, the layer will not be redrawn unless
// the noRedraw parameter is set to false.
setUrl:function(t,e){return this._url===t&&void 0===e&&(e=!0),this._url=t,e||this.redraw(),this},
// @method createTile(coords: Object, done?: Function): HTMLElement
// Called only internally, overrides GridLayer's [`createTile()`](#gridlayer-createtile)
// to return an `<img>` HTML element with the appropriate image URL given `coords`. The `done`
// callback is called when the tile has been loaded.
createTile:function(t,e){var i=document.createElement("img");return Le(i,"load",_(this._tileOnLoad,this,e,i)),Le(i,"error",_(this._tileOnError,this,e,i)),!this.options.crossOrigin&&""!==this.options.crossOrigin||(i.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin)
/*
       Alt tag is set to empty string to keep screen readers from reading URL and for compliance reasons
       http://www.w3.org/TR/WCAG20-TECHS/H67
      */,i.alt="",
/*
       Set role="presentation" to force screen readers to ignore this
       https://www.w3.org/TR/wai-aria/roles#textalternativecomputation
      */
i.setAttribute("role","presentation"),i.src=this.getTileUrl(t),i},
// @section Extension methods
// @uninheritable
// Layers extending `TileLayer` might reimplement the following method.
// @method getTileUrl(coords: Object): String
// Called only internally, returns the URL for a tile given its coordinates.
// Classes extending `TileLayer` can override this function to provide custom tile URL naming schemes.
getTileUrl:function(t){var e={r:wt?"@2x":"",s:this._getSubdomain(t),x:t.x,y:t.y,z:this._getZoomForUrl()};return this._map&&!this._map.options.crs.infinite&&(t=this._globalTileRange.max.y-t.y,this.options.tms&&(e.y=t),e["-y"]=t),f(this._url,h(e,this.options))},_tileOnLoad:function(t,e){
// For https://github.com/Leaflet/Leaflet/issues/3332
$?setTimeout(_(t,this,null,e),0):t(null,e)},_tileOnError:function(t,e,i){var n=this.options.errorTileUrl;n&&e.getAttribute("src")!==n&&(e.src=n),t(i,e)},_onTileRemove:function(t){t.tile.onload=null},_getZoomForUrl:function(){var t=this._tileZoom,e=this.options.maxZoom;return this.options.zoomReverse&&(t=e-t),t+this.options.zoomOffset},_getSubdomain:function(t){t=Math.abs(t.x+t.y)%this.options.subdomains.length;return this.options.subdomains[t]},
// stops loading all tiles in the background layer
_abortLoading:function(){var t,e;for(t in this._tiles)this._tiles[t].coords.z!==this._tileZoom&&((e=this._tiles[t].el).onload=a,e.onerror=a,e.complete||(e.src=y,te(e),delete this._tiles[t]))},_removeTile:function(t){var e=this._tiles[t];if(e)// Cancels any pending http requests associated with the tile
// unless we're on Android's stock browser,
// see https://github.com/Leaflet/Leaflet/issues/137
return st||e.el.setAttribute("src",y),Ii.prototype._removeTile.call(this,t)},_tileReady:function(t,e,i){if(this._map&&(!i||i.getAttribute("src")!==y))return Ii.prototype._tileReady.call(this,t,e,i)}});// @factory L.tilelayer(urlTemplate: String, options?: TileLayer options)
// Instantiates a tile layer object given a `URL template` and optionally an options object.
function Ri(t,e){return new Di(t,e)}
/*
   * @class TileLayer.WMS
   * @inherits TileLayer
   * @aka L.TileLayer.WMS
   * Used to display [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services as tile layers on the map. Extends `TileLayer`.
   *
   * @example
   *
   * ```js
   * var nexrad = L.tileLayer.wms("http://mesonet.agron.iastate.edu/cgi-bin/wms/nexrad/n0r.cgi", {
   * 	layers: 'nexrad-n0r-900913',
   * 	format: 'image/png',
   * 	transparent: true,
   * 	attribution: "Weather data © 2012 IEM Nexrad"
   * });
   * ```
   */var Ni=Di.extend({
// @section
// @aka TileLayer.WMS options
// If any custom options not documented here are used, they will be sent to the
// WMS server as extra parameters in each request URL. This can be useful for
// [non-standard vendor WMS parameters](http://docs.geoserver.org/stable/en/user/services/wms/vendor.html).
defaultWmsParams:{service:"WMS",request:"GetMap",
// @option layers: String = ''
// **(required)** Comma-separated list of WMS layers to show.
layers:"",
// @option styles: String = ''
// Comma-separated list of WMS styles.
styles:"",
// @option format: String = 'image/jpeg'
// WMS image format (use `'image/png'` for layers with transparency).
format:"image/jpeg",
// @option transparent: Boolean = false
// If `true`, the WMS service will return images with transparency.
transparent:!1,
// @option version: String = '1.1.1'
// Version of the WMS service to use
version:"1.1.1"},options:{
// @option crs: CRS = null
// Coordinate Reference System to use for the WMS requests, defaults to
// map CRS. Don't change this if you're not sure what it means.
crs:null,
// @option uppercase: Boolean = false
// If `true`, WMS request parameter keys will be uppercase.
uppercase:!1},initialize:function(t,e){this._url=t;var i,n=h({},this.defaultWmsParams);// all keys that are not TileLayer options go to WMS params
for(i in e)i in this.options||(n[i]=e[i]);var o=(e=c(this,e)).detectRetina&&wt?2:1,t=this.getTileSize();n.width=t.x*o,n.height=t.y*o,this.wmsParams=n},onAdd:function(t){this._crs=this.options.crs||t.options.crs,this._wmsVersion=parseFloat(this.wmsParams.version);var e=1.3<=this._wmsVersion?"crs":"srs";this.wmsParams[e]=this._crs.code,Di.prototype.onAdd.call(this,t)},getTileUrl:function(t){var e=this._tileCoordsToNwSe(t),i=this._crs,i=I(i.project(e[0]),i.project(e[1])),e=i.min,i=i.max,i=(1.3<=this._wmsVersion&&this._crs===ri?[e.y,e.x,i.y,i.x]:[e.x,e.y,i.x,i.y]).join(","),t=Di.prototype.getTileUrl.call(this,t);return t+d(this.wmsParams,t,this.options.uppercase)+(this.options.uppercase?"&BBOX=":"&bbox=")+i},
// @method setParams(params: Object, noRedraw?: Boolean): this
// Merges an object with the new parameters and re-requests tiles on the current screen (unless `noRedraw` was set to true).
setParams:function(t,e){return h(this.wmsParams,t),e||this.redraw(),this}});// @factory L.tileLayer.wms(baseUrl: String, options: TileLayer.WMS options)
// Instantiates a WMS tile layer object given a base URL of the WMS service and a WMS parameters/options object.
Di.WMS=Ni,Ri.wms=function(t,e){return new Ni(t,e)};
/*
   * @class Renderer
   * @inherits Layer
   * @aka L.Renderer
   *
   * Base class for vector renderer implementations (`SVG`, `Canvas`). Handles the
   * DOM container of the renderer, its bounds, and its zoom animation.
   *
   * A `Renderer` works as an implicit layer group for all `Path`s - the renderer
   * itself can be added or removed to the map. All paths use a renderer, which can
   * be implicit (the map will decide the type of renderer and use it automatically)
   * or explicit (using the [`renderer`](#path-renderer) option of the path).
   *
   * Do not use this class directly, use `SVG` and `Canvas` instead.
   *
   * @event update: Event
   * Fired when the renderer updates its bounds, center and zoom, for example when
   * its map has moved
   */
var ji=ai.extend({
// @section
// @aka Renderer options
options:{
// @option padding: Number = 0.1
// How much to extend the clip area around the map view (relative to its size)
// e.g. 0.1 would be 10% of map view in each direction
padding:.1,
// @option tolerance: Number = 0
// How much to extend click tolerance round a path/object on the map
tolerance:0},initialize:function(t){c(this,t),m(this),this._layers=this._layers||{}},onAdd:function(){this._container||(this._initContainer(),// defined by renderer implementations
this._zoomAnimated&&se(this._container,"leaflet-zoom-animated")),this.getPane().appendChild(this._container),this._update(),this.on("update",this._updatePaths,this)},onRemove:function(){this.off("update",this._updatePaths,this),this._destroyContainer()},getEvents:function(){var t={viewreset:this._reset,zoom:this._onZoom,moveend:this._update,zoomend:this._onZoomEnd};return this._zoomAnimated&&(t.zoomanim=this._onAnimZoom),t},_onAnimZoom:function(t){this._updateTransform(t.center,t.zoom)},_onZoom:function(){this._updateTransform(this._map.getCenter(),this._map.getZoom())},_updateTransform:function(t,e){var i=this._map.getZoomScale(e,this._zoom),n=de(this._container),o=this._map.getSize().multiplyBy(.5+this.options.padding),s=this._map.project(this._center,e),s=this._map.project(t,e).subtract(s),s=o.multiplyBy(-i).add(n).add(o).subtract(s);ft?ce(this._container,s,i):_e(this._container,s)},_reset:function(){for(var t in this._update(),this._updateTransform(this._center,this._zoom),this._layers)this._layers[t]._reset()},_onZoomEnd:function(){for(var t in this._layers)this._layers[t]._project()},_updatePaths:function(){for(var t in this._layers)this._layers[t]._update()},_update:function(){
// Update pixel bounds of renderer container (for positioning/sizing/clipping later)
// Subclasses are responsible of firing the 'update' event.
var t=this.options.padding,e=this._map.getSize(),i=this._map.containerPointToLayerPoint(e.multiplyBy(-t)).round();this._bounds=new O(i,i.add(e.multiplyBy(1+2*t)).round()),this._center=this._map.getCenter(),this._zoom=this._map.getZoom()}}),Fi=ji.extend({getEvents:function(){var t=ji.prototype.getEvents.call(this);return t.viewprereset=this._onViewPreReset,t},_onViewPreReset:function(){
// Set a flag so that a viewprereset+moveend+viewreset only updates&redraws once
this._postponeUpdatePaths=!0},onAdd:function(){ji.prototype.onAdd.call(this),// Redraw vectors since canvas is cleared upon removal,
// in case of removing the renderer itself from the map.
this._draw()},_initContainer:function(){var t=this._container=document.createElement("canvas");Le(t,"mousemove",this._onMouseMove,this),Le(t,"click dblclick mousedown mouseup contextmenu",this._onClick,this),Le(t,"mouseout",this._handleMouseOut,this),this._ctx=t.getContext("2d")},_destroyContainer:function(){T(this._redrawRequest),delete this._ctx,te(this._container),we(this._container),delete this._container},_updatePaths:function(){if(!this._postponeUpdatePaths){for(var t in this._redrawBounds=null,this._layers)this._layers[t]._update();this._redraw()}},_update:function(){var t,e,i,n;this._map._animatingZoom&&this._bounds||(ji.prototype._update.call(this),t=this._bounds,e=this._container,i=t.getSize(),n=wt?2:1,_e(e,t.min),// set canvas size (also clearing it); use double size on retina
e.width=n*i.x,e.height=n*i.y,e.style.width=i.x+"px",e.style.height=i.y+"px",wt&&this._ctx.scale(2,2),// translate so we use the same path coordinates after canvas element moves
this._ctx.translate(-t.min.x,-t.min.y),// Tell paths to redraw themselves
this.fire("update"))},_reset:function(){ji.prototype._reset.call(this),this._postponeUpdatePaths&&(this._postponeUpdatePaths=!1,this._updatePaths())},_initPath:function(t){this._updateDashArray(t);t=(this._layers[m(t)]=t)._order={layer:t,prev:this._drawLast,next:null};this._drawLast&&(this._drawLast.next=t),this._drawLast=t,this._drawFirst=this._drawFirst||this._drawLast},_addPath:function(t){this._requestRedraw(t)},_removePath:function(t){var e=t._order,i=e.next,e=e.prev;i?i.prev=e:this._drawLast=e,e?e.next=i:this._drawFirst=i,delete t._order,delete this._layers[m(t)],this._requestRedraw(t)},_updatePath:function(t){
// Redraw the union of the layer's old pixel
// bounds and the new pixel bounds.
this._extendRedrawBounds(t),t._project(),t._update(),// The redraw will extend the redraw bounds
// with the new pixel bounds.
this._requestRedraw(t)},_updateStyle:function(t){this._updateDashArray(t),this._requestRedraw(t)},_updateDashArray:function(t){if("string"==typeof t.options.dashArray){for(var e,i=t.options.dashArray.split(/[, ]+/),n=[],o=0;o<i.length;o++){// Ignore dash array containing invalid lengths
if(e=Number(i[o]),isNaN(e))return;n.push(e)}t.options._dashArray=n}else t.options._dashArray=t.options.dashArray},_requestRedraw:function(t){this._map&&(this._extendRedrawBounds(t),this._redrawRequest=this._redrawRequest||M(this._redraw,this))},_extendRedrawBounds:function(t){var e;t._pxBounds&&(e=(t.options.weight||0)+1,this._redrawBounds=this._redrawBounds||new O,this._redrawBounds.extend(t._pxBounds.min.subtract([e,e])),this._redrawBounds.extend(t._pxBounds.max.add([e,e])))},_redraw:function(){this._redrawRequest=null,this._redrawBounds&&(this._redrawBounds.min._floor(),this._redrawBounds.max._ceil()),this._clear(),// clear layers in redraw bounds
this._draw(),// draw layers
this._redrawBounds=null},_clear:function(){var t,e=this._redrawBounds;e?(t=e.getSize(),this._ctx.clearRect(e.min.x,e.min.y,t.x,t.y)):(this._ctx.save(),this._ctx.setTransform(1,0,0,1,0,0),this._ctx.clearRect(0,0,this._container.width,this._container.height),this._ctx.restore())},_draw:function(){var t,e,i=this._redrawBounds;this._ctx.save(),i&&(e=i.getSize(),this._ctx.beginPath(),this._ctx.rect(i.min.x,i.min.y,e.x,e.y),this._ctx.clip()),this._drawing=!0;for(var n=this._drawFirst;n;n=n.next)t=n.layer,(!i||t._pxBounds&&t._pxBounds.intersects(i))&&t._updatePath();this._drawing=!1,this._ctx.restore()},_updatePoly:function(t,e){if(this._drawing){var i,n,o,s,r=t._parts,a=r.length,h=this._ctx;if(a){for(h.beginPath(),i=0;i<a;i++){for(n=0,o=r[i].length;n<o;n++)s=r[i][n],h[n?"lineTo":"moveTo"](s.x,s.y);e&&h.closePath()}this._fillStroke(h,t)}}},_updateCircle:function(t){var e,i,n,o;this._drawing&&!t._empty()&&(e=t._point,i=this._ctx,n=Math.max(Math.round(t._radius),1),1!=(o=(Math.max(Math.round(t._radiusY),1)||n)/n)&&(i.save(),i.scale(1,o)),i.beginPath(),i.arc(e.x,e.y/o,n,0,2*Math.PI,!1),1!=o&&i.restore(),this._fillStroke(i,t))},_fillStroke:function(t,e){var i=e.options;i.fill&&(t.globalAlpha=i.fillOpacity,t.fillStyle=i.fillColor||i.color,t.fill(i.fillRule||"evenodd")),i.stroke&&0!==i.weight&&(t.setLineDash&&t.setLineDash(e.options&&e.options._dashArray||[]),t.globalAlpha=i.opacity,t.lineWidth=i.weight,t.strokeStyle=i.color,t.lineCap=i.lineCap,t.lineJoin=i.lineJoin,t.stroke())},
// Canvas obviously doesn't have mouse events for individual drawn objects,
// so we emulate that by calculating what's under the mouse on mousemove/click manually
_onClick:function(t){for(var e,i,n=this._map.mouseEventToLayerPoint(t),o=this._drawFirst;o;o=o.next)(e=o.layer).options.interactive&&e._containsPoint(n)&&(("click"===t.type||"preclick"!==t.type)&&this._map._draggableMoved(e)||(i=e));i&&(Ie(t),this._fireEvent([i],t))},_onMouseMove:function(t){var e;!this._map||this._map.dragging.moving()||this._map._animatingZoom||(e=this._map.mouseEventToLayerPoint(t),this._handleMouseHover(t,e))},_handleMouseOut:function(t){var e=this._hoveredLayer;e&&(
// if we're leaving the layer, fire mouseout
re(this._container,"leaflet-interactive"),this._fireEvent([e],t,"mouseout"),this._hoveredLayer=null,this._mouseHoverThrottled=!1)},_handleMouseHover:function(t,e){if(!this._mouseHoverThrottled){for(var i,n,o=this._drawFirst;o;o=o.next)(i=o.layer).options.interactive&&i._containsPoint(e)&&(n=i);n!==this._hoveredLayer&&(this._handleMouseOut(t),n&&(se(this._container,"leaflet-interactive"),// change cursor
this._fireEvent([n],t,"mouseover"),this._hoveredLayer=n)),this._hoveredLayer&&this._fireEvent([this._hoveredLayer],t),this._mouseHoverThrottled=!0,setTimeout(_(function(){this._mouseHoverThrottled=!1},this),32)}},_fireEvent:function(t,e,i){this._map._fireDOMEvent(e,i||e.type,t)},_bringToFront:function(t){var e,i,n=t._order;n&&(e=n.next,i=n.prev,e&&((e.prev=i)?i.next=e:e&&(
// Update first entry unless this is the
// single entry
this._drawFirst=e),n.prev=this._drawLast,(this._drawLast.next=n).next=null,this._drawLast=n,this._requestRedraw(t)))},_bringToBack:function(t){var e,i,n=t._order;n&&(e=n.next,(i=n.prev)&&((i.next=e)?e.prev=i:i&&(
// Update last entry unless this is the
// single entry
this._drawLast=i),n.prev=null,n.next=this._drawFirst,this._drawFirst.prev=n,this._drawFirst=n,this._requestRedraw(t)))}});
/*
   * @class Canvas
   * @inherits Renderer
   * @aka L.Canvas
   *
   * Allows vector layers to be displayed with [`<canvas>`](https://developer.mozilla.org/docs/Web/API/Canvas_API).
   * Inherits `Renderer`.
   *
   * Due to [technical limitations](http://caniuse.com/#search=canvas), Canvas is not
   * available in all web browsers, notably IE8, and overlapping geometries might
   * not display properly in some edge cases.
   *
   * @example
   *
   * Use Canvas by default for all paths in the map:
   *
   * ```js
   * var map = L.map('map', {
   * 	renderer: L.canvas()
   * });
   * ```
   *
   * Use a Canvas renderer with extra padding for specific vector geometries:
   *
   * ```js
   * var map = L.map('map');
   * var myRenderer = L.canvas({ padding: 0.5 });
   * var line = L.polyline( coordinates, { renderer: myRenderer } );
   * var circle = L.circle( center, { renderer: myRenderer } );
   * ```
   */ // @factory L.canvas(options?: Renderer options)
// Creates a Canvas renderer with the given options.
function Ui(t){return Pt?new Fi(t):null}
/*
   * Thanks to Dmitry Baranovsky and his Raphael library for inspiration!
   */var Hi=function(){try{return document.namespaces.add("lvml","urn:schemas-microsoft-com:vml"),function(t){return document.createElement("<lvml:"+t+' class="lvml">')}}catch(t){return function(t){return document.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="lvml">')}}}(),ot={_initContainer:function(){this._container=$t("div","leaflet-vml-container")},_update:function(){this._map._animatingZoom||(ji.prototype._update.call(this),this.fire("update"))},_initPath:function(t){var e=t._container=Hi("shape");se(e,"leaflet-vml-shape "+(this.options.className||"")),e.coordsize="1 1",t._path=Hi("path"),e.appendChild(t._path),this._updateStyle(t),this._layers[m(t)]=t},_addPath:function(t){var e=t._container;this._container.appendChild(e),t.options.interactive&&t.addInteractiveTarget(e)},_removePath:function(t){var e=t._container;te(e),t.removeInteractiveTarget(e),delete this._layers[m(t)]},_updateStyle:function(t){var e=t._stroke,i=t._fill,n=t.options,o=t._container;o.stroked=!!n.stroke,o.filled=!!n.fill,n.stroke?(e=e||(t._stroke=Hi("stroke")),o.appendChild(e),e.weight=n.weight+"px",e.color=n.color,e.opacity=n.opacity,n.dashArray?e.dashStyle=g(n.dashArray)?n.dashArray.join(" "):n.dashArray.replace(/( *, *)/g," "):e.dashStyle="",e.endcap=n.lineCap.replace("butt","flat"),e.joinstyle=n.lineJoin):e&&(o.removeChild(e),t._stroke=null),n.fill?(i=i||(t._fill=Hi("fill")),o.appendChild(i),i.color=n.fillColor||n.color,i.opacity=n.fillOpacity):i&&(o.removeChild(i),t._fill=null)},_updateCircle:function(t){var e=t._point.round(),i=Math.round(t._radius),n=Math.round(t._radiusY||i);this._setPath(t,t._empty()?"M0 0":"AL "+e.x+","+e.y+" "+i+","+n+" 0,23592600")},_setPath:function(t,e){t._path.v=e},_bringToFront:function(t){ie(t._container)},_bringToBack:function(t){ne(t._container)}},Gi=Mt?Hi:Y,Wi=ji.extend({getEvents:function(){var t=ji.prototype.getEvents.call(this);return t.zoomstart=this._onZoomStart,t},_initContainer:function(){this._container=Gi("svg"),// makes it possible to click through svg root; we'll reset it back in individual paths
this._container.setAttribute("pointer-events","none"),this._rootGroup=Gi("g"),this._container.appendChild(this._rootGroup)},_destroyContainer:function(){te(this._container),we(this._container),delete this._container,delete this._rootGroup,delete this._svgSize},_onZoomStart:function(){
// Drag-then-pinch interactions might mess up the center and zoom.
// In this case, the easiest way to prevent this is re-do the renderer
//   bounds and padding when the zooming starts.
this._update()},_update:function(){var t,e,i;this._map._animatingZoom&&this._bounds||(ji.prototype._update.call(this),e=(t=this._bounds).getSize(),i=this._container,// set size of svg-container if changed
this._svgSize&&this._svgSize.equals(e)||(this._svgSize=e,i.setAttribute("width",e.x),i.setAttribute("height",e.y)),// movement: update container viewBox so that we don't have to change coordinates of individual layers
_e(i,t.min),i.setAttribute("viewBox",[t.min.x,t.min.y,e.x,e.y].join(" ")),this.fire("update"))},
// methods below are called by vector layers implementations
_initPath:function(t){var e=t._path=Gi("path");// @namespace Path
// @option className: String = null
// Custom class name set on an element. Only for SVG renderer.
t.options.className&&se(e,t.options.className),t.options.interactive&&se(e,"leaflet-interactive"),this._updateStyle(t),this._layers[m(t)]=t},_addPath:function(t){this._rootGroup||this._initContainer(),this._rootGroup.appendChild(t._path),t.addInteractiveTarget(t._path)},_removePath:function(t){te(t._path),t.removeInteractiveTarget(t._path),delete this._layers[m(t)]},_updatePath:function(t){t._project(),t._update()},_updateStyle:function(t){var e=t._path,t=t.options;e&&(t.stroke?(e.setAttribute("stroke",t.color),e.setAttribute("stroke-opacity",t.opacity),e.setAttribute("stroke-width",t.weight),e.setAttribute("stroke-linecap",t.lineCap),e.setAttribute("stroke-linejoin",t.lineJoin),t.dashArray?e.setAttribute("stroke-dasharray",t.dashArray):e.removeAttribute("stroke-dasharray"),t.dashOffset?e.setAttribute("stroke-dashoffset",t.dashOffset):e.removeAttribute("stroke-dashoffset")):e.setAttribute("stroke","none"),t.fill?(e.setAttribute("fill",t.fillColor||t.color),e.setAttribute("fill-opacity",t.fillOpacity),e.setAttribute("fill-rule",t.fillRule||"evenodd")):e.setAttribute("fill","none"))},_updatePoly:function(t,e){this._setPath(t,X(t._parts,e))},_updateCircle:function(t){var e=t._point,i=Math.max(Math.round(t._radius),1),n="a"+i+","+(Math.max(Math.round(t._radiusY),1)||i)+" 0 1,0 ",i=t._empty()?"M0 0":"M"+(e.x-i)+","+e.y+n+2*i+",0 "+n+2*-i+",0 ";// drawing a circle with two half-arcs
this._setPath(t,i)},_setPath:function(t,e){t._path.setAttribute("d",e)},
// SVG does not have the concept of zIndex so we resort to changing the DOM order of elements
_bringToFront:function(t){ie(t._path)},_bringToBack:function(t){ne(t._path)}});
/*
   * @class SVG
   *
   *
   * VML was deprecated in 2012, which means VML functionality exists only for backwards compatibility
   * with old versions of Internet Explorer.
   */
// mixin to redefine some SVG methods to handle VML syntax which is similar but with some differences
// @namespace SVG
// @factory L.svg(options?: Renderer options)
// Creates a SVG renderer with the given options.
function Vi(t){return Ct||Mt?new Wi(t):null}Mt&&Wi.include(ot),je.include({
// @namespace Map; @method getRenderer(layer: Path): Renderer
// Returns the instance of `Renderer` that should be used to render the given
// `Path`. It will ensure that the `renderer` options of the map and paths
// are respected, and that the renderers do exist on the map.
getRenderer:function(t){
// @namespace Path; @option renderer: Renderer
// Use this specific instance of `Renderer` for this path. Takes
// precedence over the map's [default renderer](#map-renderer).
t=(t=t.options.renderer||this._getPaneRenderer(t.options.pane)||this.options.renderer||this._renderer)||(this._renderer=this._createRenderer());return this.hasLayer(t)||this.addLayer(t),t},_getPaneRenderer:function(t){if("overlayPane"===t||void 0===t)return!1;var e=this._paneRenderers[t];return void 0===e&&(e=this._createRenderer({pane:t}),this._paneRenderers[t]=e),e},_createRenderer:function(t){
// @namespace Map; @option preferCanvas: Boolean = false
// Whether `Path`s should be rendered on a `Canvas` renderer.
// By default, all `Path`s are rendered in a `SVG` renderer.
return this.options.preferCanvas&&Ui(t)||Vi(t)}});
/*
   * L.Rectangle extends Polygon and creates a rectangle when passed a LatLngBounds object.
   */
/*
   * @class Rectangle
   * @aka L.Rectangle
   * @inherits Polygon
   *
   * A class for drawing rectangle overlays on a map. Extends `Polygon`.
   *
   * @example
   *
   * ```js
   * // define rectangle geographical bounds
   * var bounds = [[54.559322, -5.767822], [56.1210604, -3.021240]];
   *
   * // create an orange rectangle
   * L.rectangle(bounds, {color: "#ff7800", weight: 1}).addTo(map);
   *
   * // zoom the map to the rectangle bounds
   * map.fitBounds(bounds);
   * ```
   *
   */
var qi=vi.extend({initialize:function(t,e){vi.prototype.initialize.call(this,this._boundsToLatLngs(t),e)},
// @method setBounds(latLngBounds: LatLngBounds): this
// Redraws the rectangle with the passed bounds.
setBounds:function(t){return this.setLatLngs(this._boundsToLatLngs(t))},_boundsToLatLngs:function(t){return[(t=R(t)).getSouthWest(),t.getNorthWest(),t.getNorthEast(),t.getSouthEast()]}});// @factory L.rectangle(latLngBounds: LatLngBounds, options?: Polyline options)
Wi.create=Gi,Wi.pointsToPath=X,yi.geometryToLayer=Li,yi.coordsToLatLng=wi,yi.coordsToLatLngs=bi,yi.latLngToCoords=Pi,yi.latLngsToCoords=Ci,yi.getFeature=Mi,yi.asFeature=Ti,
/*
   * L.Handler.BoxZoom is used to add shift-drag zoom interaction to the map
   * (zoom to a selected bounding box), enabled by default.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @option boxZoom: Boolean = true
// Whether the map can be zoomed to a rectangular area specified by
// dragging the mouse while pressing the shift key.
boxZoom:!0});S=mt.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane,this._resetStateTimeout=0,t.on("unload",this._destroy,this)},addHooks:function(){Le(this._container,"mousedown",this._onMouseDown,this)},removeHooks:function(){we(this._container,"mousedown",this._onMouseDown,this)},moved:function(){return this._moved},_destroy:function(){te(this._pane),delete this._pane},_resetState:function(){this._resetStateTimeout=0,this._moved=!1},_clearDeferredResetState:function(){0!==this._resetStateTimeout&&(clearTimeout(this._resetStateTimeout),this._resetStateTimeout=0)},_onMouseDown:function(t){if(!t.shiftKey||1!==t.which&&1!==t.button)return!1;// Clear the deferred resetState if it hasn't executed yet, otherwise it
// will interrupt the interaction and orphan a box element in the container.
this._clearDeferredResetState(),this._resetState(),Gt(),pe(),this._startPoint=this._map.mouseEventToContainerPoint(t),Le(document,{contextmenu:Ee,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseMove:function(t){this._moved||(this._moved=!0,this._box=$t("div","leaflet-zoom-box",this._container),se(this._container,"leaflet-crosshair"),this._map.fire("boxzoomstart")),this._point=this._map.mouseEventToContainerPoint(t);var e=new O(this._point,this._startPoint),t=e.getSize();_e(this._box,e.min),this._box.style.width=t.x+"px",this._box.style.height=t.y+"px"},_finish:function(){this._moved&&(te(this._box),re(this._container,"leaflet-crosshair")),Wt(),me(),we(document,{contextmenu:Ee,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseUp:function(t){1!==t.which&&1!==t.button||(this._finish(),this._moved&&(// Postpone to next JS tick so internal click event handling
// still see it as "moved".
this._clearDeferredResetState(),this._resetStateTimeout=setTimeout(_(this._resetState,this),0),t=new D(this._map.containerPointToLatLng(this._startPoint),this._map.containerPointToLatLng(this._point)),this._map.fitBounds(t).fire("boxzoomend",{boxZoomBounds:t})))},_onKeyDown:function(t){27===t.keyCode&&this._finish()}});// @section Handlers
// @property boxZoom: Handler
// Box (shift-drag with mouse) zoom handler.
je.addInitHook("addHandler","boxZoom",S),
/*
   * L.Handler.DoubleClickZoom is used to handle double-click zoom on the map, enabled by default.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @option doubleClickZoom: Boolean|String = true
// Whether the map can be zoomed in by double clicking on it and
// zoomed out by double clicking while holding shift. If passed
// `'center'`, double-click zoom will zoom to the center of the
//  view regardless of where the mouse was.
doubleClickZoom:!0});q=mt.extend({addHooks:function(){this._map.on("dblclick",this._onDoubleClick,this)},removeHooks:function(){this._map.off("dblclick",this._onDoubleClick,this)},_onDoubleClick:function(t){var e=this._map,i=e.getZoom(),n=e.options.zoomDelta,n=t.originalEvent.shiftKey?i-n:i+n;"center"===e.options.doubleClickZoom?e.setZoom(n):e.setZoomAround(t.containerPoint,n)}});// @section Handlers
//
// Map properties include interaction handlers that allow you to control
// interaction behavior in runtime, enabling or disabling certain features such
// as dragging or touch zoom (see `Handler` methods). For example:
//
// ```js
// map.doubleClickZoom.disable();
// ```
//
// @property doubleClickZoom: Handler
// Double click zoom handler.
je.addInitHook("addHandler","doubleClickZoom",q),
/*
   * L.Handler.MapDrag is used to make the map draggable (with panning inertia), enabled by default.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @option dragging: Boolean = true
// Whether the map be draggable with mouse/touch or not.
dragging:!0,
// @section Panning Inertia Options
// @option inertia: Boolean = *
// If enabled, panning of the map will have an inertia effect where
// the map builds momentum while dragging and continues moving in
// the same direction for some time. Feels especially nice on touch
// devices. Enabled by default unless running on old Android devices.
inertia:!nt,
// @option inertiaDeceleration: Number = 3000
// The rate with which the inertial movement slows down, in pixels/second².
inertiaDeceleration:3400,
// px/s^2
// @option inertiaMaxSpeed: Number = Infinity
// Max speed of the inertial movement, in pixels/second.
inertiaMaxSpeed:1/0,
// px/s
// @option easeLinearity: Number = 0.2
easeLinearity:.2,
// TODO refactor, move to CRS
// @option worldCopyJump: Boolean = false
// With this option enabled, the map tracks when you pan to another "copy"
// of the world and seamlessly jumps to the original one so that all overlays
// like markers and vector layers are still visible.
worldCopyJump:!1,
// @option maxBoundsViscosity: Number = 0.0
// If `maxBounds` is set, this option will control how solid the bounds
// are when dragging the map around. The default value of `0.0` allows the
// user to drag outside the bounds at normal speed, higher values will
// slow down map dragging outside bounds, and `1.0` makes the bounds fully
// solid, preventing the user from dragging outside the bounds.
maxBoundsViscosity:0});K=mt.extend({addHooks:function(){var t;this._draggable||(t=this._map,this._draggable=new Xe(t._mapPane,t._container),this._draggable.on({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this),this._draggable.on("predrag",this._onPreDragLimit,this),t.options.worldCopyJump&&(this._draggable.on("predrag",this._onPreDragWrap,this),t.on("zoomend",this._onZoomEnd,this),t.whenReady(this._onZoomEnd,this))),se(this._map._container,"leaflet-grab leaflet-touch-drag"),this._draggable.enable(),this._positions=[],this._times=[]},removeHooks:function(){re(this._map._container,"leaflet-grab"),re(this._map._container,"leaflet-touch-drag"),this._draggable.disable()},moved:function(){return this._draggable&&this._draggable._moved},moving:function(){return this._draggable&&this._draggable._moving},_onDragStart:function(){var t,e=this._map;e._stop(),this._map.options.maxBounds&&this._map.options.maxBoundsViscosity?(t=R(this._map.options.maxBounds),this._offsetLimit=I(this._map.latLngToContainerPoint(t.getNorthWest()).multiplyBy(-1),this._map.latLngToContainerPoint(t.getSouthEast()).multiplyBy(-1).add(this._map.getSize())),this._viscosity=Math.min(1,Math.max(0,this._map.options.maxBoundsViscosity))):this._offsetLimit=null,e.fire("movestart").fire("dragstart"),e.options.inertia&&(this._positions=[],this._times=[])},_onDrag:function(t){var e,i;this._map.options.inertia&&(e=this._lastTime=+new Date,i=this._lastPos=this._draggable._absPos||this._draggable._newPos,this._positions.push(i),this._times.push(e),this._prunePositions(e)),this._map.fire("move",t).fire("drag",t)},_prunePositions:function(t){for(;1<this._positions.length&&50<t-this._times[0];)this._positions.shift(),this._times.shift()},_onZoomEnd:function(){var t=this._map.getSize().divideBy(2),e=this._map.latLngToLayerPoint([0,0]);this._initialWorldOffset=e.subtract(t).x,this._worldWidth=this._map.getPixelWorldBounds().getSize().x},_viscousLimit:function(t,e){return t-(t-e)*this._viscosity},_onPreDragLimit:function(){var t,e;this._viscosity&&this._offsetLimit&&(t=this._draggable._newPos.subtract(this._draggable._startPos),e=this._offsetLimit,t.x<e.min.x&&(t.x=this._viscousLimit(t.x,e.min.x)),t.y<e.min.y&&(t.y=this._viscousLimit(t.y,e.min.y)),t.x>e.max.x&&(t.x=this._viscousLimit(t.x,e.max.x)),t.y>e.max.y&&(t.y=this._viscousLimit(t.y,e.max.y)),this._draggable._newPos=this._draggable._startPos.add(t))},_onPreDragWrap:function(){
// TODO refactor to be able to adjust map pane position after zoom
var t=this._worldWidth,e=Math.round(t/2),i=this._initialWorldOffset,n=this._draggable._newPos.x,o=(n-e+i)%t+e-i,e=(n+e+i)%t-e-i,e=Math.abs(o+i)<Math.abs(e+i)?o:e;this._draggable._absPos=this._draggable._newPos.clone(),this._draggable._newPos.x=e},_onDragEnd:function(t){var e,i,n,o,s=this._map,r=s.options,a=!r.inertia||this._times.length<2;s.fire("dragend",t),a?s.fire("moveend"):(this._prunePositions(+new Date),i=this._lastPos.subtract(this._positions[0]),t=(this._lastTime-this._times[0])/1e3,e=r.easeLinearity,i=(a=i.multiplyBy(e/t)).distanceTo([0,0]),t=Math.min(r.inertiaMaxSpeed,i),i=a.multiplyBy(t/i),n=t/(r.inertiaDeceleration*e),(o=i.multiplyBy(-n/2).round()).x||o.y?(o=s._limitOffset(o,s.options.maxBounds),M(function(){s.panBy(o,{duration:n,easeLinearity:e,noMoveStart:!0,animate:!0})})):s.fire("moveend"))}});// @section Handlers
// @property dragging: Handler
// Map dragging handler (by both mouse and touch).
je.addInitHook("addHandler","dragging",K),
/*
   * L.Map.Keyboard is handling keyboard interaction with the map, enabled by default.
   */
// @namespace Map
// @section Keyboard Navigation Options
je.mergeOptions({
// @option keyboard: Boolean = true
// Makes the map focusable and allows users to navigate the map with keyboard
// arrows and `+`/`-` keys.
keyboard:!0,
// @option keyboardPanDelta: Number = 80
// Amount of pixels to pan when pressing an arrow key.
keyboardPanDelta:80});G=mt.extend({keyCodes:{left:[37],right:[39],down:[40],up:[38],zoomIn:[187,107,61,171],zoomOut:[189,109,54,173]},initialize:function(t){this._map=t,this._setPanDelta(t.options.keyboardPanDelta),this._setZoomDelta(t.options.zoomDelta)},addHooks:function(){var t=this._map._container;// make the container focusable by tabbing
t.tabIndex<=0&&(t.tabIndex="0"),Le(t,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.on({focus:this._addHooks,blur:this._removeHooks},this)},removeHooks:function(){this._removeHooks(),we(this._map._container,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.off({focus:this._addHooks,blur:this._removeHooks},this)},_onMouseDown:function(){var t,e,i;this._focused||(t=document.body,i=document.documentElement,e=t.scrollTop||i.scrollTop,i=t.scrollLeft||i.scrollLeft,this._map._container.focus(),window.scrollTo(i,e))},_onFocus:function(){this._focused=!0,this._map.fire("focus")},_onBlur:function(){this._focused=!1,this._map.fire("blur")},_setPanDelta:function(t){for(var e=this._panKeys={},i=this.keyCodes,n=0,o=i.left.length;n<o;n++)e[i.left[n]]=[-1*t,0];for(n=0,o=i.right.length;n<o;n++)e[i.right[n]]=[t,0];for(n=0,o=i.down.length;n<o;n++)e[i.down[n]]=[0,t];for(n=0,o=i.up.length;n<o;n++)e[i.up[n]]=[0,-1*t]},_setZoomDelta:function(t){for(var e=this._zoomKeys={},i=this.keyCodes,n=0,o=i.zoomIn.length;n<o;n++)e[i.zoomIn[n]]=t;for(n=0,o=i.zoomOut.length;n<o;n++)e[i.zoomOut[n]]=-t},_addHooks:function(){Le(document,"keydown",this._onKeyDown,this)},_removeHooks:function(){we(document,"keydown",this._onKeyDown,this)},_onKeyDown:function(t){if(!(t.altKey||t.ctrlKey||t.metaKey)){var e,i=t.keyCode,n=this._map;if(i in this._panKeys)n._panAnim&&n._panAnim._inProgress||(e=this._panKeys[i],t.shiftKey&&(e=B(e).multiplyBy(3)),n.panBy(e),n.options.maxBounds&&n.panInsideBounds(n.options.maxBounds));else if(i in this._zoomKeys)n.setZoom(n.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[i]);else{if(27!==i||!n._popup||!n._popup.options.closeOnEscapeKey)return;n.closePopup()}Ee(t)}}});// @section Handlers
// @section Handlers
// @property keyboard: Handler
// Keyboard navigation handler.
je.addInitHook("addHandler","keyboard",G),
/*
   * L.Handler.ScrollWheelZoom is used by L.Map to enable mouse scroll wheel zoom on the map.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @section Mouse wheel options
// @option scrollWheelZoom: Boolean|String = true
// Whether the map can be zoomed by using the mouse wheel. If passed `'center'`,
// it will zoom to the center of the view regardless of where the mouse was.
scrollWheelZoom:!0,
// @option wheelDebounceTime: Number = 40
// Limits the rate at which a wheel can fire (in milliseconds). By default
// user can't zoom via wheel more often than once per 40 ms.
wheelDebounceTime:40,
// @option wheelPxPerZoomLevel: Number = 60
// How many scroll pixels (as reported by [L.DomEvent.getWheelDelta](#domevent-getwheeldelta))
// mean a change of one full zoom level. Smaller values will make wheel-zooming
// faster (and vice versa).
wheelPxPerZoomLevel:60});_t=mt.extend({addHooks:function(){Le(this._map._container,"wheel",this._onWheelScroll,this),this._delta=0},removeHooks:function(){we(this._map._container,"wheel",this._onWheelScroll,this)},_onWheelScroll:function(t){var e=Be(t),i=this._map.options.wheelDebounceTime;this._delta+=e,this._lastMousePos=this._map.mouseEventToContainerPoint(t),this._startTime||(this._startTime=+new Date);i=Math.max(i-(+new Date-this._startTime),0);clearTimeout(this._timer),this._timer=setTimeout(_(this._performZoom,this),i),Ee(t)},_performZoom:function(){var t=this._map,e=t.getZoom(),i=this._map.options.zoomSnap||0;t._stop();// stop panning and fly animations if any
// map the delta with a sigmoid function to -4..4 range leaning on -1..1
var n=this._delta/(4*this._map.options.wheelPxPerZoomLevel),n=4*Math.log(2/(1+Math.exp(-Math.abs(n))))/Math.LN2,n=i?Math.ceil(n/i)*i:n,n=t._limitZoom(e+(0<this._delta?n:-n))-e;this._delta=0,this._startTime=null,n&&("center"===t.options.scrollWheelZoom?t.setZoom(e+n):t.setZoomAround(this._lastMousePos,e+n))}});// @section Handlers
// @property scrollWheelZoom: Handler
// Scroll wheel zoom handler.
je.addInitHook("addHandler","scrollWheelZoom",_t),
/*
   * L.Map.Tap is used to enable mobile hacks like quick taps and long hold.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @section Touch interaction options
// @option tap: Boolean = true
// Enables mobile hacks for supporting instant taps (fixing 200ms click
// delay on iOS/Android) and touch holds (fired as `contextmenu` events).
tap:!0,
// @option tapTolerance: Number = 15
// The max number of pixels a user can shift his finger during touch
// for it to be considered a valid tap.
tapTolerance:15});H=mt.extend({addHooks:function(){Le(this._map._container,"touchstart",this._onDown,this)},removeHooks:function(){we(this._map._container,"touchstart",this._onDown,this)},_onDown:function(t){if(t.touches){// don't simulate click or track longpress if more than 1 touch
if(Se(t),this._fireClick=!0,1<t.touches.length)return this._fireClick=!1,void clearTimeout(this._holdTimeout);var e=t.touches[0],t=e.target;this._startPos=this._newPos=new Z(e.clientX,e.clientY),// if touching a link, highlight it
t.tagName&&"a"===t.tagName.toLowerCase()&&se(t,"leaflet-active"),// simulate long hold but setting a timeout
this._holdTimeout=setTimeout(_(function(){this._isTapValid()&&(this._fireClick=!1,this._onUp(),this._simulateEvent("contextmenu",e))},this),1e3),this._simulateEvent("mousedown",e),Le(document,{touchmove:this._onMove,touchend:this._onUp},this)}},_onUp:function(t){var e;clearTimeout(this._holdTimeout),we(document,{touchmove:this._onMove,touchend:this._onUp},this),this._fireClick&&t&&t.changedTouches&&((t=(e=t.changedTouches[0]).target)&&t.tagName&&"a"===t.tagName.toLowerCase()&&re(t,"leaflet-active"),this._simulateEvent("mouseup",e),// simulate click if the touch didn't move too much
this._isTapValid()&&this._simulateEvent("click",e))},_isTapValid:function(){return this._newPos.distanceTo(this._startPos)<=this._map.options.tapTolerance},_onMove:function(t){t=t.touches[0];this._newPos=new Z(t.clientX,t.clientY),this._simulateEvent("mousemove",t)},_simulateEvent:function(t,e){var i=document.createEvent("MouseEvents");i._simulated=!0,e.target._simulatedClick=!0,i.initMouseEvent(t,!0,!0,window,1,e.screenX,e.screenY,e.clientX,e.clientY,!1,!1,!1,!1,0,null),e.target.dispatchEvent(i)}});// @section Handlers
// @property tap: Handler
// Mobile touch hacks (quick tap and touch hold) handler.
!Lt||yt&&!lt||je.addInitHook("addHandler","tap",H),
/*
   * L.Handler.TouchZoom is used by L.Map to add pinch zoom on supported mobile browsers.
   */
// @namespace Map
// @section Interaction Options
je.mergeOptions({
// @section Touch interaction options
// @option touchZoom: Boolean|String = *
// Whether the map can be zoomed by touch-dragging with two fingers. If
// passed `'center'`, it will zoom to the center of the view regardless of
// where the touch events (fingers) were. Enabled for touch-capable web
// browsers except for old Androids.
touchZoom:Lt&&!nt,
// @option bounceAtZoomLimits: Boolean = true
// Set it to false if you don't want the map to zoom beyond min/max zoom
// and then bounce back when pinch-zooming.
bounceAtZoomLimits:!0});ot=mt.extend({addHooks:function(){se(this._map._container,"leaflet-touch-zoom"),Le(this._map._container,"touchstart",this._onTouchStart,this)},removeHooks:function(){re(this._map._container,"leaflet-touch-zoom"),we(this._map._container,"touchstart",this._onTouchStart,this)},_onTouchStart:function(t){var e,i,n=this._map;!t.touches||2!==t.touches.length||n._animatingZoom||this._zooming||(e=n.mouseEventToContainerPoint(t.touches[0]),i=n.mouseEventToContainerPoint(t.touches[1]),this._centerPoint=n.getSize()._divideBy(2),this._startLatLng=n.containerPointToLatLng(this._centerPoint),"center"!==n.options.touchZoom&&(this._pinchStartLatLng=n.containerPointToLatLng(e.add(i)._divideBy(2))),this._startDist=e.distanceTo(i),this._startZoom=n.getZoom(),this._moved=!1,this._zooming=!0,n._stop(),Le(document,"touchmove",this._onTouchMove,this),Le(document,"touchend",this._onTouchEnd,this),Se(t))},_onTouchMove:function(t){if(t.touches&&2===t.touches.length&&this._zooming){var e=this._map,i=e.mouseEventToContainerPoint(t.touches[0]),n=e.mouseEventToContainerPoint(t.touches[1]),o=i.distanceTo(n)/this._startDist;if(this._zoom=e.getScaleZoom(o,this._startZoom),!e.options.bounceAtZoomLimits&&(this._zoom<e.getMinZoom()&&o<1||this._zoom>e.getMaxZoom()&&1<o)&&(this._zoom=e._limitZoom(this._zoom)),"center"===e.options.touchZoom){if(this._center=this._startLatLng,1==o)return}else{
// Get delta from pinch to center, so centerLatLng is delta applied to initial pinchLatLng
n=i._add(n)._divideBy(2)._subtract(this._centerPoint);if(1==o&&0===n.x&&0===n.y)return;this._center=e.unproject(e.project(this._pinchStartLatLng,this._zoom).subtract(n),this._zoom)}this._moved||(e._moveStart(!0,!1),this._moved=!0),T(this._animRequest);e=_(e._move,e,this._center,this._zoom,{pinch:!0,round:!1});this._animRequest=M(e,this,!0),Se(t)}},_onTouchEnd:function(){this._moved&&this._zooming?(this._zooming=!1,T(this._animRequest),we(document,"touchmove",this._onTouchMove,this),we(document,"touchend",this._onTouchEnd,this),// Pinch updates GridLayers' levels only when zoomSnap is off, so zoomSnap becomes noUpdate.
this._map.options.zoomAnimation?this._map._animateZoom(this._center,this._map._limitZoom(this._zoom),!0,this._map.options.zoomSnap):this._map._resetView(this._center,this._map._limitZoom(this._zoom))):this._zooming=!1}});// @section Handlers
// @property touchZoom: Handler
// Touch zoom handler.
je.addInitHook("addHandler","touchZoom",ot),je.BoxZoom=S,je.DoubleClickZoom=q,je.Drag=K,je.Keyboard=G,je.ScrollWheelZoom=_t,je.Tap=H,je.TouchZoom=ot,t.version="1.7.1",t.Control=Fe,t.control=pt,t.Browser=rt,t.Evented=E,t.Mixin=gt,t.Util=k,t.Class=z,t.Handler=mt,t.extend=h,t.bind=_,t.stamp=m,t.setOptions=c,t.DomEvent=ct,t.DomUtil=ut,t.PosAnimation=Ne,t.Draggable=Xe,t.LineUtil=vt,t.PolyUtil=J,t.Point=Z,t.point=B,t.Bounds=O,t.bounds=I,t.Transformation=W,t.transformation=V,t.Projection=at,t.LatLng=N,t.latLng=j,t.LatLngBounds=D,t.latLngBounds=R,t.CRS=F,t.GeoJSON=yi,t.geoJSON=ki,t.geoJson=ht,t.Layer=ai,t.LayerGroup=hi,t.layerGroup=function(t,e){return new hi(t,e)},t.FeatureGroup=li,t.featureGroup=function(t,e){return new li(t,e)},t.ImageOverlay=zi,t.imageOverlay=function(t,e,i){return new zi(t,e,i)},t.VideoOverlay=Si,t.videoOverlay=// @factory L.videoOverlay(video: String|Array|HTMLVideoElement, bounds: LatLngBounds, options?: VideoOverlay options)
// Instantiates an image overlay object given the URL of the video (or array of URLs, or even a video element) and the
// geographical bounds it is tied to.
function(t,e,i){return new Si(t,e,i)},t.SVGOverlay=Ei,t.svgOverlay=function(t,e,i){return new Ei(t,e,i)},t.DivOverlay=Zi,t.Popup=Ai,t.popup=function(t,e){return new Ai(t,e)},t.Tooltip=Bi,t.tooltip=function(t,e){return new Bi(t,e)},t.Icon=ui,t.icon=// @factory L.icon(options: Icon options)
// Creates an icon instance with the given options.
function(t){return new ui(t)},t.DivIcon=Oi,t.divIcon=function(t){return new Oi(t)},t.Marker=di,t.marker=// factory L.marker(latlng: LatLng, options? : Marker options)
// @factory L.marker(latlng: LatLng, options? : Marker options)
// Instantiates a Marker object given a geographical point and optionally an options object.
function(t,e){return new di(t,e)},t.TileLayer=Di,t.tileLayer=Ri,t.GridLayer=Ii,t.gridLayer=function(t){return new Ii(t)},t.SVG=Wi,t.svg=Vi,t.Renderer=ji,t.Canvas=Fi,t.canvas=Ui,t.Path=pi,t.CircleMarker=mi,t.circleMarker=// @factory L.circleMarker(latlng: LatLng, options?: CircleMarker options)
// Instantiates a circle marker object given a geographical point, and an optional options object.
function(t,e){return new mi(t,e)},t.Circle=fi,t.circle=function(t,e,i){return new fi(t,e,i)},t.Polyline=gi,t.polyline=function(t,e){return new gi(t,e)},t.Polygon=vi,t.polygon=function(t,e){return new vi(t,e)},t.Rectangle=qi,t.rectangle=function(t,e){return new qi(t,e)},t.Map=je,t.map=// @section
// @factory L.map(id: String, options?: Map options)
// Instantiates a map object given the DOM ID of a `<div>` element
// and optionally an object literal with `Map options`.
//
// @alternative
// @factory L.map(el: HTMLElement, options?: Map options)
// Instantiates a map object given an instance of a `<div>` HTML element
// and optionally an object literal with `Map options`.
function(t,e){return new je(t,e)};var Ki=window.L;t.noConflict=function(){return window.L=Ki,this},// Always export us to window global (see #2364)
window.L=t}),L.Control.Fullscreen=L.Control.extend({options:{position:"topleft",title:{false:"View Fullscreen",true:"Exit Fullscreen"}},onAdd:function(t){var e=L.DomUtil.create("div","leaflet-control-fullscreen leaflet-bar leaflet-control");return this.link=L.DomUtil.create("a","leaflet-control-fullscreen-button leaflet-bar-part",e),this.link.href="#",this._map=t,this._map.on("fullscreenchange",this._toggleTitle,this),this._toggleTitle(),L.DomEvent.on(this.link,"click",this._click,this),e},_click:function(t){L.DomEvent.stopPropagation(t),L.DomEvent.preventDefault(t),this._map.toggleFullscreen(this.options)},_toggleTitle:function(){this.link.title=this.options.title[this._map.isFullscreen()]}}),L.Map.include({isFullscreen:function(){return this._isFullscreen||!1},toggleFullscreen:function(t){var e=this.getContainer();this.isFullscreen()?t&&t.pseudoFullscreen?this._disablePseudoFullscreen(e):document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitCancelFullScreen?document.webkitCancelFullScreen():document.msExitFullscreen?document.msExitFullscreen():this._disablePseudoFullscreen(e):t&&t.pseudoFullscreen?this._enablePseudoFullscreen(e):e.requestFullscreen?e.requestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen?e.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):e.msRequestFullscreen?e.msRequestFullscreen():this._enablePseudoFullscreen(e)},_enablePseudoFullscreen:function(t){L.DomUtil.addClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!0),this.fire("fullscreenchange")},_disablePseudoFullscreen:function(t){L.DomUtil.removeClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!1),this.fire("fullscreenchange")},_setFullscreen:function(t){this._isFullscreen=t;var e=this.getContainer();t?L.DomUtil.addClass(e,"leaflet-fullscreen-on"):L.DomUtil.removeClass(e,"leaflet-fullscreen-on"),this.invalidateSize()},_onFullscreenChange:function(){var t=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement;t!==this.getContainer()||this._isFullscreen?t!==this.getContainer()&&this._isFullscreen&&(this._setFullscreen(!1),this.fire("fullscreenchange")):(this._setFullscreen(!0),this.fire("fullscreenchange"))}}),L.Map.mergeOptions({fullscreenControl:!1}),L.Map.addInitHook(function(){var t,e;this.options.fullscreenControl&&(this.fullscreenControl=new L.Control.Fullscreen(this.options.fullscreenControl),this.addControl(this.fullscreenControl)),"onfullscreenchange"in document?t="fullscreenchange":"onmozfullscreenchange"in document?t="mozfullscreenchange":"onwebkitfullscreenchange"in document?t="webkitfullscreenchange":"onmsfullscreenchange"in document&&(t="MSFullscreenChange"),t&&(e=L.bind(this._onFullscreenChange,this),this.whenReady(function(){L.DomEvent.on(document,t,e)}),this.on("unload",function(){L.DomEvent.off(document,t,e)}))}),L.control.fullscreen=function(t){return new L.Control.Fullscreen(t)},function(t,e){"object"===("undefined"==typeof exports?"undefined":_typeof(exports))&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define("leafletGestureHandling",["exports"],e):e(t.leafletGestureHandling={})}(this,function(t){"use strict";var n={
//Arabic
ar:{touch:"استخدم إصبعين لتحريك الخريطة",scroll:"‏استخدم ctrl + scroll لتصغير/تكبير الخريطة",scrollMac:"يمكنك استخدام ⌘ + التمرير لتكبير/تصغير الخريطة"},
//Bulgarian
bg:{touch:"Използвайте два пръста, за да преместите картата",scroll:"Задръжте бутона Ctrl натиснат, докато превъртате, за да промените мащаба на картата",scrollMac:"Задръжте бутона ⌘ натиснат, докато превъртате, за да промените мащаба на картата"},
//Bengali
bn:{touch:"মানচিত্রটিকে সরাতে দুটি আঙ্গুল ব্যবহার করুন",scroll:"ম্যাপ জুম করতে ctrl + scroll ব্যবহার করুন",scrollMac:"ম্যাপে জুম করতে ⌘ বোতাম টিপে স্ক্রল করুন"},
//Catalan
ca:{touch:"Fes servir dos dits per moure el mapa",scroll:"Prem la tecla Control mentre et desplaces per apropar i allunyar el mapa",scrollMac:"Prem la tecla ⌘ mentre et desplaces per apropar i allunyar el mapa"},
//Czech
cs:{touch:"K posunutí mapy použijte dva prsty",scroll:"Velikost zobrazení mapy změňte podržením klávesy Ctrl a posouváním kolečka myši",scrollMac:"Velikost zobrazení mapy změníte podržením klávesy ⌘ a posunutím kolečka myši / touchpadu"},
//Danish
da:{touch:"Brug to fingre til at flytte kortet",scroll:"Brug ctrl + rullefunktionen til at zoome ind og ud på kortet",scrollMac:"Brug ⌘ + rullefunktionen til at zoome ind og ud på kortet"},
//German
de:{touch:"Verschieben der Karte mit zwei Fingern",scroll:"Verwende Strg+Scrollen zum Zoomen der Karte",scrollMac:"⌘"},
//Greek
el:{touch:"Χρησιμοποιήστε δύο δάχτυλα για μετακίνηση στον χάρτη",scroll:"Χρησιμοποιήστε το πλήκτρο Ctrl και κύλιση, για να μεγεθύνετε τον χάρτη",scrollMac:"Χρησιμοποιήστε το πλήκτρο ⌘ + κύλιση για εστίαση στον χάρτη"},
//English
en:{touch:"Use two fingers to move the map",scroll:"Use ctrl + scroll to zoom the map",scrollMac:"Use ⌘ + scroll to zoom the map"},
//English (Australian)
"en-AU":{touch:"Use two fingers to move the map",scroll:"Use ctrl + scroll to zoom the map",scrollMac:"Use ⌘ + scroll to zoom the map"},
//English (Great Britain)
"en-GB":{touch:"Use two fingers to move the map",scroll:"Use ctrl + scroll to zoom the map",scrollMac:"Use ⌘ + scroll to zoom the map"},
//Spanish
es:{touch:"Para mover el mapa, utiliza dos dedos",scroll:"Mantén pulsada la tecla Ctrl mientras te desplazas para acercar o alejar el mapa",scrollMac:"Mantén pulsada la tecla ⌘ mientras te desplazas para acercar o alejar el mapa"},
//Basque
eu:{touch:"Erabili bi hatz mapa mugitzeko",scroll:"Mapan zooma aplikatzeko, sakatu Ktrl eta egin gora edo behera",scrollMac:"Eduki sakatuta ⌘ eta egin gora eta behera mapa handitu eta txikitzeko"},
//Farsi
fa:{touch:"برای حرکت دادن نقشه از دو انگشت استفاده کنید.",scroll:"‏برای بزرگ‌نمایی نقشه از ctrl + scroll استفاده کنید",scrollMac:"برای بزرگ‌نمایی نقشه، از ⌘ + پیمایش استفاده کنید."},
//Finnish
fi:{touch:"Siirrä karttaa kahdella sormella.",scroll:"Zoomaa karttaa painamalla Ctrl-painiketta ja vierittämällä.",scrollMac:"Zoomaa karttaa pitämällä painike ⌘ painettuna ja vierittämällä."},
//Filipino
fil:{touch:"Gumamit ng dalawang daliri upang iusog ang mapa",scroll:"Gamitin ang ctrl + scroll upang i-zoom ang mapa",scrollMac:"Gamitin ang ⌘ + scroll upang i-zoom ang mapa"},
//French
fr:{touch:"Utilisez deux doigts pour déplacer la carte",scroll:"Vous pouvez zoomer sur la carte à l'aide de CTRL+Molette de défilement",scrollMac:"Vous pouvez zoomer sur la carte à l'aide de ⌘+Molette de défilement"},
//Galician
gl:{touch:"Utiliza dous dedos para mover o mapa",scroll:"Preme Ctrl mentres te desprazas para ampliar o mapa",scrollMac:"Preme ⌘ e desprázate para ampliar o mapa"},
//Gujarati
gu:{touch:"નકશો ખસેડવા બે આંગળીઓનો ઉપયોગ કરો",scroll:"નકશાને ઝૂમ કરવા માટે ctrl + સ્ક્રોલનો ઉપયોગ કરો",scrollMac:"નકશાને ઝૂમ કરવા ⌘ + સ્ક્રોલનો ઉપયોગ કરો"},
//Hindi
hi:{touch:"मैप एक जगह से दूसरी जगह ले जाने के लिए दो उंगलियों का इस्तेमाल करें",scroll:"मैप को ज़ूम करने के लिए ctrl + स्क्रोल का उपयोग करें",scrollMac:"मैप को ज़ूम करने के लिए ⌘ + स्क्रोल का उपयोग करें"},
//Croatian
hr:{touch:"Pomičite kartu pomoću dva prsta",scroll:"Upotrijebite Ctrl i klizač miša da biste zumirali kartu",scrollMac:"Upotrijebite gumb ⌘ dok se pomičete za zumiranje karte"},
//Hungarian
hu:{touch:"Két ujjal mozgassa a térképet",scroll:"A térkép a ctrl + görgetés használatával nagyítható",scrollMac:"A térkép a ⌘ + görgetés használatával nagyítható"},
//Indonesian
id:{touch:"Gunakan dua jari untuk menggerakkan peta",scroll:"Gunakan ctrl + scroll untuk memperbesar atau memperkecil peta",scrollMac:"Gunakan ⌘ + scroll untuk memperbesar atau memperkecil peta"},
//Italian
it:{touch:"Utilizza due dita per spostare la mappa",scroll:"Utilizza CTRL + scorrimento per eseguire lo zoom della mappa",scrollMac:"Utilizza ⌘ + scorrimento per eseguire lo zoom della mappa"},
//Hebrew
iw:{touch:"הזז את המפה באמצעות שתי אצבעות",scroll:"‏אפשר לשנות את מרחק התצוגה במפה באמצעות מקש ctrl וגלילה",scrollMac:"אפשר לשנות את מרחק התצוגה במפה באמצעות מקש ⌘ וגלילה"},
//Japanese
ja:{touch:"地図を移動させるには指 2 本で操作します",scroll:"地図をズームするには、Ctrl キーを押しながらスクロールしてください",scrollMac:"地図をズームするには、⌘ キーを押しながらスクロールしてください"},
//Kannada
kn:{touch:"Use two fingers to move the map",scroll:"Use Ctrl + scroll to zoom the map",scrollMac:"Use ⌘ + scroll to zoom the map"},
//Korean
ko:{touch:"지도를 움직이려면 두 손가락을 사용하세요.",scroll:"지도를 확대/축소하려면 Ctrl을 누른 채 스크롤하세요.",scrollMac:"지도를 확대하려면 ⌘ + 스크롤 사용"},
//Lithuanian
lt:{touch:"Perkelkite žemėlapį dviem pirštais",scroll:"Slinkite nuspaudę klavišą „Ctrl“, kad pakeistumėte žemėlapio mastelį",scrollMac:"Paspauskite klavišą ⌘ ir slinkite, kad priartintumėte žemėlapį"},
//Latvian
lv:{touch:"Lai pārvietotu karti, bīdiet to ar diviem pirkstiem",scroll:"Kartes tālummaiņai izmantojiet ctrl + ritināšanu",scrollMac:"Lai veiktu kartes tālummaiņu, izmantojiet ⌘ + ritināšanu"},
//Malayalam
ml:{touch:"മാപ്പ് നീക്കാൻ രണ്ട് വിരലുകൾ ഉപയോഗിക്കുക",scroll:"കൺട്രോൾ + സ്‌ക്രോൾ ഉപയോഗിച്ച് ‌മാപ്പ് ‌സൂം ചെയ്യുക",scrollMac:"⌘ + സ്‌ക്രോൾ ഉപയോഗിച്ച് ‌മാപ്പ് ‌സൂം ചെയ്യുക"},
//Marathi
mr:{touch:"नकाशा हलविण्यासाठी दोन बोटे वापरा",scroll:"नकाशा झूम करण्यासाठी ctrl + scroll वापरा",scrollMac:"नकाशावर झूम करण्यासाठी ⌘ + स्क्रोल वापरा"},
//Dutch
nl:{touch:"Gebruik twee vingers om de kaart te verplaatsen",scroll:"Gebruik Ctrl + scrollen om in- en uit te zoomen op de kaart",scrollMac:"Gebruik ⌘ + scrollen om in en uit te zoomen op de kaart"},
//Norwegian
no:{touch:"Bruk to fingre for å flytte kartet",scroll:"Hold ctrl-tasten inne og rull for å zoome på kartet",scrollMac:"Hold inne ⌘-tasten og rull for å zoome på kartet"},
//Polish
pl:{touch:"Przesuń mapę dwoma palcami",scroll:"Naciśnij CTRL i przewiń, by przybliżyć mapę",scrollMac:"Naciśnij ⌘ i przewiń, by przybliżyć mapę"},
//Portuguese
pt:{touch:"Use dois dedos para mover o mapa",scroll:"Pressione Ctrl e role a tela simultaneamente para aplicar zoom no mapa",scrollMac:"Use ⌘ e role a tela simultaneamente para aplicar zoom no mapa"},
//Portuguese (Brazil)
"pt-BR":{touch:"Use dois dedos para mover o mapa",scroll:"Pressione Ctrl e role a tela simultaneamente para aplicar zoom no mapa",scrollMac:"Use ⌘ e role a tela simultaneamente para aplicar zoom no mapa"},
//Portuguese (Portugal
"pt-PT":{touch:"Utilize dois dedos para mover o mapa",scroll:"Utilizar ctrl + deslocar para aumentar/diminuir zoom do mapa",scrollMac:"Utilize ⌘ + deslocar para aumentar/diminuir o zoom do mapa"},
//Romanian
ro:{touch:"Folosiți două degete pentru a deplasa harta",scroll:"Apăsați tasta ctrl și derulați simultan pentru a mări harta",scrollMac:"Folosiți ⌘ și derulați pentru a mări/micșora harta"},
//Russian
ru:{touch:"Чтобы переместить карту, проведите по ней двумя пальцами",scroll:"Чтобы изменить масштаб, прокручивайте карту, удерживая клавишу Ctrl.",scrollMac:"Чтобы изменить масштаб, нажмите ⌘ + прокрутка"},
//Slovak
sk:{touch:"Mapu môžete posunúť dvoma prstami",scroll:"Ak chcete priblížiť mapu, stlačte kláves ctrl a posúvajte",scrollMac:"Ak chcete priblížiť mapu, stlačte kláves ⌘ a posúvajte kolieskom myši"},
//Slovenian
sl:{touch:"Premaknite zemljevid z dvema prstoma",scroll:"Zemljevid povečate tako, da držite tipko Ctrl in vrtite kolesce na miški",scrollMac:"Uporabite ⌘ + funkcijo pomika, da povečate ali pomanjšate zemljevid"},
//Serbian
sr:{touch:"Мапу померајте помоћу два прста",scroll:"Притисните ctrl тастер док померате да бисте зумирали мапу",scrollMac:"Притисните тастер ⌘ док померате да бисте зумирали мапу"},
//Swedish
sv:{touch:"Använd två fingrar för att flytta kartan",scroll:"Använd ctrl + rulla för att zooma kartan",scrollMac:"Använd ⌘ + rulla för att zooma på kartan"},
//Tamil
ta:{touch:"மேப்பை நகர்த்த இரண்டு விரல்களைப் பயன்படுத்தவும்",scroll:"மேப்பை பெரிதாக்கி/சிறிதாக்கிப் பார்க்க, ctrl பட்டனைப் பிடித்தபடி, மேலே/கீழே ஸ்க்ரால் செய்யவும்",scrollMac:"மேப்பை பெரிதாக்கி/சிறிதாக்கிப் பார்க்க, ⌘ பட்டனைப் பிடித்தபடி, மேலே/கீழே ஸ்க்ரால் செய்யவும்"},
//Telugu
te:{touch:"మ్యాప్‌ని తరలించడం కోసం రెండు వేళ్లను ఉపయోగించండి",scroll:"మ్యాప్‌ని జూమ్ చేయడానికి ctrl బటన్‌ను నొక్కి ఉంచి, స్క్రోల్ చేయండి",scrollMac:"మ్యాప్ జూమ్ చేయాలంటే ⌘ + స్క్రోల్ ఉపయోగించండి"},
//Thai
th:{touch:"ใช้ 2 นิ้วเพื่อเลื่อนแผนที่",scroll:"กด Ctrl ค้างไว้ แล้วเลื่อนหน้าจอเพื่อซูมแผนที่",scrollMac:"กด ⌘ แล้วเลื่อนหน้าจอเพื่อซูมแผนที่"},
//Tagalog
tl:{touch:"Gumamit ng dalawang daliri upang iusog ang mapa",scroll:"Gamitin ang ctrl + scroll upang i-zoom ang mapa",scrollMac:"Gamitin ang ⌘ + scroll upang i-zoom ang mapa"},
//Turkish
tr:{touch:"Haritada gezinmek için iki parmağınızı kullanın",scroll:"Haritayı yakınlaştırmak için ctrl + kaydırma kombinasyonunu kullanın",scrollMac:"Haritayı yakınlaştırmak için ⌘ tuşuna basıp ekranı kaydırın"},
//Ukrainian
uk:{touch:"Переміщуйте карту двома пальцями",scroll:"Щоб змінювати масштаб карти, прокручуйте коліщатко миші, утримуючи клавішу Ctrl",scrollMac:"Щоб змінити масштаб карти, використовуйте ⌘ + прокручування"},
//Vietnamese
vi:{touch:"Sử dụng hai ngón tay để di chuyển bản đồ",scroll:"Sử dụng ctrl + cuộn để thu phóng bản đồ",scrollMac:"Sử dụng ⌘ + cuộn để thu phóng bản đồ"},
//Chinese (Simplified)
"zh-CN":{touch:"使用双指移动地图",scroll:"按住 Ctrl 并滚动鼠标滚轮才可缩放地图",scrollMac:"按住 ⌘ 并滚动鼠标滚轮才可缩放地图"},
//Chinese (Traditional)
"zh-TW":{touch:"同時以兩指移動地圖",scroll:"按住 ctrl 鍵加上捲動滑鼠可以縮放地圖",scrollMac:"按 ⌘ 加上滾動捲軸可以縮放地圖"}};
/*
  * * Leaflet Gesture Handling **
  * * Version 1.1.8
  */L.Map.mergeOptions({gestureHandlingOptions:{text:{},duration:1e3}});var e=!1,i=L.Handler.extend({addHooks:function(){this._handleTouch=this._handleTouch.bind(this),this._setupPluginOptions(),this._setLanguageContent(),this._disableInteractions(),//Uses native event listeners instead of L.DomEvent due to issues with Android touch events
//turning into pointer events
this._map._container.addEventListener("touchstart",this._handleTouch,{passive:!0}),this._map._container.addEventListener("touchmove",this._handleTouch,{passive:!0}),this._map._container.addEventListener("touchend",this._handleTouch),this._map._container.addEventListener("touchcancel",this._handleTouch),this._map._container.addEventListener("click",this._handleTouch),L.DomEvent.on(this._map._container,"mousewheel",this._handleScroll,this),L.DomEvent.on(this._map,"mouseover",this._handleMouseOver,this),L.DomEvent.on(this._map,"mouseout",this._handleMouseOut,this),// Listen to these events so will not disable dragging if the user moves the mouse out the boundary of the map container whilst actively dragging the map.
L.DomEvent.on(this._map,"movestart",this._handleDragging,this),L.DomEvent.on(this._map,"move",this._handleDragging,this),L.DomEvent.on(this._map,"moveend",this._handleDragging,this)},removeHooks:function(){this._enableInteractions(),this._map._container.removeEventListener("touchstart",this._handleTouch),this._map._container.removeEventListener("touchmove",this._handleTouch),this._map._container.removeEventListener("touchend",this._handleTouch),this._map._container.removeEventListener("touchcancel",this._handleTouch),this._map._container.removeEventListener("click",this._handleTouch),L.DomEvent.off(this._map._container,"mousewheel",this._handleScroll,this),L.DomEvent.off(this._map,"mouseover",this._handleMouseOver,this),L.DomEvent.off(this._map,"mouseout",this._handleMouseOut,this),L.DomEvent.off(this._map,"movestart",this._handleDragging,this),L.DomEvent.off(this._map,"move",this._handleDragging,this),L.DomEvent.off(this._map,"moveend",this._handleDragging,this)},_handleDragging:function(t){"movestart"==t.type||"move"==t.type?e=!0:"moveend"==t.type&&(e=!1)},_disableInteractions:function(){this._map.dragging.disable(),this._map.scrollWheelZoom.disable(),this._map.tap&&this._map.tap.disable()},_enableInteractions:function(){this._map.dragging.enable(),this._map.scrollWheelZoom.enable(),this._map.tap&&this._map.tap.enable()},_setupPluginOptions:function(){
//For backwards compatibility, merge gestureHandlingText into the new options object
this._map.options.gestureHandlingText&&(this._map.options.gestureHandlingOptions.text=this._map.options.gestureHandlingText)},_setLanguageContent:function(){var//If user has supplied custom language, use that
t=this._map.options.gestureHandlingOptions&&this._map.options.gestureHandlingOptions.text&&this._map.options.gestureHandlingOptions.text.touch&&this._map.options.gestureHandlingOptions.text.scroll&&this._map.options.gestureHandlingOptions.text.scrollMac?this._map.options.gestureHandlingOptions.text:(i=this._getUserLanguage(),//Lookup the appropriate language content
n[i=//If we couldn't find it default to en
i||"en"]&&(t=n[i]),//If no result, try searching by the first part only. e.g en-US just use en.
t||-1===i.indexOf("-")||(i=i.split("-")[0],t=n[i]),t||n[
// If still nothing, default to English
// console.log("No lang found for", lang);
i="en"]),e=!1;0<=navigator.platform.toUpperCase().indexOf("MAC")&&(e=!0);var i=t.scroll;e&&(i=t.scrollMac),this._map._container.setAttribute("data-gesture-handling-touch-content",t.touch),this._map._container.setAttribute("data-gesture-handling-scroll-content",i)},_getUserLanguage:function(){return navigator.languages?navigator.languages[0]:navigator.language||navigator.userLanguage},_handleTouch:function(t){for(
//Disregard touch events on the minimap if present
var e=["leaflet-control-minimap","leaflet-interactive","leaflet-popup-content","leaflet-popup-content-wrapper","leaflet-popup-close-button","leaflet-control-zoom-in","leaflet-control-zoom-out"],i=!1,n=0;n<e.length;n++)L.DomUtil.hasClass(t.target,e[n])&&(i=!0);i?L.DomUtil.hasClass(t.target,"leaflet-interactive")&&"touchmove"===t.type&&1===t.touches.length?(L.DomUtil.addClass(this._map._container,"leaflet-gesture-handling-touch-warning"),this._disableInteractions()):L.DomUtil.removeClass(this._map._container,"leaflet-gesture-handling-touch-warning"):// screenLog(e.type+' '+e.touches.length);
"touchmove"===t.type||"touchstart"===t.type?1===t.touches.length?(L.DomUtil.addClass(this._map._container,"leaflet-gesture-handling-touch-warning"),this._disableInteractions()):(this._enableInteractions(),L.DomUtil.removeClass(this._map._container,"leaflet-gesture-handling-touch-warning")):L.DomUtil.removeClass(this._map._container,"leaflet-gesture-handling-touch-warning")},_isScrolling:!1,_handleScroll:function(t){t.metaKey||t.ctrlKey?(t.preventDefault(),L.DomUtil.removeClass(this._map._container,"leaflet-gesture-handling-scroll-warning"),this._map.scrollWheelZoom.enable()):(L.DomUtil.addClass(this._map._container,"leaflet-gesture-handling-scroll-warning"),this._map.scrollWheelZoom.disable(),clearTimeout(this._isScrolling),// Set a timeout to run after scrolling ends
this._isScrolling=setTimeout(function(){for(
// Run the callback
var t=document.getElementsByClassName("leaflet-gesture-handling-scroll-warning"),e=0;e<t.length;e++)L.DomUtil.removeClass(t[e],"leaflet-gesture-handling-scroll-warning")},this._map.options.gestureHandlingOptions.duration))},_handleMouseOver:function(){this._enableInteractions()},_handleMouseOut:function(){e||this._disableInteractions()}});L.Map.addInitHook("addHandler","gestureHandling",i),t.GestureHandling=i,t.default=i,Object.defineProperty(t,"__esModule",{value:!0})}),
/*
 * Leaflet.markercluster 1.4.1+master.94f9815,
 * Provides Beautiful Animated Marker Clustering functionality for Leaflet, a JS library for interactive maps.
 * https://github.com/Leaflet/Leaflet.markercluster
 * (c) 2012-2017, Dave Leaver, smartrak
 */
function(t,e){"object"===("undefined"==typeof exports?"undefined":_typeof(exports))&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t.Leaflet=t.Leaflet||{},t.Leaflet.markercluster=t.Leaflet.markercluster||{}))}(this,function(t){"use strict";
/*
   * L.MarkerClusterGroup extends L.FeatureGroup by clustering the markers contained within
   */var e=L.MarkerClusterGroup=L.FeatureGroup.extend({options:{maxClusterRadius:80,
//A cluster will cover at most this many pixels from its center
iconCreateFunction:null,clusterPane:L.Marker.prototype.options.pane,spiderfyOnMaxZoom:!0,showCoverageOnHover:!0,zoomToBoundsOnClick:!0,singleMarkerMode:!1,disableClusteringAtZoom:null,
// Setting this to false prevents the removal of any clusters outside of the viewpoint, which
// is the default behaviour for performance reasons.
removeOutsideVisibleBounds:!0,
// Set to false to disable all animations (zoom and spiderfy).
// If false, option animateAddingMarkers below has no effect.
// If L.DomUtil.TRANSITION is falsy, this option has no effect.
animate:!0,
//Whether to animate adding markers after adding the MarkerClusterGroup to the map
// If you are adding individual markers set to true, if adding bulk markers leave false for massive performance gains.
animateAddingMarkers:!1,
//Increase to increase the distance away that spiderfied markers appear from the center
spiderfyDistanceMultiplier:1,
// Make it possible to specify a polyline options on a spider leg
spiderLegPolylineOptions:{weight:1.5,color:"#222",opacity:.5},
// When bulk adding layers, adds markers in chunks. Means addLayers may not add all the layers in the call, others will be loaded during setTimeouts
chunkedLoading:!1,chunkInterval:200,
// process markers for a maximum of ~ n milliseconds (then trigger the chunkProgress callback)
chunkDelay:50,
// at the end of each interval, give n milliseconds back to system/browser
chunkProgress:null,
// progress callback: function(processed, total, elapsed) (e.g. for a progress indicator)
//Options to pass to the L.Polygon constructor
polygonOptions:{}},initialize:function(t){L.Util.setOptions(this,t),this.options.iconCreateFunction||(this.options.iconCreateFunction=this._defaultIconCreateFunction),this._featureGroup=L.featureGroup(),this._featureGroup.addEventParent(this),this._nonPointGroup=L.featureGroup(),this._nonPointGroup.addEventParent(this),this._inZoomAnimation=0,this._needsClustering=[],this._needsRemoving=[],//Markers removed while we aren't on the map need to be kept track of
//The bounds of the currently shown area (from _getExpandedVisibleBounds) Updated on zoom/move
this._currentShownBounds=null,this._queue=[],this._childMarkerEventHandlers={dragstart:this._childMarkerDragStart,move:this._childMarkerMoved,dragend:this._childMarkerDragEnd};// Hook the appropriate animation methods.
t=L.DomUtil.TRANSITION&&this.options.animate;L.extend(this,t?this._withAnimation:this._noAnimation),// Remember which MarkerCluster class to instantiate (animated or not).
this._markerCluster=t?L.MarkerCluster:L.MarkerClusterNonAnimated},addLayer:function(t){if(t instanceof L.LayerGroup)return this.addLayers([t]);//Don't cluster non point data
if(!t.getLatLng)return this._nonPointGroup.addLayer(t),this.fire("layeradd",{layer:t}),this;if(!this._map)return this._needsClustering.push(t),this.fire("layeradd",{layer:t}),this;if(this.hasLayer(t))return this;//If we have already clustered we'll need to add this one to a cluster
this._unspiderfy&&this._unspiderfy(),this._addLayer(t,this._maxZoom),this.fire("layeradd",{layer:t}),// Refresh bounds and weighted positions.
this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons();//Work out what is visible
var e=t,i=this._zoom;if(t.__parent)for(;e.__parent._zoom>=i;)e=e.__parent;return this._currentShownBounds.contains(e.getLatLng())&&(this.options.animateAddingMarkers?this._animationAddLayer(t,e):this._animationAddLayerNonAnimated(t,e)),this},removeLayer:function(t){return t instanceof L.LayerGroup?this.removeLayers([t]):(//Non point layers
t.getLatLng?this._map?t.__parent&&(this._unspiderfy&&(this._unspiderfy(),this._unspiderfyLayer(t)),//Remove the marker from clusters
this._removeLayer(t,!0),this.fire("layerremove",{layer:t}),// Refresh bounds and weighted positions.
this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),t.off(this._childMarkerEventHandlers,this),this._featureGroup.hasLayer(t)&&(this._featureGroup.removeLayer(t),t.clusterShow&&t.clusterShow())):(!this._arraySplice(this._needsClustering,t)&&this.hasLayer(t)&&this._needsRemoving.push({layer:t,latlng:t._latlng}),this.fire("layerremove",{layer:t})):(this._nonPointGroup.removeLayer(t),this.fire("layerremove",{layer:t})),this)},
//Takes an array of markers and adds them in bulk
addLayers:function(i,n){if(!L.Util.isArray(i))return this.addLayer(i);var o,s=this._featureGroup,r=this._nonPointGroup,a=this.options.chunkedLoading,h=this.options.chunkInterval,l=this.options.chunkProgress,u=i.length,c=0,_=!0;if(this._map){var d=(new Date).getTime(),p=L.bind(function(){for(var t=(new Date).getTime();c<u;c++){if(a&&c%200==0){
// every couple hundred markers, instrument the time elapsed since processing started:
var e=(new Date).getTime()-t;if(h<e)break;// been working too hard, time to take a break :-)
}// Group of layers, append children to layersArray and skip.
// Side effects:
// - Total increases, so chunkProgress ratio jumps backward.
// - Groups are not included in this group, only their non-group child layers (hasLayer).
// Changing array length while looping does not affect performance in current browsers:
// http://jsperf.com/for-loop-changing-length/6
(o=i[c])instanceof L.LayerGroup?(_&&(i=i.slice(),_=!1),this._extractNonGroupLayers(o,i),u=i.length)://Not point data, can't be clustered
o.getLatLng?this.hasLayer(o)||(this._addLayer(o,this._maxZoom),n||this.fire("layeradd",{layer:o}),//If we just made a cluster of size 2 then we need to remove the other marker from the map (if it is) or we never will
o.__parent&&2===o.__parent.getChildCount()&&(e=(e=o.__parent.getAllChildMarkers())[0]===o?e[1]:e[0],s.removeLayer(e))):(r.addLayer(o),n||this.fire("layeradd",{layer:o}))}l&&
// report progress and time elapsed:
l(c,u,(new Date).getTime()-d),// Completed processing all markers.
c===u?(
// Refresh bounds and weighted positions.
this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,this._currentShownBounds)):setTimeout(p,this.options.chunkDelay)},this);p()}else for(var t=this._needsClustering;c<u;c++)// Group of layers, append children to layersArray and skip.
(o=i[c])instanceof L.LayerGroup?(_&&(i=i.slice(),_=!1),this._extractNonGroupLayers(o,i),u=i.length)://Not point data, can't be clustered
o.getLatLng?this.hasLayer(o)||t.push(o):r.addLayer(o);return this},
//Takes an array of markers and removes them in bulk
removeLayers:function(t){var e,i=t.length,n=this._featureGroup,o=this._nonPointGroup,s=!0;if(!this._map){for(h=0;h<i;h++)// Group of layers, append children to layersArray and skip.
(e=t[h])instanceof L.LayerGroup?(s&&(t=t.slice(),s=!1),this._extractNonGroupLayers(e,t),i=t.length):(this._arraySplice(this._needsClustering,e),o.removeLayer(e),this.hasLayer(e)&&this._needsRemoving.push({layer:e,latlng:e._latlng}),this.fire("layerremove",{layer:e}));return this}if(this._unspiderfy){this._unspiderfy();for(// Work on a copy of the array, so that next loop is not affected.
var r=t.slice(),a=i,h=0;h<a;h++)// Group of layers, append children to layersArray and skip.
(e=r[h])instanceof L.LayerGroup?(this._extractNonGroupLayers(e,r),a=r.length):this._unspiderfyLayer(e)}for(h=0;h<i;h++)// Group of layers, append children to layersArray and skip.
(e=t[h])instanceof L.LayerGroup?(s&&(t=t.slice(),s=!1),this._extractNonGroupLayers(e,t),i=t.length):e.__parent?(this._removeLayer(e,!0,!0),this.fire("layerremove",{layer:e}),n.hasLayer(e)&&(n.removeLayer(e),e.clusterShow&&e.clusterShow())):(o.removeLayer(e),this.fire("layerremove",{layer:e}));// Refresh bounds and weighted positions.
return this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),//Fix up the clusters and markers on the map
this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,this._currentShownBounds),this},
//Removes all layers from the MarkerClusterGroup
clearLayers:function(){
//Need our own special implementation as the LayerGroup one doesn't work for us
//If we aren't on the map (yet), blow away the markers we know of
return this._map||(this._needsClustering=[],this._needsRemoving=[],delete this._gridClusters,delete this._gridUnclustered),this._noanimationUnspiderfy&&this._noanimationUnspiderfy(),//Remove all the visible layers
this._featureGroup.clearLayers(),this._nonPointGroup.clearLayers(),this.eachLayer(function(t){t.off(this._childMarkerEventHandlers,this),delete t.__parent},this),this._map&&
//Reset _topClusterLevel and the DistanceGrids
this._generateInitialClusters(),this},
//Override FeatureGroup.getBounds as it doesn't work
getBounds:function(){var t=new L.LatLngBounds;this._topClusterLevel&&t.extend(this._topClusterLevel._bounds);for(var e=this._needsClustering.length-1;0<=e;e--)t.extend(this._needsClustering[e].getLatLng());return t.extend(this._nonPointGroup.getBounds()),t},
//Overrides LayerGroup.eachLayer
eachLayer:function(t,e){var i,n,o,s=this._needsClustering.slice(),r=this._needsRemoving;for(this._topClusterLevel&&this._topClusterLevel.getAllChildMarkers(s),n=s.length-1;0<=n;n--){for(i=!0,o=r.length-1;0<=o;o--)if(r[o].layer===s[n]){i=!1;break}i&&t.call(e,s[n])}this._nonPointGroup.eachLayer(t,e)},
//Overrides LayerGroup.getLayers
getLayers:function(){var e=[];return this.eachLayer(function(t){e.push(t)}),e},
//Overrides LayerGroup.getLayer, WARNING: Really bad performance
getLayer:function(e){var i=null;return e=parseInt(e,10),this.eachLayer(function(t){L.stamp(t)===e&&(i=t)}),i},
//Returns true if the given layer is in this MarkerClusterGroup
hasLayer:function(t){if(!t)return!1;for(var e=this._needsClustering,i=e.length-1;0<=i;i--)if(e[i]===t)return!0;for(i=(e=this._needsRemoving).length-1;0<=i;i--)if(e[i].layer===t)return!1;return!(!t.__parent||t.__parent._group!==this)||this._nonPointGroup.hasLayer(t)},
//Zoom down to show the given layer (spiderfying if necessary) then calls the callback
zoomToShowLayer:function(t,e){"function"!=typeof e&&(e=function(){});function i(){!t._icon&&!t.__parent._icon||this._inZoomAnimation||(this._map.off("moveend",i,this),this.off("animationend",i,this),t._icon?e():t.__parent._icon&&(this.once("spiderfied",e,this),t.__parent.spiderfy()))}t._icon&&this._map.getBounds().contains(t.getLatLng())?
//Layer is visible ond on screen, immediate return
e():t.__parent._zoom<Math.round(this._map._zoom)?(
//Layer should be visible at this zoom level. It must not be on screen so just pan over to it
this._map.on("moveend",i,this),this._map.panTo(t.getLatLng())):(this._map.on("moveend",i,this),this.on("animationend",i,this),t.__parent.zoomToBounds())},
//Overrides FeatureGroup.onAdd
onAdd:function(t){var e,i,n;if(this._map=t,!isFinite(this._map.getMaxZoom()))throw"Map has no maxZoom specified";//Restore all the positions as they are in the MCG before removing them
for(this._featureGroup.addTo(t),this._nonPointGroup.addTo(t),this._gridClusters||this._generateInitialClusters(),this._maxLat=t.options.crs.projection.MAX_LATITUDE,e=0,i=this._needsRemoving.length;e<i;e++)(n=this._needsRemoving[e]).newlatlng=n.layer._latlng,n.layer._latlng=n.latlng;//Remove them, then restore their new positions
for(e=0,i=this._needsRemoving.length;e<i;e++)n=this._needsRemoving[e],this._removeLayer(n.layer,!0),n.layer._latlng=n.newlatlng;this._needsRemoving=[],//Remember the current zoom level and bounds
this._zoom=Math.round(this._map._zoom),this._currentShownBounds=this._getExpandedVisibleBounds(),this._map.on("zoomend",this._zoomEnd,this),this._map.on("moveend",this._moveEnd,this),this._spiderfierOnAdd&&
//TODO FIXME: Not sure how to have spiderfier add something on here nicely
this._spiderfierOnAdd(),this._bindEvents(),//Actually add our markers to the map:
i=this._needsClustering,this._needsClustering=[],this.addLayers(i,!0)},
//Overrides FeatureGroup.onRemove
onRemove:function(t){t.off("zoomend",this._zoomEnd,this),t.off("moveend",this._moveEnd,this),this._unbindEvents(),//In case we are in a cluster animation
this._map._mapPane.className=this._map._mapPane.className.replace(" leaflet-cluster-anim",""),this._spiderfierOnRemove&&
//TODO FIXME: Not sure how to have spiderfier add something on here nicely
this._spiderfierOnRemove(),delete this._maxLat,//Clean up all the layers we added to the map
this._hideCoverage(),this._featureGroup.remove(),this._nonPointGroup.remove(),this._featureGroup.clearLayers(),this._map=null},getVisibleParent:function(t){for(var e=t;e&&!e._icon;)e=e.__parent;return e||null},
//Remove the given object from the given array
_arraySplice:function(t,e){for(var i=t.length-1;0<=i;i--)if(t[i]===e)return t.splice(i,1),!0},
/**
     * Removes a marker from all _gridUnclustered zoom levels, starting at the supplied zoom.
     * @param marker to be removed from _gridUnclustered.
     * @param z integer bottom start zoom level (included)
     * @private
     */
_removeFromGridUnclustered:function(t,e){for(var i=this._map,n=this._gridUnclustered,o=Math.floor(this._map.getMinZoom());o<=e&&n[e].removeObject(t,i.project(t.getLatLng(),e));e--);},_childMarkerDragStart:function(t){t.target.__dragStart=t.target._latlng},_childMarkerMoved:function(t){var e;this._ignoreMove||t.target.__dragStart||(e=t.target._popup&&t.target._popup.isOpen(),this._moveChild(t.target,t.oldLatLng,t.latlng),e&&t.target.openPopup())},_moveChild:function(t,e,i){t._latlng=e,this.removeLayer(t),t._latlng=i,this.addLayer(t)},_childMarkerDragEnd:function(t){var e=t.target.__dragStart;delete t.target.__dragStart,e&&this._moveChild(t.target,e,t.target._latlng)},
//Internal function for removing a marker from everything.
//dontUpdateMap: set to true if you will handle updating the map manually (for bulk functions)
_removeLayer:function(t,e,i){var n=this._gridClusters,o=this._gridUnclustered,s=this._featureGroup,r=this._map,a=Math.floor(this._map.getMinZoom());//Remove the marker from distance clusters it might be in
e&&this._removeFromGridUnclustered(t,this._maxZoom);//Work our way up the clusters removing them as we go if required
var h,l=t.__parent,u=l._markers;//Remove the marker from the immediate parents marker list
for(this._arraySplice(u,t);l&&(l._childCount--,l._boundsNeedUpdate=!0,!(l._zoom<a));)e&&l._childCount<=1?(
//Cluster no longer required
//We need to push the other marker up to the parent
h=l._markers[0]===t?l._markers[1]:l._markers[0],//Update distance grid
n[l._zoom].removeObject(l,r.project(l._cLatLng,l._zoom)),o[l._zoom].addObject(h,r.project(h.getLatLng(),l._zoom)),//Move otherMarker up to parent
this._arraySplice(l.__parent._childClusters,l),l.__parent._markers.push(h),h.__parent=l.__parent,l._icon&&(
//Cluster is currently on the map, need to put the marker on the map instead
s.removeLayer(l),i||s.addLayer(h))):l._iconNeedsUpdate=!0,l=l.__parent;delete t.__parent},_isOrIsParent:function(t,e){for(;e;){if(t===e)return!0;e=e.parentNode}return!1},
//Override L.Evented.fire
fire:function(t,e,i){if(e&&e.layer instanceof L.MarkerCluster){
//Prevent multiple clustermouseover/off events if the icon is made up of stacked divs (Doesn't work in ie <= 8, no relatedTarget)
if(e.originalEvent&&this._isOrIsParent(e.layer._icon,e.originalEvent.relatedTarget))return;t="cluster"+t}L.FeatureGroup.prototype.fire.call(this,t,e,i)},
//Override L.Evented.listens
listens:function(t,e){return L.FeatureGroup.prototype.listens.call(this,t,e)||L.FeatureGroup.prototype.listens.call(this,"cluster"+t,e)},
//Default functionality
_defaultIconCreateFunction:function(t){var e=t.getChildCount(),t=" marker-cluster-";return t+=e<10?"small":e<100?"medium":"large",new L.DivIcon({html:"<div><span>"+e+"</span></div>",className:"marker-cluster"+t,iconSize:new L.Point(40,40)})},_bindEvents:function(){var t=this._map,e=this.options.spiderfyOnMaxZoom,i=this.options.showCoverageOnHover,n=this.options.zoomToBoundsOnClick;//Zoom on cluster click or spiderfy if we are at the lowest level
(e||n)&&this.on("clusterclick",this._zoomOrSpiderfy,this),//Show convex hull (boundary) polygon on mouse over
i&&(this.on("clustermouseover",this._showCoverage,this),this.on("clustermouseout",this._hideCoverage,this),t.on("zoomend",this._hideCoverage,this))},_zoomOrSpiderfy:function(t){for(var e=t.layer,i=e;1===i._childClusters.length;)i=i._childClusters[0];i._zoom===this._maxZoom&&i._childCount===e._childCount&&this.options.spiderfyOnMaxZoom?
// All child markers are contained in a single cluster from this._maxZoom to this cluster.
e.spiderfy():this.options.zoomToBoundsOnClick&&e.zoomToBounds(),// Focus the map again for keyboard users.
t.originalEvent&&13===t.originalEvent.keyCode&&this._map._container.focus()},_showCoverage:function(t){var e=this._map;this._inZoomAnimation||(this._shownPolygon&&e.removeLayer(this._shownPolygon),2<t.layer.getChildCount()&&t.layer!==this._spiderfied&&(this._shownPolygon=new L.Polygon(t.layer.getConvexHull(),this.options.polygonOptions),e.addLayer(this._shownPolygon)))},_hideCoverage:function(){this._shownPolygon&&(this._map.removeLayer(this._shownPolygon),this._shownPolygon=null)},_unbindEvents:function(){var t=this.options.spiderfyOnMaxZoom,e=this.options.showCoverageOnHover,i=this.options.zoomToBoundsOnClick,n=this._map;(t||i)&&this.off("clusterclick",this._zoomOrSpiderfy,this),e&&(this.off("clustermouseover",this._showCoverage,this),this.off("clustermouseout",this._hideCoverage,this),n.off("zoomend",this._hideCoverage,this))},_zoomEnd:function(){this._map&&(this._mergeSplitClusters(),this._zoom=Math.round(this._map._zoom),this._currentShownBounds=this._getExpandedVisibleBounds())},_moveEnd:function(){var t;this._inZoomAnimation||(t=this._getExpandedVisibleBounds(),this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),this._zoom,t),this._topClusterLevel._recursivelyAddChildrenToMap(null,Math.round(this._map._zoom),t),this._currentShownBounds=t)},_generateInitialClusters:function(){var t=Math.ceil(this._map.getMaxZoom()),e=Math.floor(this._map.getMinZoom()),i=this.options.maxClusterRadius,n=//If we just set maxClusterRadius to a single number, we need to create
//a simple function to return that number. Otherwise, we just have to
//use the function we've passed in.
"function"!=typeof i?function(){return i}:i;null!==this.options.disableClusteringAtZoom&&(t=this.options.disableClusteringAtZoom-1),this._maxZoom=t,this._gridClusters={},this._gridUnclustered={};//Set up DistanceGrids for each zoom
for(var o=t;e<=o;o--)this._gridClusters[o]=new L.DistanceGrid(n(o)),this._gridUnclustered[o]=new L.DistanceGrid(n(o));// Instantiate the appropriate L.MarkerCluster class (animated or not).
this._topClusterLevel=new this._markerCluster(this,e-1)},
//Zoom: Zoom to start adding at (Pass this._maxZoom to start at the bottom)
_addLayer:function(t,e){var i,n=this._gridClusters,o=this._gridUnclustered,s=Math.floor(this._map.getMinZoom());//Find the lowest zoom level to slot this one in
for(this.options.singleMarkerMode&&this._overrideMarkerIcon(t),t.on(this._childMarkerEventHandlers,this);s<=e;e--){i=this._map.project(t.getLatLng(),e);// calculate pixel position
//Try find a cluster close by
var r=n[e].getNearObject(i);if(r)return r._addChild(t),void(t.__parent=r);//Try find a marker close by to form a new cluster with
if(r=o[e].getNearObject(i)){var a=r.__parent;a&&this._removeLayer(r,!1);//Create new cluster with these 2 in it
var h=new this._markerCluster(this,e,r,t);n[e].addObject(h,this._map.project(h._cLatLng,e)),r.__parent=h;for(//First create any new intermediate parent clusters that don't exist
var l=t.__parent=h,u=e-1;u>a._zoom;u--)l=new this._markerCluster(this,u,l),n[u].addObject(l,this._map.project(r.getLatLng(),u));return a._addChild(l),void//Remove closest from this zoom level and any above that it is in, replace with newCluster
this._removeFromGridUnclustered(r,e)}//Didn't manage to cluster in at this zoom, record us as a marker here and continue upwards
o[e].addObject(t,i)}//Didn't get in anything, add us to the top
this._topClusterLevel._addChild(t),t.__parent=this._topClusterLevel},
/**
     * Refreshes the icon of all "dirty" visible clusters.
     * Non-visible "dirty" clusters will be updated when they are added to the map.
     * @private
     */
_refreshClustersIcons:function(){this._featureGroup.eachLayer(function(t){t instanceof L.MarkerCluster&&t._iconNeedsUpdate&&t._updateIcon()})},
//Enqueue code to fire after the marker expand/contract has happened
_enqueue:function(t){this._queue.push(t),this._queueTimeout||(this._queueTimeout=setTimeout(L.bind(this._processQueue,this),300))},_processQueue:function(){for(var t=0;t<this._queue.length;t++)this._queue[t].call(this);this._queue.length=0,clearTimeout(this._queueTimeout),this._queueTimeout=null},
//Merge and split any existing clusters that are too big or small
_mergeSplitClusters:function(){var t=Math.round(this._map._zoom);//In case we are starting to split before the animation finished
this._processQueue(),this._zoom<t&&this._currentShownBounds.intersects(this._getExpandedVisibleBounds())?(
//Zoom in, split
this._animationStart(),//Remove clusters now off screen
this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),this._zoom,this._getExpandedVisibleBounds()),this._animationZoomIn(this._zoom,t)):this._zoom>t?(
//Zoom out, merge
this._animationStart(),this._animationZoomOut(this._zoom,t)):this._moveEnd()},
//Gets the maps visible bounds expanded in each direction by the size of the screen (so the user cannot see an area we do not cover in one pan)
_getExpandedVisibleBounds:function(){return this.options.removeOutsideVisibleBounds?L.Browser.mobile?this._checkBoundsMaxLat(this._map.getBounds()):this._checkBoundsMaxLat(this._map.getBounds().pad(1)):this._mapBoundsInfinite},
/**
     * Expands the latitude to Infinity (or -Infinity) if the input bounds reach the map projection maximum defined latitude
     * (in the case of Web/Spherical Mercator, it is 85.0511287798 / see https://en.wikipedia.org/wiki/Web_Mercator#Formulas).
     * Otherwise, the removeOutsideVisibleBounds option will remove markers beyond that limit, whereas the same markers without
     * this option (or outside MCG) will have their position floored (ceiled) by the projection and rendered at that limit,
     * making the user think that MCG "eats" them and never displays them again.
     * @param bounds L.LatLngBounds
     * @returns {L.LatLngBounds}
     * @private
     */
_checkBoundsMaxLat:function(t){var e=this._maxLat;return void 0!==e&&(t.getNorth()>=e&&(t._northEast.lat=1/0),t.getSouth()<=-e&&(t._southWest.lat=-1/0)),t},
//Shared animation code
_animationAddLayerNonAnimated:function(t,e){e===t?this._featureGroup.addLayer(t):2===e._childCount?(e._addToMap(),t=e.getAllChildMarkers(),this._featureGroup.removeLayer(t[0]),this._featureGroup.removeLayer(t[1])):e._updateIcon()},
/**
     * Extracts individual (i.e. non-group) layers from a Layer Group.
     * @param group to extract layers from.
     * @param output {Array} in which to store the extracted layers.
     * @returns {*|Array}
     * @private
     */
_extractNonGroupLayers:function(t,e){var i,n=t.getLayers(),o=0;for(e=e||[];o<n.length;o++)(i=n[o])instanceof L.LayerGroup?this._extractNonGroupLayers(i,e):e.push(i);return e},
/**
     * Implements the singleMarkerMode option.
     * @param layer Marker to re-style using the Clusters iconCreateFunction.
     * @returns {L.Icon} The newly created icon.
     * @private
     */
_overrideMarkerIcon:function(t){return t.options.icon=this.options.iconCreateFunction({getChildCount:function(){return 1},getAllChildMarkers:function(){return[t]}})}});// Constant bounds used in case option "removeOutsideVisibleBounds" is set to false.
L.MarkerClusterGroup.include({_mapBoundsInfinite:new L.LatLngBounds(new L.LatLng(-1/0,-1/0),new L.LatLng(1/0,1/0))}),L.MarkerClusterGroup.include({_noAnimation:{
//Non Animated versions of everything
_animationStart:function(){//Do nothing...
},_animationZoomIn:function(t,e){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t),this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),//We didn't actually animate, but we use this event to mean "clustering animations have finished"
this.fire("animationend")},_animationZoomOut:function(t,e){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t),this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),//We didn't actually animate, but we use this event to mean "clustering animations have finished"
this.fire("animationend")},_animationAddLayer:function(t,e){this._animationAddLayerNonAnimated(t,e)}},_withAnimation:{
//Animated versions here
_animationStart:function(){this._map._mapPane.className+=" leaflet-cluster-anim",this._inZoomAnimation++},_animationZoomIn:function(o,s){var r,a=this._getExpandedVisibleBounds(),h=this._featureGroup,t=Math.floor(this._map.getMinZoom());this._ignoreMove=!0,//Add all children of current clusters to map and remove those clusters from map
this._topClusterLevel._recursively(a,o,t,function(t){var e,i=t._latlng,n=t._markers;//Remove all markers that aren't visible any more
//TODO: Do we actually need to do this on the higher levels too?
for(a.contains(i)||(i=null),t._isSingleParent()&&o+1===s?(
//Immediately add the new child and remove us
h.removeLayer(t),t._recursivelyAddChildrenToMap(null,s,a)):(
//Fade out old cluster
t.clusterHide(),t._recursivelyAddChildrenToMap(i,s,a)),r=n.length-1;0<=r;r--)e=n[r],a.contains(e._latlng)||h.removeLayer(e)}),this._forceLayout(),//Update opacities
this._topClusterLevel._recursivelyBecomeVisible(a,s),//TODO Maybe? Update markers in _recursivelyBecomeVisible
h.eachLayer(function(t){t instanceof L.MarkerCluster||!t._icon||t.clusterShow()}),//update the positions of the just added clusters/markers
this._topClusterLevel._recursively(a,o,s,function(t){t._recursivelyRestoreChildPositions(s)}),this._ignoreMove=!1,//Remove the old clusters and close the zoom animation
this._enqueue(function(){
//update the positions of the just added clusters/markers
this._topClusterLevel._recursively(a,o,t,function(t){h.removeLayer(t),t.clusterShow()}),this._animationEnd()})},_animationZoomOut:function(t,e){this._animationZoomOutSingle(this._topClusterLevel,t-1,e),//Need to add markers for those that weren't on the map before but are now
this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),//Remove markers that were on the map before but won't be now
this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t,this._getExpandedVisibleBounds())},_animationAddLayer:function(t,e){var i=this,n=this._featureGroup;n.addLayer(t),e!==t&&(2<e._childCount?(
//Was already a cluster
e._updateIcon(),this._forceLayout(),this._animationStart(),t._setPos(this._map.latLngToLayerPoint(e.getLatLng())),t.clusterHide(),this._enqueue(function(){n.removeLayer(t),t.clusterShow(),i._animationEnd()})):(
//Just became a cluster
this._forceLayout(),i._animationStart(),i._animationZoomOutSingle(e,this._map.getMaxZoom(),this._zoom)))}},
// Private methods for animated versions.
_animationZoomOutSingle:function(e,i,n){var o=this._getExpandedVisibleBounds(),s=Math.floor(this._map.getMinZoom());//Animate all of the markers in the clusters to move to their cluster center point
e._recursivelyAnimateChildrenInAndAddSelfToMap(o,s,i+1,n);var r=this;//Update the opacity (If we immediately set it they won't animate)
this._forceLayout(),e._recursivelyBecomeVisible(o,n),//TODO: Maybe use the transition timing stuff to make this more reliable
//When the animations are done, tidy up
this._enqueue(function(){
//This cluster stopped being a cluster before the timeout fired
var t;1===e._childCount?(t=e._markers[0],//If we were in a cluster animation at the time then the opacity and position of our child could be wrong now, so fix it
this._ignoreMove=!0,t.setLatLng(t.getLatLng()),this._ignoreMove=!1,t.clusterShow&&t.clusterShow()):e._recursively(o,n,s,function(t){t._recursivelyRemoveChildrenFromMap(o,s,i+1)}),r._animationEnd()})},_animationEnd:function(){this._map&&(this._map._mapPane.className=this._map._mapPane.className.replace(" leaflet-cluster-anim","")),this._inZoomAnimation--,this.fire("animationend")},
//Force a browser layout of stuff in the map
// Should apply the current opacity and location to all elements so we can update them again for an animation
_forceLayout:function(){
//In my testing this works, infact offsetWidth of any element seems to work.
//Could loop all this._layers and do this for each _icon if it stops working
L.Util.falseFn(document.body.offsetWidth)}}),L.markerClusterGroup=function(t){return new L.MarkerClusterGroup(t)};var i=L.MarkerCluster=L.Marker.extend({options:L.Icon.prototype.options,initialize:function(t,e,i,n){L.Marker.prototype.initialize.call(this,i?i._cLatLng||i.getLatLng():new L.LatLng(0,0),{icon:this,pane:t.options.clusterPane}),this._group=t,this._zoom=e,this._markers=[],this._childClusters=[],this._childCount=0,this._iconNeedsUpdate=!0,this._boundsNeedUpdate=!0,this._bounds=new L.LatLngBounds,i&&this._addChild(i),n&&this._addChild(n)},
//Recursively retrieve all child markers of this cluster
getAllChildMarkers:function(t,e){t=t||[];for(var i=this._childClusters.length-1;0<=i;i--)this._childClusters[i].getAllChildMarkers(t);for(var n=this._markers.length-1;0<=n;n--)e&&this._markers[n].__dragStart||t.push(this._markers[n]);return t},
//Returns the count of how many child markers we have
getChildCount:function(){return this._childCount},
//Zoom to the minimum of showing all of the child markers, or the extents of this cluster
zoomToBounds:function(t){//calculate how far we need to zoom down to see all of the markers
for(var e=this._childClusters.slice(),i=this._group._map,n=i.getBoundsZoom(this._bounds),o=this._zoom+1,i=i.getZoom();0<e.length&&o<n;){o++;for(var s=[],r=0;r<e.length;r++)s=s.concat(e[r]._childClusters);e=s}o<n?this._group._map.setView(this._latlng,o):n<=i?
//If fitBounds wouldn't zoom us down, zoom us down instead
this._group._map.setView(this._latlng,i+1):this._group._map.fitBounds(this._bounds,t)},getBounds:function(){var t=new L.LatLngBounds;return t.extend(this._bounds),t},_updateIcon:function(){this._iconNeedsUpdate=!0,this._icon&&this.setIcon(this)},
//Cludge for Icon, we pretend to be an icon for performance
createIcon:function(){return this._iconNeedsUpdate&&(this._iconObj=this._group.options.iconCreateFunction(this),this._iconNeedsUpdate=!1),this._iconObj.createIcon()},createShadow:function(){return this._iconObj.createShadow()},_addChild:function(t,e){this._iconNeedsUpdate=!0,this._boundsNeedUpdate=!0,this._setClusterCenter(t),t instanceof L.MarkerCluster?(e||(this._childClusters.push(t),t.__parent=this),this._childCount+=t._childCount):(e||this._markers.push(t),this._childCount++),this.__parent&&this.__parent._addChild(t,!0)},
/**
     * Makes sure the cluster center is set. If not, uses the child center if it is a cluster, or the marker position.
     * @param child L.MarkerCluster|L.Marker that will be used as cluster center if not defined yet.
     * @private
     */
_setClusterCenter:function(t){this._cLatLng||(
// when clustering, take position of the first point as the cluster center
this._cLatLng=t._cLatLng||t._latlng)},
/**
     * Assigns impossible bounding values so that the next extend entirely determines the new bounds.
     * This method avoids having to trash the previous L.LatLngBounds object and to create a new one, which is much slower for this class.
     * As long as the bounds are not extended, most other methods would probably fail, as they would with bounds initialized but not extended.
     * @private
     */
_resetBounds:function(){var t=this._bounds;t._southWest&&(t._southWest.lat=1/0,t._southWest.lng=1/0),t._northEast&&(t._northEast.lat=-1/0,t._northEast.lng=-1/0)},_recalculateBounds:function(){var t,e,i,n=this._markers,o=this._childClusters,s=0,r=0,a=this._childCount;// Case where all markers are removed from the map and we are left with just an empty _topClusterLevel.
if(0!==a){// Child markers.
for(// Reset rather than creating a new object, for performance.
this._resetBounds(),t=0;t<n.length;t++)e=n[t]._latlng,this._bounds.extend(e),s+=e.lat,r+=e.lng;// Child clusters.
for(t=0;t<o.length;t++)// Re-compute child bounds and weighted position first if necessary.
(i=o[t])._boundsNeedUpdate&&i._recalculateBounds(),this._bounds.extend(i._bounds),e=i._wLatLng,i=i._childCount,s+=e.lat*i,r+=e.lng*i;this._latlng=this._wLatLng=new L.LatLng(s/a,r/a),// Reset dirty flag.
this._boundsNeedUpdate=!1}},
//Set our markers position as given and add it to the map
_addToMap:function(t){t&&(this._backupLatlng=this._latlng,this.setLatLng(t)),this._group._featureGroup.addLayer(this)},_recursivelyAnimateChildrenIn:function(t,o,e){this._recursively(t,this._group._map.getMinZoom(),e-1,function(t){for(var e,i=t._markers,n=i.length-1;0<=n;n--)//Only do it if the icon is still on the map
(e=i[n])._icon&&(e._setPos(o),e.clusterHide())},function(t){for(var e,i=t._childClusters,n=i.length-1;0<=n;n--)(e=i[n])._icon&&(e._setPos(o),e.clusterHide())})},_recursivelyAnimateChildrenInAndAddSelfToMap:function(e,i,n,o){this._recursively(e,o,i,function(t){t._recursivelyAnimateChildrenIn(e,t._group._map.latLngToLayerPoint(t.getLatLng()).round(),n),//TODO: depthToAnimateIn affects _isSingleParent, if there is a multizoom we may/may not be.
//As a hack we only do a animation free zoom on a single level zoom, if someone does multiple levels then we always animate
t._isSingleParent()&&n-1===o?(t.clusterShow(),t._recursivelyRemoveChildrenFromMap(e,i,n)):t.clusterHide(),t._addToMap()})},_recursivelyBecomeVisible:function(t,e){this._recursively(t,this._group._map.getMinZoom(),e,null,function(t){t.clusterShow()})},_recursivelyAddChildrenToMap:function(n,o,s){this._recursively(s,this._group._map.getMinZoom()-1,o,function(t){if(o!==t._zoom)//Add our child markers at startPos (so they can be animated out)
for(var e=t._markers.length-1;0<=e;e--){var i=t._markers[e];s.contains(i._latlng)&&(n&&(i._backupLatlng=i.getLatLng(),i.setLatLng(n),i.clusterHide&&i.clusterHide()),t._group._featureGroup.addLayer(i))}},function(t){t._addToMap(n)})},_recursivelyRestoreChildPositions:function(t){
//Fix positions of child markers
for(var e=this._markers.length-1;0<=e;e--){var i=this._markers[e];i._backupLatlng&&(i.setLatLng(i._backupLatlng),delete i._backupLatlng)}if(t-1===this._zoom)
//Reposition child clusters
for(var n=this._childClusters.length-1;0<=n;n--)this._childClusters[n]._restorePosition();else for(var o=this._childClusters.length-1;0<=o;o--)this._childClusters[o]._recursivelyRestoreChildPositions(t)},_restorePosition:function(){this._backupLatlng&&(this.setLatLng(this._backupLatlng),delete this._backupLatlng)},
//exceptBounds: If set, don't remove any markers/clusters in it
_recursivelyRemoveChildrenFromMap:function(t,e,i,n){var o,s;this._recursively(t,e-1,i-1,function(t){
//Remove markers at every level
for(s=t._markers.length-1;0<=s;s--)o=t._markers[s],n&&n.contains(o._latlng)||(t._group._featureGroup.removeLayer(o),o.clusterShow&&o.clusterShow())},function(t){
//Remove child clusters at just the bottom level
for(s=t._childClusters.length-1;0<=s;s--)o=t._childClusters[s],n&&n.contains(o._latlng)||(t._group._featureGroup.removeLayer(o),o.clusterShow&&o.clusterShow())})},
//Run the given functions recursively to this and child clusters
// boundsToApplyTo: a L.LatLngBounds representing the bounds of what clusters to recurse in to
// zoomLevelToStart: zoom level to start running functions (inclusive)
// zoomLevelToStop: zoom level to stop running functions (inclusive)
// runAtEveryLevel: function that takes an L.MarkerCluster as an argument that should be applied on every level
// runAtBottomLevel: function that takes an L.MarkerCluster as an argument that should be applied at only the bottom level
_recursively:function(t,e,i,n,o){var s,r,a=this._childClusters,h=this._zoom;if(e<=h&&(n&&n(this),o&&h===i&&o(this)),h<e||h<i)for(s=a.length-1;0<=s;s--)(r=a[s])._boundsNeedUpdate&&r._recalculateBounds(),t.intersects(r._bounds)&&r._recursively(t,e,i,n,o)},
//Returns true if we are the parent of only one cluster and that cluster is the same as us
_isSingleParent:function(){
//Don't need to check this._markers as the rest won't work if there are any
return 0<this._childClusters.length&&this._childClusters[0]._childCount===this._childCount}});
/*
  * Extends L.Marker to include two extra methods: clusterHide and clusterShow.
  * 
  * They work as setOpacity(0) and setOpacity(1) respectively, but
  * don't overwrite the options.opacity
  * 
  */L.Marker.include({clusterHide:function(){var t=this.options.opacity;return this.setOpacity(0),this.options.opacity=t,this},clusterShow:function(){return this.setOpacity(this.options.opacity)}}),L.DistanceGrid=function(t){this._cellSize=t,this._sqCellSize=t*t,this._grid={},this._objectPoint={}},L.DistanceGrid.prototype={addObject:function(t,e){var i=this._getCoord(e.x),n=this._getCoord(e.y),o=this._grid,n=o[n]=o[n]||{},n=n[i]=n[i]||[],i=L.Util.stamp(t);this._objectPoint[i]=e,n.push(t)},updateObject:function(t,e){this.removeObject(t),this.addObject(t,e)},
//Returns true if the object was found
removeObject:function(t,e){var i,n,o=this._getCoord(e.x),s=this._getCoord(e.y),e=this._grid,r=e[s]=e[s]||{},a=r[o]=r[o]||[];for(delete this._objectPoint[L.Util.stamp(t)],i=0,n=a.length;i<n;i++)if(a[i]===t)return a.splice(i,1),1===n&&delete r[o],!0},eachObject:function(t,e){var i,n,o,s,r,a,h=this._grid;for(i in h)for(n in r=h[i])for(o=0,s=(a=r[n]).length;o<s;o++)t.call(e,a[o])&&(o--,s--)},getNearObject:function(t){for(var e,i,n,o,s,r,a,h=this._getCoord(t.x),l=this._getCoord(t.y),u=this._objectPoint,c=this._sqCellSize,_=null,d=l-1;d<=l+1;d++)if(n=this._grid[d])for(e=h-1;e<=h+1;e++)if(o=n[e])for(i=0,s=o.length;i<s;i++)r=o[i],((a=this._sqDist(u[L.Util.stamp(r)],t))<c||a<=c&&null===_)&&(c=a,_=r);return _},_getCoord:function(t){var e=Math.floor(t/this._cellSize);return isFinite(e)?e:t},_sqDist:function(t,e){var i=e.x-t.x,t=e.y-t.y;return i*i+t*t}},L.QuickHull={
/*
       * @param {Object} cpt a point to be measured from the baseline
       * @param {Array} bl the baseline, as represented by a two-element
       *   array of latlng objects.
       * @returns {Number} an approximate distance measure
       */
getDistant:function(t,e){var i=e[1].lat-e[0].lat;return(e[0].lng-e[1].lng)*(t.lat-e[0].lat)+i*(t.lng-e[0].lng)},
/*
       * @param {Array} baseLine a two-element array of latlng objects
       *   representing the baseline to project from
       * @param {Array} latLngs an array of latlng objects
       * @returns {Object} the maximum point and all new points to stay
       *   in consideration for the hull.
       */
findMostDistantPointFromBaseLine:function(t,e){for(var i,n,o=0,s=null,r=[],a=e.length-1;0<=a;a--)i=e[a],0<(n=this.getDistant(i,t))&&(r.push(i),o<n&&(o=n,s=i));return{maxPoint:s,newPoints:r}},
/*
       * Given a baseline, compute the convex hull of latLngs as an array
       * of latLngs.
       *
       * @param {Array} latLngs
       * @returns {Array}
       */
buildConvexHull:function(t,e){var i=[],e=this.findMostDistantPointFromBaseLine(t,e);return e.maxPoint?i=(
// if there is still a point "outside" the base line
i=i.concat(this.buildConvexHull([t[0],e.maxPoint],e.newPoints))).concat(this.buildConvexHull([e.maxPoint,t[1]],e.newPoints)):[t[0]]},
/*
       * Given an array of latlngs, compute a convex hull as an array
       * of latlngs
       *
       * @param {Array} latLngs
       * @returns {Array}
       */
getConvexHull:function(t){for(
// find first baseline
var e=!1,i=!1,n=!1,o=!1,s=null,r=null,a=null,h=null,l=null,u=null,c=t.length-1;0<=c;c--){var _=t[c];(!1===e||_.lat>e)&&(e=(s=_).lat),(!1===i||_.lat<i)&&(i=(r=_).lat),(!1===n||_.lng>n)&&(n=(a=_).lng),(!1===o||_.lng<o)&&(o=(h=_).lng)}return l=i!==e?(u=r,s):(u=h,a),[].concat(this.buildConvexHull([u,l],t),this.buildConvexHull([l,u],t))}},L.MarkerCluster.include({getConvexHull:function(){for(var t,e=this.getAllChildMarkers(),i=[],n=e.length-1;0<=n;n--)t=e[n].getLatLng(),i.push(t);return L.QuickHull.getConvexHull(i)}}),//This code is 100% based on https://github.com/jawj/OverlappingMarkerSpiderfier-Leaflet
//Huge thanks to jawj for implementing it first to make my job easy :-)
L.MarkerCluster.include({_2PI:2*Math.PI,_circleFootSeparation:25,
//related to circumference of circle
_circleStartAngle:0,_spiralFootSeparation:28,
//related to size of spiral (experiment!)
_spiralLengthStart:11,_spiralLengthFactor:5,_circleSpiralSwitchover:9,
//show spiral instead of circle from this marker count upwards.
// 0 -> always spiral; Infinity -> always circle
spiderfy:function(){var t,e;this._group._spiderfied===this||this._group._inZoomAnimation||(t=this.getAllChildMarkers(null,!0),e=this._group._map.latLngToLayerPoint(this._latlng),this._group._unspiderfy(),this._group._spiderfied=this,//TODO Maybe: childMarkers order by distance to center
e=t.length>=this._circleSpiralSwitchover?this._generatePointsSpiral(t.length,e):(e.y+=10,this._generatePointsCircle(t.length,e)),this._animationSpiderfy(t,e))},unspiderfy:function(t){
/// <param Name="zoomDetails">Argument from zoomanim if being called in a zoom animation or null otherwise</param>
this._group._inZoomAnimation||(this._animationUnspiderfy(t),this._group._spiderfied=null)},_generatePointsCircle:function(t,e){var i,n,o=this._group.options.spiderfyDistanceMultiplier*this._circleFootSeparation*(2+t)/this._2PI,
//radius from circumference
s=this._2PI/t,r=[],o=Math.max(o,35);for(// Minimum distance to get outside the cluster icon.
r.length=t,i=0;i<t;i++)
// Clockwise, like spiral.
n=this._circleStartAngle+i*s,r[i]=new L.Point(e.x+o*Math.cos(n),e.y+o*Math.sin(n))._round();return r},_generatePointsSpiral:function(t,e){// Higher index, closer position to cluster center.
for(var i=this._group.options.spiderfyDistanceMultiplier,n=i*this._spiralLengthStart,o=i*this._spiralFootSeparation,s=i*this._spiralLengthFactor*this._2PI,r=0,a=[],h=a.length=t;0<=h;h--)
// Skip the first position, so that we are already farther from center and we avoid
// being under the default cluster icon (especially important for Circle Markers).
h<t&&(a[h]=new L.Point(e.x+n*Math.cos(r),e.y+n*Math.sin(r))._round()),n+=s/(r+=o/n+5e-4*h);return a},_noanimationUnspiderfy:function(){var t,e,i=this._group,n=i._map,o=i._featureGroup,s=this.getAllChildMarkers(null,!0);for(i._ignoreMove=!0,this.setOpacity(1),e=s.length-1;0<=e;e--)t=s[e],o.removeLayer(t),t._preSpiderfyLatlng&&(t.setLatLng(t._preSpiderfyLatlng),delete t._preSpiderfyLatlng),t.setZIndexOffset&&t.setZIndexOffset(0),t._spiderLeg&&(n.removeLayer(t._spiderLeg),delete t._spiderLeg);i.fire("unspiderfied",{cluster:this,markers:s}),i._ignoreMove=!1,i._spiderfied=null}}),//Non Animated versions of everything
L.MarkerClusterNonAnimated=L.MarkerCluster.extend({_animationSpiderfy:function(t,e){var i,n,o,s,r=this._group,a=r._map,h=r._featureGroup,l=this._group.options.spiderLegPolylineOptions;// Traverse in ascending order to make sure that inner circleMarkers are on top of further legs. Normal markers are re-ordered by newPosition.
// The reverse order trick no longer improves performance on modern browsers.
for(r._ignoreMove=!0,i=0;i<t.length;i++)s=a.layerPointToLatLng(e[i]),n=t[i],// Add the leg before the marker, so that in case the latter is a circleMarker, the leg is behind it.
o=new L.Polyline([this._latlng,s],l),a.addLayer(o),n._spiderLeg=o,// Now add the marker.
n._preSpiderfyLatlng=n._latlng,n.setLatLng(s),n.setZIndexOffset&&n.setZIndexOffset(1e6),h.addLayer(n);this.setOpacity(.3),r._ignoreMove=!1,r.fire("spiderfied",{cluster:this,markers:t})},_animationUnspiderfy:function(){this._noanimationUnspiderfy()}}),//Animated versions here
L.MarkerCluster.include({_animationSpiderfy:function(t,e){var i,n,o,s,r,a,h=this,l=this._group,u=l._map,c=l._featureGroup,_=this._latlng,d=u.latLngToLayerPoint(_),p=L.Path.SVG,m=L.extend({},this._group.options.spiderLegPolylineOptions),
// Copy the options so that we can modify them for animation.
f=m.opacity;// Add markers and spider legs to map, hidden at our center point.
// Traverse in ascending order to make sure that inner circleMarkers are on top of further legs. Normal markers are re-ordered by newPosition.
// The reverse order trick no longer improves performance on modern browsers.
for(void 0===f&&(f=L.MarkerClusterGroup.prototype.options.spiderLegPolylineOptions.opacity),p?(
// If the initial opacity of the spider leg is not 0 then it appears before the animation starts.
m.opacity=0,// Add the class for CSS transitions.
m.className=(m.className||"")+" leaflet-cluster-spider-leg"):
// Make sure we have a defined opacity.
m.opacity=f,l._ignoreMove=!0,i=0;i<t.length;i++)n=t[i],a=u.layerPointToLatLng(e[i]),// Add the leg before the marker, so that in case the latter is a circleMarker, the leg is behind it.
o=new L.Polyline([_,a],m),u.addLayer(o),n._spiderLeg=o,// Explanations: https://jakearchibald.com/2013/animated-line-drawing-svg/
// In our case the transition property is declared in the CSS file.
p&&(r=(s=o._path).getTotalLength()+.1,// Need a small extra length to avoid remaining dot in Firefox.
s.style.strokeDasharray=r,// Just 1 length is enough, it will be duplicated.
s.style.strokeDashoffset=r),// If it is a marker, add it now and we'll animate it out
n.setZIndexOffset&&n.setZIndexOffset(1e6),n.clusterHide&&n.clusterHide(),// Vectors just get immediately added
c.addLayer(n),n._setPos&&n._setPos(d);// Reveal markers and spider legs.
for(l._forceLayout(),l._animationStart(),i=t.length-1;0<=i;i--)a=u.layerPointToLatLng(e[i]),//Move marker to new position
(n=t[i])._preSpiderfyLatlng=n._latlng,n.setLatLng(a),n.clusterShow&&n.clusterShow(),// Animate leg (animation is actually delegated to CSS transition).
p&&((s=(o=n._spiderLeg)._path).style.strokeDashoffset=0,//legPath.style.strokeOpacity = finalLegOpacity;
o.setStyle({opacity:f}));this.setOpacity(.3),l._ignoreMove=!1,setTimeout(function(){l._animationEnd(),l.fire("spiderfied",{cluster:h,markers:t})},200)},_animationUnspiderfy:function(t){var e,i,n,o,s,r=this,a=this._group,h=a._map,l=a._featureGroup,u=t?h._latLngToNewLayerPoint(this._latlng,t.zoom,t.center):h.latLngToLayerPoint(this._latlng),c=this.getAllChildMarkers(null,!0),_=L.Path.SVG;for(a._ignoreMove=!0,a._animationStart(),//Make us visible and bring the child markers back in
this.setOpacity(1),i=c.length-1;0<=i;i--)//Marker was added to us after we were spiderfied
(e=c[i])._preSpiderfyLatlng&&(//Close any popup on the marker first, otherwise setting the location of the marker will make the map scroll
e.closePopup(),//Fix up the location to the real one
e.setLatLng(e._preSpiderfyLatlng),delete e._preSpiderfyLatlng,//Hack override the location to be our center
s=!0,e._setPos&&(e._setPos(u),s=!1),e.clusterHide&&(e.clusterHide(),s=!1),s&&l.removeLayer(e),// Animate the spider leg back in (animation is actually delegated to CSS transition).
_&&(s=(o=(n=e._spiderLeg)._path).getTotalLength()+.1,o.style.strokeDashoffset=s,n.setStyle({opacity:0})));a._ignoreMove=!1,setTimeout(function(){
//If we have only <= one child left then that marker will be shown on the map so don't remove it!
var t=0;for(i=c.length-1;0<=i;i--)(e=c[i])._spiderLeg&&t++;for(i=c.length-1;0<=i;i--)(e=c[i])._spiderLeg&&(e.clusterShow&&e.clusterShow(),e.setZIndexOffset&&e.setZIndexOffset(0),1<t&&l.removeLayer(e),h.removeLayer(e._spiderLeg),delete e._spiderLeg);a._animationEnd(),a.fire("unspiderfied",{cluster:r,markers:c})},200)}}),L.MarkerClusterGroup.include({
//The MarkerCluster currently spiderfied (if any)
_spiderfied:null,unspiderfy:function(){this._unspiderfy.apply(this,arguments)},_spiderfierOnAdd:function(){this._map.on("click",this._unspiderfyWrapper,this),this._map.options.zoomAnimation&&this._map.on("zoomstart",this._unspiderfyZoomStart,this),//Browsers without zoomAnimation or a big zoom don't fire zoomstart
this._map.on("zoomend",this._noanimationUnspiderfy,this),L.Browser.touch||this._map.getRenderer(this)},_spiderfierOnRemove:function(){this._map.off("click",this._unspiderfyWrapper,this),this._map.off("zoomstart",this._unspiderfyZoomStart,this),this._map.off("zoomanim",this._unspiderfyZoomAnim,this),this._map.off("zoomend",this._noanimationUnspiderfy,this),//Ensure that markers are back where they should be
// Use no animation to avoid a sticky leaflet-cluster-anim class on mapPane
this._noanimationUnspiderfy()},
//On zoom start we add a zoomanim handler so that we are guaranteed to be last (after markers are animated)
//This means we can define the animation they do rather than Markers doing an animation to their actual location
_unspiderfyZoomStart:function(){this._map&&this._map.on("zoomanim",this._unspiderfyZoomAnim,this)},_unspiderfyZoomAnim:function(t){
//Wait until the first zoomanim after the user has finished touch-zooming before running the animation
L.DomUtil.hasClass(this._map._mapPane,"leaflet-touching")||(this._map.off("zoomanim",this._unspiderfyZoomAnim,this),this._unspiderfy(t))},_unspiderfyWrapper:function(){
/// <summary>_unspiderfy but passes no arguments</summary>
this._unspiderfy()},_unspiderfy:function(t){this._spiderfied&&this._spiderfied.unspiderfy(t)},_noanimationUnspiderfy:function(){this._spiderfied&&this._spiderfied._noanimationUnspiderfy()},
//If the given layer is currently being spiderfied then we unspiderfy it so it isn't on the map anymore etc
_unspiderfyLayer:function(t){t._spiderLeg&&(this._featureGroup.removeLayer(t),t.clusterShow&&t.clusterShow(),//Position will be fixed up immediately in _animationUnspiderfy
t.setZIndexOffset&&t.setZIndexOffset(0),this._map.removeLayer(t._spiderLeg),delete t._spiderLeg)}}),
/**
   * Adds 1 public method to MCG and 1 to L.Marker to facilitate changing
   * markers' icon options and refreshing their icon and their parent clusters
   * accordingly (case where their iconCreateFunction uses data of childMarkers
   * to make up the cluster icon).
   */
L.MarkerClusterGroup.include({
/**
     * Updates the icon of all clusters which are parents of the given marker(s).
     * In singleMarkerMode, also updates the given marker(s) icon.
     * @param layers L.MarkerClusterGroup|L.LayerGroup|Array(L.Marker)|Map(L.Marker)|
     * L.MarkerCluster|L.Marker (optional) list of markers (or single marker) whose parent
     * clusters need to be updated. If not provided, retrieves all child markers of this.
     * @returns {L.MarkerClusterGroup}
     */
refreshClusters:function(t){return t?t instanceof L.MarkerClusterGroup?t=t._topClusterLevel.getAllChildMarkers():t instanceof L.LayerGroup?t=t._layers:t instanceof L.MarkerCluster?t=t.getAllChildMarkers():t instanceof L.Marker&&(t=[t]):t=this._topClusterLevel.getAllChildMarkers(),// else: must be an Array(L.Marker)|Map(L.Marker)
this._flagParentsIconsNeedUpdate(t),this._refreshClustersIcons(),// In case of singleMarkerMode, also re-draw the markers.
this.options.singleMarkerMode&&this._refreshSingleMarkerModeMarkers(t),this},
/**
     * Simply flags all parent clusters of the given markers as having a "dirty" icon.
     * @param layers Array(L.Marker)|Map(L.Marker) list of markers.
     * @private
     */
_flagParentsIconsNeedUpdate:function(t){var e,i;// Assumes layers is an Array or an Object whose prototype is non-enumerable.
for(e in t)for(
// Flag parent clusters' icon as "dirty", all the way up.
// Dumb process that flags multiple times upper parents, but still
// much more efficient than trying to be smart and make short lists,
// at least in the case of a hierarchy following a power law:
// http://jsperf.com/flag-nodes-in-power-hierarchy/2
i=t[e].__parent;i;)i._iconNeedsUpdate=!0,i=i.__parent},
/**
     * Re-draws the icon of the supplied markers.
     * To be used in singleMarkerMode only.
     * @param layers Array(L.Marker)|Map(L.Marker) list of markers.
     * @private
     */
_refreshSingleMarkerModeMarkers:function(t){var e,i;for(e in t)i=t[e],// Make sure we do not override markers that do not belong to THIS group.
this.hasLayer(i)&&
// Need to re-create the icon first, then re-draw the marker.
i.setIcon(this._overrideMarkerIcon(i))}}),L.Marker.include({
/**
     * Updates the given options in the marker's icon and refreshes the marker.
     * @param options map object of icon options.
     * @param directlyRefreshClusters boolean (optional) true to trigger
     * MCG.refreshClustersOf() right away with this single marker.
     * @returns {L.Marker}
     */
refreshIconOptions:function(t,e){var i=this.options.icon;return L.setOptions(i,t),this.setIcon(i),// Shortcut to refresh the associated MCG clusters right away.
// To be used when refreshing a single marker.
// Otherwise, better use MCG.refreshClusters() once at the end with
// the list of modified markers.
e&&this.__parent&&this.__parent._group.refreshClusters(this),this}}),t.MarkerClusterGroup=e,t.MarkerCluster=i});