function _typeof(t){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}!function(t,i){"function"==typeof define&&define.amd?
// AMD
define(["leaflet","mapbox-gl"],i):"object"===("undefined"==typeof exports?"undefined":_typeof(exports))?
// Node, CommonJS-like
module.exports=i(require("leaflet"),require("mapbox-gl")):
// Browser globals (root is window)
t.returnExports=i(window.L,window.mapboxgl)}(this,function(a,s){a.MapboxGL=a.Layer.extend({options:{updateInterval:32,
// How much to extend the overlay view (relative to map size)
// e.g. 0.1 would be 10% of map view in each direction
padding:.1,
// whether or not to register the mouse and keyboard
// events on the mapbox overlay
interactive:!1,
// set the tilepane as the default pane to draw gl tiles
pane:"tilePane"},initialize:function(t){a.setOptions(this,t),t.accessToken&&(s.accessToken=t.accessToken),// setup throttling the update event when panning
this._throttledUpdate=a.Util.throttle(this._update,this.options.updateInterval,this)},onAdd:function(t){this._container||this._initContainer();var i=this.getPaneName();t.getPane(i).appendChild(this._container),this._initGL(),this._offset=this._map.containerPointToLayerPoint([0,0]),// work around https://github.com/mapbox/mapbox-gl-leaflet/issues/47
t.options.zoomAnimation&&a.DomEvent.on(t._proxy,a.DomUtil.TRANSITION_END,this._transitionEnd,this)},onRemove:function(t){this._map._proxy&&this._map.options.zoomAnimation&&a.DomEvent.off(this._map._proxy,a.DomUtil.TRANSITION_END,this._transitionEnd,this);var i=this.getPaneName();t.getPane(i).removeChild(this._container),this._glMap.remove(),this._glMap=null},getEvents:function(){return{move:this._throttledUpdate,
// sensibly throttle updating while panning
zoomanim:this._animateZoom,
// applys the zoom animation to the <canvas>
zoom:this._pinchZoom,
// animate every zoom event for smoother pinch-zooming
zoomstart:this._zoomStart,
// flag starting a zoom to disable panning
zoomend:this._zoomEnd,resize:this._resize}},getMapboxMap:function(){return this._glMap},getCanvas:function(){return this._glMap.getCanvas()},getSize:function(){return this._map.getSize().multiplyBy(1+2*this.options.padding)},getBounds:function(){var t=this.getSize().multiplyBy(.5),i=this._map.latLngToContainerPoint(this._map.getCenter());return a.latLngBounds(this._map.containerPointToLatLng(i.subtract(t)),this._map.containerPointToLatLng(i.add(t)))},getContainer:function(){return this._container},
// returns the pane name set in options if it is a valid pane, defaults to tilePane
getPaneName:function(){return this._map.getPane(this.options.pane)?this.options.pane:"tilePane"},_initContainer:function(){var t=this._container=a.DomUtil.create("div","leaflet-gl-layer"),i=this.getSize(),o=this._map.getSize().multiplyBy(this.options.padding);t.style.width=i.x+"px",t.style.height=i.y+"px";o=this._map.containerPointToLayerPoint([0,0]).subtract(o);a.DomUtil.setPosition(t,o)},_initGL:function(){var t=this._map.getCenter(),t=a.extend({},this.options,{container:this._container,center:[t.lng,t.lat],zoom:this._map.getZoom()-1,attributionControl:!1});this._glMap=new s.Map(t),// allow GL base map to pan beyond min/max latitudes
this._glMap.transform.latRange=null,this._glMap._canvas.canvas?
// older versions of mapbox-gl surfaced the canvas differently
this._glMap._actualCanvas=this._glMap._canvas.canvas:this._glMap._actualCanvas=this._glMap._canvas;// treat child <canvas> element like L.ImageOverlay
t=this._glMap._actualCanvas;a.DomUtil.addClass(t,"leaflet-image-layer"),a.DomUtil.addClass(t,"leaflet-zoom-animated"),this.options.interactive&&a.DomUtil.addClass(t,"leaflet-interactive"),this.options.className&&a.DomUtil.addClass(t,this.options.className)},_update:function(){var t,i,o,n,e;
// update the offset so we can correct for it later when we zoom
this._offset=this._map.containerPointToLayerPoint([0,0]),this._zooming||(t=this.getSize(),i=this._container,o=this._glMap,n=this._map.getSize().multiplyBy(this.options.padding),e=this._map.containerPointToLayerPoint([0,0]).subtract(n),a.DomUtil.setPosition(i,e),n=this._map.getCenter(),(e=o.transform).center=s.LngLat.convert([n.lng,n.lat]),e.zoom=this._map.getZoom()-1,o.transform.width!==t.x||o.transform.height!==t.y?(i.style.width=t.x+"px",i.style.height=t.y+"px",null!==o._resize&&void 0!==o._resize?o._resize():o.resize()):
// older versions of mapbox-gl surfaced update publicly
null!==o._update&&void 0!==o._update?o._update():o.update())},
// update the map constantly during a pinch zoom
_pinchZoom:function(){this._glMap.jumpTo({zoom:this._map.getZoom()-1,center:this._map.getCenter()})},
// borrowed from L.ImageOverlay
// https://github.com/Leaflet/Leaflet/blob/master/src/layer/ImageOverlay.js#L139-L144
_animateZoom:function(t){var i=this._map.getZoomScale(t.zoom),o=this._map.getSize().multiplyBy(this.options.padding*i),n=this.getSize()._divideBy(2),o=this._map.project(t.center,t.zoom)._subtract(n)._add(this._map._getMapPanePos().add(o))._round(),o=this._map.project(this._map.getBounds().getNorthWest(),t.zoom)._subtract(o);a.DomUtil.setTransform(this._glMap._actualCanvas,o.subtract(this._offset),i)},_zoomStart:function(){this._zooming=!0},_zoomEnd:function(){var t=this._map.getZoomScale(this._map.getZoom()),i=this._map._latLngToNewLayerPoint(this._map.getBounds().getNorthWest(),this._map.getZoom(),this._map.getCenter());a.DomUtil.setTransform(this._glMap._actualCanvas,i.subtract(this._offset),t),this._zooming=!1,this._update()},_transitionEnd:function(){a.Util.requestAnimFrame(function(){var t=this._map.getZoom(),i=this._map.getCenter(),o=this._map.latLngToContainerPoint(this._map.getBounds().getNorthWest());// reset the scale and offset
a.DomUtil.setTransform(this._glMap._actualCanvas,o,1),// enable panning once the gl map is ready again
this._glMap.once("moveend",a.Util.bind(function(){this._zoomEnd()},this)),// update the map position
this._glMap.jumpTo({center:i,zoom:t-1})},this)},_resize:function(t){this._transitionEnd(t)}}),a.mapboxGL=function(t){return new a.MapboxGL(t)}});