// Based on https://github.com/shramov/leaflet-plugins
// GridLayer like https://avinmathew.com/leaflet-and-google-maps/ , but using MutationObserver instead of jQuery
// 🍂class GridLayer.GoogleMutant
// 🍂extends GridLayer
L.GridLayer.GoogleMutant=L.GridLayer.extend({options:{minZoom:0,maxZoom:21,
// can be 23, but ugly if more than maxNativeZoom
tileSize:256,subdomains:"abc",errorTileUrl:"",attribution:"",
// The mutant container will add its own attribution anyways.
opacity:1,continuousWorld:!1,noWrap:!1,
// 🍂option type: String = 'roadmap'
// Google's map type. Valid values are 'roadmap', 'satellite' or 'terrain'. 'hybrid' is not really supported.
type:"roadmap",maxNativeZoom:21},initialize:function(t){L.GridLayer.prototype.initialize.call(this,t),this._ready=!!window.google&&!!window.google.maps&&!!window.google.maps.Map,this._isMounted=!0,this._GAPIPromise=this._ready?Promise.resolve(window.google):new Promise(function(t,e){var i=0,n=null,n=setInterval(function(){return 10<=i?(clearInterval(n),e(new Error("window.google not found after 10 attempts"))):window.google&&window.google.maps&&window.google.maps.Map?(clearInterval(n),t(window.google)):void++i},500)}),this.once("spawned",function(){if(this._subLayers)
//restore previously added google layers
for(var t in this._subLayers)this._subLayers[t].setMap(this._mutant)}),// Couple data structures indexed by tile key
this._tileCallbacks={},// Callbacks for promises for tiles that are expected
this._freshTiles={},// Tiles from the mutant which haven't been requested yet
this._imagesPerTile="hybrid"===this.options.type?2:1,this._boundOnMutatedImage=this._onMutatedImage.bind(this)},onAdd:function(e){L.GridLayer.prototype.onAdd.call(this,e),this._initMutantContainer(),this._GAPIPromise.then(function(){var t;this._isMounted&&(this._ready=!0,this._initMutant(),(e=this._map)&&(t=this.options.updateWhenIdle?"moveend":"move",e.on(t,this._update,this),this.once("remove",function(){this._map.off(t,this._update,this)}),//handle layer being added to a map for which there are no Google tiles at the given zoom
google.maps.event.addListenerOnce(this._mutant,"idle",function(){this._map&&(this._checkZoomLevels(),this._mutantIsReady=!0)}.bind(this)),//20px instead of 1em to avoid a slight overlap with google's attribution
e._controlCorners.bottomright.style.marginBottom="20px",e._controlCorners.bottomleft.style.marginBottom="20px",this._update()))}.bind(this))},onRemove:function(t){L.GridLayer.prototype.onRemove.call(this,t),this._observer.disconnect(),t._container.removeChild(this._mutantContainer),google.maps.event.clearListeners(t,"idle"),this._mutant&&google.maps.event.clearListeners(this._mutant,"idle"),t.off("viewreset",this._reset,this),t.off("move",this._update,this),t.off("moveend",this._update,this),t.off("zoomend",this._handleZoomAnim,this),t.off("resize",this._resize,this),t._controlCorners&&(t._controlCorners.bottomright.style.marginBottom=0,t._controlCorners.bottomleft.style.marginBottom=0),this._isMounted=!1},
// @method addGoogleLayer(name: String, options?: Object): this
// Adds layer with the given name and options to the google Map instance.
// `name`: one of the google maps API layers, with it's constructor available in `google.maps` object.
// currently following values supported: 'TrafficLayer', 'TransitLayer', 'BicyclingLayer'.
// `options`: see https://developers.google.com/maps/documentation/javascript/reference/map
addGoogleLayer:function(e,i){return this._subLayers||(this._subLayers={}),this._GAPIPromise.then(function(){var t=new google.maps[e](i);this._mutant&&t.setMap(this._mutant),// otherwise it will be added on 'spawned'
this._subLayers[e]=t}.bind(this)),this},
// @method removeGoogleLayer(name: String): this
// Removes layer with the given name from the google Map instance.
removeGoogleLayer:function(e){return this._GAPIPromise.then(function(){var t=this._subLayers&&this._subLayers[e];t&&(t.setMap(null),delete this._subLayers[e])}.bind(this)),this},_initMutantContainer:function(){this._mutantContainer||(this._mutantContainer=L.DomUtil.create("div","leaflet-google-mutant leaflet-top leaflet-left"),this._mutantContainer.id="_MutantContainer_"+L.Util.stamp(this._mutantContainer),this._mutantContainer.style.zIndex=800,//leaflet map pane at 400, controls at 1000
this._mutantContainer.style.pointerEvents="none",L.DomEvent.off(this._mutantContainer)),this._map.getContainer().appendChild(this._mutantContainer),this.setOpacity(this.options.opacity);var t=this._mutantContainer.style;t.width="100%",t.height="100%",this._attachObserver(this._mutantContainer)},_initMutant:function(){var t;this._mutant||(t=new google.maps.Map(this._mutantContainer,{center:{lat:0,lng:0},zoom:0,tilt:0,mapTypeId:this.options.type,disableDefaultUI:!0,keyboardShortcuts:!1,draggable:!1,disableDoubleClickZoom:!0,scrollwheel:!1,streetViewControl:!1,styles:this.options.styles||{},backgroundColor:"transparent"}),this._mutant=t,google.maps.event.addListenerOnce(t,"idle",function(){for(var t=this._mutantContainer.querySelectorAll("a"),e=0;e<t.length;++e)t[e].style.pointerEvents="auto"}.bind(this)),// 🍂event spawned
// Fired when the mutant has been created.
this.fire("spawned",{mapObject:t}))},_attachObserver:function(t){
// 		console.log('Gonna observe', node);
this._observer||(this._observer=new MutationObserver(this._onMutations.bind(this))),// pass in the target node, as well as the observer options
this._observer.observe(t,{childList:!0,subtree:!0}),// if we are reusing an old _mutantContainer, we must manually detect
// all existing tiles in it
Array.prototype.forEach.call(t.querySelectorAll("img"),this._boundOnMutatedImage)},_onMutations:function(t){for(var e=0;e<t.length;++e)for(var i=t[e],n=0;n<i.addedNodes.length;++n){var a=i.addedNodes[n];a instanceof HTMLImageElement?this._onMutatedImage(a):a instanceof HTMLElement&&(Array.prototype.forEach.call(a.querySelectorAll("img"),this._boundOnMutatedImage),// Check for, and remove, the "Google Maps can't load correctly" div.
// You *are* loading correctly, you dumbwit.
"white"===a.style.backgroundColor&&L.DomUtil.remove(a),// Check for, and remove, the "For development purposes only" divs on the aerial/hybrid tiles.
0===a.textContent.indexOf("For development purposes only")&&L.DomUtil.remove(a),// Check for, and remove, the "Sorry, we have no imagery here"
// empty <div>s. The [style*="text-align: center"] selector
// avoids matching the attribution notice.
// This empty div doesn't have a reference to the tile
// coordinates, so it's not possible to mark the tile as
// failed.
Array.prototype.forEach.call(a.querySelectorAll('div[draggable=false][style*="text-align: center"]'),L.DomUtil.remove))}},
// Only images which 'src' attrib match this will be considered for moving around.
// Looks like some kind of string-based protobuf, maybe??
// Only the roads (and terrain, and vector-based stuff) match this pattern
_roadRegexp:/!1i(\d+)!2i(\d+)!3i(\d+)!/,
// On the other hand, raster imagery matches this other pattern
_satRegexp:/x=(\d+)&y=(\d+)&z=(\d+)/,
// On small viewports, when zooming in/out, a static image is requested
// This will not be moved around, just removed from the DOM.
_staticRegExp:/StaticMapService\.GetMapImage/,_onMutatedImage:function(t){
// 		if (imgNode.src) {
// 			console.log('caught mutated image: ', imgNode.src);
// 		}
var e,i=t.src.match(this._roadRegexp),n=0;i?(e={z:i[1],x:i[2],y:i[3]},1<this._imagesPerTile&&(n=t.style.zIndex=1)):((i=t.src.match(this._satRegexp))&&(e={x:i[1],y:i[2],z:i[3]}),// 			imgNode.style.zIndex = 0;
n=0),e?(i=this._tileCoordsToKey(e),t.style.position="absolute",t.style.visibility="hidden",e=i+"/"+n,// console.log('mutation for tile', key)
//store img so it can also be used in subsequent tile requests
this._freshTiles[e]=t,e in this._tileCallbacks&&this._tileCallbacks[e]?(
// console.log('Fullfilling callback ', key);
//fullfill most recent tileCallback because there maybe callbacks that will never get a
//corresponding mutation (because map moved to quickly...)
this._tileCallbacks[e].pop()(t),this._tileCallbacks[e].length||delete this._tileCallbacks[e]):this._tiles[i]&&(e=this._tiles[i].el,i=0===n?e.firstChild:e.firstChild.nextSibling,n=this._clone(t),e.replaceChild(n,i))):t.src.match(this._staticRegExp)&&(t.style.visibility="hidden")},createTile:function(t,i){var e=this._tileCoordsToKey(t),n=L.DomUtil.create("div");n.dataset.pending=this._imagesPerTile,i=i.bind(this,null,n);for(var a=0;a<this._imagesPerTile;++a){var s,o=e+"/"+a;o in this._freshTiles?(s=this._freshTiles[o],n.appendChild(this._clone(s)),--n.dataset.pending):(this._tileCallbacks[o]=this._tileCallbacks[o]||[],this._tileCallbacks[o].push(function(e
/*, k2*/){return function(t){e.appendChild(this._clone(t)),--e.dataset.pending,parseInt(e.dataset.pending)||i()}.bind(this)}.bind(this)(n
/*, key2*/)))}return parseInt(n.dataset.pending)||L.Util.requestAnimFrame(i),n},_clone:function(t){t=t.cloneNode(!0);return t.style.visibility="visible",t},_checkZoomLevels:function(){
//setting the zoom level on the Google map may result in a different zoom level than the one requested
//(it won't go beyond the level for which they have data).
var t=this._map.getZoom(),e=this._mutant.getZoom();t&&e&&(e!==t||//zoom levels are out of sync, Google doesn't have data
e>this.options.maxNativeZoom)&&
//at current location, Google does have data (contrary to maxNativeZoom)
//Update maxNativeZoom
this._setMaxNativeZoom(e)},_setMaxNativeZoom:function(t){t!==this.options.maxNativeZoom&&(this.options.maxNativeZoom=t,this._resetView())},_update:function(){
// zoom level check needs to happen before super's implementation (tile addition/creation)
// otherwise tiles may be missed if maxNativeZoom is not yet correctly determined
var t,e,i;this._mutant&&(e=this._map.getCenter(),i=new google.maps.LatLng(e.lat,e.lng),this._mutant.setCenter(i),e=(t=this._map.getZoom())!==Math.round(t),i=this._mutant.getZoom(),//ignore fractional zoom levels
e||t===i||(this._mutant.setZoom(t),this._mutantIsReady&&this._checkZoomLevels())),L.GridLayer.prototype._update.call(this)},_resize:function(){var t=this._map.getSize();this._mutantContainer.style.width===t.x&&this._mutantContainer.style.height===t.y||(this.setElementSize(this._mutantContainer,t),this._mutant&&google.maps.event.trigger(this._mutant,"resize"))},_handleZoomAnim:function(){if(this._mutant){var t=this._map.getCenter(),t=new google.maps.LatLng(t.lat,t.lng);this._mutant.setCenter(t),this._mutant.setZoom(Math.round(this._map.getZoom()));var e,i=this._mutant.getZoom();// for (let key of Object.keys(this._freshTiles)) {
// IE-compatible code, in ecmascript5:
for(e in Object.keys(this._freshTiles))i!==e.split(":")[2]
/* tileZoom */&&delete this._freshTiles[e]}},
// Agressively prune _freshtiles when a tile with the same key is removed,
// this prevents a problem where Leaflet keeps a loaded tile longer than
// GMaps, so that GMaps makes two requests but Leaflet only consumes one,
// polluting _freshTiles with stale data.
_removeTile:function(t){if(this._mutant)//give time for animations to finish before checking it tile should be pruned
return setTimeout(this._pruneTile.bind(this,t),1e3),L.GridLayer.prototype._removeTile.call(this,t)},_getLargeGMapBound:function(t){var e=t.getSouthWest(),i=t.getNorthEast(),n=e.lat(),a=e.lng(),s=i.lat(),t=i.lng(),e=Math.abs(s-n),i=Math.abs(t-a);return L.latLngBounds([[n-e,a-i],[s+e,t+i]])},_pruneTile:function(t){var e=this._mutant.getZoom(),i=t.split(":")[2],n=this._mutant.getBounds(),a=this._getLargeGMapBound(n);if(n)for(var s=0;s<this._imagesPerTile;++s){var o,r=t+"/"+s;r in this._freshTiles&&(o=this._map&&this._keyToBounds(t),this._map&&o.overlaps(a)&&i===e||delete this._freshTiles[r])}}}),// 🍂factory gridLayer.googleMutant(options)
// Returns a new `GridLayer.GoogleMutant` given its options
L.gridLayer.googleMutant=function(t){return new L.GridLayer.GoogleMutant(t)},
/*!
 * Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 * License: WTFPL V2, 2004 (wtfpl.net).
 * Though credit and staring the repo will make me feel pretty, you can modify and redistribute as you please.
 * Attempts to follow spec (https://www.w3.org/TR/dom/#mutation-observers) as closely as possible for native javascript
 * See https://github.com/WebKit/webkit/blob/master/Source/WebCore/dom/MutationObserver.cpp for current webkit source c++ implementation
 */
/**
 * prefix bugs:
    - https://bugs.webkit.org/show_bug.cgi?id=85161
    - https://bugzilla.mozilla.org/show_bug.cgi?id=749920
 * Don't use WebKitMutationObserver as Safari (6.0.5-6.1) use a buggy implementation
*/
window.MutationObserver||(window.MutationObserver=function(L){"use strict";
/**
     * @param {function(Array.<MutationRecord>, MutationObserver)} listener
     * @constructor
     */function h(t){
/**
       * @type {Array.<Object>}
       * @private
       */
this._watched=[],
/** @private */
this._listener=t}
/**
     * Start a recursive timeout function to check all items being observed for mutations
     * @type {MutationObserver} observer
     * @private
     */
/**
     * Simple MutationRecord pseudoclass. No longer exposing as its not fully compliant
     * @param {Object} data
     * @return {Object} a MutationRecord
     */
function C(t){var e,i={
// technically these should be on proto so hasOwnProperty will return false for non explicitly props
type:null,target:null,addedNodes:[],removedNodes:[],previousSibling:null,nextSibling:null,attributeName:null,attributeNamespace:null,oldValue:null};for(e in t)m(i,e)&&t[e]!==L&&(i[e]=t[e]);return i}
/**
     * Creates a func to find all the mutations
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     */
/**
     * Period to check for mutations (~32 times/sec)
     * @type {number}
     * @expose
     */
h._period=30
/*ms+runtime*/,
/**
     * Exposed API
     * @expose
     * @final
     */
h.prototype={
/**
       * see https://dom.spec.whatwg.org/#dom-mutationobserver-observe
       * not going to throw here but going to follow the current spec config sets
       * @param {Node|null} $target
       * @param {Object|null} config : MutationObserverInit configuration dictionary
       * @expose
       * @return undefined
       */
observe:function(t,e){// remove already observed target element from pool
for(
/**
         * Using slightly different names so closure can go ham
         * @type {!Object} : A custom mutation config
         */
var n,a,s,i,o={attr:!!(e.attributes||e.attributeFilter||e.attributeOldValue),
// some browsers enforce that subtree must be set with childList, attributes or characterData.
// We don't care as spec doesn't specify this rule.
kids:!!e.childList,descendents:!!e.subtree,charData:!(!e.characterData&&!e.characterDataOldValue)},r=this._watched,l=0;l<r.length;l++)r[l].tar===t&&r.splice(l,1);e.attributeFilter&&(
/**
           * converts to a {key: true} dict for faster lookup
           * @type {Object.<String,Boolean>}
           */
o.afilter=c(e.attributeFilter,function(t,e){return t[e]=!0,t},{})),r.push({tar:t,fn:(s=d(n=t,a=o),function(t){var e,g,f,v,i=t.length;
/*
       * Helper to identify node rearrangment and stuff...
       * There is no gaurentee that the same node will be identified for both added and removed nodes
       * if the positions have been shuffled.
       * conflicts array will be emptied by end of operation
       */
function y(t,e,i,n,a){for(
// the distance between the first conflicting node and the last
var s,o,r,l=t.length-1,h=-~((l-a)/2)// prevents same conflict being resolved twice consider when two nodes switch places.
// only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
;r=t.pop();)s=i[r.i],o=n[r.j],// attempt to determine if there was node rearrangement... won't gaurentee all matches
// also handles case where added/removed nodes cause nodes to be identified as conflicts
f.kids&&h&&Math.abs(r.i-r.j)>=l&&(g.push(C({type:"childList",target:e,addedNodes:[s],removedNodes:[s],
// haha don't rely on this please
nextSibling:s.nextSibling,previousSibling:s.previousSibling})),h--),// Alright we found the resorted nodes now check for other types of mutations
f.attr&&o.attr&&w(g,s,o.attr,f.afilter),f.charData&&3===s.nodeType&&s.nodeValue!==o.charData&&g.push(C({type:"characterData",target:s,oldValue:o.charData})),// now look @ subtree
f.descendents&&b(s,o)}
/**
       * Main worker. Finds and adds mutations if there are any
       * @param {Node} node
       * @param {!Object} old : A cloned data structure using internal clone
       */function b(t,e){// while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
for(var i,n,a,s,o,r,l,h=t.childNodes,u=e.kids,d=h.length,c=u?u.length:0,m=0,_=0,p=0;_<d||p<c;)
// current and old nodes at the indexs
(r=h[_])===(l=(o=u[p])&&o.node)?(
// expected case - optimized for this case
// check attributes as specified by config
f.attr&&o.attr&&
/* oldstruct.attr instead of textnode check */
w(g,r,o.attr,f.afilter),// check character data if node is a comment or textNode and it's being observed
f.charData&&o.charData!==L&&r.nodeValue!==o.charData&&g.push(C({type:"characterData",target:r,oldValue:o.charData})),// resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
n&&y(n,t,h,u,m),// recurse on next level of children. Avoids the recursive call when there are no children left to iterate
f.descendents&&(r.childNodes.length||o.kids&&o.kids.length)&&b(r,o),_++,p++):(
// (uncommon case) lookahead until they are the same again or the end of children
v=!0,i||(
// delayed initalization (big perf benefit)
i={},n=[]),r&&(
// check id is in the location map otherwise do a indexOf search
i[a=M(r)]||(
// to prevent double checking
// mark id as found
i[a]=!0,// custom indexOf using comparitor checking oldkids[i].node === $cur
-1===(s=T(u,r,p,"node"))?f.kids&&(g.push(C({type:"childList",target:t,addedNodes:[r],
// $cur is a new node
nextSibling:r.nextSibling,previousSibling:r.previousSibling})),m++):n.push({
// add conflict
i:_,j:s})),_++),l&&// special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
l!==h[_]&&(i[a=M(l)]||(i[a]=!0,-1===(s=T(h,l,_))?f.kids&&(g.push(C({type:"childList",target:e.node,removedNodes:[l],nextSibling:u[p+1],
// praise no indexoutofbounds exception
previousSibling:u[p-1]})),m--):n.push({i:s,j:p})),p++));// end loop
// resolve any remaining conflicts
n&&y(n,t,h,u,m)}a.charData&&3===n.nodeType&&n.nodeValue!==s.charData&&t.push(new C({type:"characterData",target:n,oldValue:s.charData})),// Alright we check base level changes in attributes... easy
a.attr&&s.attr&&w(t,n,s.attr,a.afilter),// check childlist or subtree for mutations
(a.kids||a.descendents)&&(g=t,f=a,b(n,s),e=v),// reclone data structure if theres changes
!e&&t.length===i||(
/** type {Elestuct} */
s=d(n,a))})}),// reconnect if not connected
this._timeout||(i=this,function t(){var e=i.takeRecords();e.length&&
// fire away
// calling the listener with context is not spec but currently consistent with FF and WebKit
i._listener(e,i)
/** @private */,i._timeout=setTimeout(t,h._period)}())},
/**
       * Finds mutations since last check and empties the "record queue" i.e. mutations will only be found once
       * @expose
       * @return {Array.<MutationRecord>}
       */
takeRecords:function(){for(var t=[],e=this._watched,i=0;i<e.length;i++)e[i].fn(t);return t},
/**
       * @expose
       * @return undefined
       */
disconnect:function(){this._watched=[],// clear the stuff being observed
clearTimeout(this._timeout),// ready for garbage collection
/** @private */
this._timeout=null}};
/* attributes + attributeFilter helpers */
// Check if the environment has the attribute bug (#4) which cause
// element.attributes.style to always be null.
var t=document.createElement("i");t.style.top=0;var u=(t="null"!=t.attributes.style.value)?
/**
     * Gets an attribute value in an environment without attribute bug
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */
function(t,e){
// There is a potential for a warning to occur here if the attribute is a
// custom attribute in IE<9 with a custom .toString() method. This is
// just a warning and doesn't affect execution (see #21)
return e.value}
/**
     * Gets an attribute value with special hack for style attribute (see #4)
     *
     * @param {Node} el
     * @param {Attr} attr
     * @return {String} an attribute value
     */:function(t,e){
// As with getAttributeSimple there is a potential warning for custom attribtues in IE7.
return"style"!==e.name?e.value:t.style.cssText};
/**
     * fast helper to check to see if attributes object of an element has changed
     * doesnt handle the textnode case
     *
     * @param {Array.<MutationRecord>} mutations
     * @param {Node} $target
     * @param {Object.<string, string>} $oldstate : Custom attribute clone data structure from clone
     * @param {Object} filter
     */function w(t,e,i,n){for(var a,s,o={},r=e.attributes,l=r.length;l--;)s=(a=r[l]).name,n&&!m(n,s)||(u(e,a)!==i[s]&&
// The pushing is redundant but gzips very nicely
t.push(C({type:"attributes",target:e,attributeName:s,oldValue:i[s],attributeNamespace:a.namespaceURI})),o[s]=!0);for(s in i)o[s]||t.push(C({target:e,type:"attributes",attributeName:s,oldValue:i[s]}))}
/**
     * searchSubtree: array of mutations so far, element, element clone, bool
     * synchronous dfs comparision of two nodes
     * This function is applied to any observed element with childList or subtree specified
     * Sorry this is kind of confusing as shit, tried to comment it a bit...
     * codereview.stackexchange.com/questions/38351 discussion of an earlier version of this func
     *
     * @param {Array} mutations
     * @param {Node} $target
     * @param {!Object} $oldstate : A custom cloned node from clone()
     * @param {!Object} config : A custom mutation config
     */
/**
     * Utility
     * Cones a element into a custom data structure designed for comparision. https://gist.github.com/megawac/8201012
     *
     * @param {Node} $target
     * @param {!Object} config : A custom mutation config
     * @return {!Object} : Cloned data structure
     */
function d(t,n){var a=!0;// set true so childList we'll always check the first level
return function t(i){var e={
/** @type {Node} */
node:i};// Store current character data of target text or comment node if the config requests
// those properties to be observed.
return!n.charData||3!==i.nodeType&&8!==i.nodeType?(
// Add attr only if subtree is specified or top level and avoid if
// attributes is a document object (#13).
n.attr&&a&&1===i.nodeType&&(
/**
               * clone live attribute list to an object structure {name: val}
               * @type {Object.<string, string>}
               */
e.attr=c(i.attributes,function(t,e){return n.afilter&&!n.afilter[e.name]||(t[e.name]=u(i,e)),t},{})),// whether we should iterate the children of $target node
a&&(n.kids||n.charData||n.attr&&n.descendents)&&(
/** @type {Array.<!Object>} : Array of custom clone */
e.kids=
/**
     * **map** Apply a mapping function to each item of a set
     * @param {Array|NodeList} set
     * @param {Function} iterator
     */
function(t,e){for(var i=[],n=0;n<t.length;n++)i[n]=e(t[n],n,t);return i}
/**
     * **Reduce** builds up a single result from a list of values
     * @param {Array|NodeList|NamedNodeMap} set
     * @param {Function} iterator
     * @param {*} [memo] Initial value of the memo.
     */(i.childNodes,t)),a=n.descendents):e.charData=i.nodeValue,e}(t)}
/**
     * indexOf an element in a collection of custom nodes
     *
     * @param {NodeList} set
     * @param {!Object} $node : A custom cloned node
     * @param {number} idx : index to start the loop
     * @return {number}
     */ // using a non id (eg outerHTML or nodeValue) is extremely naive and will run into issues with nodes that may appear the same like <li></li>
var i=1,n="mo_id";// don't use 0 as id (falsy)
/** @const */
/**
     * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
     *
     * @param {Node} $ele
     * @return {(string|number)}
     */
function M(e){try{return e.id||(e[n]=e[n]||i++)}catch(t){
// ie <8 will throw if you set an unknown property on a text node
try{return e.nodeValue;// naive
}catch(t){
// when text node is removed: https://gist.github.com/megawac/8355978 :(
return i++}}}function c(t,e,i){for(var n=0;n<t.length;n++)i=e(i,t[n],n,t);return i}
/**
     * **indexOf** find index of item in collection.
     * @param {Array|NodeList} set
     * @param {Object} item
     * @param {number} idx
     * @param {string} [prop] Property on set item to compare to item
     */function T(t,e,i,n){for(;
/*idx = ~~idx*/
i<t.length;i++)
// start idx is always given as this is internal
if((n?t[i][n]:t[i])===e)return i;return-1}
/**
     * @param {Object} obj
     * @param {(string|number)} prop
     * @return {boolean}
     */function m(t,e){return t[e]!==L;// will be nicely inlined by gcc
}// GCC hack see https://stackoverflow.com/a/23202438/1517919
return h}(void 0));