/*!
 * Lightweight URL manipulation with JavaScript
 * This library is independent of any other libraries and has pretty simple
 * interface and lightweight code-base.
 * Some ideas of query string parsing had been taken from Jan Wolter
 * @see http://unixpapa.com/js/querystring.html
 *
 * @license MIT
 * @author Mykhailo Stadnyk <mikhus@gmail.com> and contributors
 * @see https://github.com/Mikhus/domurl/graphs/contributors
 */
!function(t){"use strict";var l=/^[a-z]+:/,y=/[-a-z0-9]+(\.[-a-z0-9])*:\d+/i,d=/\/\/(.*?)(?::(.*?))?@/,r=/^win/i,g=/:$/,v=/^\?/,m=/^#/,q=/(.*\/)/,w=/^\/{2,}/,A=/(^\/?)/,e=/'/g,o=/%([ef][0-9a-f])%([89ab][0-9a-f])%([89ab][0-9a-f])/gi,n=/%([cd][0-9a-f])%([89ab][0-9a-f])/gi,i=/%([0-7][0-9a-f])/gi,s=/\+/g,a=/^\w:$/,I=/[^/#?]/;var p,C="undefined"==typeof window&&"undefined"!=typeof global&&"function"==typeof require,S=!C&&t.navigator&&t.navigator.userAgent&&~t.navigator.userAgent.indexOf("MSIE"),b=C?t.require:null,x={protocol:"protocol",host:"hostname",port:"port",path:"pathname",query:"search",hash:"hash"},j={ftp:21,gopher:70,http:80,https:443,ws:80,wss:443};function z(){return C?p=p||"file://"+(process.platform.match(r)?"/":"")+b("fs").realpathSync("."):("about:srcdoc"===document.location.href?self.parent.document:document).location.href}function h(t,r,e){var o,n;r=r||z(),C?o=b("url").parse(r):(o=document.createElement("a")).href=r;var i,s=(a={path:!0,query:!0,hash:!0},(i=r)&&l.test(i)&&(a.protocol=!0,a.host=!0,y.test(i)&&(a.port=!0),d.test(i)&&(a.user=!0,a.pass=!0)),a),a=r.match(d)||[];for(n in x)s[n]?t[n]=o[x[n]]||"":t[n]="";// fix-up some parts
if(t.protocol=t.protocol.replace(g,""),t.query=t.query.replace(v,""),t.hash=E(t.hash.replace(m,"")),t.user=E(a[1]||""),t.pass=E(a[2]||""),
/* jshint ignore:start */
t.port=// loosely compare because port can be a string
j[t.protocol]==t.port||0==t.port?"":t.port,// IE fix, Android browser fix
/* jshint ignore:end */
!s.protocol&&I.test(r.charAt(0))&&(t.path=r.split("?")[0].split("#")[0]),!s.protocol&&e){
// is IE and path is relative
var p=new U(z().match(q)[0]),h=p.path.split("/"),u=t.path.split("/"),c=["protocol","user","pass","host","port"],f=c.length;for(h.pop(),n=0;n<f;n++)t[c[n]]=p[c[n]];for(;".."===u[0];)
// skip all "../
h.pop(),u.shift();t.path=("/"!==r.charAt(0)?h.join("/"):"")+"/"+u.join("/")}t.path=t.path.replace(w,"/"),S&&(t.path=t.path.replace(A,"/")),t.paths(t.paths()),t.query=new F(t.query)}function u(t){return encodeURIComponent(t).replace(e,"%27")}function E(t){return(t=(t=(t=t.replace(s," ")).replace(o,function(t,r,e,o){r=parseInt(r,16)-224,e=parseInt(e,16)-128;if(0==r&&e<32)return t;o=(r<<12)+(e<<6)+(parseInt(o,16)-128);return 65535<o?t:String.fromCharCode(o)})).replace(n,function(t,r,e){r=parseInt(r,16)-192;if(r<2)return t;e=parseInt(e,16)-128;return String.fromCharCode((r<<6)+e)})).replace(i,function(t,r){return String.fromCharCode(parseInt(r,16))})}
/**
   * Class QueryString
   *
   * @param {string} qs - string representation of QueryString
   * @constructor
   */function F(t){for(var r=t.split("&"),e=0,o=r.length;e<o;e++){var n=r[e].split("="),i=decodeURIComponent(n[0].replace(s," "));i&&(n=void 0!==n[1]?E(n[1]):null,void 0===this[i]?this[i]=n:(this[i]instanceof Array||(this[i]=[this[i]]),this[i].push(n)))}}
/**
   * Converts QueryString object back to string representation
   *
   * @returns {string}
   */
/**
   * Class Url
   *
   * @param {string} [url] - string URL representation
   * @param {boolean} [noTransform] - do not transform to absolute URL
   * @constructor
   */
function U(t,r){h(this,t,!r)}
/**
   * Clears QueryString, making it contain no params at all
   *
   * @returns {Url}
   */F.prototype.toString=function(){var t,r,e="",o=u;for(t in this){var n=this[t];if(!(n instanceof Function||void 0===n))if(n instanceof Array){var i=n.length;if(i)for(r=0;r<i;r++){var s=n[r];void 0!==s&&(e+=e?"&":"",e+=o(t)+(null===s?"":"="+o(s)))}else
// Parameter is an empty array, so treat as
// an empty argument
e+=(e?"&":"")+o(t)+"="}// Plain value
else e+=e?"&":"",e+=o(t)+(null===n?"":"="+o(n))}return e},U.prototype.clearQuery=function(){for(var t in this.query)this.query[t]instanceof Function||delete this.query[t];return this},
/**
   * Returns total number of parameters in QueryString
   *
   * @returns {number}
   */
U.prototype.queryLength=function(){var t,r=0;for(t in this.query)this.query[t]instanceof Function||r++;return r},
/**
   * Returns true if QueryString contains no parameters, false otherwise
   *
   * @returns {boolean}
   */
U.prototype.isEmptyQuery=function(){return 0===this.queryLength()},
/**
   *
   * @param {Array} [paths] - an array pf path parts (if given will modify
   *                          Url.path property
   * @returns {Array} - an array representation of the Url.path property
   */
U.prototype.paths=function(t){var r,e="",o=0;if(t&&t.length&&t+""!==t){for(this.isAbsolute()&&(e="/"),r=t.length;o<r;o++)t[o]=!o&&a.test(t[o])?t[o]:u(t[o]);this.path=e+t.join("/")}for(o=0,r=(t=("/"===this.path.charAt(0)?this.path.slice(1):this.path).split("/")).length;o<r;o++)t[o]=E(t[o]);return t},
/**
   * Performs URL-specific encoding of the given string
   *
   * @method Url#encode
   * @param {string} s - string to encode
   * @returns {string}
   */
U.prototype.encode=u,
/**
   * Performs URL-specific decoding of the given encoded string
   *
   * @method Url#decode
   * @param {string} s - string to decode
   * @returns {string}
   */
U.prototype.decode=E,
/**
   * Checks if current URL is an absolute resource locator (globally absolute
   * or absolute path to current server)
   *
   * @returns {boolean}
   */
U.prototype.isAbsolute=function(){return this.protocol||"/"===this.path.charAt(0)},
/**
   * Returns string representation of current Url object
   *
   * @returns {string}
   */
U.prototype.toString=function(){return(this.protocol&&this.protocol+"://")+(this.user&&u(this.user)+(this.pass&&":"+u(this.pass))+"@")+(this.host&&this.host)+(this.port&&":"+this.port)+(this.path&&this.path)+(this.query.toString()&&"?"+this.query)+(this.hash&&"#"+u(this.hash))},t[t.exports?"exports":"Url"]=U}("undefined"!=typeof module&&module.exports?module:window);