<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2016 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::register('DPCalendarHelper', dirname(__FILE__) . '/admin/helpers/dpcalendar.php');

class Com_DPCalendarInstallerScript
{

	public function install($parent)
	{
	}

	public function update($parent)
	{
		$path = JPATH_ADMINISTRATOR . '/components/com_dpcalendar/dpcalendar.xml';
		$version = null;
		if (file_exists($path))
		{
			$manifest = simplexml_load_file($path);
			$version = (string)$manifest->version;
		}
		if (empty($version))
		{
			return;
		}

		if (version_compare($version, '2.0.0') == -1)
		{
			$this->run("update `#__extensions` set enabled=1 where type = 'plugin' and element = 'dpcalendar'");

			$this->run("ALTER TABLE  `#__dpcalendar_events` ADD INDEX  `idx_start_date` (  `start_date` )");
			$this->run("ALTER TABLE  `#__dpcalendar_events` ADD INDEX  `idx_end_date` (  `end_date` )");

			// Enhance location
			$this->run("ALTER TABLE `#__dpcalendar_events` ADD `latitude` float NULL DEFAULT NULL AFTER `location`");
			$this->run("ALTER TABLE `#__dpcalendar_events` ADD `longitude` float NULL DEFAULT NULL AFTER `latitude`");

			// Migrate to rule
			$this->run("ALTER TABLE `#__dpcalendar_events` ADD `rrule` varchar(255) AFTER `alias`");

			$this->run("select * from `#__dpcalendar_events` where original_id = -1");
			$events = JFactory::getDBO()->loadObjectList();

			foreach ($events as $event)
			{
				$rule = '';

				switch ($event->scheduling)
				{
					case 1:
						if ($event->scheduling_daily_weekdays == 1)
						{
							$rule = 'FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR';
						}
						else
						{
							$rule = 'FREQ=DAILY';
						}
						break;
					case 2:
						$rule = 'FREQ=WEEKLY';
						$registry = new JRegistry();
						$registry->loadString($event->scheduling_weekly_days);
						$weeklyDays = $registry->toArray();
						if (count($weeklyDays) > 0)
						{
							$rule .= ';BYDAY=';
						}
						$map = array(
								1 => 'MO',
								2 => 'TU',
								3 => 'WE',
								4 => 'TH',
								5 => 'FR',
								6 => 'SA',
								7 => 'SU'
						);
						foreach ($weeklyDays as $day)
						{
							$rule .= $map[$day] . ',';
						}
						$rule = trim($rule, ',');
						break;
					case 3:
						$rule = 'FREQ=MONTHLY';
						$registry = new JRegistry();
						$registry->loadString($event->scheduling_monthly_days);
						$monthlyDays = $registry->toArray();
						if (count($monthlyDays) > 0)
						{
							$rule .= ';BYMONTHDAY=' . implode(',', $monthlyDays);
						}
						break;
					case 4:
						$rule = 'FREQ=YEARLY';
						break;
				}
				if (!empty($event->scheduling_end_date))
				{
					$rule .= ';UNTIL=' . str_replace('-', '', substr($event->scheduling_end_date, 0, 10)) . '235959Z';
				}

				$this->run("update `#__dpcalendar_events` set rrule='" . $rule . "' where id =" . $event->id);
			}
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `scheduling_start_date`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `scheduling_end_date`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `scheduling_daily_weekdays`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `scheduling_weekly_days`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `scheduling_monthly_days`");

			foreach (JFolder::files(JPATH_ADMINISTRATOR . '/language', '.*dpcalendar.*', true, true) as $file)
			{
				JFile::delete($file);
			}
			foreach (JFolder::files(JPATH_SITE . '/language', '.*dpcalendar.*', true, true) as $file)
			{
				JFile::delete($file);
			}
		}
		if (version_compare($version, '2.2.0') == -1)
		{
			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_locations` (
					`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`title` varchar(255) NOT NULL DEFAULT '',
					`alias` varchar(255) NOT NULL DEFAULT '',
					`country` varchar(255) NOT NULL DEFAULT '',
					`province` varchar(255) NOT NULL DEFAULT '',
					`city` varchar(255) NOT NULL DEFAULT '',
					`zip` varchar(255) NOT NULL DEFAULT '',
					`street` varchar(255) NOT NULL DEFAULT '',
					`number` varchar(255) NOT NULL DEFAULT '',
					`room` varchar(255) NOT NULL DEFAULT '',
					`latitude` float DEFAULT NULL,
					`longitude` float DEFAULT NULL,
					`url` varchar(250) NOT NULL DEFAULT '',
					`description` text NOT NULL,
					`date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`state` tinyint(1) NOT NULL DEFAULT '0',
					`checked_out` int(11) NOT NULL DEFAULT '0',
					`checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`ordering` int(11) NOT NULL DEFAULT '0',
					`params` text NOT NULL,
					`language` char(7) NOT NULL DEFAULT '',
					`created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`created_by` int(10) unsigned NOT NULL DEFAULT '0',
					`created_by_alias` varchar(255) NOT NULL DEFAULT '',
					`version` int(10) unsigned NOT NULL DEFAULT '0',
					`modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`modified_by` int(10) unsigned NOT NULL DEFAULT '0',
					`publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					PRIMARY KEY (`id`),
					KEY `idx_checkout` (`checked_out`),
					KEY `idx_state` (`state`),
					KEY `idx_createdby` (`created_by`),
					KEY `idx_language` (`language`)
			) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ");

			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_events_location` (
					`event_id` int(11) NOT NULL DEFAULT '0',
					`location_id` int(11) NOT NULL DEFAULT '0',
					PRIMARY KEY (`event_id`,`location_id`)
			) DEFAULT CHARSET=utf8;");

			$db = JFactory::getDbo();
			$db->setQuery(
					"select id,location,latitude,longitude from `#__dpcalendar_events` where location is not null and location != '' group by location");
			$locations = $db->loadObjectList();
			JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/tables');
			foreach ($locations as $loc)
			{
				$data = array();
				if ($loc->latitude != 0 && $loc->longitude != 0)
				{
					$data['latitude'] = $loc->latitude;
					$data['longitude'] = $loc->longitude;
					$data['title'] = $loc->location;
					$data['country'] = $loc->location;
				}
				else
				{
					$content = DPCalendarHelper::fetchContent('http://maps.google.com/maps/api/geocode/json?address=' . urlencode($loc->location));
					if (!empty($content))
					{
						$tmp = json_decode($content);

						if ($tmp)
						{
							if ($tmp->status == 'OK')
							{
								if (!empty($tmp->results))
								{
									foreach ($tmp->results[0]->address_components as $part)
									{
										switch ($part->types[0])
										{
											case 'country':
												$data['country'] = $part->long_name;
												break;
											case 'administrative_area_level_1':
												$data['province'] = $part->long_name;
												break;
											case 'locality':
												$data['city'] = $part->long_name;
												break;
											case 'postal_code':
												$data['zip'] = $part->long_name;
												break;
											case 'route':
												$data['street'] = $part->long_name;
												break;
											case 'street_number':
												$data['number'] = $part->long_name;
												break;
										}
									}

									$data['latitude'] = $tmp->results[0]->geometry->location->lat;
									$data['longitude'] = $tmp->results[0]->geometry->location->lng;

									$data['title'] = $tmp->results[0]->formatted_address;
								}
							}
						}
					}
				}

				if (!empty($data))
				{
					$data['state'] = 1;
					$data['language'] = '*';
					$table = JTable::getInstance('Location', 'DPCalendarTable');
					$table->save($data);

					if ($table->id)
					{
						$db->setQuery(
								'insert into #__dpcalendar_events_location (event_id, location_id) select id as event_id, ' . $table->id .
										 " as location_id from #__dpcalendar_events where location='" . $loc->location . "'");
						$db->execute();
					}
				}
			}
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `location`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `latitude`");
			$this->run("ALTER TABLE `#__dpcalendar_events` drop `longitude`");
		}

		if (version_compare($version, '3.0.0') == -1)
		{
			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_caldav_calendarobjects` (
					`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`calendardata` mediumblob,
					`uri` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
					`calendarid` int(10) unsigned NOT NULL,
					`lastmodified` int(11) unsigned DEFAULT NULL,
					`etag` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
					`size` int(11) unsigned NOT NULL,
					`componenttype` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
					`firstoccurence` int(11) unsigned DEFAULT NULL,
					`lastoccurence` int(11) unsigned DEFAULT NULL,
					PRIMARY KEY (`id`),
					UNIQUE KEY `calendarid` (`calendarid`,`uri`)
			) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;");

			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_caldav_calendars` (
					`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`principaluri` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
					`displayname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
					`uri` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
					`ctag` int(10) unsigned NOT NULL DEFAULT '0',
					`description` text COLLATE utf8_unicode_ci,
					`calendarorder` int(10) unsigned NOT NULL DEFAULT '0',
					`calendarcolor` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
					`timezone` text COLLATE utf8_unicode_ci,
					`components` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
					`transparent` tinyint(1) NOT NULL DEFAULT '0',
					PRIMARY KEY (`id`),
					UNIQUE KEY `principaluri` (`principaluri`,`uri`)
			) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;");

			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_caldav_principals` (
					`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`uri` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
					`email` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
					`displayname` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
					`vcardurl` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
					`external_id` int(11) unsigned NOT NULL,
					PRIMARY KEY (`id`),
					UNIQUE KEY `uri` (`uri`),
					KEY `external_id` (`external_id`)
			) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;");

			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_caldav_groupmembers` (
					`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`principal_id` int(10) unsigned NOT NULL,
					`member_id` int(10) unsigned NOT NULL,
					PRIMARY KEY (`id`),
					UNIQUE(principal_id, member_id)
			);");

			$this->run(
					'insert into `#__dpcalendar_caldav_principals`
					(uri, email, displayname, external_id) select concat("principals/", username) as uri, email, name as displayname, id
					from `#__users` u ON DUPLICATE KEY UPDATE email=u.email, displayname=u.name');
			$this->run(
					'insert into `#__dpcalendar_caldav_principals`
					(uri, email, displayname, external_id) select concat("principals/", username, "/calendar-proxy-read") as uri, email, name as displayname, id
					from `#__users` u ON DUPLICATE KEY UPDATE email=u.email, displayname=u.name');
			$this->run(
					'insert into `#__dpcalendar_caldav_principals`
					(uri, email, displayname, external_id) select concat("principals/", username, "/calendar-proxy-write") as uri, email, name as displayname, id
					from `#__users` u ON DUPLICATE KEY UPDATE email=u.email, displayname=u.name');
		}
		if (version_compare($version, '3.3.0') == -1)
		{
			$this->run('alter table `#__dpcalendar_events` add  `capacity` int( 11 ) null after `hits`');
			$this->run('update `#__dpcalendar_events` set capacity = 0');
			$this->run('alter table `#__dpcalendar_events` add  `capacity_used` int( 11 ) default 0 after `capacity`');
			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_attendees` (
				  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
				  `event_id` int(11) NOT NULL,
				  `user_id` int(11) NOT NULL DEFAULT '0',
				  `location_id` int(11) NOT NULL DEFAULT '0',
				  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
				  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
				  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
				  `book_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
				  `remind_time` int(11) NOT NULL,
				  `remind_type` tinyint(1) NOT NULL DEFAULT '1',
				  `reminder_sent_date` datetime DEFAULT NULL,
				  `public` tinyint(1) NOT NULL DEFAULT '1',
				  `state` tinyint(1) NOT NULL DEFAULT '0',
				  PRIMARY KEY (`id`),
				  KEY `event_id` (`event_id`)
				) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
			$this->run('alter table  `#__dpcalendar_events` add `recurrence_id` varchar(255) DEFAULT NULL AFTER `rrule`');
			$this->run("update `#__dpcalendar_events` set recurrence_id = DATE_FORMAT(start_date, '%Y%m%dT%H%i%sZ') where original_id > 0");
			$this->run('alter table `#__dpcalendar_locations` change `latitude` `latitude` decimal( 9, 6 ) null default null');
		}

		if (version_compare($version, '4.0.0') == -1)
		{
			$this->run(
					"ALTER IGNORE TABLE  `#__dpcalendar_attendees` ADD  `transaction_id` VARCHAR( 255 ) NULL DEFAULT NULL ,
ADD  `price` DECIMAL( 10, 2 ) NOT NULL DEFAULT  '0.00',
ADD  `processor` VARCHAR( 255 ) DEFAULT NULL,
ADD  `net_amount` DECIMAL( 10, 2 ) NOT NULL DEFAULT  '0.00',
ADD  `tax_amount` DECIMAL( 10, 2 ) NOT NULL DEFAULT  '0.00',
ADD  `gross_amount` DECIMAL( 10, 2 ) NOT NULL DEFAULT  '0.00',
ADD  `payment_fee` DECIMAL( 10, 2 ) NOT NULL DEFAULT  '0.00',
ADD  `tax_percent` FLOAT DEFAULT NULL,
ADD  `txn_type` VARCHAR( 255 ) NOT NULL ,
ADD  `payer_id` VARCHAR( 255 ) NOT NULL ,
ADD  `payer_email` VARCHAR( 255 ) NOT NULL;");

			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `price` DECIMAL(10, 2) NOT NULL DEFAULT '0.00' AFTER `capacity_used`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `tax` TINYINT(1) NOT NULL DEFAULT '0' AFTER `price`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `ordertext` TEXT NOT NULL AFTER `tax`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `orderurl` TEXT NOT NULL AFTER `ordertext`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `canceltext` TEXT NOT NULL AFTER `orderurl`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `cancelurl` TEXT NOT NULL AFTER `canceltext`");
			$this->run("ALTER IGNORE TABLE `#__dpcalendar_events` ADD COLUMN `plugintype` TEXT NOT NULL");
			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_extcalendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `plugin` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `color` varchar(250) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_plugin` (`plugin`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`)
) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;");
		}

		if (version_compare($version, '4.0.1') == -1)
		{
			if (JFile::exists(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/models/events.php'))
			{
				JFile::delete(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/models/events.php');
			}
		}
		if (version_compare($version, '4.0.5') == -1)
		{
			$db = JFactory::getDBO();
			$db->setQuery("select * from #__dpcalendar_extcalendars where plugin = 'google' or plugin = 'caldav'");

			foreach ($db->loadObjectList() as $cal)
			{
				$params = new JRegistry();
				$params->loadString($cal->params);
				$params->set('action-create', true);
				$params->set('action-edit', true);
				$params->set('action-delete', true);

				$db->setQuery('update #__dpcalendar_extcalendars set params = ' . $db->q($params->toString()) . ' where id = ' . (int)$cal->id);
				$db->query();
			}
		}
		if (version_compare($version, '4.0.6') == -1)
		{
			$db = JFactory::getDBO();
			$db->setQuery('delete from #__dpcalendar_extcalendars where plugin = ' . $db->q('') . ' or plugin is null');
			$db->query();
		}
		if (version_compare($version, '4.1.0') == -1)
		{
			$this->run("ALTER TABLE  `#__dpcalendar_locations` CHANGE  `latitude`  `latitude` DECIMAL( 20, 15 ) NULL DEFAULT  '0.0'");
			$this->run("ALTER TABLE  `#__dpcalendar_locations` CHANGE  `longitude`  `longitude` DECIMAL( 20, 15 ) NULL DEFAULT  '0.0'");
			$this->run("ALTER TABLE  `#__dpcalendar_extcalendars` ADD  `access_content` INT( 11 ) NOT NULL DEFAULT  '1'");
		}
		if (version_compare($version, '4.1.1') == -1)
		{
			$this->run("ALTER TABLE  `#__dpcalendar_locations` CHANGE  `latitude`  `latitude` DECIMAL( 12, 8 ) DEFAULT NULL");
			$this->run("ALTER TABLE  `#__dpcalendar_locations` CHANGE  `longitude`  `longitude` DECIMAL( 12, 8 ) DEFAULT NULL");
		}
		if (version_compare($version, '4.1.2') == -1)
		{
			if (DPCalendarHelper::isJoomlaVersion('3'))
			{
				$this->run(
						'INSERT INTO `#__content_types`
					(`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`)
					VALUES (NULL,
					\'DPCalendar Category\',
					\'com_dpcalendar.category\',
					\'{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},
						"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable",
						"config":"array()"}}\', \'\', \'{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published",
						"core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description",
						"core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params",
						"core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null",
						"core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id",
						"core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level",
						"path":"path","extension":"extension","note":"note"}}\',
					\'DPCalendarHelperRoute::getCalendarRoute\', \'\')');
			}
		}
		if (version_compare($version, '4.2.0') == -1)
		{
			$this->run("ALTER TABLE  `#__dpcalendar_extcalendars` ADD  `access` INT( 11 ) NOT NULL DEFAULT  '1'");
		}
		if (version_compare($version, '4.2.5') == -1)
		{
			$db = JFactory::getDBO();
			$db->setQuery("select * from #__dpcalendar_extcalendars where plugin = 'caldav'");

			foreach ($db->loadObjectList() as $cal)
			{
				$params = new JRegistry();
				$params->loadString($cal->params);
				$params->set('calendar', '/calendars/' . trim($params->get('calendar'), '/'));

				$db->setQuery('update #__dpcalendar_extcalendars set params = ' . $db->q($params->toString()) . ' where id = ' . (int)$cal->id);
				$db->query();
			}
		}

		if (version_compare($version, '5.0.0') == -1)
		{
			// Clearing the location cache
			$cache = JFactory::getCache('com_dpcalendar_location', '');
			$cache->cache->clean('com_dpcalendar_location', '');

			// Adding missing fields
			$this->run("ALTER TABLE `#__dpcalendar_events` ADD `images` TEXT NOT NULL DEFAULT '' AFTER `url`");
			$this->run("ALTER TABLE `#__dpcalendar_events` CHANGE `sid` `uid` VARCHAR(255) NOT NULL DEFAULT ''");

			$db = JFactory::getDbo();
			$db->setQuery("select id, original_id from `#__dpcalendar_events` where original_id = 0 or original_id = '-1'");
			$events = $db->loadObjectList();
			JLoader::import('components.com_dpcalendar.libraries.vendor.autoload', JPATH_ADMINISTRATOR);
			foreach ($events as $event)
			{
				$uid = strtoupper(Sabre\VObject\UUIDUtil::getUUID());

				$childs = '';
				if ($event->original_id == '-1')
				{
					$childs = ' or original_id = ' . $event->id;
				}

				$db->setQuery('update #__dpcalendar_events set uid = ' . $db->quote($uid) . ' where id = ' . $event->id . $childs);
				$db->query();
			}

			$this->run(
					'INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
					(\'Event\',
					\'com_dpcalendar.event\',
					\'{"special":{"dbtable":"#__dpcalendar_events","key":"id","type":"Event","prefix":"DPCalendarTable","config":"array()"},
						"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Event","prefix":"DPCalendarTable","config":"array()"}}\',
					\'\',
					\'{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias",
						"core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits",
						"core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs",
						"core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"url",
						 "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid",
						"core_xreference":"xreference", "asset_id":"asset_id"}, "special":{}}\',
					\'DPCalendarHelperRoute::getEventRoute\',
					\'{"formFile":"administrator\\/components\\/com_dpcalendar\\/models\\/forms\\/event.xml", "hideFields":["asset_id","checked_out",
						"checked_out_time"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "hits"],
						"convertToInt":["publish_up", "publish_down", "featured"],"displayLookup":[{"sourceColumn":"catid",
						"targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},
						{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},
						{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},
						{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}\')');
		}

		if (version_compare($version, '5.1.0') == -1)
		{
			$this->run("ALTER TABLE `#__dpcalendar_attendees` drop location_id");

			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `country` varchar(255) NOT NULL DEFAULT '' AFTER `telephone`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `province` varchar(255) NOT NULL DEFAULT '' AFTER `country`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `city` varchar(255) NOT NULL DEFAULT '' AFTER `province`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `zip` varchar(255) NOT NULL DEFAULT '' AFTER `city`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `street` varchar(255) NOT NULL DEFAULT '' AFTER `zip`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `number` varchar(255) NOT NULL DEFAULT '' AFTER `street`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `latitude` DECIMAL(12, 8) DEFAULT NULL AFTER `number`");
			$this->run("ALTER TABLE `#__dpcalendar_attendees` ADD `longitude` DECIMAL(12, 8) DEFAULT NULL AFTER `latitude`");
		}

		if (version_compare($version, '5.2.0') == -1)
		{
			// Allowing strings as calendar id
			$this->run("ALTER TABLE `#__dpcalendar_events` CHANGE `catid` `catid` varchar(255) NOT NULL DEFAULT '0' AFTER `id`;");

			// Add sync fields
			$this->run("ALTER TABLE `#__dpcalendar_extcalendars` ADD `sync_token` varchar(255)");
			$this->run("ALTER TABLE `#__dpcalendar_extcalendars` ADD `sync_date` datetime");

			// Add color force flag
			$this->run("ALTER TABLE `#__dpcalendar_extcalendars` ADD `color_force` tinyint(1) NOT NULL DEFAULT '0' AFTER `color`");
		}

		if (version_compare($version, '5.2.3') == -1)
		{
			// Allowing strings as calendar id
			$this->run("ALTER TABLE `#__dpcalendar_extcalendars` CHANGE `sync_token` `sync_token` text NULL AFTER `access_content`;");
		}
		if (version_compare($version, '5.3.0') == -1)
		{
			// Add max tickets column
			$this->run("ALTER TABLE `#__dpcalendar_events` ADD `max_tickets` int(11) NOT NULL DEFAULT '1' AFTER `capacity_used`");

			// Rename to bookings
			$this->run("ALTER TABLE `#__dpcalendar_attendees`RENAME TO `#__dpcalendar_bookings`");
			$this->run(
					"ALTER TABLE `#__dpcalendar_bookings` CHANGE `attend_date` `book_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' AFTER `name`;");

			// Add UID
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD `uid` varchar(255) AFTER `user_id`");
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD INDEX `uid` (`uid`);");

			// Payment columns
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD `currency` varchar(10) NOT NULL AFTER `price`");
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD `txn_currency` varchar(10) NOT NULL AFTER `txn_type`");
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD `raw_data` text NOT NULL");

			// Create tickets table
			$this->run(
					"CREATE TABLE IF NOT EXISTS `#__dpcalendar_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) NOT NULL,
  `event_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `uid` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `country` varchar(255) NOT NULL DEFAULT '',
  `province` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `zip` varchar(255) NOT NULL DEFAULT '',
  `street` varchar(255) NOT NULL DEFAULT '',
  `number` varchar(255) NOT NULL DEFAULT '',
  `latitude` DECIMAL(12, 8) DEFAULT NULL,
  `longitude` DECIMAL(12, 8) DEFAULT NULL,
  `seat` varchar(255) DEFAULT NULL,
  `remind_time` int(11) NOT NULL,
  `remind_type` tinyint(1) NOT NULL DEFAULT '1',
  `reminder_sent_date` datetime DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `public` tinyint(1) NOT NULL DEFAULT '1',
  `price` DECIMAL(10, 2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `booking_id` (`booking_id`),
  KEY `event_id` (`event_id`),
  KEY `user_id` (`user_id`),
  KEY `state` (`state`),
  KEY `notify` (`reminder_sent_date`, `state`)
) DEFAULT CHARSET=utf8;");

			// Update the UID's
			JLoader::import('components.com_dpcalendar.libraries.vendor.autoload', JPATH_ADMINISTRATOR);
			$db = JFactory::getDbo();
			$db->setQuery("select id from `#__dpcalendar_bookings`");
			$bookings = $db->loadObjectList();
			foreach ($bookings as $booking)
			{
				$uid = strtoupper(Sabre\VObject\UUIDUtil::getUUID());

				$db->setQuery('update #__dpcalendar_bookings set uid = ' . $db->quote($uid) . ' where id = ' . $booking->id);
				$db->query();
			}

			// Create one ticket per booking
			$this->run(
					"insert into #__dpcalendar_tickets(booking_id, event_id, user_id, uid, name, email, remind_time, remind_type, reminder_sent_date, public, created, state, price)
select id, event_id, user_id, uid, name, email, remind_time, remind_type, reminder_sent_date, public, book_date, state, price
from #__dpcalendar_bookings");

			// Remove obsolete fields
			$this->run(
					"ALTER TABLE `#__dpcalendar_bookings` DROP `event_id`, DROP `remind_time`, DROP `remind_type`, DROP `reminder_sent_date`, DROP `public`;");
			$this->run("ALTER TABLE #__dpcalendar_bookings DROP INDEX idx_notify");
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD INDEX `state` (`state`)");
			$this->run("ALTER TABLE `#__dpcalendar_bookings` ADD INDEX `user_id` (`user_id`)");

			// Renaming payment plugins to new structure
			JLoader::import('joomla.filesystem.folder');
			JLoader::import('joomla.filesystem.file');

			$rootPath = JPATH_PLUGINS . '/dpcalendarpay/';
			foreach (JFolder::folders($rootPath) as $oldName)
			{
				$newName = str_replace('dpcalendar_', '', $oldName);
				if ($newName == $oldName)
				{
					continue;
				}
				JFile::delete($rootPath . $oldName . '/' . $oldName . '.xml');
				JFile::delete($rootPath . $oldName . '/' . $oldName . '.php');
				JFile::move($rootPath . $oldName, $rootPath . $newName);

				$this->run(
						"update `#__extensions` set name = REPLACE(name, '" . $oldName . "', 'dpcalendarpay_" . $newName .
								 "'), element = REPLACE(element, '" . $oldName . "', '" . $newName . "'), manifest_cache = REPLACE(manifest_cache, '" .
								 $oldName . "', '" . $newName . "') where element = '" . $oldName . "'");
			}
		}
		if (version_compare($version, '5.4.0') == -1)
		{
			$this->run('alter table `#__dpcalendar_events` add  `booking_closing_date` varchar(255) null after `max_tickets`');
		}
		if (version_compare($version, '5.5.0') == -1)
		{
			$this->run("alter table `#__dpcalendar_tickets` ADD `type` INT( 11 ) NOT NULL DEFAULT  '0'");
			$this->run("alter table `#__dpcalendar_events` ADD `earlybird` TEXT NULL DEFAULT NULL after price");
			$this->run("alter table `#__dpcalendar_events` ADD `booking_information` TEXT NULL DEFAULT NULL after earlybird");
			$this->run('alter table `#__dpcalendar_events` CHANGE `price` `price` TEXT NULL DEFAULT NULL');
			$this->run('update `#__dpcalendar_events` set `price` = null where `price` = 0');

			$db = JFactory::getDbo();
			$db->setQuery("select id, price from `#__dpcalendar_events` where price is not null");
			$events = $db->loadObjectList();
			foreach ($events as $event)
			{
				$data = array(
						'value' => array(
								$event->price
						),
						'label' => array(
								''
						),
						'description' => array(
								''
						)
				);
				$db->setQuery('update #__dpcalendar_events set price = ' . $db->quote(json_encode($data)) . ' where id = ' . $event->id);
				$db->query();
			}
		}
		if (version_compare($version, '5.6.0') == -1)
		{
			$this->run("alter table `#__dpcalendar_events` ADD `user_discount` TEXT NULL DEFAULT NULL after earlybird");
		}
	}

	public function uninstall($parent)
	{
	}

	public function preflight($type, $parent)
	{
		// Delete existing update sites, neccessary if upgrading eg. free to pro
		$this->run(
				"delete from #__update_sites_extensions where extension_id in (select extension_id from #__extensions where element = 'pkg_dpcalendar')");
		$this->run("delete from #__update_sites where name like 'DPCalendar%'");

		// Check if the local Joomla version does fit the minimum requirement
		if (version_compare(JVERSION, '3.3') == -1)
		{
			JFactory::getApplication()->enqueueMessage(
					'This DPCalendar version does only run on Joomla 3.3 and above, please upgrade your Joomla version or install an older version of DPCalendar!',
					'error');
			JFactory::getApplication()->redirect('index.php?option=com_installer&view=install');
			return false;
		}
	}

	public function postflight($type, $parent)
	{
		if (JFile::exists(JPATH_SITE . '/components/com_jcomments/jcomments.php'))
		{
			JFile::copy(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/libraries/jcomments/com_dpcalendar.plugin.php',
					JPATH_SITE . '/components/com_jcomments/plugins/com_dpcalendar.plugin.php');
		}

		JLoader::import('joomla.filesystem.folder');
		if (JFolder::exists(JPATH_ADMINISTRATOR . '/components/com_falang/contentelements'))
		{
			JFile::copy(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/libraries/falang/dpcalendar_events.xml',
					JPATH_ADMINISTRATOR . '/components/com_falang/contentelements/dpcalendar_events.xml');
			JFile::copy(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/libraries/falang/dpcalendar_locations.xml',
					JPATH_ADMINISTRATOR . '/components/com_falang/contentelements/dpcalendar_locations.xml');
		}

		if ($type == 'install')
		{
			$this->run("update `#__extensions` set enabled=1 where type = 'plugin' and element = 'dpcalendar'");

			$this->run("update `#__extensions` set enabled=1 where type = 'plugin' and element = 'manual'");

			$this->run(
					"insert into `#__modules_menu` (menuid, moduleid) select 0 as menuid, id as moduleid from `#__modules` where module like 'mod_dpcalendar%'");

			// Create default table
			JTable::addIncludePath(JPATH_LIBRARIES . '/joomla/database/table');
			$category = JTable::getInstance('Category');
			$category->extension = 'com_dpcalendar';
			$category->title = 'Uncategorised';
			$category->alias = 'uncategorised';
			$category->description = '';
			$category->published = 1;
			$category->access = 1;
			$category->params = '{"category_layout":"","image":"","color":"3366CC"}';
			$category->metadata = '{"author":"","robots":""}';
			$category->language = '*';
			$category->setLocation(1, 'last-child');
			$category->store(true);
			$category->rebuildPath($category->id);
		}
	}

	private function run($query)
	{
		try
		{
			$db = JFactory::getDBO();
			$db->setQuery($query);
			$db->query();
		}
		catch (Exception $e)
		{
			echo $e;
		}
	}

	private function getParam($name)
	{
		$db = JFactory::getDbo();
		$db->setQuery('SELECT manifest_cache FROM `#__extensions` WHERE name = "com_dpcalendar"');
		$manifest = json_decode($db->loadResult(), true);
		return $manifest[$name];
	}
}
