<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2016 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

if (!$events)
{
	echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_NO_EVENT_TEXT');
	return;
}

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base() . 'modules/mod_dpcalendar_upcoming/tmpl/default.css');

if ($params->get('show_as_popup', '0') == '1' || $params->get('show_as_popup', '0') == '3')
{
	DPCalendarHelper::loadLibrary(array('jquery' => true, 'dpcalendar' => 'true'));

	$id = "dpc-upcoming-" . $module->id;
	$calCode = "dpjQuery(document).ready(function() {\n";
	$calCode .= "dpjQuery('.dpc-upcoming-event-link').click(function (event) {\n";
	$calCode .= "	event.stopPropagation();\n";

	if ($params->get('show_as_popup', '0') == '1')
	{
		$calCode .= "	var link = dpjQuery(this).attr('href');\n";
		$calCode .= "	dpjQuery('#" . $id . "').on('show', function () {\n";
		$calCode .= "		var url = new Url(link);\n";
		$calCode .= "		url.query.tmpl = 'component';\n";
		$calCode .= "		dpjQuery('#" . $id . " iframe').attr('src', url.toString());\n";
		$calCode .= "	});\n";
		$calCode .= "	dpjQuery('#" . $id . " iframe').removeAttr('src');\n";
		$calCode .= "	dpjQuery('#" . $id . "').modal();\n";
	}
	else if ($params->get('show_as_popup', '0') == '3')
	{
		JHtml::_('behavior.modal', '.dpc-upcoming-event-link-invalid');

		$calCode .= "	var modal = dpjQuery('#" . $id . "');\n";
		$calCode .= "	var width = dpjQuery(window).width();\n";
		$calCode .= "	var url = new Url(dpjQuery(this).attr('href'));\n";
		$calCode .= "	url.query.tmpl = 'component';\n";
		$calCode .= "	SqueezeBox.open(url.toString(), {\n";
		$calCode .= "		handler : 'iframe',\n";
		$calCode .= "		size : {\n";
		$calCode .= "			x : (width < 650 ? width - (width * 0.10) : modal.width() < 650 ? 650 : modal.width()),\n";
		$calCode .= "			y : modal.height()\n";
		$calCode .= "		}\n";
		$calCode .= "	});\n";
	}
	$calCode .= "	return false;\n";
	$calCode .= "});\n";
	$calCode .= "});\n";
	$document->addScriptDeclaration($calCode);
	?>
<div id="<?php echo $id;?>" class="modal hide" tabindex="-1" role="dialog" aria-hidden="true"
	style="height:500px">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
  	<iframe style="width:99.6%;height:95%;border:none;"></iframe>
</div>
<?php
}
?>

<div class="row-fluid">
<?php
$return = JFactory::getApplication()->input->getInt('Itemid', null);
if (! empty($return))
{
	$return = JRoute::_('index.php?Itemid=' . $return);
}

$lastHeading = '';
$grouping = $params->get('output_grouping', '');

foreach ($events as $event)
{
	$calendar = DPCalendarHelper::getCalendar($event->catid);

	$startDate = DPCalendarHelper::getDate($event->start_date, $event->all_day);
	if ($grouping)
	{
		$groupHeading = $startDate->format($grouping, true);
		if ($groupHeading != $lastHeading)
		{
			$lastHeading = $groupHeading;
			?>
				<p style="clear: both;"><strong><?php echo htmlspecialchars($groupHeading);?></strong></p>
			<?php
		}
	}
?>
	<div itemscope itemtype="http://schema.org/Event">
	<div class="page-header">
		<a href="<?php echo DPCalendarHelperRoute::getEventRoute($event->id, $event->catid)?>" itemprop="url" class="dpc-upcoming-event-link">
			<span itemprop="name"><?php echo htmlspecialchars($event->title)?></span>
		</a>
	</div>
	<span class="badge badge-info pull-right hidden-phone"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_HITS');?>:<?php echo $event->hits?></span>
	<?php if (DPCalendarHelperBooking::openForBooking($event))
	{ ?>
		<div class="pull-left width-20">
			<a href="<?php echo DPCalendarHelperRoute::getBookingFormRouteFromEvent($event, $return)?>"><i class="hasTooltip icon-plus"
					title="<?php echo JText::_('COM_DPCALENDAR_BOOK');?>"></i></a>
		</div>
	<?php
	}
	if ($calendar->canEdit || ($calendar->canEditOwn && $event->created_by == $user->id))
	{?>
	<span class="pull-left width-20">
		<a href="<?php echo DPCalendarHelperRoute::getFormRoute($event->id, $return);?>"><i class="hasTip icon-edit" title="<?php echo JText::_('JACTION_EDIT');?>"></i></a>
	</span>
	<?php
	}

	if ($calendar->canDelete || ($calendar->canEditOwn && $event->created_by == $user->id))
	{?>
	<span class="pull-left width-20"><a href="<?php echo JRoute::_(
				'index.php?option=com_dpcalendar&task=event.delete&e_id=' . $event->id . '&return=' . base64_encode($return));?>">
		<i class="hasTip icon-remove" title="<?php echo JText::_('JACTION_DELETE');?>"></i></a>
	</span>
	<?php
	}?>
	<small class="list-author" itemprop="startDate" content="<?php echo DPCalendarHelper::getDate($event->start_date, $event->all_day)->format('c');?>">
			(<?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_DATE');?>: <?php echo DPCalendarHelper::getDateStringFromEvent($event, $params->get('event_date_format', 'm.d.Y'), $params->get('event_time_format', 'g:i a'));?>)
	</small>
	<br />
	<small class="list-author">
		<?php
		echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_CALANDAR');?>: <?php echo $calendar != null ? $calendar->title : $event->catid;
		?>
	</small>
	<small class="pull-right">
		<?php
		if (isset($event->locations))
		{
			foreach ($event->locations as $location)
			{ ?>
				<div class="dp-location"
					data-latitude="<?php echo $location->latitude;?>" data-longitude="<?php echo $location->longitude?>"
					data-title="<?php echo htmlspecialchars($location->title);?>">
					<a href="http://maps.google.com/?q=<?php echo htmlspecialchars(DPCalendarHelperLocation::format($location));?>" target="_blank"><?php echo htmlspecialchars($location->title);?></a>
					<?php echo DPCalendarHelperSchema::location(array($location));?>
				</div>
				<br/>
			<?php
			}
		}?>
	</small>
	<?php
	echo DPCalendarHelperSchema::offer($event);

	$images = json_decode($event->images);
	if (!$images)
	{
		echo JHtml::_('string.truncate', JHTML::_('content.prepare', $event->description), $params->get('description_length', 0));
	}
	else
	{ ?>
		<div class="row-fluid">
			<div class="span6">
				<?php echo JHtml::_('string.truncate', JHTML::_('content.prepare', $event->description), $params->get('description_length', 0));?>
			</div>
			<div class="span6">
				<?php
				echo JLayoutHelper::render('event.images', array('event' => $event), null, array('component' => 'com_dpcalendar'));
				?>
			</div>
		</div>
	<?php
	} ?>
	</div>
<?php
}?>
</div>
