<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

if (!$events)
{
	echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_NO_EVENT_TEXT');
	return;
}

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base() . 'modules/mod_dpcalendar_upcoming/tmpl/default.css');

if ($params->get('show_as_popup', '0') == '1' || $params->get('show_as_popup', '0') == '3')
{
	DPCalendarHelper::loadLibrary(array('jquery' => true, 'dpcalendar' => 'true'));

	$id = "dpc-upcoming-" . $module->id;
	$calCode = "dpjQuery(document).ready(function() {\n";
	$calCode .= "dpjQuery('.dpc-upcoming-event-link').click(function (event) {\n";
	$calCode .= "	event.stopPropagation();\n";

	if ($params->get('show_as_popup', '0') == '1')
	{
		$calCode .= "	var link = dpjQuery(this).attr('href');\n";
		$calCode .= "	dpjQuery('#" . $id . "').on('show', function () {\n";
		$calCode .= "		var url = new Url(link);\n";
		$calCode .= "		url.query.tmpl = 'component';\n";
		$calCode .= "		dpjQuery('#" . $id . " iframe').attr('src', url.toString());\n";
		$calCode .= "	});\n";
		$calCode .= "	dpjQuery('#" . $id . " iframe').removeAttr('src');\n";
		$calCode .= "	dpjQuery('#" . $id . "').modal();\n";
	}
	else if ($params->get('show_as_popup', '0') == '3')
	{
		JHtml::_('behavior.modal', '.dpc-upcoming-event-link-invalid');

		$calCode .= "	var modal = dpjQuery('#" . $id . "');\n";
		$calCode .= "	var width = dpjQuery(window).width();\n";
		$calCode .= "	var url = new Url(dpjQuery(this).attr('href'));\n";
		$calCode .= "	url.query.tmpl = 'component';\n";
		$calCode .= "	SqueezeBox.open(url.toString(), {\n";
		$calCode .= "		handler : 'iframe',\n";
		$calCode .= "		size : {\n";
		$calCode .= "			x : (width < 650 ? width - (width * 0.10) : modal.width() < 650 ? 650 : modal.width()),\n";
		$calCode .= "			y : modal.height()\n";
		$calCode .= "		}\n";
		$calCode .= "	});\n";
	}
	$calCode .= "	return false;\n";
	$calCode .= "});\n";
	$calCode .= "});\n";
	$document->addScriptDeclaration($calCode);
	?>
<div id="<?php echo $id;?>" class="modal hide" tabindex="-1" role="dialog" aria-hidden="true"
	style="height:500px">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
  	<iframe style="width:99.6%;height:95%;border:none;"></iframe>
</div>
<?php
}
?>
<div itemscope itemtype="http://schema.org/Thing" class="dp-upcoming">
<?php
$lastHeading = '';
$grouping = $params->get('output_grouping', '');
foreach ($events as $event){
	$startDate = DPCalendarHelper::getDate($event->start_date, $event->all_day);
	if ($grouping)
	{
		$groupHeading = $startDate->format($grouping, true);
		if ($groupHeading != $lastHeading)
		{
			$lastHeading = $groupHeading;
			?>
			<p style="clear: both;"><strong><?php echo htmlspecialchars($groupHeading);?></strong></p>
			<?php
		}
	}
	?>
<div itemprop="event" itemscope itemtype="http://schema.org/Event">
	<div style="clear: both;" ></div>
	<div class="dp-upcoming-calendar">
		<div class="dp-upcoming-calendar-background" style="background-color: #<?php echo $event->color?>"></div>
		<div class="dp-upcoming-text-month"><?php echo $startDate->format('M', true);?></div>
		<div class="dp-upcoming-text-day" style="color: #<?php echo $event->color?>"><?php echo $startDate->format('j', true);?></div>
	</div>
	<p itemprop="startDate" content="<?php echo $startDate->format('c')?>">
		<?php echo DPCalendarHelper::getDateStringFromEvent($event, $params->get('date_format'), $params->get('time_format'));?>
		<br />
		<a href="<?php echo DPCalendarHelperRoute::getEventRoute($event->id, $event->catid)?>" itemprop="url" class="dpc-upcoming-event-link">
			<span itemprop="name"><?php echo htmlspecialchars($event->title)?></span>
		</a>
	</p>
	<?php if ($event->locations)
	{
		echo DPCalendarHelperSchema::location($event->locations);
	}

	echo DPCalendarHelperSchema::offer($event);
	?>
	<div style="clear: both;" ></div>
</div>
<?php
}
?>
</div>
