<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$tickets = $displayData['tickets'];
if (! $tickets)
{
	return;
}

$params = $displayData['params'];
if (! $params)
{
	$params = clone JComponentHelper::getParams('com_dpcalendar');
}

$hasPrice = false;
foreach ($tickets as $ticket)
{
	if ($ticket->price && $ticket->price != '0.00')
	{
		$hasPrice = true;
		break;
	}
}
?>

<table class="table table-striped">
	<thead>
		<tr>
			<th><?php echo JText::_('COM_DPCALENDAR_BOOKING_FIELD_ID_LABEL')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_DATE')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_VIEW_EVENTS_MODAL_COLUMN_STATE')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_BOOKING_FIELD_NAME_LABEL')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_LOCATION')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_CREATED_DATE')?></th>
			<th><?php echo JText::_('COM_DPCALENDAR_TICKET_FIELD_SEAT_LABEL')?></th>
			<?php
			if ($hasPrice)
			{?>
			<th><?php echo JText::_('COM_DPCALENDAR_BOOKING_FIELD_PRICE_LABEL')?></th>
			<?php
			} ?>
		</tr>
	</thead>

	<tbody>
		<?php foreach ($tickets as $ticket)
		{
		?>
			<tr>
				<td>
				<?php if ($ticket->params->get('access-edit'))
				{?>
					<span class="width-20">
						<a href="<?php echo DPCalendarHelperRoute::getTicketFormRoute($ticket->id);?>"><i class="hasTip icon-edit" title="<?php echo JText::_('JACTION_EDIT');?>"></i></a>
					</span>
				<?php
				}?>
					<a href="<?php echo DPCalendarHelperRoute::getTicketRoute($ticket, true)?>"><?php echo $this->escape(JHtmlString::abridge($ticket->uid, 15, 5));?></a>
				</td>
				<td><a href="<?php echo DPCalendarHelperRoute::getEventRoute($ticket->event_id, $ticket->event_calid)?>"><?php echo $this->escape($ticket->event_title);?></a></td>
				<td><?php echo DPCalendarHelper::getDateStringFromEvent($ticket);?></td>
				<td><?php echo $this->escape(DPCalendarHelperBooking::getStatusLabel($ticket));?></td>
				<td><?php echo $this->escape($ticket->name);?></td>
				<td><?php echo $this->escape(DPCalendarHelperLocation::format(array($ticket)));?></td>
				<td><?php echo DPCalendarHelper::getDate($ticket->created)->format($params->get('event_date_format', 'm.d.Y') . ' ' . $params->get('event_time_format', 'g:i a'));?></td>
				<td><?php echo $this->escape($ticket->seat);?></td>
				<?php
				if ($hasPrice)
				{?>
				<td><?php echo $this->escape($ticket->price . ' ' . $params->get('currency_symbol', '$'));?></td>
				<?php
				} ?>
			</tr>
		<?php
		}?>
	</tbody>
</table>