<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::import('joomla.application.component.controllerform');

class DPCalendarControllerEvent extends JControllerForm
{

	protected function allowAdd ($data = array())
	{
		// Initialise variables.
		$user = JFactory::getUser();
		$categoryId = JArrayHelper::getValue($data, 'catid', JRequest::getInt('filter_category_id'), 'int');
		$allow = null;

		if ($categoryId)
		{
			// If the category has been passed in the URL check it.
			$allow = $user->authorise('core.create', $this->option . '.category.' . $categoryId);
		}

		if ($allow === null)
		{
			// In the absense of better information, revert to the component
			// permissions.
			return parent::allowAdd($data);
		}
		else
		{
			return $allow;
		}
	}

	protected function allowEdit ($data = array(), $key = 'id')
	{
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$event = null;

		if ($recordId)
		{
			$event = $this->getModel()->getItem($recordId);
		}

		if ($event != null)
		{
			$calendar = DPCalendarHelper::getCalendar($event->catid);
			return $calendar->canEdit || ($calendar->canEditOwn && $event->created_by == JFactory::getUser()->id);
		}
		else
		{
			// Since there is no asset tracking, revert to the component
			// permissions.
			return parent::allowEdit($data, $key);
		}
	}

	public function save ($key = null, $urlVar = null)
	{
		$data = JRequest::getVar('jform', array(), 'post', 'array');

		if (empty($data['start_date_time']) && empty($data['end_date_time']))
		{
			$data['all_day'] = '1';
		}

		$dateFormat = DPCalendarHelper::getComponentParameter('event_date_format', 'Y-m-d');
		$timeFormat = DPCalendarHelper::getComponentParameter('event_time_format', 'g:i a');

		$data['start_date'] = DPCalendarHelper::getDateFromString($data['start_date'], $data['start_date_time'], $data['all_day'] == '1')->toSql(
				false);
		$data['end_date'] = DPCalendarHelper::getDateFromString($data['end_date'], $data['end_date_time'], $data['all_day'] == '1')->toSql(false);

		JRequest::setVar('jform', $data);
		JFactory::getApplication()->input->post->set('jform', $data);

		$result = false;
		if (! is_numeric($data['catid']))
		{
			JPluginHelper::importPlugin('dpcalendar');
			$data['id'] = JRequest::getVar($urlVar, null);

			$model = $this->getModel();
			$form = $model->getForm($data, false);
			$validData = $model->validate($form, $data);

			if ($validData['all_day'] == 1)
			{
				$validData['start_date'] = DPCalendarHelper::getDate($validData['start_date'])->toSql(true);
				$validData['end_date'] = DPCalendarHelper::getDate($validData['end_date'])->toSql(true);
			}

			$tmp = JDispatcher::getInstance()->trigger('onEventSave', array(
					$validData
			));
			foreach ($tmp as $newEventId)
			{
				if ($newEventId === false)
				{
					continue;
				}
				$result = true;
				switch ($this->getTask())
				{
					case 'apply':
						$this->setRedirect(
								JRoute::_(
										'index.php?option=' . $this->option . '&view=' . $this->view_item .
												 $this->getRedirectToItemAppend($newEventId, $urlVar), false));
						break;
					case 'save2new':
						$this->setRedirect(
								JRoute::_(
										'index.php?option=' . $this->option . '&view=' . $this->view_item .
												 $this->getRedirectToItemAppend(null, $urlVar), false));
						break;
					default:
						$this->setRedirect(
								JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $this->getRedirectToListAppend(), false));
						break;
				}
			}
		}
		else
		{
			$result = parent::save($key, $urlVar);
		}

		return $result;
	}

	public function batch ($model = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_dpcalendar&view=events' . $this->getRedirectToListAppend(), false));

		return parent::batch($this->getModel());
	}

	public function getModel ($name = 'AdminEvent', $prefix = 'DPCalendarModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
}
