<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JTable::addIncludePath(JPATH_ADMINISTRATOR . 'components/com_dpcalendar/tables');

class DPCalendarHelperLocation
{

	private static $locationCache = null;

	private static $googleLanguages = array(
			'ar',
			'eu',
			'bg',
			'bn',
			'ca',
			'cs',
			'da',
			'de',
			'el',
			'en',
			'en-AU',
			'en-GB',
			'es',
			'eu',
			'fa',
			'fi',
			'fil',
			'fr',
			'gl',
			'gu',
			'hi',
			'hr',
			'hu',
			'id',
			'it',
			'iw',
			'ja',
			'kn',
			'ko',
			'lt',
			'lv',
			'nl',
			'ml',
			'mr',
			'nl',
			'nn',
			'no',
			'or',
			'pl',
			'pt',
			'pt-BR',
			'pt-PT',
			'rm',
			'ro',
			'ru',
			'sk',
			'sl',
			'sr',
			'sv',
			'tl',
			'ta',
			'te',
			'th',
			'tr',
			'uk',
			'vi',
			'zh-CN',
			'zh-TW'
	);

	public static function format ($locations)
	{
		$format = DPCalendarHelper::getComponentParameter('location_format', 'format_us');
		$format = str_replace('.php', '', $format);

		return JLayoutHelper::render('location.' . $format, array(
				'locations' => $locations
		), null, array(
				'component' => 'com_dpcalendar'
		));
	}

	public static function get ($location, $fill = true)
	{
		if (self::$locationCache == null)
		{
			JLoader::import('joomla.application.component.model');
			JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/models', 'DPCalendarModel');
			$model = JModelLegacy::getInstance('Locations', 'DPCalendarModel', array(
					'ignore_request' => true
			));
			self::$locationCache = $model;
		}

		if ($fill)
		{
			try
			{
				self::$locationCache->setState('filter.search', JApplication::stringURLSafe($location));
				$locations = self::$locationCache->getItems();
				if ($locations)
				{
					$locObject = $locations[0];
					if ((int) $locObject->latitude)
					{
						return $locObject;
					}
				}
			}
			catch (Exception $e)
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
			}
		}

		$lang = DPCalendarHelper::getFrLanguage();
		if (! in_array($lang, self::$googleLanguages))
		{
			$lang = substr($lang, 0, strpos($lang, '-'));
		}
		if (! in_array($lang, self::$googleLanguages))
		{
			$lang = '';
		}
		else
		{
			$lang = '&language=' . $lang;
		}
		$url = 'https://maps.google.com/maps/api/geocode/json?';

		if ($key = DPCalendarHelper::getComponentParameter('map_api_google_key'))
		{
			$url .= 'key=' . $key . '&';
		}
		$url .= 'address=' . urlencode($location) . '&sensor=false' . $lang;
		$content = DPCalendarHelper::fetchContent($url);
		if ($content instanceof Exception)
		{
			JFactory::getApplication()->enqueueMessage((string) $content->getMessage(), 'warning');
		}

		if (! isset($locObject))
		{
			$locObject = JTable::getInstance('Location', 'DPCalendarTable');
			$locObject->title = $location;
			$locObject->alias = JApplication::stringURLSafe($location);
			$locObject->state = 1;
			$locObject->language = '*';
			$locObject->country = '';
			$locObject->province = '';
			$locObject->city = '';
			$locObject->zip = '';
			$locObject->street = '';
			$locObject->number = '';
			$locObject->latitude = 0;
			$locObject->longitude = 0;
		}
		else
		{
			$tmp = $locObject;
			$locObject = JTable::getInstance('Location', 'DPCalendarTable');
			$locObject->bind((array) $tmp);
		}
		if (! empty($content) && ! ($content instanceof Exception))
		{
			$tmp = json_decode($content);

			if ($tmp)
			{
				if ($tmp->status == 'OK')
				{
					if (! empty($tmp->results))
					{
						if ($fill)
						{
							foreach ($tmp->results[0]->address_components as $part)
							{
								if (empty($part->types))
								{
									continue;
								}
								switch ($part->types[0])
								{
									case 'country':
										$locObject->country = $part->long_name;
										break;
									case 'administrative_area_level_1':
										$locObject->province = $part->long_name;
										break;
									case 'locality':
										$locObject->city = $part->long_name;
										break;
									case 'postal_code':
										$locObject->zip = $part->long_name;
										break;
									case 'route':
										$locObject->street = $part->long_name;
										break;
									case 'street_number':
										$locObject->number = $part->long_name;
										break;
								}
							}
							$locObject->title = $tmp->results[0]->formatted_address;
						}
						else
						{
							$locObject->title = $location;
							$locObject->country = $location;
						}

						$locObject->latitude = $tmp->results[0]->geometry->location->lat;
						$locObject->longitude = $tmp->results[0]->geometry->location->lng;
					}
				}
				else if (isset($tmp->error_message))
				{
					JFactory::getApplication()->enqueueMessage($tmp->error_message, 'warning');
				}
			}
		}

		if ($fill)
		{
			try
			{
				if (! $locObject->store())
				{
					JFactory::getApplication()->enqueueMessage(0, $locObject->getError());
				}
			}
			catch (Exception $e)
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
			}
		}
		return $locObject;
	}

	public static function getLocations ($locationIds)
	{
		if (empty($locationIds))
		{
			return array();
		}
		JLoader::import('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_dpcalendar' . DS . 'models', 'DPCalendarModel');

		$model = JModelLegacy::getInstance('Locations', 'DPCalendarModel');
		$model->getState();
		$model->setState('filter.search', 'ids:' . implode(',', $locationIds));

		return $model->getItems();
	}

	public static function within ($location, $latitude, $longitude, $radius)
	{
		if (empty($location->latitude) || empty($location->longitude) || empty($latitude) || empty($longitude))
		{
			return false;
		}
		$latitude = (float) $latitude;
		$longitude = (float) $longitude;

		$longitudeMin = $longitude - $radius / abs(cos(deg2rad($longitude)) * 69);
		$longitudeMax = $longitude + $radius / abs(cos(deg2rad($longitude)) * 69);
		$latitudeMin = $latitude - ($radius / 69);
		$latitudeMax = $latitude + ($radius / 69);

		return $location->longitude > $longitudeMin && $location->longitude < $longitudeMax && $location->latitude > $latitudeMin &&
				 $location->latitude < $latitudeMax;
	}
}
