<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::import('components.com_dpcalendar.libraries.dpcalendar.plugin', JPATH_ADMINISTRATOR);
if (! class_exists('DPCalendarPlugin'))
{
	return;
}

JLoader::import('joomla.filesystem.folder');

class PlgDPCalendarDPCalendar_GCalendar extends DPCalendarPlugin
{

	protected $identifier = 'gc';

	public function fetchEvents ($calendarId, JDate $startDate = null, JDate $endDate = null, JRegistry $options)
	{
		$events = parent::fetchEvents($calendarId, $startDate, $endDate, $options);

		$db = JFactory::getDbo();
		$db->setQuery('select * from #__gcalendar where id = ' . $db->q($calendarId));
		$calendar = $db->loadObject();
		foreach ($events as $event)
		{
			$description = str_replace('\n', '<br/>', $event->description);
			$event->description = DPCalendarHelper::parseHtml($description);
			$at = strpos($event->id, '@');
			$delimiter = strrpos($event->id, '_');
			if ($at !== false && $delimiter !== false)
			{
				$event->id = substr_replace($event->id, '', $at, $delimiter - $at);
			}

			if ($calendar)
			{
				$event->access_content = $calendar->access_content;
			}
		}
		return $events;
	}

	protected function getContent ($calendarId, JDate $startDate = null, JDate $endDate = null, JRegistry $options)
	{
		if (! JFolder::exists(JPATH_ADMINISTRATOR . '/components/com_gcalendar'))
		{
			return '';
		}

		$db = JFactory::getDbo();
		$db->setQuery('select * from #__gcalendar where id = ' . $db->q($calendarId));
		$calendar = $db->loadObject();

		$googleId = $calendar->calendar_id;
		if (empty($googleId))
		{
			return null;
		}

		$googleId = str_replace('#', '%23', $googleId);

		$url = 'https://www.google.com/calendar/ical/' . $googleId;
		$magicCookie = $calendar->magic_cookie;
		if (! empty($magicCookie))
		{
			$url .= '/private-' . $magicCookie;
		}
		else
		{
			$url .= '/public';
		}
		$url .= '/basic.ics';
		$content = DPCalendarHelper::fetchContent($url);

		if ($content instanceof Exception)
		{
			$this->log($content->getMessage());
			return '';
		}

		return $content;
	}

	public function fetchCalendars ($calendarIds = null)
	{
		if (! JFolder::exists(JPATH_ADMINISTRATOR . '/components/com_gcalendar'))
		{
			return array();
		}

		$db = JFactory::getDbo();
		$db->setQuery('select * from #__gcalendar');
		$calendars = array();
		foreach ($db->loadObjectList() as $calendar)
		{
			if (! empty($calendarIds) && ! in_array($calendar->id, $calendarIds))
			{
				continue;
			}
			$cal = $this->createCalendar($calendar->id, $calendar->name, '', $calendar->color);
			$cal->access = $calendar->access;
			$cal->access_content = $calendar->access_content;
			$calendars[] = $cal;
		}
		return $calendars;
	}
}
