<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::import('controllers.location', JPATH_COMPONENT_ADMINISTRATOR);

class DPCalendarControllerLocationForm extends DPCalendarControllerLocation
{

	protected $view_item = 'locationform';

	public function __construct ($config = array())
	{
		JFactory::getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');

		JModelLegacy::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/models');
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables');
		JForm::addFormPath(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/models/forms');

		parent::__construct();
	}

	public function save ($key = null, $urlVar = 'l_id')
	{
		$result = parent::save($key, $urlVar);

		if ($return = $this->input->get('return', null, 'base64'))
		{
			$this->setRedirect(base64_decode($return));
		}

		return $result;
	}

	public function cancel ($key = 'l_id')
	{
		parent::cancel($key);

		// Redirect to the return page.
		$this->setRedirect($this->getReturnPage());
	}

	public function getModel ($name = 'Location', $prefix = '', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function edit ($key = 'id', $urlVar = 'l_id')
	{
		return parent::edit($key, $urlVar);
	}

	protected function getRedirectToItemAppend ($recordId = null, $urlVar = null)
	{
		$append = parent::getRedirectToItemAppend($recordId, $urlVar);
		$itemId = JRequest::getInt('Itemid');
		$return = $this->getReturnPage();

		if ($itemId)
		{
			$append .= '&Itemid=' . $itemId;
		}

		if ($return)
		{
			$append .= '&return=' . base64_encode($return);
		}

		if (JRequest::getCmd('tmpl'))
		{
			$append .= '&tmpl=' . JRequest::getCmd('tmpl');
		}
		return $append;
	}

	protected function getReturnPage ()
	{
		$return = JRequest::getVar('return', null, 'default', 'base64');

		if (empty($return) || ! JUri::isInternal(base64_decode($return)))
		{
			return JURI::base();
		}
		else
		{
			return base64_decode($return);
		}
	}
}
