<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
JFactory::getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');

DPCalendarHelper::loadLibrary(array('jquery' => true, 'bootstrap' => true, 'dpcalendar' => true));

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base() . 'components/com_dpcalendar/views/event/tmpl/default.css');

$params = $this->params;
if ($params->get('event_show_map', '1'))
{
	DPCalendarHelper::loadLibrary(array('maps' => true));
	$document->addScript(JURI::base() . 'components/com_dpcalendar/views/event/tmpl/event.js');
}

if (JRequest::getCmd('tmpl', '') == 'component')
{
	$document->addStyleSheet(JURI::base() . 'components/com_dpcalendar/views/event/tmpl/none-responsive.css');
}

$event = $this->event;
$dispatcher = JDispatcher::getInstance();
$calendar = DPCalendarHelper::getCalendar($event->catid);

$startDate = DPCalendarHelper::getDate($event->start_date, $event->all_day);
$endDate = DPCalendarHelper::getDate($event->end_date, $event->all_day);

echo JLayoutHelper::render('user.timezone');
?>
<div id="dpcal-event-container" class="dp-container" itemprop="event" itemscope itemtype="http://schema.org/Event">
<?php
$text = '';
$dispatcher->trigger('onEventBeforeDisplay', array(&$event,  &$text));
echo $text;

if ($event->params->get('access-attend'))
{
	$button = JHtml::_('dpcalendaricon.attend', $event);
	if ($button)
	{ ?>
	<div class="pull-left event-button"><?php echo $button;?></div>
	<?php
	}
}

if ($event->params->get('access-edit'))
{
	$button = JHtml::_('dpcalendaricon.edit', $event);
	if ($button)
	{ ?>
	<div class="pull-left event-button"><?php echo $button;?></div>
	<?php
	}
}

if ($event->params->get('access-delete'))
{
	$button = JHtml::_('dpcalendaricon.delete', $event);
	if ($button)
	{ ?>
	<div class="pull-left event-button"><?php echo $button;?></div>
	<?php
	}
}
?>
<div class="pull-left event-button"><?php echo JHtml::_('share.twitter', $params);?></div>
<div class="pull-left event-button"><?php echo JHtml::_('share.like', $params);?></div>
<div class="pull-left event-button"><?php echo JHtml::_('share.google', $params);?></div>
<div class="pull-left event-button"><?php echo JHtml::_('share.linkedin', $params);?></div>
<div class="clearfix"></div>
<h2><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL');?></h2>
<div class="row-fluid">
	<div class="span7">
		<div class="row-fluid" id="dp-event-title">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_TITLE');?>: </div>
			<div class="span9 event-content" itemprop="name"><?php echo $this->escape($event->title);?></div>
		</div>
		<div class="row-fluid" id="dp-event-calendar">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_CALANDAR');?>: </div>
			<div class="span9 event-content">
				<?php
				$calendarLink = DPCalendarHelper::getCalendarRoute($event->catid);
				if ($calendarLink)
				{
				?>
					<a href="<?php echo JRoute::_($calendarLink);?>" target="_parent"><?php echo $this->escape($calendar->title);?></a>
				<?php
				}
				else
				{
					echo $calendar != null ? $this->escape($calendar->title) : $event->catid;
				}?>
			</div>
		</div>
		<?php if ($params->get('event_show_date', '1'))
		{?>
		<div class="row-fluid" id="dp-event-date">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_DATE');?>: </div>
			<div class="span9 event-content" itemprop="startDate" content="<?php echo $startDate->format('c');?>">
				<?php echo DPCalendarHelper::getDateStringFromEvent($event, $params->get('event_date_format', 'm.d.Y'), $params->get('event_time_format', 'g:i a'));?>
			</div>
		</div>
		<?php
		}

		if ($event->locations && $params->get('event_show_location', '1'))
		{?>
		<div class="row-fluid" id="dp-event-location">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_LOCATION');?>: </div>
			<div class="span9 event-content">
				<?php foreach ($event->locations as $location)
				{ ?>
				<div class="dp-location" data-latitude="<?php echo $location->latitude;?>" data-longitude="<?php echo $location->longitude?>" data-title="<?php echo $this->escape($location->title);?>">
					<a href="http://maps.google.com/?q=<?php echo $this->escape(DPCalendarHelperLocation::format($location));?>" target="_blank"><?php echo $this->escape($location->title);?></a>
				</div>
				<?php echo DPCalendarHelperSchema::location(array($location));?>
				<br/>
				<?php
				}
				?>
			</div>
		</div>
		<?php
		}

		if ($event->url && $params->get('event_show_url', '1'))
		{?>
		<div class="row-fluid" id="dp-event-url">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_URL');?>: </div>
			<div class="span9 event-content"><a href="<?php echo $event->url;?>" target="_blank"><?php echo $event->url?></a></div>
		</div>
		<?php
		}

		$author = JFactory::getUser($event->created_by);
		if ($author && !$author->guest && $params->get('event_show_author', '1'))
		{
		?>
		<div class="row-fluid" id="dp-event-author">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_AUTHOR');?>: </div>
			<div class="span9 event-content" itemprop="performer">
				<?php echo $event->created_by_alias ? $this->escape($event->created_by_alias) : $this->escape($author->name)?>
				<br/><?php echo DPCalendarHelper::getAvatar($author->id, $author->email, $params);?></div>
		</div>
		<?php
		}

		if ($params->get('event_show_price', '1') && $event->price != '0.00')
		{?>
		<div class="row-fluid" id="dp-event-capacity">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_PRICE_LABEL');?>: </div>
			<div class="span9 event-content" title="<?php echo DPCalendarHelper::getComponentParameter('currency', 'USD');?>"><?php echo $this->escape($event->price . ' ' . DPCalendarHelper::getComponentParameter('currency_symbol', '$'))?></div>
			<?php echo DPCalendarHelperSchema::offer($event);?>
		</div>
		<?php
		}

		if ($params->get('event_show_capacity', '1') && ($event->capacity === null || $event->capacity > 0))
		{?>
		<div class="row-fluid" id="dp-event-capacity">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CAPACITY_LABEL');?>: </div>
			<div class="span9 event-content"><?php echo $event->capacity === null ? JText::_('COM_DPCALENDAR_FIELD_CAPACITY_UNLIMITED') : (int)$event->capacity?></div>
		</div>
		<?php
		}

		if ($params->get('event_show_attendees', '1') && isset($event->attendees) && count($event->attendees))
		{?>
		<div class="row-fluid">
			<div class="span3 event-label" id="dp-event-attendee"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_ATTENDEES');?>: </div>
			<div class="span9 event-content" itemprop="performer">
			<?php
			if (isset($event->attendees))
			{
				foreach ($event->attendees as $attendee)
				{?>
					<span class="label"><?php echo $attendee->name;?></span>
				<?php
				}
			}?>
			</div>
		</div>
		<?php
		}

		if ($params->get('event_show_copy', '1'))
		{
		?>
		<div class="row-fluid" id="dp-event-copy-google">
			<div class="span3 event-label"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_COPY')?>: </div>
			<?php
			$copyDateTimeFormat = $event->all_day ? 'Ymd' : 'Ymd\THis';
			if ($event->all_day)
			{
				$endDate->modify('+1 day');
			}
			$url = 'http://www.google.com/calendar/render?action=TEMPLATE&text=' . urlencode($event->title);
			$url .= '&dates=' . $startDate->format($copyDateTimeFormat, true) . '%2F' .
					$endDate->format($copyDateTimeFormat, true);
			$url .= '&location=' . urlencode(DPCalendarHelperLocation::format($event->locations));
			$url .= '&details=' . urlencode(JHtml::_('string.truncate', $event->description, 200));
			$url .= '&hl=' . DPCalendarHelper::getFrLanguage() . '&ctz=' . $startDate->getTimezone()->getName();
			$url .= '&sf=true&output=xml';
			?>
			<div class="span9 event-content"><a target="_blank" href="<?php echo $url;?>"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_COPY_GOOGLE');?></a></div>
		</div>
		<div class="row-fluid" id="dp-event-coppy-outlook">
			<div class="span3 event-label"></div>
			<div class="span9 event-content"><a target="_blank" href="<?php echo JRoute::_("index.php?option=com_dpcalendar&view=event&format=raw&id=" . $event->id);?>"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_COPY_OUTLOOK');?></a></div>
		</div>
	<?php
	} ?>
	</div>

	<div class="span5">
	<?php
	if ($params->get('event_show_images', '1'))
	{
		echo JLayoutHelper::render('event.images', array('event' => $event));
	} ?>

	<?php
	if ($event->locations && $params->get('event_show_map', '1'))
	{?>
		<div id="dp-event-details-map" class="pull-right dpcalendar-fixed-map"
			data-zoom="<?php echo $params->get('event_map_zoom', 4);?>"
			data-lat="<?php echo $params->get('event_map_lat', 47);?>"
			data-long="<?php echo $params->get('event_map_long', 4);?>"></div>
	<?php
	} ?>
	</div>
</div>
<?php
echo JLayoutHelper::render('joomla.content.tags', $event->tags->itemTags);

if ($event->description)
{?>
<h2><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_DESCRIPTION');?></h2>
<div itemprop="description">
<?php echo JHTML::_('content.prepare', $event->description);?>
</div>
<?php
}
$text = '';
$dispatcher->trigger('onEventAfterDisplay', array(&$event,  &$text));
echo $text;

$comments = JHtml::_('share.comment', $params, $event);
if ($comments)
{
	echo '<h2>' . JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_COMMENTS') . '</h2>';
	echo $comments;
}
?>
</div>
