<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base() . 'modules/mod_dpcalendar_upcoming/tmpl/simple.css');

if ($params->get('show_as_popup', '0') == '1')
{
	DPCalendarHelper::loadLibrary(array('jquery' => true, 'dpcalendar' => 'true'));

	$id = "dpc-upcoming-" . $module->id;
	$calCode = "dpjQuery(document).ready(function() {\n";
	$calCode .= "dpjQuery('.dpc-upcoming-event-link').click(function () {\n";
	$calCode .= "	var link = dpjQuery(this).attr('href');\n";
	$calCode .= "	dpjQuery('#" . $id . "').on('show', function () {console.log(link);\n";
	$calCode .= "		var url = new Url(link);\n";
	$calCode .= "		url.query.tmpl = 'component';\n";
	$calCode .= "		dpjQuery('#" . $id . " iframe').attr('src', url.toString());\n";
	$calCode .= "	});\n";
	$calCode .= "	dpjQuery('#" . $id . " iframe').removeAttr('src');\n";
	$calCode .= "	dpjQuery('#" . $id . "').modal();\n";
	$calCode .= "	return false;\n";
	$calCode .= "});\n";
	$calCode .= "});\n";
	$document->addScriptDeclaration($calCode);
	?>
<div id="<?php echo $id;?>" class="modal hide" tabindex="-1" role="dialog" aria-hidden="true"
	style="height:500px">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
  	<iframe style="width:99.6%;height:95%;border:none;"></iframe>
</div>
<?php
}

$lastHeading = '';
$grouping = $params->get('output_grouping', '');
foreach ($events as $event){
	$startDate = DPCalendarHelper::getDate($event->start_date, $event->all_day);
	if ($grouping)
	{
		$groupHeading = $startDate->format($grouping, true);
		if ($groupHeading != $lastHeading)
		{
			$lastHeading = $groupHeading;
			?>
			<p style="clear: both;"><strong><?php echo htmlspecialchars($groupHeading);?></strong></p>
			<?php
		}
	}
	?>
<div class="dp-upcoming-group" style="border-color:#<?php echo $event->color?>"itemprop="event" itemscope itemtype="http://schema.org/Event">
	<div style="clear: both;" /></div>
	<p itemprop="startDate" content="<?php echo $startDate->format('c');?>">
		<?php echo DPCalendarHelper::getDateStringFromEvent($event, $params->get('date_format'), $params->get('time_format'));?>
		<a href="<?php echo DPCalendarHelper::getEventRoute($event->id, $event->catid)?>" itemprop="url" class="dpc-upcoming-event-link">
			<span itemprop="name"><?php echo htmlspecialchars($event->title)?></span>
		</a>
	</p>
	<?php if ($event->locations)
	{
		echo DPCalendarHelperSchema::location($event->locations);
	}

	echo DPCalendarHelperSchema::offer($event);
	?>
	<p style="clear: both;" />
</div>
<?php
}
