<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$locations = $displayData['locations'];

if (empty($locations))
{
	return '';
}
if (! is_array($locations))
{
	$locations = array(
			$locations
	);
}
$buffer = '';
foreach ($locations as $index => $location)
{
	if (! empty($location->street))
	{
		$buffer .= (! empty($location->number) ? $location->number . ' ' : '') . $location->street . ', ';
	}
	if (! empty($location->city))
	{
		$buffer .= (! empty($location->zip) ? $location->zip . ' ' : '') . $location->city . ', ';
	}
	if (! empty($location->province))
	{
		$buffer .= $location->province . ', ';
	}
	if (! empty($location->country))
	{
		$buffer .= $location->country . ', ';
	}
	if ($index < count($locations) - 1)
	{
		$buffer .= '; ';
	}
}
$buffer = trim($buffer, ', ');
echo $buffer;
