<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$event = $displayData['event'];
if (! $event || ! isset($event->images))
{
	return;
}

$images = json_decode($event->images);
if (! $images)
{
	return;
}
?>

<div id="dp-event-details-images" class="pull-right">
<?php
for ($i = 1; $i < 3; $i ++)
{
	if (! isset($images->{'image' . $i}))
	{
		continue;
	}

	$imagePath = $images->{'image' . $i};
	if (! $imagePath)
	{
		continue;
	}

	$caption = '';
	if (isset($images->{'image' . $i . '_caption'}))
	{
		$caption = $images->{'image' . $i . '_caption'};
	}
	if ($caption)
	{
		JHtml::_('behavior.caption');
		$caption = 'class="caption" title="' . htmlspecialchars($caption) . '"';
	}
	?>
	<div class="pull-right item-image">
		<img <?php echo $caption;?>
			src="<?php echo htmlspecialchars($imagePath); ?>"
			alt="<?php echo htmlspecialchars($images->{'image' . $i . '_alt'}); ?>" />
	</div>
<?php
}
?>
</div>
