<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base() . 'modules/mod_dpcalendar_upcoming/tmpl/default.css');

if ($params->get('show_as_popup', '0') == '1')
{
	DPCalendarHelper::loadLibrary(array('jquery' => true, 'dpcalendar' => 'true'));

	$id = "dpc-upcoming-" . $module->id;
	$calCode = "dpjQuery(document).ready(function() {\n";
	$calCode .= "dpjQuery('.dpc-upcoming-event-link').click(function () {\n";
	$calCode .= "	var link = dpjQuery(this).attr('href');\n";
	$calCode .= "	dpjQuery('#" . $id . "').on('show', function () {console.log(link);\n";
	$calCode .= "		var url = new Url(link);\n";
	$calCode .= "		url.query.tmpl = 'component';\n";
	$calCode .= "		dpjQuery('#" . $id . " iframe').attr('src', url.toString());\n";
	$calCode .= "	});\n";
	$calCode .= "	dpjQuery('#" . $id . " iframe').removeAttr('src');\n";
	$calCode .= "	dpjQuery('#" . $id . "').modal();\n";
	$calCode .= "	return false;\n";
	$calCode .= "});\n";
	$calCode .= "});\n";
	$document->addScriptDeclaration($calCode);
	?>
<div id="<?php echo $id;?>" class="modal hide" tabindex="-1" role="dialog" aria-hidden="true"
	style="height:500px">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
  	<iframe style="width:99.6%;height:95%;border:none;"></iframe>
</div>
<?php
}
?>
<div class="row-fluid">
<?php
$return = JFactory::getApplication()->input->getInt('Itemid', null);
if (! empty($return))
{
	$return = JRoute::_('index.php?Itemid=' . $return);
}

$lastHeading = '';
$grouping = $params->get('output_grouping', '');

foreach ($events as $event)
{
	$calendar = DPCalendarHelper::getCalendar($event->catid);

	$startDate = DPCalendarHelper::getDate($event->start_date, $event->all_day);
	if ($grouping)
	{
		$groupHeading = $startDate->format($grouping, true);
		if ($groupHeading != $lastHeading)
		{
			$lastHeading = $groupHeading;
			?>
				<p style="clear: both;"><strong><?php echo htmlentities($groupHeading);?></strong></p>
			<?php
		}
	}
?>
	<div itemprop="event" itemscope itemtype="http://schema.org/Event">
	<div class="page-header">
		<a href="<?php echo DPCalendarHelper::getEventRoute($event->id, $event->catid)?>" itemprop="url"><span itemprop="name"><?php echo htmlentities($event->title)?></span></a>
	</div>
	<span class="badge badge-info pull-right hidden-phone"><?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_HITS');?>:<?php echo $event->hits?></span>
	<?php if (DPCalendarHelper::openForAttending($event))
	{
		$title = JText::_('COM_DPCALENDAR_ATTEND');
		if (isset($event->attending) && (boolean) $event->attending)
		{
			$title = JText::_('COM_DPCALENDAR_ATTENDING');
		}?>
		<div class="pull-left width-20">
			<a href="<?php echo DPCalendarHelper::getAttendRoute($event, $return)?>"><i class="hasTooltip icon-plus"
					title="<?php echo $title;?>"></i></a>
		</div>
	<?php
	}
	if ($calendar->canEdit || ($calendar->canEditOwn && $event->created_by == $user->id))
	{?>
	<span class="pull-left width-20">
		<a href="<?php echo DPCalendarHelper::getFormRoute($event->id, $return);?>"><i class="hasTip icon-edit" title="<?php echo JText::_('JACTION_EDIT');?>"></i></a>
	</span>
	<?php
	}

	if ($calendar->canDelete || ($calendar->canEditOwn && $event->created_by == $user->id))
	{?>
	<span class="pull-left width-20"><a href="<?php echo JRoute::_(
				'index.php?option=com_dpcalendar&task=event.delete&e_id=' . $event->id . '&return=' . base64_encode($return));?>">
		<i class="hasTip icon-remove" title="<?php echo JText::_('JACTION_DELETE');?>"></i></a>
	</span>
	<?php
	}?>
	<small class="list-author" itemprop="startDate" content="<?php echo DPCalendarHelper::getDate($event->start_date, $event->all_day)->format('c');?>">
			(<?php echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_DATE');?>: <?php echo DPCalendarHelper::getDateStringFromEvent($event, $params->get('event_date_format', 'm.d.Y'), $params->get('event_time_format', 'g:i a'));?>)
	</small>
	<br />
	<small class="list-author">
		<?php
		echo JText::_('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_CALANDAR');?>: <?php echo $calendar != null ? $calendar->title : $event->catid;
		?>
	</small>
	<small class="pull-right">
		<?php
		if (isset($event->locations))
		{
			foreach ($event->locations as $location)
			{ ?>
				<div class="dp-location"
					data-latitude="<?php echo $location->latitude;?>" data-longitude="<?php echo $location->longitude?>"
					data-title="<?php echo htmlentities($location->title);?>">
					<a href="http://maps.google.com/?q=<?php echo htmlentities(DPCalendarHelperLocation::format($location));?>" target="_blank"><?php echo htmlentities($location->title);?></a>
					<?php echo DPCalendarHelperSchema::location(array($location));?>
				</div>
				<br/>
			<?php
			}
		}?>
	</small>
	<?php
	echo DPCalendarHelperSchema::offer($event);

	$images = json_decode($event->images);
	if (!$images)
	{
		echo JHTML::_('content.prepare', $event->description);
	}
	else
	{ ?>
		<div class="row-fluid">
			<div class="span6">
				<?php echo JHTML::_('content.prepare', $event->description);?>
			</div>
			<div class="span6">
				<?php
				$layout = new JLayoutFile('com_dpcalendar.event.images', JPATH_ADMINISTRATOR . '/components/com_dpcalendar/layouts');
				echo $layout->render(array('event' => $event));
				?>
			</div>
		</div>
	<?php
	} ?>
	</div>
<?php
}?>
</div>
