<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2014 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::import('components.com_dpcalendar.models.event', JPATH_ADMINISTRATOR);
JLoader::import('components.com_dpcalendar.tables.event', JPATH_ADMINISTRATOR);

class DPCalendarModelForm extends DPCalendarModelEvent
{

	public function getReturnPage ()
	{
		return base64_encode($this->getState('return_page'));
	}

	protected function populateState ()
	{
		$app = JFactory::getApplication();

		// Load state from the request.
		$pk = JRequest::getVar('e_id');
		$this->setState('event.id', $pk);

		// Add compatibility variable for default naming conventions.
		$this->setState('form.id', $pk);

		$categoryId = JRequest::getVar('catid');
		$this->setState('event.catid', $categoryId);

		$return = JRequest::getVar('return', null, 'default', 'base64');

		if (! JUri::isInternal(base64_decode($return)))
		{
			$return = null;
		}

		$this->setState('return_page', base64_decode($return));

		// Load the parameters.
		if ($app->isSite())
		{
			$this->setState('params', $app->getParams());
		}
		else
		{
			$this->setState('params', JComponentHelper::getParams('com_dpcalendar'));
		}

		$this->setState('layout', JRequest::getCmd('layout'));
	}

	public function getForm ($data = array(), $loadData = true)
	{
		$form = parent::getForm($data, $loadData);

		$params = $this->getState('params');
		if (! $params)
		{
			$params = JFactory::getApplication()->getParams();
		}

		// Set the default values from the params
		$form->setValue('color', null, $params->get('event_form_color'));
		$form->setValue('url', null, $params->get('event_form_url'));
		$form->setValue('description', null, $params->get('event_form_description'));
		$form->setValue('capacity', null, $params->get('event_form_capacity'));
		$form->setValue('price', null, $params->get('event_form_price'));
		$form->setValue('plugintype', null, $params->get('event_form_plugintype'));
		$form->setValue('ordertext', null, $params->get('event_form_ordertext'));
		$form->setValue('canceltext', null, $params->get('event_form_canceltext'));
		$form->setValue('payment_statement', null, $params->get('event_form_payment_statement'));
		$form->setValue('access', null, $params->get('event_form_access'));
		$form->setValue('access_content', null, $params->get('event_form_access_content'));
		$form->setValue('featured', null, $params->get('event_form_featured'));
		$form->setValue('language', null, $params->get('event_form_language'));
		$form->setValue('metakey', null, $params->get('menu-meta_keywords'));
		$form->setValue('metadesc', null, $params->get('menu-meta_description'));

		// Remove fields depending on the params
		if ($params->get('event_form_change_color', '1') != '1')
		{
			$form->removeField('color');
		}
		if ($params->get('event_form_change_url', '1') != '1')
		{
			$form->removeField('url');
		}
		if ($params->get('event_form_change_description', '1') != '1')
		{
			$form->removeField('description');
		}
		if ($params->get('event_form_change_capacity', '1') != '1')
		{
			$form->removeField('capacity');
		}
		if ($params->get('event_form_change_price', '1') != '1')
		{
			$form->removeField('price');
		}
		if ($params->get('event_form_change_payment', '1') != '1')
		{
			$form->removeField('plugintype');
		}
		if ($params->get('event_form_change_order', '1') != '1')
		{
			$form->removeField('ordertext');
		}
		if ($params->get('event_form_change_cancellation', '1') != '1')
		{
			$form->removeField('canceltext');
		}
		if ($params->get('event_form_change_paystatement', '1') != '1')
		{
			$form->removeField('payment_statement');
		}
		if ($params->get('event_form_change_access', '1') != '1')
		{
			$form->removeField('access');
		}
		if ($params->get('event_form_change_access_content', '1') != '1')
		{
			$form->removeField('access_content');
		}
		if ($params->get('event_form_change_featured', '1') != '1')
		{
			$form->removeField('featured');
		}

		// Handle tabs
		if ($params->get('event_form_change_location', '1') != '1')
		{
			$form->removeField('location');
			$form->removeField('location_ids');
		}

		return $form;
	}

	protected function preprocessForm (JForm $form, $data, $group = 'content')
	{
		$return = parent::preprocessForm($form, $data, $group);
		$form->setFieldAttribute('user_id', 'type', 'hidden');

		$params = $this->getState('params');
		if (! $params)
		{
			$params = JFactory::getApplication()->getParams();
		}

		$form->setFieldAttribute('start_date', 'format', $params->get('event_form_date_format', 'm.d.Y'));
		$form->setFieldAttribute('start_date', 'formatTime', $params->get('event_form_time_format', 'g:i a'));
		$form->setFieldAttribute('end_date', 'format', $params->get('event_form_date_format', 'm.d.Y'));
		$form->setFieldAttribute('end_date', 'formatTime', $params->get('event_form_time_format', 'g:i a'));

		return $return;
	}
}
