<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2014 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JLoader::import('joomla.application.component.controllerform');

class DPCalendarControllerLocation extends JControllerForm
{

	protected $text_prefix = 'COM_DPCALENDAR_LOCATION';

	public function batch ($model = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Set the model
		$model = $this->getModel('Location', '', array());

		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_dpcalendar&view=locations' . $this->getRedirectToListAppend(), false));

		return parent::batch($model);
	}

	public function save ($key = null, $urlVar = null)
	{
		$return = parent::save($key, $urlVar);

		if (JRequest::getVar('ajax') != 0)
		{
			$id = JFactory::getDbo()->insertid();
			if (! empty($id))
			{
				$table = $this->getModel()->getTable();
				$table->load($id);
				DPCalendarHelper::sendMessage($this->message, false,
						array(
								'id' => $id,
								'display' => $table->title . ' [' . $table->latitude . ':' . $table->longitude . ']'
						));
			}
			else
			{
				DPCalendarHelper::sendMessage($this->message, true, array(
						'id' => 0
				));
			}
		}
		return $return;
	}

	public function loc ()
	{
		ob_clean();
		$loc = DPCalendarHelperLocation::get(JRequest::getVar('loc'));
		echo json_encode(array(
				'latitude' => $loc->latitude,
				'longitude' => $loc->longitude
		));
		JFactory::getApplication()->close();
	}
}
